/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class FindFieldSelfAssignment
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    int state;
    int register;
    String f;
    String className;
    Set<String> initializedFields = new HashSet<String>();

    public FindFieldSelfAssignment(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.state = 0;
        super.visit(obj);
        this.initializedFields.clear();
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (seen == 42) {
                    this.state = 1;
                    break;
                }
                if (seen != 89) break;
                this.state = 6;
                break;
            }
            case 1: {
                if (seen == 42) {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                if (seen == 180) {
                    this.state = 3;
                    this.f = this.getRefConstantOperand();
                    this.className = this.getClassConstantOperand();
                    break;
                }
                this.state = 0;
                break;
            }
            case 3: {
                if (seen == 181 && this.getRefConstantOperand().equals(this.f) && this.getClassConstantOperand().equals(this.className)) {
                    int priority = 2;
                    LocalVariableAnnotation possibleMatch = LocalVariableAnnotation.findMatchingIgnoredParameter(this.getClassContext(), this.getMethod(), this.getNameConstantOperand(), this.getSigConstantOperand());
                    if (possibleMatch != null) {
                        priority = 1;
                    } else {
                        possibleMatch = LocalVariableAnnotation.findUniqueBestMatchingParameter(this.getClassContext(), this.getMethod(), this.getNameConstantOperand(), this.getSigConstantOperand());
                        if (possibleMatch != null) {
                            --priority;
                        }
                    }
                    this.bugReporter.reportBug(new BugInstance(this, "SA_FIELD_SELF_ASSIGNMENT", priority).addClassAndMethod(this).addReferencedField(this).addOptionalAnnotation(possibleMatch).addSourceLine(this));
                }
                this.state = 0;
                break;
            }
            case 6: {
                if (this.isRegisterStore()) {
                    this.state = 7;
                    this.register = this.getRegisterOperand();
                    break;
                }
                this.state = 0;
                break;
            }
            case 7: {
                if (this.isRegisterStore() && this.register == this.getRegisterOperand()) {
                    this.bugReporter.reportBug(new BugInstance(this, "SA_LOCAL_DOUBLE_ASSIGNMENT", 2).addClassAndMethod(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), this.register, this.getPC(), this.getPC() - 1)).addSourceLine(this));
                }
                this.state = 0;
            }
        }
        if (seen == 181 && this.getClassConstantOperand().equals(this.className)) {
            this.initializedFields.add(this.getRefConstantOperand());
        }
    }
}

