/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.detect.UnreadFields;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUninitializedGet
extends BytecodeScanningDetector
implements StatelessDetector {
    Set<FieldAnnotation> initializedFields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> declaredFields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> containerFields = new HashSet<FieldAnnotation>();
    Collection<BugInstance> pendingBugs = new LinkedList<BugInstance>();
    boolean inConstructor;
    boolean thisOnTOS = false;
    private BugReporter bugReporter;
    private static final int UNKNOWN_PRIORITY = -1;

    public FindUninitializedGet(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(JavaClass obj) {
        this.pendingBugs.clear();
        this.declaredFields.clear();
        this.containerFields.clear();
        super.visit(obj);
    }

    @Override
    public void visit(Field obj) {
        super.visit(obj);
        FieldAnnotation f = FieldAnnotation.fromVisitedField(this);
        this.declaredFields.add(f);
    }

    @Override
    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        if (!this.visitingField()) {
            return;
        }
        if (UnreadFields.isInjectionAttribute(annotationClass)) {
            this.containerFields.add(FieldAnnotation.fromVisitedField(this));
        }
    }

    @Override
    public void visit(Method obj) {
        super.visit(obj);
        this.initializedFields.clear();
        this.thisOnTOS = false;
        this.inConstructor = this.getMethodName().equals("<init>") && this.getMethodSig().indexOf(this.getClassName()) == -1;
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        for (BugInstance bug : this.pendingBugs) {
            this.bugReporter.reportBug(bug);
        }
        this.pendingBugs.clear();
    }

    @Override
    public void sawBranchTo(int target) {
        Iterator<BugInstance> i = this.pendingBugs.iterator();
        while (i.hasNext()) {
            BugInstance bug = i.next();
            if (bug.getPrimarySourceLineAnnotation().getStartBytecode() < target) continue;
            i.remove();
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (!this.inConstructor) {
            return;
        }
        if (seen == 42) {
            this.thisOnTOS = true;
            return;
        }
        if (seen == 181 && this.getClassConstantOperand().equals(this.getClassName())) {
            this.initializedFields.add(FieldAnnotation.fromReferencedField(this));
        } else if (this.thisOnTOS && seen == 180 && this.getClassConstantOperand().equals(this.getClassName())) {
            UnreadFields unreadFields = AnalysisContext.currentAnalysisContext().getUnreadFields();
            XField xField = XFactory.createReferencedXField(this);
            FieldAnnotation f = FieldAnnotation.fromReferencedField(this);
            byte nextOpcode = this.codeBytes[this.getPC() + 3];
            if (nextOpcode != 87 && !this.initializedFields.contains(f) && this.declaredFields.contains(f) && !this.containerFields.contains(f) && !unreadFields.isContainerField(xField)) {
                int priority;
                LocalVariableAnnotation possibleTarget = LocalVariableAnnotation.findMatchingIgnoredParameter(this.getClassContext(), this.getMethod(), this.getNameConstantOperand(), xField.getSignature());
                int n = priority = unreadFields.getReadFields().contains(xField) ? 2 : 3;
                if (possibleTarget != null) {
                    --priority;
                }
                this.pendingBugs.add(new BugInstance(this, "UR_UNINIT_READ", priority).addClassAndMethod(this).addField(f).addOptionalAnnotation(possibleTarget).addSourceLine(this));
                this.initializedFields.add(f);
            }
        } else if (seen == 183 && (!this.getNameConstantOperand().equals("<init>") || this.getClassConstantOperand().equals(this.getClassName())) || seen == 184 && this.getNameConstantOperand().equals("doPrivileged") && this.getClassConstantOperand().equals("java/security/AccessController") || seen == 182 && this.getClassConstantOperand().equals(this.getClassName()) || seen == 182 && this.getNameConstantOperand().equals("start")) {
            this.inConstructor = false;
        }
        this.thisOnTOS = false;
    }
}

