/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncallableMethodOfAnonymousClass
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    boolean isAnonymousInnerClass = false;

    public UncallableMethodOfAnonymousClass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(JavaClass obj) {
        String superclassName2 = this.getSuperclassName();
        this.isAnonymousInnerClass = ClassName.isAnonymous(this.getClassName()) && (!superclassName2.equals("java.lang.Object") || obj.getInterfaceIndices().length != 0);
    }

    boolean definedInThisClassOrSuper(JavaClass clazz, String method) throws ClassNotFoundException {
        if (clazz == null) {
            return false;
        }
        for (Method m : clazz.getMethods()) {
            if (m.isStatic() || !method.equals(m.getName() + ":" + m.getSignature())) continue;
            return true;
        }
        return this.definedInSuperClassOrInterface(clazz, method);
    }

    boolean definedInSuperClassOrInterface(JavaClass clazz, String method) throws ClassNotFoundException {
        if (clazz == null) {
            return false;
        }
        JavaClass superClass = clazz.getSuperClass();
        if (this.definedInThisClassOrSuper(superClass, method)) {
            return true;
        }
        for (JavaClass i : clazz.getInterfaces()) {
            if (!this.definedInThisClassOrSuper(i, method)) continue;
            return true;
        }
        return false;
    }

    Set<String> definedInClass(JavaClass clazz) {
        HashSet<String> result = new HashSet<String>();
        for (Method m : clazz.getMethods()) {
            if (this.skip(m)) continue;
            result.add(m.getName() + m.getSignature());
        }
        return result;
    }

    private boolean skip(Method obj) {
        if (obj.isSynthetic()) {
            return true;
        }
        if (obj.isPrivate()) {
            return true;
        }
        if (obj.isAbstract()) {
            return true;
        }
        String methodName = obj.getName();
        String sig = obj.getSignature();
        if (methodName.equals("<init>")) {
            return true;
        }
        if (methodName.equals("<clinit>")) {
            return true;
        }
        if (sig.equals("()Ljava/lang/Object;") && (methodName.equals("readResolve") || methodName.equals("writeReplace"))) {
            return true;
        }
        if (methodName.startsWith("access$")) {
            return true;
        }
        if (methodName.length() < 2 || methodName.indexOf(36) >= 0) {
            return true;
        }
        XMethod m = this.getXMethod();
        for (ClassDescriptor c : m.getAnnotationDescriptors()) {
            if (c.getClassName().indexOf("inject") < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(Method obj) {
        try {
            if (!this.isAnonymousInnerClass) {
                return;
            }
            if (this.skip(obj)) {
                return;
            }
            JavaClass clazz = this.getThisClass();
            XMethod xmethod = XFactory.createXMethod(clazz, obj);
            XFactory factory = AnalysisContext.currentXFactory();
            if (!(factory.isCalled(xmethod) || !obj.isStatic() && this.definedInSuperClassOrInterface(clazz, obj.getName() + ":" + obj.getSignature()))) {
                int priority = 2;
                String role = "CLASS_SUPERCLASS";
                JavaClass superClass = clazz.getSuperClass();
                String superClassName = superClass.getClassName();
                if (superClassName.equals("java.lang.Object")) {
                    priority = 2;
                    JavaClass[] interfaces = clazz.getInterfaces();
                    if (interfaces.length == 1) {
                        superClassName = interfaces[0].getClassName();
                        role = "CLASS_IMPLEMENTED_INTERFACE";
                    }
                } else {
                    priority = this.definedInClass(superClass).containsAll(this.definedInClass(clazz)) ? 2 : 1;
                }
                Code code = null;
                for (Attribute a : obj.getAttributes()) {
                    if (!(a instanceof Code)) continue;
                    code = (Code)a;
                    break;
                }
                if (code != null && code.getLength() == 1) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance(this, "UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS", priority).addClassAndMethod(this).addClass(superClass).describe("CLASS_SUPERCLASS"));
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
    }
}

