/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class ClassMatcher
implements Matcher {
    private static final boolean DEBUG = SystemProperties.getBoolean("filter.debug");
    private NameMatch className;

    public String toString() {
        return "Class(class=\"" + this.className.getValue() + "\")";
    }

    public ClassMatcher(String className) {
        this.className = new NameMatch(className);
    }

    public boolean match(BugInstance bugInstance) {
        ClassAnnotation primaryClassAnnotation = bugInstance.getPrimaryClass();
        String bugClassName = primaryClassAnnotation.getClassName();
        boolean result = this.className.match(bugClassName);
        if (DEBUG) {
            System.out.println("Matching " + bugClassName + " with " + this.className + ", result = " + result);
        }
        return result;
    }

    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("name", this.className.getSpec());
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Class", attributes);
    }
}

