/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;

public class CommentsArea {
    private JTextArea userCommentsText = new JTextArea();
    private Color userCommentsTextUnenabledColor;
    private JComboBox designationComboBox;
    private ArrayList<String> designationKeys;
    LinkedList<String> prevCommentsList = new LinkedList();
    private static final int prevCommentsMaxSize = 10;
    private JComboBox prevCommentsComboBox = new JComboBox();
    private boolean dontShowAnnotationConfirmation = false;
    private boolean changed;
    final MainFrame frame;

    CommentsArea(MainFrame frame) {
        this.frame = frame;
    }

    JPanel createCommentsInputPanel() {
        JPanel centerPanel = new JPanel();
        BorderLayout centerLayout = new BorderLayout();
        centerLayout.setVgap(10);
        centerPanel.setLayout(centerLayout);
        this.userCommentsText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CommentsArea.this.setProjectChanged(true);
                CommentsArea.this.changed = true;
            }

            public void removeUpdate(DocumentEvent e) {
                CommentsArea.this.setProjectChanged(true);
                CommentsArea.this.changed = true;
            }

            public void changedUpdate(DocumentEvent e) {
                CommentsArea.this.changed = true;
            }
        });
        this.userCommentsTextUnenabledColor = centerPanel.getBackground();
        this.userCommentsText.setLineWrap(true);
        this.userCommentsText.setToolTipText(L10N.getLocalString("tooltip.enter_comments", "Enter your comments about this bug here"));
        this.userCommentsText.setWrapStyleWord(true);
        this.userCommentsText.setEnabled(false);
        this.userCommentsText.setBackground(this.userCommentsTextUnenabledColor);
        JScrollPane commentsScrollP = new JScrollPane(this.userCommentsText);
        this.prevCommentsComboBox.setEnabled(false);
        this.prevCommentsComboBox.setToolTipText(L10N.getLocalString("tooltip.reuse_comments", "Use this to reuse a previous textual comment for this bug"));
        this.prevCommentsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && CommentsArea.this.prevCommentsComboBox.getSelectedIndex() != 0) {
                    CommentsArea.this.setCurrentUserCommentsText(CommentsArea.this.getCurrentPrevCommentsSelection());
                    CommentsArea.this.prevCommentsComboBox.setSelectedIndex(0);
                }
            }
        });
        this.designationComboBox = new JComboBox();
        this.designationKeys = new ArrayList();
        this.designationComboBox.setEnabled(false);
        this.designationComboBox.setToolTipText(L10N.getLocalString("tooltip.select_designation", "Select a user designation for this bug"));
        this.designationComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (CommentsArea.this.frame.userInputEnabled && e.getStateChange() == 1) {
                    if (CommentsArea.this.frame.currentSelectedBugLeaf == null) {
                        CommentsArea.this.setDesignationNonLeaf(CommentsArea.this.designationComboBox.getSelectedItem().toString());
                    } else if (!this.alreadySelected()) {
                        CommentsArea.this.setDesignation(CommentsArea.this.designationComboBox.getSelectedItem().toString());
                    }
                }
            }

            private boolean alreadySelected() {
                return ((String)CommentsArea.this.designationKeys.get(CommentsArea.this.designationComboBox.getSelectedIndex())).equals(CommentsArea.this.frame.currentSelectedBugLeaf.getBug().getNonnullUserDesignation().getDesignationKey());
            }
        });
        this.designationKeys.add("");
        this.designationComboBox.addItem("");
        for (String s : I18N.instance().getUserDesignationKeys(true)) {
            this.designationKeys.add(s);
            this.designationComboBox.addItem(Sortables.DESIGNATION.formatValue(s));
        }
        this.setUnknownDesignation();
        centerPanel.add((Component)this.designationComboBox, "North");
        centerPanel.add((Component)commentsScrollP, "Center");
        centerPanel.add((Component)this.prevCommentsComboBox, "South");
        return centerPanel;
    }

    void setUnknownDesignation() {
        this.designationComboBox.setSelectedIndex(0);
    }

    void setUserCommentInputEnable(final boolean isEnabled) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CommentsArea.this.setUserCommentInputEnableFromSwingThread(isEnabled);
            }
        });
    }

    void setUserCommentInputEnableFromSwingThread(boolean isEnabled) {
        this.frame.userInputEnabled = isEnabled;
        if (!isEnabled) {
            boolean b = this.frame.getProjectChanged();
            this.userCommentsText.setText("");
            this.setUnknownDesignation();
            this.userCommentsText.setBackground(this.userCommentsTextUnenabledColor);
            this.setProjectChanged(b);
        } else {
            this.userCommentsText.setBackground(Color.WHITE);
        }
        this.userCommentsText.setEnabled(isEnabled);
        this.prevCommentsComboBox.setEnabled(isEnabled);
        this.designationComboBox.setEnabled(isEnabled);
    }

    void updateCommentsFromLeafInformation(final BugLeafNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean b = CommentsArea.this.frame.getProjectChanged();
                BugInstance bug = node.getBug();
                CommentsArea.this.setCurrentUserCommentsText(bug.getAnnotationText());
                CommentsArea.this.designationComboBox.setSelectedIndex(CommentsArea.this.designationKeys.indexOf(bug.getNonnullUserDesignation().getDesignationKey()));
                CommentsArea.this.setUserCommentInputEnableFromSwingThread(true);
                CommentsArea.this.changed = false;
                CommentsArea.this.setProjectChanged(b);
            }
        });
    }

    void updateCommentsFromNonLeafInformation(final BugAspects theAspects) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean b = CommentsArea.this.frame.getProjectChanged();
                CommentsArea.this.updateCommentsFromNonLeafInformationFromSwingThread(theAspects);
                CommentsArea.this.setUserCommentInputEnableFromSwingThread(true);
                CommentsArea.this.changed = false;
                CommentsArea.this.setProjectChanged(b);
            }
        });
    }

    private void saveCommentsToBug(BugLeafNode node) {
        if (node == null) {
            return;
        }
        String comments = this.getCurrentUserCommentsText();
        BugInstance bug = node.getBug();
        if (bug.getAnnotationText().equals(comments)) {
            return;
        }
        bug.setAnnotationText(comments, MainFrame.getInstance().bugCollection);
        this.setProjectChanged(true);
        this.changed = false;
        this.addToPrevComments(comments);
    }

    private boolean confirmAnnotation() {
        Object[] options = new String[]{L10N.getLocalString("dlg.yes_btn", "Yes"), L10N.getLocalString("dlg.no_btn", "No"), L10N.getLocalString("dlg.yes_dont_ask_btn", "Yes, and don't ask me this again")};
        if (this.dontShowAnnotationConfirmation) {
            return true;
        }
        int choice = JOptionPane.showOptionDialog(this.frame, L10N.getLocalString("dlg.changing_text_lbl", "Changing this text box will overwrite the annotations associated with all bugs in this folder and subfolders. Are you sure?"), L10N.getLocalString("dlg.annotation_change_ttl", "Annotation Change"), -1, 3, null, options, options[0]);
        switch (choice) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                this.dontShowAnnotationConfirmation = true;
                return true;
            }
        }
        return true;
    }

    private void saveCommentsToNonLeaf(BugAspects aspects) {
        if (aspects == null) {
            return;
        }
        if (!this.changed) {
            return;
        }
        String newComment = this.getCurrentUserCommentsText();
        if (newComment.equals(this.getNonLeafCommentsText(aspects))) {
            return;
        }
        if (this.confirmAnnotation()) {
            BugSet filteredSet = aspects.getMatchingBugs(BugSet.getMainBugSet());
            for (BugLeafNode nextNode : filteredSet) {
                this.saveCommentsToBug(nextNode);
            }
        }
        this.changed = false;
    }

    public void saveComments() {
        this.saveComments(this.frame.currentSelectedBugLeaf, this.frame.currentSelectedBugAspects);
    }

    public void saveComments(BugLeafNode theNode, BugAspects theAspects) {
        if (theNode != null) {
            this.saveCommentsToBug(theNode);
        } else {
            this.saveCommentsToNonLeaf(theAspects);
        }
    }

    void loadPrevCommentsList(String[] list) {
        int i;
        String[] temp;
        int count = 0;
        for (String str : list) {
            if (!str.equals("")) continue;
            ++count;
        }
        String[] ary = new String[list.length - count];
        int j = 0;
        for (String str : list) {
            if (str.equals("")) continue;
            ary[j] = str;
            ++j;
        }
        this.prevCommentsList = new LinkedList();
        if (ary.length > 10) {
            temp = new String[10];
            for (i = 0; i < temp.length && i < ary.length; ++i) {
                temp[i] = ary[i];
            }
        } else {
            temp = new String[ary.length];
            for (i = 0; i < ary.length; ++i) {
                temp[i] = ary[i];
            }
        }
        for (String str : temp) {
            this.prevCommentsList.add(str);
        }
        this.resetPrevCommentsComboBox();
    }

    private void addToPrevComments(String comment) {
        if (comment.equals("")) {
            return;
        }
        if (this.prevCommentsList.contains(comment)) {
            int index = this.prevCommentsList.indexOf(comment);
            if (index == 0) {
                return;
            }
            this.prevCommentsList.remove(index);
        }
        this.prevCommentsList.addFirst(comment);
        while (this.prevCommentsList.size() > 10) {
            this.prevCommentsList.removeLast();
        }
        this.resetPrevCommentsComboBox();
    }

    private void resetPrevCommentsComboBox() {
        this.prevCommentsComboBox.removeAllItems();
        this.prevCommentsComboBox.addItem("");
        for (String str : this.prevCommentsList) {
            if (str.length() < 20) {
                this.prevCommentsComboBox.addItem(str);
                continue;
            }
            this.prevCommentsComboBox.addItem(str.substring(0, 17) + "...");
        }
    }

    private String getCurrentUserCommentsText() {
        return this.userCommentsText.getText();
    }

    private void setCurrentUserCommentsText(String comment) {
        this.changed = true;
        this.userCommentsText.setText(comment);
    }

    private String getCurrentPrevCommentsSelection() {
        return this.prevCommentsList.get(this.prevCommentsComboBox.getSelectedIndex() - 1);
    }

    void addDesignationItem(JMenu menu, final String menuName, int keyEvent) {
        JMenuItem toggleItem = new JMenuItem(menuName);
        toggleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (CommentsArea.this.frame.currentSelectedBugLeaf == null) {
                    CommentsArea.this.setDesignationNonLeaf(menuName);
                } else {
                    CommentsArea.this.setDesignation(menuName);
                }
            }
        });
        MainFrame.attachAcceleratorKey(toggleItem, keyEvent);
        menu.add(toggleItem);
    }

    void setDesignation(String designationName) {
        if (this.frame.currentSelectedBugLeaf == null) {
            return;
        }
        String designationKey = this.convertDesignationNameToDesignationKey(designationName);
        if (designationKey == null) {
            return;
        }
        if (this.changeDesignationOfBug(this.frame.currentSelectedBugLeaf, designationKey)) {
            this.changed = true;
            this.setProjectChanged(true);
        }
        this.setDesignationComboBox(designationKey);
    }

    protected void setDesignationNonLeaf(String designationName) {
        String designationKey = this.convertDesignationNameToDesignationKey(designationName);
        if (designationKey == null || this.frame.currentSelectedBugAspects == null) {
            return;
        }
        BugSet filteredSet = this.frame.currentSelectedBugAspects.getMatchingBugs(BugSet.getMainBugSet());
        for (BugLeafNode nextNode : filteredSet) {
            if (!this.changeDesignationOfBug(nextNode, designationKey)) continue;
            this.changed = true;
            this.setProjectChanged(true);
        }
        this.setDesignationComboBox(designationKey);
    }

    protected boolean changeDesignationOfBug(BugLeafNode theNode, String selection) {
        BugInstance bug = theNode.getBug();
        String oldValue = bug.getUserDesignationKey();
        if (selection.equals(oldValue)) {
            return false;
        }
        bug.setUserDesignationKey(selection, MainFrame.getInstance().bugCollection);
        return true;
    }

    protected void updateDesignationComboBox() {
        if (this.frame.currentSelectedBugLeaf == null) {
            this.updateCommentsFromNonLeafInformationFromSwingThread(this.frame.currentSelectedBugAspects);
        } else {
            int selectedIndex = this.designationComboBox.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.setDesignationComboBox(this.designationKeys.get(selectedIndex));
            } else {
                Debug.println("Couldn't find selected index in designationComboBox: " + this.designationComboBox.getSelectedItem());
            }
        }
    }

    protected void updateCommentsFromNonLeafInformationFromSwingThread(BugAspects theAspects) {
        if (theAspects == null) {
            return;
        }
        BugSet filteredSet = theAspects.getMatchingBugs(BugSet.getMainBugSet());
        boolean allSame = true;
        int first = -1;
        for (BugLeafNode nextNode : filteredSet) {
            int designationIndex = this.designationKeys.indexOf(nextNode.getBug().getNonnullUserDesignation().getDesignationKey());
            if (first == -1) {
                first = designationIndex;
                continue;
            }
            if (designationIndex == first) continue;
            allSame = false;
        }
        if (allSame) {
            this.designationComboBox.setSelectedIndex(first);
        } else {
            this.designationComboBox.setSelectedIndex(0);
        }
        this.userCommentsText.setText(this.getNonLeafCommentsText(theAspects));
        this.changed = false;
    }

    protected String getNonLeafCommentsText(BugAspects theAspects) {
        if (theAspects == null) {
            return "";
        }
        BugSet filteredSet = theAspects.getMatchingBugs(BugSet.getMainBugSet());
        boolean allSame = true;
        String comments = null;
        for (BugLeafNode nextNode : filteredSet) {
            String commentsOnThisBug = nextNode.getBug().getAnnotationText();
            if (comments == null) {
                comments = commentsOnThisBug;
                continue;
            }
            if (commentsOnThisBug.equals(comments)) continue;
            allSame = false;
        }
        if (comments == null || !allSame) {
            return "";
        }
        return comments;
    }

    protected void setDesignationComboBox(String designationKey) {
        int numItems = this.designationComboBox.getItemCount();
        for (int i = 0; i < numItems; ++i) {
            String value = this.designationKeys.get(i);
            if (!designationKey.equals(value)) continue;
            this.designationComboBox.setSelectedIndex(i);
            return;
        }
        if (MainFrame.DEBUG) {
            System.out.println("Couldn't find combo box for " + designationKey);
        }
    }

    public void moveNodeAccordingToDesignation(BugLeafNode theNode, String selection) {
        if (!this.getSorter().getOrder().contains(Sortables.DESIGNATION)) {
            theNode.getBug().getNonnullUserDesignation().setDesignationKey(selection);
        } else if (this.getSorter().getOrderBeforeDivider().contains(Sortables.DESIGNATION)) {
            BugTreeModel model = this.getModel();
            TreePath path = model.getPathToBug(theNode.getBug());
            if (path == null) {
                theNode.getBug().getNonnullUserDesignation().setDesignationKey(selection);
                return;
            }
            Object[] objPath = path.getParentPath().getPath();
            ArrayList<Object> reconstruct = new ArrayList<Object>();
            ArrayList<TreePath> listOfNodesToReconstruct = new ArrayList<TreePath>();
            for (int x = 0; x < objPath.length; ++x) {
                Object o = objPath[x];
                reconstruct.add(o);
                if (o instanceof BugAspects && ((BugAspects)o).getCount() == 1) break;
                TreePath pathToNode = new TreePath(reconstruct.toArray());
                listOfNodesToReconstruct.add(pathToNode);
            }
            theNode.getBug().getNonnullUserDesignation().setDesignationKey(selection);
            model.bugTreeFilterListener.suppressBug(path);
            TreePath unsuppressPath = model.getPathToBug(theNode.getBug());
            if (unsuppressPath != null) {
                model.bugTreeFilterListener.unsuppressBug(unsuppressPath);
            }
            for (TreePath pathToNode : listOfNodesToReconstruct) {
                model.treeNodeChanged(pathToNode);
            }
            this.setProjectChanged(true);
        } else if (this.getSorter().getOrderAfterDivider().contains(Sortables.DESIGNATION)) {
            theNode.getBug().getNonnullUserDesignation().setDesignationKey(selection);
            BugTreeModel model = this.getModel();
            TreePath path = model.getPathToBug(theNode.getBug());
            if (path != null) {
                model.sortBranch(path.getParentPath());
            }
        }
    }

    @CheckForNull
    protected String convertDesignationNameToDesignationKey(String name) {
        int itemCount = this.designationComboBox.getItemCount();
        for (int i = 1; i < itemCount; ++i) {
            if (!name.equals(this.designationComboBox.getItemAt(i))) continue;
            return this.designationKeys.get(i);
        }
        return null;
    }

    private void setProjectChanged(boolean b) {
        this.frame.setProjectChanged(b);
    }

    SorterTableColumnModel getSorter() {
        return this.frame.getSorter();
    }

    public void resized() {
        this.resetPrevCommentsComboBox();
        this.userCommentsText.validate();
    }

    BugTreeModel getModel() {
        return (BugTreeModel)this.frame.tree.getModel();
    }

    public boolean hasFocus() {
        return this.userCommentsText.hasFocus();
    }
}

