/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUISaveState {
    private static GUISaveState instance;
    private static final String SORTERTABLELENGTH = "Sorter Length";
    private static final String PREVCOMMENTSSIZE = "Previous Comments Size";
    private static final String PREFERENCESDIRECTORY = "Preference Directory";
    private static final String DOCKINGLAYOUT = "Docking Layout";
    private static final String FRAME_BOUNDS = "Frame Bounds";
    private static final int MAXNUMRECENTPROJECTS = 5;
    private static final int MAXNUMRECENTANALYSES = 5;
    private static final Sortables[] DEFAULT_COLUMN_HEADERS;
    private static final String[] RECENTPROJECTKEYS;
    private static final String[] RECENTANALYSISKEYS;
    private static final int MAXNUMPREVCOMMENTS = 10;
    private static final String[] COMMENTKEYS;
    private static final String NUMPROJECTS = "NumberOfProjectsToLoad";
    private static final String NUMANALYSES = "NumberOfAnalysesToLoad";
    private static final String STARTERDIRECTORY = "Starter Directory";
    private static final String SPLIT_MAIN = "MainSplit";
    private static final String SPLIT_TREE_COMMENTS = "TreeCommentsSplit";
    private static final String SPLIT_TOP = "TopSplit";
    private static final String SPLIT_SUMMARY = "SummarySplit";
    private int splitMain;
    private int splitTreeComments;
    private int splitTop;
    private int splitSummary;
    private File starterDirectoryForLoadBugs;
    private LinkedList<String> previousComments;
    private boolean useDefault = false;
    private SorterTableColumnModel starterTable;
    private ArrayList<File> recentFiles = new ArrayList();
    private byte[] dockingLayout;
    private Rectangle frameBounds;
    private static final String TAB_SIZE = "TabSize";
    private int tabSize;
    private static final String FONT_SIZE = "FontSize";
    private float fontSize;
    private int packagePrefixSegments;
    private static final String PACKAGE_PREFIX_SEGEMENTS = "PackagePrefixSegments";

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public int getPackagePrefixSegments() {
        return this.packagePrefixSegments;
    }

    public void setPackagePrefixSegments(int packagePrefixSegments) {
        this.packagePrefixSegments = packagePrefixSegments;
    }

    public byte[] getDockingLayout() {
        return this.dockingLayout;
    }

    public void setDockingLayout(byte[] dockingLayout) {
        this.dockingLayout = dockingLayout;
    }

    private static String[] generateSorterKeys(int numSorters) {
        String[] result = new String[numSorters];
        for (int x = 0; x < result.length; ++x) {
            result[x] = "Sorter" + x;
        }
        return result;
    }

    SorterTableColumnModel getStarterTable() {
        if (this.useDefault || this.starterTable == null) {
            this.starterTable = new SorterTableColumnModel(DEFAULT_COLUMN_HEADERS);
        }
        return this.starterTable;
    }

    private GUISaveState() {
        this.previousComments = new LinkedList();
    }

    public static synchronized GUISaveState getInstance() {
        if (instance == null) {
            instance = new GUISaveState();
        }
        return instance;
    }

    public void fileReused(File f) {
        if (!this.recentFiles.contains(f)) {
            throw new IllegalStateException("Selected a recent project that doesn't exist?");
        }
        this.recentFiles.remove(f);
        this.recentFiles.add(f);
    }

    public void addRecentFile(File f) {
        this.recentFiles.add(f);
    }

    public ArrayList<File> getRecentFiles() {
        return this.recentFiles;
    }

    public void fileNotFound(File f) {
        if (!this.recentFiles.contains(f)) {
            throw new IllegalStateException("Well no wonder it wasn't found, its not in the list.");
        }
        this.recentFiles.remove(f);
    }

    public File getStarterDirectoryForLoadBugs() {
        return this.starterDirectoryForLoadBugs;
    }

    public void setStarterDirectoryForLoadBugs(File f) {
        this.starterDirectoryForLoadBugs = f;
    }

    public static void loadInstance() {
        GUISaveState newInstance = new GUISaveState();
        newInstance.recentFiles = new ArrayList();
        Preferences p = Preferences.userNodeForPackage(GUISaveState.class);
        newInstance.tabSize = p.getInt(TAB_SIZE, 4);
        newInstance.fontSize = p.getFloat(FONT_SIZE, 12.0f);
        newInstance.starterDirectoryForLoadBugs = new File(p.get(STARTERDIRECTORY, SystemProperties.getProperty("user.dir")));
        int prevCommentsSize = p.getInt(PREVCOMMENTSSIZE, 0);
        for (int x = 0; x < prevCommentsSize; ++x) {
            String comment = p.get(COMMENTKEYS[x], "");
            newInstance.previousComments.add(comment);
        }
        int size = Math.min(5, p.getInt(NUMPROJECTS, 0));
        for (int x = 0; x < size; ++x) {
            newInstance.recentFiles.add(new File(p.get(RECENTPROJECTKEYS[x], "")));
        }
        int sorterSize = p.getInt(SORTERTABLELENGTH, -1);
        if (sorterSize != -1) {
            Sortables[] sortColumns = new Sortables[sorterSize];
            String[] sortKeys = GUISaveState.generateSorterKeys(sorterSize);
            for (int x = 0; x < sorterSize; ++x) {
                sortColumns[x] = Sortables.getSortableByPrettyName(p.get(sortKeys[x], "*none*"));
                if (sortColumns[x] != null) continue;
                if (MainFrame.DEBUG) {
                    System.err.println("Sort order was corrupted, using default sort order");
                }
                newInstance.useDefault = true;
            }
            if (!newInstance.useDefault) {
                newInstance.starterTable = new SorterTableColumnModel(sortColumns);
            }
        } else {
            newInstance.useDefault = true;
        }
        newInstance.dockingLayout = p.getByteArray(DOCKINGLAYOUT, new byte[0]);
        String boundsString = p.get(FRAME_BOUNDS, null);
        Rectangle r = new Rectangle(0, 0, 800, 650);
        if (boundsString != null) {
            String[] a = boundsString.split(",", 4);
            if (a.length > 0) {
                try {
                    r.x = Math.max(0, Integer.parseInt(a[0]));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (a.length > 1) {
                try {
                    r.y = Math.max(0, Integer.parseInt(a[1]));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (a.length > 2) {
                try {
                    r.width = Math.max(40, Integer.parseInt(a[2]));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (a.length > 3) {
                try {
                    r.height = Math.max(40, Integer.parseInt(a[3]));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        newInstance.frameBounds = r;
        newInstance.splitMain = p.getInt(SPLIT_MAIN, 400);
        newInstance.splitSummary = p.getInt(SPLIT_SUMMARY, 85);
        newInstance.splitTop = p.getInt(SPLIT_TOP, -1);
        newInstance.splitTreeComments = p.getInt(SPLIT_TREE_COMMENTS, 250);
        newInstance.packagePrefixSegments = p.getInt(PACKAGE_PREFIX_SEGEMENTS, 3);
        instance = newInstance;
    }

    public void save() {
        int x;
        Preferences p = Preferences.userNodeForPackage(GUISaveState.class);
        p.putInt(TAB_SIZE, this.tabSize);
        p.putFloat(FONT_SIZE, this.fontSize);
        try {
            p.put(STARTERDIRECTORY, this.starterDirectoryForLoadBugs.getCanonicalPath());
        }
        catch (IOException e) {
            Debug.println(e);
        }
        int sorterLength = MainFrame.getInstance().getSorter().getColumnCount();
        ArrayList<Sortables> sortables = MainFrame.getInstance().getSorter().getOrder();
        p.putInt(SORTERTABLELENGTH, sorterLength);
        String[] sorterKeys = GUISaveState.generateSorterKeys(sorterLength);
        for (x = 0; x < sorterKeys.length; ++x) {
            p.put(sorterKeys[x], sortables.get((int)x).prettyName);
        }
        p.putInt(PREVCOMMENTSSIZE, this.previousComments.size());
        for (x = 0; x < this.previousComments.size(); ++x) {
            String comment = this.previousComments.get(x);
            p.put(COMMENTKEYS[x], comment);
        }
        int size = this.recentFiles.size();
        while (this.recentFiles.size() > 5) {
            this.recentFiles.remove(0);
        }
        p.putInt(NUMPROJECTS, Math.min(size, 5));
        for (int x2 = 0; x2 < Math.min(size, 5); ++x2) {
            File file = this.recentFiles.get(x2);
            p.put(RECENTPROJECTKEYS[x2], file.getAbsolutePath());
        }
        p.putByteArray(DOCKINGLAYOUT, this.dockingLayout);
        p.put(FRAME_BOUNDS, this.frameBounds.x + "," + this.frameBounds.y + "," + this.frameBounds.width + "," + this.frameBounds.height);
        p.putInt(SPLIT_MAIN, this.splitMain);
        p.putInt(SPLIT_SUMMARY, this.splitSummary);
        p.putInt(SPLIT_TOP, this.splitTop);
        p.putInt(SPLIT_TREE_COMMENTS, this.splitTreeComments);
        p.putInt(PACKAGE_PREFIX_SEGEMENTS, this.packagePrefixSegments);
    }

    static void clear() {
        Preferences p = Preferences.userNodeForPackage(GUISaveState.class);
        try {
            p.clear();
        }
        catch (BackingStoreException e) {
            Debug.println(e);
        }
        instance = new GUISaveState();
    }

    public LinkedList<String> getPreviousComments() {
        return this.previousComments;
    }

    public void setPreviousComments(LinkedList<String> previousComments) {
        this.previousComments = previousComments;
    }

    public Rectangle getFrameBounds() {
        return this.frameBounds;
    }

    public void setFrameBounds(Rectangle frameBounds) {
        this.frameBounds = frameBounds;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public int getSplitMain() {
        return this.splitMain;
    }

    public void setSplitMain(int splitMain) {
        this.splitMain = splitMain;
    }

    public int getSplitSummary() {
        return this.splitSummary;
    }

    public void setSplitSummary(int splitSummary) {
        this.splitSummary = splitSummary;
    }

    public int getSplitTop() {
        return this.splitTop;
    }

    public void setSplitTop(int splitTop) {
        this.splitTop = splitTop;
    }

    public int getSplitTreeComments() {
        return this.splitTreeComments;
    }

    public void setSplitTreeComments(int splitTreeComments) {
        this.splitTreeComments = splitTreeComments;
    }

    static {
        int x;
        DEFAULT_COLUMN_HEADERS = new Sortables[]{Sortables.CATEGORY, Sortables.BUGCODE, Sortables.TYPE, Sortables.DIVIDER, Sortables.PRIORITY};
        RECENTPROJECTKEYS = new String[5];
        RECENTANALYSISKEYS = new String[5];
        for (x = 0; x < RECENTPROJECTKEYS.length; ++x) {
            GUISaveState.RECENTPROJECTKEYS[x] = "Project" + x;
            GUISaveState.RECENTANALYSISKEYS[x] = "Analysis" + x;
        }
        COMMENTKEYS = new String[10];
        for (x = 0; x < COMMENTKEYS.length; ++x) {
            GUISaveState.COMMENTKEYS[x] = "Comment" + x;
        }
    }
}

