/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.LastVersionMatcher;
import edu.umd.cs.findbugs.gui.ConsoleLogger;
import edu.umd.cs.findbugs.gui.LogSync;
import edu.umd.cs.findbugs.gui.Logger;
import edu.umd.cs.findbugs.gui2.AboutDialog;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugLoader;
import edu.umd.cs.findbugs.gui2.BugRenderer;
import edu.umd.cs.findbugs.gui2.BugSaver;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.CommentsArea;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBFileChooser;
import edu.umd.cs.findbugs.gui2.FBFrame;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.FindBugsAnalysisFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBAFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBPFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFilterFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManager;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManagerFactory;
import edu.umd.cs.findbugs.gui2.FindBugsProjectFileFilter;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.NewFilterFromBug;
import edu.umd.cs.findbugs.gui2.NewProjectWizard;
import edu.umd.cs.findbugs.gui2.OriginalGUI2ProjectFile;
import edu.umd.cs.findbugs.gui2.PreferencesFrame;
import edu.umd.cs.findbugs.gui2.ProjectSettings;
import edu.umd.cs.findbugs.gui2.RecentMenu;
import edu.umd.cs.findbugs.gui2.SaveType;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterDialog;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import edu.umd.cs.findbugs.gui2.SourceCodeDisplay;
import edu.umd.cs.findbugs.gui2.SwingThread;
import edu.umd.cs.findbugs.sourceViewer.NavigableTextPane;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;

public class MainFrame
extends FBFrame
implements LogSync {
    JTree tree;
    private BasicTreeUI treeUI;
    boolean userInputEnabled;
    static final String DEFAULT_SOURCE_CODE_MSG = L10N.getLocalString("msg.nosource_txt", "No available source");
    static final int COMMENTS_TAB_STRUT_SIZE = 5;
    static final int COMMENTS_MARGIN = 5;
    static final int SEARCH_TEXT_FIELD_SIZE = 32;
    static final String TITLE_START_TXT = "FindBugs: ";
    private JTextField sourceSearchTextField = new JTextField(32);
    private JButton findButton = MainFrame.newButton("button.find", "Find");
    private JButton findNextButton = MainFrame.newButton("button.findNext", "Find Next");
    private JButton findPreviousButton = MainFrame.newButton("button.findPrev", "Find Previous");
    public static final boolean DEBUG = SystemProperties.getBoolean("gui2.debug");
    static final boolean MAC_OS_X = SystemProperties.getProperty("os.name").toLowerCase().startsWith("mac os x");
    static final String WINDOW_MODIFIED = "windowModified";
    NavigableTextPane sourceCodeTextPane = new NavigableTextPane();
    private JScrollPane sourceCodeScrollPane;
    final CommentsArea comments;
    private SorterTableColumnModel sorter;
    private JTableHeader tableheader;
    private JLabel statusBarLabel = new JLabel();
    private JPanel summaryTopPanel;
    private final HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
    private final JEditorPane summaryHtmlArea = new JEditorPane();
    private JScrollPane summaryHtmlScrollPane = new JScrollPane(this.summaryHtmlArea);
    private final FindBugsLayoutManagerFactory findBugsLayoutManagerFactory;
    private final FindBugsLayoutManager guiLayout;
    boolean projectChanged = false;
    private final JMenuItem reconfigMenuItem = MainFrame.newJMenuItem("menu.reconfig", "Reconfigure...", 70);
    private JMenuItem redoAnalysis;
    BugLeafNode currentSelectedBugLeaf;
    BugAspects currentSelectedBugAspects;
    private JPopupMenu bugPopupMenu;
    private JPopupMenu branchPopupMenu;
    private static MainFrame instance;
    private RecentMenu recentMenuCache;
    private JMenu recentMenu;
    private JMenuItem preferencesMenuItem;
    private Project curProject = new Project();
    private JScrollPane treeScrollPane;
    SourceFinder sourceFinder;
    private Object lock = new Object();
    private boolean newProject = false;
    private Class<?> osxAdapter;
    private Method osxPrefsEnableMethod;
    private Logger logger = new ConsoleLogger(this);
    SourceCodeDisplay displayer = new SourceCodeDisplay(this);
    private SaveType saveType = SaveType.NOT_KNOWN;
    FBFileChooser saveOpenFileChooser;
    FBFileChooser filterOpenFileChooser;
    @CheckForNull
    private File saveFile = null;
    JMenuItem saveMenuItem = MainFrame.newJMenuItem("menu.save_item", "Save", 83);
    BugCollection bugCollection;
    static final String TREECARD = "Tree";
    static final String WAITCARD = "Wait";
    JPanel waitPanel;
    JPanel cardPanel;
    @CheckForNull
    Pattern sourceFileLinkPattern;
    String sourceFileLinkFormat;
    String sourceFileLinkToolTip;
    URL sourceLink;
    boolean listenerAdded = false;

    static JButton newButton(String key, String name) {
        JButton b = new JButton();
        L10N.localiseButton(b, key, name, false);
        return b;
    }

    static JMenuItem newJMenuItem(String key, String string, int vkF) {
        JMenuItem m = new JMenuItem();
        L10N.localiseButton(m, key, string, false);
        m.setMnemonic(vkF);
        return m;
    }

    static JMenuItem newJMenuItem(String key, String string) {
        JMenuItem m = new JMenuItem();
        L10N.localiseButton(m, key, string, true);
        return m;
    }

    static JMenu newJMenu(String key, String string) {
        JMenu m = new JMenu();
        L10N.localiseButton(m, key, string, true);
        return m;
    }

    static boolean isMacLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getName().startsWith("apple");
    }

    static void makeInstance(FindBugsLayoutManagerFactory factory) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = new MainFrame(factory);
        instance.initializeGUI();
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    public static boolean isAvailable() {
        return instance != null;
    }

    private void initializeGUI() {
        SwingUtilities.invokeLater(new InitializeGUI());
    }

    private MainFrame(FindBugsLayoutManagerFactory factory) {
        this.findBugsLayoutManagerFactory = factory;
        this.guiLayout = factory.getInstance(this);
        this.comments = new CommentsArea(this);
        FindBugsDisplayFeatures.setAbridgedMessages(true);
        String sp = SystemProperties.getProperty("findbugs.sourcelink.pattern");
        String sf = SystemProperties.getProperty("findbugs.sourcelink.format");
        if (sf != null) {
            sf = sf.replace("ESCAPEDPERCENT", "%");
        }
        String stt = SystemProperties.getProperty("findbugs.sourcelink.tooltip");
        if (sp != null && sf != null) {
            try {
                this.sourceFileLinkPattern = Pattern.compile(sp);
                this.sourceFileLinkFormat = sf;
                this.sourceFileLinkToolTip = stt;
            }
            catch (RuntimeException e) {
                AnalysisContext.logError("Could not compile pattern " + sp, e);
            }
        }
    }

    void about() {
        AboutDialog dialog = new AboutDialog(this, this.logger, true);
        dialog.setSize(600, 554);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    void preferences() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        PreferencesFrame.getInstance().setLocationRelativeTo(this);
        PreferencesFrame.getInstance().setVisible(true);
    }

    void enablePreferences(boolean b) {
        this.preferencesMenuItem.setEnabled(b);
        if (MAC_OS_X && this.osxPrefsEnableMethod != null) {
            Object[] args = new Object[]{b};
            try {
                this.osxPrefsEnableMethod.invoke(this.osxAdapter, args);
            }
            catch (Exception e) {
                System.err.println("Exception while enabling Preferences menu: " + e);
            }
        }
    }

    void callOnClose() {
        this.comments.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        if (this.projectChanged) {
            int value = JOptionPane.showConfirmDialog(this, this.getActionWithoutSavingMsg("closing"), L10N.getLocalString("msg.confirm_save_txt", "Do you want to save?"), 1, 3);
            if (value == 2 || value == -1) {
                return;
            }
            if (value == 0) {
                if (this.saveFile == null) {
                    if (!this.saveAs()) {
                        return;
                    }
                } else {
                    this.save();
                }
            }
        }
        GUISaveState.getInstance().setPreviousComments(this.comments.prevCommentsList);
        this.guiLayout.saveState();
        GUISaveState.getInstance().setFrameBounds(this.getBounds());
        GUISaveState.getInstance().save();
        System.exit(0);
    }

    private String getActionWithoutSavingMsg(String action) {
        String msg = L10N.getLocalString("msg.you_are_" + action + "_without_saving_txt", null);
        if (msg != null) {
            return msg;
        }
        return L10N.getLocalString("msg.you_are_" + action + "_txt", "You are " + action) + " " + L10N.getLocalString("msg.without_saving_txt", "without saving. Do you want to save?");
    }

    JMenuItem createRecentItem(final File f, final SaveType localSaveType) {
        if (DEBUG) {
            System.out.println("createRecentItem(" + f + ", " + (Object)((Object)localSaveType) + ")");
        }
        String name = f.getName();
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    MainFrame.this.setCursor(new Cursor(3));
                    if (!f.exists()) {
                        JOptionPane.showMessageDialog(null, L10N.getLocalString("msg.proj_not_found", "This project can no longer be found"));
                        GUISaveState.getInstance().fileNotFound(f);
                        return;
                    }
                    GUISaveState.getInstance().fileReused(f);
                    MainFrame.this.recentMenuCache.addRecentFile(f);
                    if (!f.exists()) {
                        throw new IllegalStateException("User used a recent projects menu item that didn't exist.");
                    }
                    if (MainFrame.this.curProject != null && MainFrame.this.projectChanged) {
                        int response = JOptionPane.showConfirmDialog(MainFrame.this, L10N.getLocalString("dlg.save_current_changes", "The current project has been changed, Save current changes?"), L10N.getLocalString("dlg.save_changes", "Save Changes?"), 1, 2);
                        if (response == 0) {
                            if (MainFrame.this.saveFile != null) {
                                MainFrame.this.save();
                            } else {
                                MainFrame.this.saveAs();
                            }
                        } else if (response == 2) {
                            return;
                        }
                    }
                    SaveType st = SaveType.forFile(f);
                    boolean result = true;
                    switch (st) {
                        case PROJECT: {
                            MainFrame.this.openProject(f);
                            break;
                        }
                        case XML_ANALYSIS: {
                            result = MainFrame.this.openAnalysis(f, st);
                            break;
                        }
                        case FBP_FILE: {
                            result = MainFrame.this.openFBPFile(f);
                            break;
                        }
                        case FBA_FILE: {
                            result = MainFrame.this.openFBAFile(f);
                            break;
                        }
                        default: {
                            MainFrame.this.error("Wrong file type in recent menu item.");
                        }
                    }
                    if (!result) {
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "There was an error in opening the file", "Recent Menu Opening Error", 2);
                    }
                }
                finally {
                    MainFrame.this.setCursor(new Cursor(0));
                    MainFrame.this.setSaveType(localSaveType);
                }
            }
        });
        item.setFont(item.getFont().deriveFont(Driver.getFontSize()));
        return item;
    }

    @SwingThread
    void setProjectAndBugCollection(Project project, @CheckForNull BugCollection bugCollection) {
        Filter suppressionMatcher = project.getSuppressionFilter();
        if (suppressionMatcher != null) {
            suppressionMatcher.softAdd(LastVersionMatcher.DEAD_BUG_MATCHER);
        }
        if (bugCollection == null) {
            this.showTreeCard();
        } else {
            this.curProject = project;
            this.bugCollection = bugCollection;
            this.displayer.clearCache();
            BugTreeModel model = (BugTreeModel)this.getTree().getModel();
            this.setSourceFinder(new SourceFinder());
            this.getSourceFinder().setSourceBaseList(project.getSourceDirList());
            BugSet bs = new BugSet(bugCollection);
            model.getOffListenerList();
            model.changeSet(bs);
            if (bs.size() == 0 && bs.sizeUnfiltered() > 0) {
                this.warnUserOfFilters();
            }
            this.updateStatusBar();
        }
        PreferencesFrame.getInstance().updateFilterPanel();
        this.setProjectChanged(false);
        this.reconfigMenuItem.setEnabled(true);
        this.newProject();
        this.clearSourcePane();
        this.clearSummaryTab();
        this.changeTitle();
    }

    void updateProjectAndBugCollection(Project project, BugCollection bugCollection, BugTreeModel previousModel) {
        this.setRebuilding(false);
        if (bugCollection != null) {
            this.displayer.clearCache();
            BugSet bs = new BugSet(bugCollection);
            ((BugTreeModel)this.tree.getModel()).getOffListenerList();
            ((BugTreeModel)this.tree.getModel()).changeSet(bs);
            this.setProjectChanged(true);
        }
        this.setCursor(new Cursor(0));
    }

    public void changeTitle() {
        String name = this.curProject.getProjectName();
        if (name == null && this.saveFile != null) {
            name = this.saveFile.getAbsolutePath();
        }
        if (name == null) {
            name = "<<unnamed project>>";
        }
        this.setTitle(TITLE_START_TXT + name);
    }

    private JPopupMenu createBugPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filterMenuItem = MainFrame.newJMenuItem("menu.filterBugsLikeThis", "Filter bugs like this");
        filterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                new NewFilterFromBug(MainFrame.this.currentSelectedBugLeaf.getBug());
                MainFrame.this.setProjectChanged(true);
                MainFrame.getInstance().getTree().setSelectionRow(0);
            }
        });
        popupMenu.add(filterMenuItem);
        JMenu changeDesignationMenu = MainFrame.newJMenu("menu.changeDesignation", "Change bug designation");
        int i = 0;
        int[] keyEvents = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        for (String key : I18N.instance().getUserDesignationKeys(true)) {
            String name = I18N.instance().getUserDesignation(key);
            this.comments.addDesignationItem(changeDesignationMenu, name, keyEvents[i++]);
        }
        popupMenu.add(changeDesignationMenu);
        return popupMenu;
    }

    private JPopupMenu createBranchPopUpMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filterMenuItem = MainFrame.newJMenuItem("menu.filterTheseBugs", "Filter these bugs");
        filterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreePath path;
                MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                TreePath deletePath = path = MainFrame.getInstance().getTree().getSelectionPath();
                int startCount = ((BugAspects)path.getLastPathComponent()).getCount();
                int count = ((BugAspects)path.getParentPath().getLastPathComponent()).getCount();
                while (count == startCount) {
                    if ((deletePath = deletePath.getParentPath()).getParentPath() == null) {
                        edu.umd.cs.findbugs.filter.Matcher m = MainFrame.this.currentSelectedBugAspects.getMatcher();
                        Filter suppressionFilter = MainFrame.getInstance().getProject().getSuppressionFilter();
                        suppressionFilter.addChild(m);
                        PreferencesFrame.getInstance().updateFilterPanel();
                        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
                        return;
                    }
                    count = ((BugAspects)deletePath.getParentPath().getLastPathComponent()).getCount();
                }
                BugTreeModel model = MainFrame.getInstance().getBugTreeModel();
                TreeModelEvent event = new TreeModelEvent((Object)this, deletePath.getParentPath(), new int[]{model.getIndexOfChild(deletePath.getParentPath().getLastPathComponent(), deletePath.getLastPathComponent())}, new Object[]{deletePath.getLastPathComponent()});
                edu.umd.cs.findbugs.filter.Matcher m = MainFrame.this.currentSelectedBugAspects.getMatcher();
                Filter suppressionFilter = MainFrame.getInstance().getProject().getSuppressionFilter();
                suppressionFilter.addChild(m);
                PreferencesFrame.getInstance().updateFilterPanel();
                model.sendEvent(event, BugTreeModel.TreeModification.REMOVE);
                MainFrame.this.setProjectChanged(true);
                MainFrame.getInstance().getTree().setSelectionRow(0);
            }
        });
        popupMenu.add(filterMenuItem);
        JMenu changeDesignationMenu = MainFrame.newJMenu("menu.changeDesignation", "Change bug designation");
        int i = 0;
        int[] keyEvents = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        for (String key : I18N.instance().getUserDesignationKeys(true)) {
            String name = I18N.instance().getUserDesignation(key);
            this.addDesignationItem(changeDesignationMenu, name, keyEvents[i++]);
        }
        popupMenu.add(changeDesignationMenu);
        return popupMenu;
    }

    protected JMenuBar createMainMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = MainFrame.newJMenu("menu.file_menu", "File");
        fileMenu.setMnemonic(70);
        JMenu editMenu = MainFrame.newJMenu("menu.edit_menu", "Edit");
        editMenu.setMnemonic(69);
        JMenuItem newProjectMenuItem = MainFrame.newJMenuItem("menu.new_item", "New Project", 78);
        JMenuItem openMenuItem = MainFrame.newJMenuItem("menu.open_item", "Open...", 79);
        this.recentMenu = MainFrame.newJMenu("menu.recent", "Recent");
        this.recentMenuCache = new RecentMenu(this.recentMenu);
        JMenuItem saveAsMenuItem = MainFrame.newJMenuItem("menu.saveas_item", "Save As...", 65);
        this.redoAnalysis = MainFrame.newJMenuItem("menu.rerunAnalysis", "Redo Analysis", 82);
        JMenuItem importFilter = MainFrame.newJMenuItem("menu.importFilter_item", "Import filter...");
        JMenuItem exportFilter = MainFrame.newJMenuItem("menu.exportFilter_item", "Export filter...");
        JMenuItem exitMenuItem = null;
        if (!MAC_OS_X) {
            exitMenuItem = MainFrame.newJMenuItem("menu.exit", "Exit", 88);
            exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainFrame.this.callOnClose();
                }
            });
        }
        JMenu windowMenu = this.guiLayout.createWindowMenu();
        MainFrame.attachAcceleratorKey(newProjectMenuItem, 78);
        newProjectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.newProjectMenu();
            }
        });
        this.reconfigMenuItem.setEnabled(false);
        MainFrame.attachAcceleratorKey(this.reconfigMenuItem, 70);
        this.reconfigMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                new NewProjectWizard(MainFrame.this.curProject);
            }
        });
        JMenuItem mergeMenuItem = MainFrame.newJMenuItem("menu.mergeAnalysis", "Merge Analysis...");
        mergeMenuItem.setEnabled(true);
        mergeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.mergeAnalysis();
            }
        });
        this.redoAnalysis.setEnabled(false);
        MainFrame.attachAcceleratorKey(this.redoAnalysis, 82);
        this.redoAnalysis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.redoAnalysis();
            }
        });
        openMenuItem.setEnabled(true);
        MainFrame.attachAcceleratorKey(openMenuItem, 79);
        openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.open();
            }
        });
        saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveAs();
            }
        });
        exportFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exportFilter();
            }
        });
        importFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.importFilter();
            }
        });
        this.saveMenuItem.setEnabled(false);
        MainFrame.attachAcceleratorKey(this.saveMenuItem, 83);
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.save();
            }
        });
        fileMenu.add(newProjectMenuItem);
        fileMenu.add(this.reconfigMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(openMenuItem);
        fileMenu.add(this.recentMenu);
        fileMenu.addSeparator();
        fileMenu.add(importFilter);
        fileMenu.add(exportFilter);
        fileMenu.addSeparator();
        fileMenu.add(saveAsMenuItem);
        fileMenu.add(this.saveMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(this.redoAnalysis);
        if (exitMenuItem != null) {
            fileMenu.addSeparator();
            fileMenu.add(exitMenuItem);
        }
        menuBar.add(fileMenu);
        JMenuItem cutMenuItem = new JMenuItem(new CutAction());
        JMenuItem copyMenuItem = new JMenuItem(new CopyAction());
        JMenuItem pasteMenuItem = new JMenuItem(new PasteAction());
        this.preferencesMenuItem = MainFrame.newJMenuItem("menu.preferences_menu", "Filters/Suppressions...");
        JMenuItem sortMenuItem = MainFrame.newJMenuItem("menu.sortConfiguration", "Sort Configuration...");
        JMenuItem goToLineMenuItem = MainFrame.newJMenuItem("menu.gotoLine", "Go to line...");
        MainFrame.attachAcceleratorKey(cutMenuItem, 88);
        MainFrame.attachAcceleratorKey(copyMenuItem, 67);
        MainFrame.attachAcceleratorKey(pasteMenuItem, 86);
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.preferences();
            }
        });
        sortMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                SorterDialog.getInstance().setLocationRelativeTo(MainFrame.this);
                SorterDialog.getInstance().setVisible(true);
            }
        });
        MainFrame.attachAcceleratorKey(goToLineMenuItem, 76);
        goToLineMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.guiLayout.makeSourceVisible();
                try {
                    int num = Integer.parseInt(JOptionPane.showInputDialog(MainFrame.this, "", L10N.getLocalString("dlg.go_to_line_lbl", "Go To Line") + ":", 3));
                    MainFrame.this.displayer.showLine(num);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        editMenu.add(cutMenuItem);
        editMenu.add(copyMenuItem);
        editMenu.add(pasteMenuItem);
        editMenu.addSeparator();
        editMenu.add(goToLineMenuItem);
        editMenu.addSeparator();
        if (!MAC_OS_X) {
            editMenu.add(this.preferencesMenuItem);
        }
        editMenu.add(sortMenuItem);
        menuBar.add(editMenu);
        if (windowMenu != null) {
            menuBar.add(windowMenu);
        }
        ActionMap map = this.tree.getActionMap();
        JMenu navMenu = MainFrame.newJMenu("menu.navigation", "Navigation");
        this.addNavItem(map, navMenu, "menu.expand", "Expand", "expand", 39);
        this.addNavItem(map, navMenu, "menu.collapse", "Collapse", "collapse", 37);
        this.addNavItem(map, navMenu, "menu.up", "Up", "selectPrevious", 38);
        this.addNavItem(map, navMenu, "menu.down", "Down", "selectNext", 40);
        menuBar.add(navMenu);
        JMenu designationMenu = MainFrame.newJMenu("menu.designation", "Designation");
        int i = 0;
        int[] keyEvents = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        for (String key : I18N.instance().getUserDesignationKeys(true)) {
            String name = I18N.instance().getUserDesignation(key);
            this.addDesignationItem(designationMenu, name, keyEvents[i++]);
        }
        menuBar.add(designationMenu);
        if (!MAC_OS_X) {
            JMenu helpMenu = MainFrame.newJMenu("menu.help_menu", "Help");
            JMenuItem aboutItem = MainFrame.newJMenuItem("menu.about_item", "About FindBugs");
            helpMenu.add(aboutItem);
            aboutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainFrame.this.about();
                }
            });
            menuBar.add(helpMenu);
        }
        return menuBar;
    }

    private void addNavItem(ActionMap map, JMenu navMenu, String menuNameKey, String menuNameDefault, String actionName, int keyEvent) {
        JMenuItem toggleItem = MainFrame.newJMenuItem(menuNameKey, menuNameDefault);
        toggleItem.addActionListener(this.treeActionAdapter(map, actionName));
        MainFrame.attachAcceleratorKey(toggleItem, keyEvent);
        navMenu.add(toggleItem);
    }

    ActionListener treeActionAdapter(ActionMap map, String actionName) {
        final Action selectPrevious = map.get(actionName);
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                e.setSource(MainFrame.this.tree);
                selectPrevious.actionPerformed(e);
            }
        };
    }

    static void attachAcceleratorKey(JMenuItem item, int keystroke) {
        MainFrame.attachAcceleratorKey(item, keystroke, 0);
    }

    static void attachAcceleratorKey(JMenuItem item, int keystroke, int additionalMask) {
        if (!MAC_OS_X && additionalMask != 0) {
            return;
        }
        item.setAccelerator(KeyStroke.getKeyStroke(keystroke, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | additionalMask));
    }

    void newProject() {
        this.clearSourcePane();
        this.redoAnalysis.setEnabled(true);
        if (this.newProject) {
            this.setProjectChanged(true);
            this.saveFile = null;
            this.saveMenuItem.setEnabled(false);
            this.reconfigMenuItem.setEnabled(true);
            this.newProject = false;
        }
    }

    private void importFilter() {
        boolean loading = true;
        this.filterOpenFileChooser.setDialogTitle(L10N.getLocalString("dlg.importFilter_ttl", "Import and merge filter..."));
        boolean retry = true;
        boolean alreadyExists = true;
        File f = null;
        while (retry) {
            Filter filter;
            retry = false;
            int value = this.filterOpenFileChooser.showOpenDialog(this);
            if (value != 0) {
                return;
            }
            f = this.filterOpenFileChooser.getSelectedFile();
            if (!f.exists()) {
                JOptionPane.showMessageDialog(this.filterOpenFileChooser, "No such file", "Invalid File", 2);
                retry = true;
                continue;
            }
            try {
                filter = Filter.parseFilter(f.getPath());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.filterOpenFileChooser, "Could not load filter.");
                retry = true;
                continue;
            }
            this.projectChanged = true;
            if (this.curProject.getSuppressionFilter() == null) {
                this.curProject.setSuppressionFilter(filter);
            } else {
                for (edu.umd.cs.findbugs.filter.Matcher m : filter.getChildren()) {
                    this.curProject.getSuppressionFilter().addChild(m);
                }
            }
            PreferencesFrame.getInstance().updateFilterPanel();
        }
    }

    private void open() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        if (this.projectChanged) {
            int response = JOptionPane.showConfirmDialog(this, L10N.getLocalString("dlg.save_current_changes", "The current project has been changed, Save current changes?"), L10N.getLocalString("dlg.save_changes", "Save Changes?"), 1, 2);
            if (response == 0) {
                if (this.saveFile != null) {
                    this.save();
                } else {
                    this.saveAs();
                }
            } else if (response == 2) {
                return;
            }
        }
        boolean loading = true;
        SaveType fileType = SaveType.NOT_KNOWN;
        while (loading) {
            File f;
            int value = this.saveOpenFileChooser.showOpenDialog(this);
            if (value != 0) {
                return;
            }
            loading = false;
            fileType = this.convertFilterToType(this.saveOpenFileChooser.getFileFilter());
            if (!fileType.isValid(f = this.saveOpenFileChooser.getSelectedFile())) {
                JOptionPane.showMessageDialog(this.saveOpenFileChooser, "That file is not compatible with the choosen file type", "Invalid File", 2);
                loading = true;
                continue;
            }
            switch (fileType) {
                case PROJECT: {
                    File xmlFile = OriginalGUI2ProjectFile.fileContainingXMLData(f);
                    if (!xmlFile.exists()) {
                        JOptionPane.showMessageDialog(this.saveOpenFileChooser, L10N.getLocalString("dlg.no_xml_data_lbl", "This directory does not contain saved bug XML data, please choose a different directory."));
                        loading = true;
                        break;
                    }
                    this.openProject(f);
                    break;
                }
                case XML_ANALYSIS: {
                    if (!f.getName().endsWith(".xml")) {
                        JOptionPane.showMessageDialog(this.saveOpenFileChooser, L10N.getLocalString("dlg.not_xml_data_lbl", "This is not a saved bug XML data file."));
                        loading = true;
                        break;
                    }
                    if (this.openAnalysis(f, fileType)) break;
                    JOptionPane.showMessageDialog(this.saveOpenFileChooser, "An error occurred while trying to load the analysis.");
                    loading = true;
                    break;
                }
                case FBP_FILE: {
                    if (this.openFBPFile(f)) break;
                    JOptionPane.showMessageDialog(this.saveOpenFileChooser, "An error occurred while trying to load the analysis.");
                    loading = true;
                    break;
                }
                case FBA_FILE: {
                    if (this.openFBAFile(f)) break;
                    JOptionPane.showMessageDialog(this.saveOpenFileChooser, "An error occurred while trying to load the analysis.");
                    loading = true;
                    break;
                }
            }
        }
    }

    private boolean openFBAFile(File f) {
        return this.openAnalysis(f, SaveType.FBA_FILE);
    }

    private boolean openFBPFile(File f) {
        if (!f.exists() || !f.canRead()) {
            return false;
        }
        this.prepareForFileLoad(f, SaveType.FBP_FILE);
        this.loadProjectFromFile(f);
        return true;
    }

    private boolean exportFilter() {
        if (this.curProject == null || this.curProject.getSuppressionFilter() == null) {
            JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.no_filter", "There is no filter"));
            return false;
        }
        this.filterOpenFileChooser.setDialogTitle(L10N.getLocalString("dlg.exportFilter_ttl", "Export filter..."));
        boolean retry = true;
        boolean alreadyExists = true;
        File f = null;
        while (retry) {
            retry = false;
            int value = this.filterOpenFileChooser.showSaveDialog(this);
            if (value != 0) {
                return false;
            }
            f = this.filterOpenFileChooser.getSelectedFile();
            alreadyExists = f.exists();
            if (alreadyExists) {
                int response = JOptionPane.showConfirmDialog(this.filterOpenFileChooser, L10N.getLocalString("dlg.file_exists_lbl", "This file already exists.\nReplace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                if (response == 0) {
                    retry = false;
                }
                if (response == 2) {
                    retry = true;
                    continue;
                }
            }
            Filter suppressionFilter = this.curProject.getSuppressionFilter();
            try {
                suppressionFilter.writeEnabledMatchersAsXML(new FileOutputStream(f));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.saving_error_lbl", "An error occurred in saving."));
                return false;
            }
        }
        return true;
    }

    private boolean saveAs() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        this.saveOpenFileChooser.setDialogTitle(L10N.getLocalString("dlg.saveas_ttl", "Save as..."));
        if (this.curProject == null) {
            JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.no_proj_save_lbl", "There is no project to save"));
            return false;
        }
        boolean retry = true;
        SaveType fileType = SaveType.NOT_KNOWN;
        boolean alreadyExists = true;
        File f = null;
        while (retry) {
            retry = false;
            int value = this.saveOpenFileChooser.showSaveDialog(this);
            if (value != 0) {
                return false;
            }
            fileType = this.convertFilterToType(this.saveOpenFileChooser.getFileFilter());
            if (fileType == SaveType.NOT_KNOWN) {
                Debug.println("Error! fileType == SaveType.NOT_KNOWN");
                retry = true;
                continue;
            }
            f = this.saveOpenFileChooser.getSelectedFile();
            if (!fileType.isValid(f = this.convertFile(f, fileType))) {
                JOptionPane.showMessageDialog(this.saveOpenFileChooser, "That file is not compatible with the chosen file type", "Invalid File", 2);
                retry = true;
                continue;
            }
            alreadyExists = this.fileAlreadyExists(f, fileType);
            if (alreadyExists) {
                int response = -1;
                switch (fileType) {
                    case XML_ANALYSIS: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("dlg.analysis_exists_lbl", "This analysis already exists.\nReplace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                        break;
                    }
                    case PROJECT: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("dlg.proj_already_exists_lbl", "This project already exists.\nDo you want to replace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                        break;
                    }
                    case FBP_FILE: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("FB Project File already exists", "This FB project file already exists.\nDo you want to replace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                        break;
                    }
                    case FBA_FILE: {
                        response = JOptionPane.showConfirmDialog(this.saveOpenFileChooser, L10N.getLocalString("FB Analysis File already exists", "This FB analysis file already exists.\nDo you want to replace it?"), L10N.getLocalString("dlg.warning_ttl", "Warning!"), 2, 2);
                    }
                }
                if (response == 0) {
                    retry = false;
                }
                if (response == 2) {
                    retry = true;
                    continue;
                }
            }
            SaveReturn successful = SaveReturn.SAVE_ERROR;
            switch (fileType) {
                case PROJECT: {
                    successful = this.saveProject(f);
                    break;
                }
                case XML_ANALYSIS: {
                    successful = this.saveAnalysis(f);
                    break;
                }
                case FBA_FILE: {
                    successful = this.saveFBAFile(f);
                    break;
                }
                case FBP_FILE: {
                    successful = this.saveFBPFile(f);
                }
            }
            if (successful == SaveReturn.SAVE_SUCCESSFUL) continue;
            JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.saving_error_lbl", "An error occurred in saving."));
            return false;
        }
        this.saveMenuItem.setEnabled(false);
        this.setSaveType(fileType);
        this.saveFile = f;
        File xmlFile = this.getSaveType() == SaveType.PROJECT ? new File(f.getAbsolutePath() + File.separator + f.getName() + ".xml") : f;
        this.addFileToRecent(xmlFile, this.getSaveType());
        return true;
    }

    private SaveType convertFilterToType(FileFilter f) {
        if (f instanceof FindBugsFileFilter) {
            return ((FindBugsFileFilter)f).getSaveType();
        }
        return SaveType.NOT_KNOWN;
    }

    private boolean fileAlreadyExists(File f, SaveType fileType) {
        if (fileType == SaveType.PROJECT) {
            return OriginalGUI2ProjectFile.fileContainingXMLData(f).exists();
        }
        return f.exists();
    }

    private File convertFile(File f, SaveType fileType) {
        if (fileType == SaveType.PROJECT) {
            return f;
        }
        if (!f.getName().endsWith(fileType.getFileExtension())) {
            f = new File(f.getAbsolutePath() + fileType.getFileExtension());
        }
        return f;
    }

    private void save() {
        File sFile = this.saveFile;
        assert (sFile != null);
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        SaveReturn result = SaveReturn.SAVE_ERROR;
        switch (this.getSaveType()) {
            case PROJECT: {
                result = this.saveProject(sFile);
                break;
            }
            case XML_ANALYSIS: {
                result = this.saveAnalysis(sFile);
                break;
            }
            case FBA_FILE: {
                result = this.saveFBAFile(sFile);
                break;
            }
            case FBP_FILE: {
                result = this.saveFBPFile(sFile);
            }
        }
        if (result != SaveReturn.SAVE_SUCCESSFUL) {
            JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.saving_error_lbl", "An error occurred in saving."));
        }
    }

    private SaveReturn saveFBAFile(File saveFile2) {
        return this.saveAnalysis(saveFile2);
    }

    private SaveReturn saveFBPFile(File saveFile2) {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        try {
            this.curProject.writeXML(saveFile2);
        }
        catch (IOException e) {
            AnalysisContext.logError("Couldn't save FBP file to " + saveFile2, e);
            return SaveReturn.SAVE_IO_EXCEPTION;
        }
        this.setProjectChanged(false);
        return SaveReturn.SAVE_SUCCESSFUL;
    }

    public void showWaitCard() {
        this.showCard(WAITCARD, new Cursor(3));
    }

    public void showTreeCard() {
        this.showCard(TREECARD, new Cursor(0));
    }

    private void showCard(final String c, final Cursor cursor) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setCursor(cursor);
            CardLayout layout = (CardLayout)this.cardPanel.getLayout();
            layout.show(this.cardPanel, c);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.setCursor(cursor);
                    CardLayout layout = (CardLayout)MainFrame.this.cardPanel.getLayout();
                    layout.show(MainFrame.this.cardPanel, c);
                }
            });
        }
    }

    JPanel bugListPanel() {
        this.cardPanel = new JPanel(new CardLayout());
        JPanel topPanel = new JPanel();
        this.waitPanel = new JPanel();
        this.waitPanel.add(new JLabel("Please wait..."));
        this.cardPanel.add((Component)topPanel, TREECARD);
        this.cardPanel.add((Component)this.waitPanel, WAITCARD);
        topPanel.setMinimumSize(new Dimension(200, 200));
        this.tableheader = new JTableHeader();
        this.tableheader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Debug.println("tableheader.getReorderingAllowed() = " + MainFrame.this.tableheader.getReorderingAllowed());
                if (!MainFrame.this.tableheader.getReorderingAllowed()) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    SorterDialog.getInstance().setVisible(true);
                }
            }

            public void mouseReleased(MouseEvent arg0) {
                if (!MainFrame.this.tableheader.getReorderingAllowed()) {
                    return;
                }
                BugTreeModel bt = (BugTreeModel)MainFrame.this.getTree().getModel();
                bt.checkSorter();
            }
        });
        this.sorter = GUISaveState.getInstance().getStarterTable();
        this.tableheader.setColumnModel(this.sorter);
        this.tableheader.setToolTipText(L10N.getLocalString("tooltip.reorder_message", "Drag to reorder tree folder and sort order"));
        this.tree = new JTree();
        this.treeUI = (BasicTreeUI)this.tree.getUI();
        this.tree.setLargeModel(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new BugRenderer());
        this.tree.setRowHeight((int)(Driver.getFontSize() + 7.0f));
        this.tree.setModel(new BugTreeModel(this.tree, this.sorter, new BugSet(new ArrayList())));
        this.setupTreeListeners();
        this.curProject = new Project();
        this.treeScrollPane = new JScrollPane(this.tree);
        topPanel.setLayout(new BorderLayout());
        JTable t = new JTable(new DefaultTableModel(0, Sortables.values().length));
        t.setTableHeader(this.tableheader);
        JScrollPane sp = new JScrollPane(t);
        int num = (int)((double)Driver.getFontSize() * 1.2);
        sp.setPreferredSize(new Dimension(0, 10 + num));
        topPanel.add((Component)sp, "North");
        topPanel.add((Component)this.treeScrollPane, "Center");
        return this.cardPanel;
    }

    public void newTree(final JTree newTree, final BugTreeModel newModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.tree = newTree;
                MainFrame.this.tree.getSelectionModel().setSelectionMode(1);
                MainFrame.this.tree.setLargeModel(true);
                MainFrame.this.tree.setCellRenderer(new BugRenderer());
                MainFrame.this.showTreeCard();
                Container container = MainFrame.this.treeScrollPane.getParent();
                container.remove(MainFrame.this.treeScrollPane);
                MainFrame.this.treeScrollPane = new JScrollPane(newTree);
                container.add((Component)MainFrame.this.treeScrollPane, "Center");
                MainFrame.this.setFontSizeHelper(container.getComponents(), Driver.getFontSize());
                MainFrame.this.tree.setRowHeight((int)(Driver.getFontSize() + 7.0f));
                MainFrame.getInstance().getContentPane().validate();
                MainFrame.getInstance().getContentPane().repaint();
                MainFrame.this.setupTreeListeners();
                newModel.openPreviouslySelected(((BugTreeModel)MainFrame.this.tree.getModel()).getOldSelectedBugs());
                MainFrame.this.getSorter().addColumnModelListener(newModel);
                FilterActivity.addFilterListener(newModel.bugTreeFilterListener);
                MainFrame.this.setSorting(true);
            }
        });
    }

    private void setupTreeListeners() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent selectionEvent) {
                TreePath path = selectionEvent.getNewLeadSelectionPath();
                if (path != null) {
                    MainFrame.this.saveComments(MainFrame.this.currentSelectedBugLeaf, MainFrame.this.currentSelectedBugAspects);
                    Object lastPathComponent = path.getLastPathComponent();
                    if (lastPathComponent instanceof BugLeafNode) {
                        boolean beforeProjectChanged = MainFrame.this.projectChanged;
                        MainFrame.this.currentSelectedBugLeaf = (BugLeafNode)lastPathComponent;
                        MainFrame.this.currentSelectedBugAspects = null;
                        MainFrame.this.syncBugInformation();
                        MainFrame.this.setProjectChanged(beforeProjectChanged);
                    } else {
                        boolean beforeProjectChanged = MainFrame.this.projectChanged;
                        MainFrame.this.updateDesignationDisplay();
                        MainFrame.this.currentSelectedBugLeaf = null;
                        MainFrame.this.currentSelectedBugAspects = (BugAspects)lastPathComponent;
                        MainFrame.this.syncBugInformation();
                        MainFrame.this.setProjectChanged(beforeProjectChanged);
                    }
                }
                if (MainFrame.this.tree.getSelectionCount() != 1) {
                    Debug.println("Tree selection count not equal to 1, disabling comments tab" + selectionEvent);
                    MainFrame.this.setUserCommentInputEnable(false);
                }
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                TreePath path = MainFrame.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                if (e.getButton() == 3 || e.getButton() == 1 && e.isControlDown()) {
                    if (MainFrame.this.tree.getModel().isLeaf(path.getLastPathComponent())) {
                        MainFrame.this.tree.setSelectionPath(path);
                        MainFrame.this.bugPopupMenu.show(MainFrame.this.tree, e.getX(), e.getY());
                    } else {
                        MainFrame.this.tree.setSelectionPath(path);
                        if (path.getParentPath() != null) {
                            MainFrame.this.branchPopupMenu.show(MainFrame.this.tree, e.getX(), e.getY());
                        }
                    }
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
    }

    void syncBugInformation() {
        boolean prevProjectChanged = this.projectChanged;
        if (this.currentSelectedBugLeaf != null) {
            BugInstance bug = this.currentSelectedBugLeaf.getBug();
            this.displayer.displaySource(bug, bug.getPrimarySourceLineAnnotation());
            this.comments.updateCommentsFromLeafInformation(this.currentSelectedBugLeaf);
            this.updateDesignationDisplay();
            this.comments.updateCommentsFromLeafInformation(this.currentSelectedBugLeaf);
            this.updateSummaryTab(this.currentSelectedBugLeaf);
        } else if (this.currentSelectedBugAspects != null) {
            this.updateDesignationDisplay();
            this.comments.updateCommentsFromNonLeafInformation(this.currentSelectedBugAspects);
            this.displayer.displaySource(null, null);
            this.clearSummaryTab();
        } else {
            this.displayer.displaySource(null, null);
            this.clearSummaryTab();
        }
        this.setProjectChanged(prevProjectChanged);
    }

    void clearSourcePane() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.setSourceTab("Source", null);
                MainFrame.this.sourceCodeTextPane.setDocument(SourceCodeDisplay.SOURCE_NOT_RELEVANT);
            }
        });
    }

    private void setUserCommentInputEnable(boolean b) {
        this.comments.setUserCommentInputEnable(b);
    }

    JPanel statusBar() {
        JPanel statusBar = new JPanel();
        statusBar.setBorder(new BevelBorder(1));
        statusBar.setLayout(new BorderLayout());
        statusBar.add((Component)this.statusBarLabel, "West");
        JLabel logoLabel = new JLabel();
        ImageIcon logoIcon = new ImageIcon(MainFrame.class.getResource("logo_umd.png"));
        logoLabel.setIcon(logoIcon);
        statusBar.add((Component)logoLabel, "East");
        return statusBar;
    }

    void updateStatusBar() {
        int countFilteredBugs = BugSet.countFilteredBugs();
        if (countFilteredBugs == 0) {
            this.statusBarLabel.setText("  http://findbugs.sourceforge.net/");
        } else if (countFilteredBugs == 1) {
            this.statusBarLabel.setText("  1 " + L10N.getLocalString("statusbar.bug_hidden", "bug hidden"));
        } else {
            this.statusBarLabel.setText("  " + countFilteredBugs + " " + L10N.getLocalString("statusbar.bugs_hidden", "bugs hidden"));
        }
    }

    private void updateSummaryTab(BugLeafNode node) {
        final BugInstance bug = node.getBug();
        final ArrayList<BugAnnotation> primaryAnnotations = new ArrayList<BugAnnotation>();
        boolean classIncluded = false;
        if (bug.getPrimarySourceLineAnnotation() != null) {
            primaryAnnotations.add(bug.getPrimarySourceLineAnnotation());
        }
        if (bug.getPrimaryMethod() != null) {
            primaryAnnotations.add(bug.getPrimaryMethod());
        }
        if (bug.getPrimaryField() != null) {
            primaryAnnotations.add(bug.getPrimaryField());
        }
        if (bug.getPrimaryClass() != null) {
            FieldAnnotation primeField = bug.getPrimaryField();
            MethodAnnotation primeMethod = bug.getPrimaryMethod();
            ClassAnnotation primeClass = bug.getPrimaryClass();
            String fieldClass = "";
            String methodClass = "";
            if (primeField != null) {
                fieldClass = primeField.getClassName();
            }
            if (primeMethod != null) {
                methodClass = primeMethod.getClassName();
            }
            if (primaryAnnotations.size() < 2 || !primeClass.getClassName().equals(fieldClass) && !primeClass.getClassName().equals(methodClass)) {
                primaryAnnotations.add(primeClass);
                classIncluded = true;
            }
        }
        final boolean classIncluded2 = classIncluded;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.summaryTopPanel.removeAll();
                MainFrame.this.summaryTopPanel.add(MainFrame.this.bugSummaryComponent(bug.getMessageWithoutPrefix(), bug));
                for (BugAnnotation b : primaryAnnotations) {
                    MainFrame.this.summaryTopPanel.add(MainFrame.this.bugSummaryComponent(b, bug));
                }
                if (!classIncluded2 && bug.getPrimaryClass() != null) {
                    primaryAnnotations.add(bug.getPrimaryClass());
                }
                Iterator<BugAnnotation> i = bug.annotationIterator();
                while (i.hasNext()) {
                    BugAnnotation b;
                    b = i.next();
                    boolean cont = true;
                    for (BugAnnotation p : primaryAnnotations) {
                        if (p != b) continue;
                        cont = false;
                    }
                    if (!cont) continue;
                    MainFrame.this.summaryTopPanel.add(MainFrame.this.bugSummaryComponent(b, bug));
                }
                MainFrame.this.summaryHtmlArea.setText(bug.getBugPattern().getDetailHTML());
                MainFrame.this.summaryTopPanel.add(Box.createVerticalGlue());
                MainFrame.this.summaryTopPanel.revalidate();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.this.summaryHtmlScrollPane.getVerticalScrollBar().setValue(MainFrame.this.summaryHtmlScrollPane.getVerticalScrollBar().getMinimum());
                    }
                });
            }
        });
    }

    private void clearSummaryTab() {
        this.summaryHtmlArea.setText("");
        this.summaryTopPanel.removeAll();
        this.summaryTopPanel.revalidate();
    }

    JSplitPane summaryTab() {
        int fontSize = (int)Driver.getFontSize();
        this.summaryTopPanel = new JPanel();
        this.summaryTopPanel.setLayout(new GridLayout(0, 1));
        this.summaryTopPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.summaryTopPanel.setMinimumSize(new Dimension(fontSize * 50, fontSize * 5));
        JPanel summaryTopOuter = new JPanel(new BorderLayout());
        summaryTopOuter.add((Component)this.summaryTopPanel, "North");
        this.summaryHtmlArea.setToolTipText(L10N.getLocalString("tooltip.longer_description", "This gives a longer description of the detected bug pattern"));
        this.summaryHtmlArea.setContentType("text/html");
        this.summaryHtmlArea.setEditable(false);
        this.summaryHtmlArea.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.editorPaneHyperlinkUpdate(evt);
            }
        });
        this.setStyleSheets();
        JScrollPane summaryScrollPane = new JScrollPane(summaryTopOuter);
        summaryScrollPane.getVerticalScrollBar().setUnitIncrement((int)Driver.getFontSize());
        JSplitPane splitP = new JSplitPane(0, false, summaryScrollPane, this.summaryHtmlScrollPane);
        splitP.setDividerLocation(GUISaveState.getInstance().getSplitSummary());
        splitP.setOneTouchExpandable(true);
        return splitP;
    }

    private Component bugSummaryComponent(Object obj, BugInstance bug) {
        JLabel label = new JLabel();
        label.setFont(label.getFont().deriveFont(Driver.getFontSize()));
        label.setFont(label.getFont().deriveFont(0));
        label.setForeground(Color.BLACK);
        if (obj instanceof String) {
            String str = (String)obj;
            label.setText(str);
        } else {
            BugAnnotation value = (BugAnnotation)obj;
            if (value == null) {
                return new JLabel(L10N.getLocalString("summary.null", "null"));
            }
            if (value instanceof SourceLineAnnotation) {
                SourceLineAnnotation note = (SourceLineAnnotation)value;
                if (this.sourceCodeExist(note)) {
                    String srcStr = "";
                    int start = note.getStartLine();
                    int end = note.getEndLine();
                    if (start < 0 && end < 0) {
                        srcStr = L10N.getLocalString("summary.source_code", "source code.");
                    } else if (start == end) {
                        srcStr = " [" + L10N.getLocalString("summary.line", "Line") + " " + start + "]";
                    } else if (start < end) {
                        srcStr = " [" + L10N.getLocalString("summary.lines", "Lines") + " " + start + " - " + end + "]";
                    }
                    label.setToolTipText(L10N.getLocalString("tooltip.click_to_go_to", "Click to go to") + " " + srcStr);
                    label.addMouseListener(new BugSummaryMouseListener(bug, label, note));
                }
                label.setText(note.toString());
            } else if (value instanceof BugAnnotationWithSourceLines) {
                BugAnnotationWithSourceLines note = (BugAnnotationWithSourceLines)value;
                SourceLineAnnotation noteSrc = note.getSourceLines();
                String srcStr = "";
                if (noteSrc != null && this.sourceCodeExist(noteSrc)) {
                    int start = noteSrc.getStartLine();
                    int end = noteSrc.getEndLine();
                    if (start < 0 && end < 0) {
                        srcStr = L10N.getLocalString("summary.source_code", "source code.");
                    } else if (start == end) {
                        srcStr = " [" + L10N.getLocalString("summary.line", "Line") + " " + start + "]";
                    } else if (start < end) {
                        srcStr = " [" + L10N.getLocalString("summary.lines", "Lines") + " " + start + " - " + end + "]";
                    }
                    if (!srcStr.equals("")) {
                        label.setToolTipText(L10N.getLocalString("tooltip.click_to_go_to", "Click to go to") + " " + srcStr);
                        label.addMouseListener(new BugSummaryMouseListener(bug, label, noteSrc));
                    }
                }
                if (!srcStr.equals(L10N.getLocalString("summary.source_code", "source code."))) {
                    label.setText(note.toString() + srcStr);
                } else {
                    label.setText(note.toString());
                }
            } else {
                label.setText(value.toString());
            }
        }
        return label;
    }

    private boolean sourceCodeExist(@Nonnull SourceLineAnnotation note) {
        try {
            this.sourceFinder.findSourceFile(note);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void setStyleSheets() {
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("body {font-size: " + Driver.getFontSize() + "pt}");
        styleSheet.addRule("H1 {color: red;  font-size: 120%; font-weight: bold;}");
        styleSheet.addRule("code {font-family: courier; font-size: " + Driver.getFontSize() + "pt}");
        this.htmlEditorKit.setStyleSheet(styleSheet);
        this.summaryHtmlArea.setEditorKit(this.htmlEditorKit);
    }

    JPanel createCommentsInputPanel() {
        return this.comments.createCommentsInputPanel();
    }

    JPanel createSourceCodePanel() {
        Font sourceFont = new Font("Monospaced", 0, (int)Driver.getFontSize());
        this.sourceCodeTextPane.setFont(sourceFont);
        this.sourceCodeTextPane.setEditable(false);
        this.sourceCodeTextPane.getCaret().setSelectionVisible(true);
        this.sourceCodeTextPane.setDocument(SourceCodeDisplay.SOURCE_NOT_RELEVANT);
        this.sourceCodeScrollPane = new JScrollPane(this.sourceCodeTextPane);
        this.sourceCodeScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.sourceCodeScrollPane, "Center");
        panel.revalidate();
        if (DEBUG) {
            System.out.println("Created source code panel");
        }
        return panel;
    }

    JPanel createSourceSearchPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel thePanel = new JPanel();
        thePanel.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 5);
        c.fill = 2;
        gridbag.setConstraints(this.sourceSearchTextField, c);
        thePanel.add(this.sourceSearchTextField);
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.searchSource(0);
            }
        });
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        gridbag.setConstraints(this.findButton, c);
        thePanel.add(this.findButton);
        this.findNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.searchSource(1);
            }
        });
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 0;
        gridbag.setConstraints(this.findNextButton, c);
        thePanel.add(this.findNextButton);
        this.findPreviousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.searchSource(2);
            }
        });
        c.gridx = 3;
        c.weightx = 0.0;
        c.fill = 0;
        gridbag.setConstraints(this.findPreviousButton, c);
        thePanel.add(this.findPreviousButton);
        return thePanel;
    }

    void searchSource(int type) {
        int targetLineNum = -1;
        String targetString = this.sourceSearchTextField.getText();
        switch (type) {
            case 0: {
                targetLineNum = this.displayer.find(targetString);
                break;
            }
            case 1: {
                targetLineNum = this.displayer.findNext(targetString);
                break;
            }
            case 2: {
                targetLineNum = this.displayer.findPrevious(targetString);
            }
        }
        if (targetLineNum != -1) {
            this.displayer.foundItem(targetLineNum);
        }
    }

    void setSourceTab(String title, SourceFile source) {
        JComponent label = this.guiLayout.getSourceTitleComponent();
        if (label != null) {
            if (source != null && this.sourceFileLinkPattern != null) {
                String name = source.getFullFileName();
                Matcher m = this.sourceFileLinkPattern.matcher(name);
                boolean isMatch = m.matches();
                if (isMatch) {
                    try {
                        URL link = new URL(String.format(this.sourceFileLinkFormat, m.group(1)));
                        this.addLink(label, link);
                    }
                    catch (MalformedURLException e) {
                        this.removeLink(label);
                    }
                } else {
                    this.removeLink(label);
                }
            } else {
                this.removeLink(label);
            }
        }
        this.guiLayout.setSourceTitle(title);
    }

    void addLink(JComponent component, URL source) {
        this.sourceLink = source;
        if (!this.listenerAdded) {
            this.listenerAdded = true;
            component.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    URL u = MainFrame.this.sourceLink;
                    if (u != null) {
                        LaunchBrowser.showDocument(u);
                    }
                }
            });
        }
        component.setCursor(new Cursor(12));
        if (this.sourceFileLinkToolTip != null) {
            component.setToolTipText(this.sourceFileLinkToolTip);
        }
    }

    void removeLink(JComponent component) {
        this.sourceLink = null;
        component.setCursor(new Cursor(0));
        component.setToolTipText("");
    }

    SorterTableColumnModel getSorter() {
        return this.sorter;
    }

    public void addNotify() {
        super.addNotify();
        float size = Driver.getFontSize();
        this.getJMenuBar().setFont(this.getJMenuBar().getFont().deriveFont(size));
        for (int i = 0; i < this.getJMenuBar().getMenuCount(); ++i) {
            for (int j = 0; j < this.getJMenuBar().getMenu(i).getMenuComponentCount(); ++j) {
                Component temp = this.getJMenuBar().getMenu(i).getMenuComponent(j);
                temp.setFont(temp.getFont().deriveFont(size));
            }
        }
        this.bugPopupMenu.setFont(this.bugPopupMenu.getFont().deriveFont(size));
        this.setFontSizeHelper(this.bugPopupMenu.getComponents(), size);
        this.branchPopupMenu.setFont(this.branchPopupMenu.getFont().deriveFont(size));
        this.setFontSizeHelper(this.branchPopupMenu.getComponents(), size);
    }

    public JTree getTree() {
        return this.tree;
    }

    public BugTreeModel getBugTreeModel() {
        return (BugTreeModel)this.getTree().getModel();
    }

    public Project getProject() {
        return this.curProject;
    }

    public void setProject(Project p) {
        this.curProject = p;
    }

    public SourceFinder getSourceFinder() {
        return this.sourceFinder;
    }

    public void setSourceFinder(SourceFinder sf) {
        this.sourceFinder = sf;
    }

    @SwingThread
    public void setRebuilding(boolean b) {
        this.tableheader.setReorderingAllowed(!b);
        this.enablePreferences(!b);
        if (b) {
            SorterDialog.getInstance().freeze();
            this.showWaitCard();
        } else {
            SorterDialog.getInstance().thaw();
            this.showTreeCard();
        }
        this.recentMenu.setEnabled(!b);
    }

    public void setSorting(boolean b) {
        this.tableheader.setReorderingAllowed(b);
    }

    private void setSaveMenu() {
        File s = this.saveFile;
        this.saveMenuItem.setEnabled(this.projectChanged && s != null && this.getSaveType() != SaveType.FBP_FILE && s.exists());
    }

    public void setProjectChanged(boolean b) {
        if (this.curProject == null) {
            return;
        }
        if (this.projectChanged == b) {
            return;
        }
        this.projectChanged = b;
        this.setSaveMenu();
        this.getRootPane().putClientProperty(WINDOW_MODIFIED, b);
    }

    public boolean getProjectChanged() {
        return this.projectChanged;
    }

    private SaveReturn saveProject(File dir) {
        if (this.curProject == null) {
            this.curProject = new Project();
            JOptionPane.showMessageDialog(this, "Null project; this is unexpected.  Creating a new Project so the bugs can be saved, but please report this error.");
        }
        if (!dir.mkdir()) {
            return SaveReturn.SAVE_IO_EXCEPTION;
        }
        File f = new File(dir.getAbsolutePath() + File.separator + dir.getName() + ".xml");
        File filtersAndSuppressions = new File(dir.getAbsolutePath() + File.separator + dir.getName() + ".fas");
        BugSaver.saveBugs(f, this.bugCollection, this.curProject);
        try {
            ProjectSettings.getInstance().save(new FileOutputStream(filtersAndSuppressions));
        }
        catch (IOException e) {
            Debug.println(e);
            return SaveReturn.SAVE_IO_EXCEPTION;
        }
        this.setProjectChanged(false);
        return SaveReturn.SAVE_SUCCESSFUL;
    }

    private void saveComments(BugLeafNode theNode, BugAspects theAspects) {
        this.comments.saveComments(theNode, theAspects);
    }

    void saveComments() {
        this.comments.saveComments();
    }

    public Color getSourceColor() {
        return this.sourceCodeTextPane.getBackground();
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    public void writeToLog(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    private SaveReturn saveAnalysis(File f) {
        BugSaver.saveBugs(f, this.bugCollection, this.curProject);
        this.setProjectChanged(false);
        return SaveReturn.SAVE_SUCCESSFUL;
    }

    public boolean openAnalysis(File f, SaveType saveType) {
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException("Can't read " + f);
        }
        this.prepareForFileLoad(f, saveType);
        try {
            FileInputStream in = new FileInputStream(f);
            this.loadAnalysisFromInputStream(in, f);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void prepareForFileLoad(File f, SaveType saveType) {
        this.setRebuilding(true);
        ProjectSettings.newInstance();
        this.clearSourcePane();
        this.clearSummaryTab();
        this.comments.setUserCommentInputEnable(false);
        this.reconfigMenuItem.setEnabled(true);
        this.setProjectChanged(false);
        this.setSaveType(saveType);
        this.saveFile = f;
        this.addFileToRecent(f, saveType);
    }

    private void loadAnalysisFromInputStream(final @WillClose InputStream in, final Object source) {
        Runnable runnable = new Runnable(){

            public void run() {
                final Project project = new Project();
                if (source instanceof File) {
                    project.setCurrentWorkingDirectory(((File)source).getParentFile());
                }
                final SortedBugCollection bc = BugLoader.loadBugs(MainFrame.this, project, in);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (bc == null) {
                            MainFrame.this.setProjectAndBugCollection(new Project(), new SortedBugCollection());
                        } else {
                            MainFrame.this.setProjectAndBugCollection(project, bc);
                        }
                    }
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    private void loadProjectFromFile(final File f) {
        Runnable runnable = new Runnable(){

            public void run() {
                final Project project = BugLoader.loadProject(MainFrame.this, f);
                final BugCollection bc = project == null ? null : BugLoader.doAnalysis(project);
                MainFrame.this.updateProjectAndBugCollection(project, bc, null);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (project == null) {
                            MainFrame.this.setProjectAndBugCollection(new Project(), new SortedBugCollection());
                        } else {
                            MainFrame.this.setProjectAndBugCollection(project, bc);
                        }
                    }
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    void redoAnalysis() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        this.showWaitCard();
        new Thread(){

            public void run() {
                MainFrame.this.updateDesignationDisplay();
                BugCollection bc = BugLoader.redoAnalysisKeepComments(MainFrame.this.curProject);
                MainFrame.this.updateProjectAndBugCollection(MainFrame.this.curProject, bc, null);
            }
        }.start();
    }

    private void mergeAnalysis() {
        this.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        this.showWaitCard();
        Project p = new Project();
        BugCollection bc = BugLoader.combineBugHistories(p);
        this.setProjectAndBugCollection(p, bc);
    }

    private void openProject(File dir) {
        File xmlFile = new File(dir.getAbsolutePath() + File.separator + dir.getName() + ".xml");
        File fasFile = new File(dir.getAbsolutePath() + File.separator + dir.getName() + ".fas");
        if (!fasFile.exists()) {
            JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.filter_settings_not_found_lbl", "Filter settings not found, using default settings."));
            ProjectSettings.newInstance();
        } else {
            try {
                ProjectSettings.loadInstance(new FileInputStream(fasFile));
            }
            catch (FileNotFoundException e) {
                if (DEBUG) {
                    System.err.println(".fas file not found, using default settings");
                }
                ProjectSettings.newInstance();
            }
        }
        final File extraFinalReferenceToXmlFile = xmlFile;
        new Thread(new Runnable(){

            public void run() {
                BugTreeModel.pleaseWait();
                MainFrame.this.setRebuilding(true);
                Project project = new Project();
                SortedBugCollection bc = BugLoader.loadBugs(MainFrame.this, project, extraFinalReferenceToXmlFile);
                MainFrame.this.setProjectAndBugCollection(project, bc);
            }
        }).start();
        this.addFileToRecent(dir, SaveType.PROJECT);
        this.clearSourcePane();
        this.clearSummaryTab();
        this.comments.setUserCommentInputEnable(false);
        this.setProjectChanged(false);
        this.setSaveType(SaveType.PROJECT);
        this.saveFile = dir;
        this.changeTitle();
    }

    private void addFileToRecent(File xmlFile, SaveType st) {
        ArrayList<File> xmlFiles = GUISaveState.getInstance().getRecentFiles();
        if (!xmlFiles.contains(xmlFile)) {
            GUISaveState.getInstance().addRecentFile(xmlFile);
        }
        this.recentMenuCache.addRecentFile(xmlFile);
    }

    private void newProjectMenu() {
        this.comments.saveComments(this.currentSelectedBugLeaf, this.currentSelectedBugAspects);
        new NewProjectWizard();
        this.newProject = true;
    }

    void updateDesignationDisplay() {
        this.comments.updateDesignationComboBox();
    }

    void addDesignationItem(JMenu menu, String menuName, int keyEvent) {
        this.comments.addDesignationItem(menu, menuName, keyEvent);
    }

    void warnUserOfFilters() {
        JOptionPane.showMessageDialog(this, L10N.getLocalString("dlg.everything_is_filtered", "All bugs in this project appear to be filtered out.  \nYou may wish to check your filter settings in the preferences menu."), "Warning", 2);
    }

    void setSaveType(SaveType saveType) {
        if (DEBUG && this.saveType != saveType) {
            System.out.println("Changing save type from " + (Object)((Object)this.saveType) + " to " + (Object)((Object)saveType));
        }
        this.saveType = saveType;
    }

    SaveType getSaveType() {
        return this.saveType;
    }

    static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(L10N.getLocalString("txt.paste", "Paste"));
        }

        public void actionPerformed(ActionEvent evt) {
            JTextComponent text = this.getTextComponent(evt);
            if (text == null) {
                return;
            }
            text.paste();
        }
    }

    static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(L10N.getLocalString("txt.copy", "Copy"));
        }

        public void actionPerformed(ActionEvent evt) {
            JTextComponent text = this.getTextComponent(evt);
            if (text == null) {
                return;
            }
            text.copy();
        }
    }

    static class CutAction
    extends TextAction {
        public CutAction() {
            super(L10N.getLocalString("txt.cut", "Cut"));
        }

        public void actionPerformed(ActionEvent evt) {
            JTextComponent text = this.getTextComponent(evt);
            if (text == null) {
                return;
            }
            text.cut();
        }
    }

    private class BugSummaryMouseListener
    extends MouseAdapter {
        private final BugInstance bugInstance;
        private final JLabel label;
        private final SourceLineAnnotation note;

        BugSummaryMouseListener(@NonNull BugInstance bugInstance, @NonNull JLabel label, SourceLineAnnotation note) {
            this.bugInstance = bugInstance;
            this.label = label;
            this.note = note;
        }

        public void mouseClicked(MouseEvent e) {
            MainFrame.this.displayer.displaySource(this.bugInstance, this.note);
        }

        public void mouseEntered(MouseEvent e) {
            this.label.setForeground(Color.blue);
            MainFrame.this.setCursor(new Cursor(12));
        }

        public void mouseExited(MouseEvent e) {
            this.label.setForeground(Color.black);
            MainFrame.this.setCursor(new Cursor(0));
        }
    }

    private final class InitializeGUI
    implements Runnable {
        private InitializeGUI() {
        }

        public void run() {
            String loadFromURL;
            block16: {
                MainFrame.this.setTitle("FindBugs");
                try {
                    MainFrame.this.guiLayout.initialize();
                }
                catch (Exception e) {
                    if (!UIManager.getLookAndFeel().getName().equals("Metal")) {
                        System.err.println("Exception caught initializing GUI; reverting to CrossPlatformLookAndFeel");
                        try {
                            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        }
                        catch (Exception e2) {
                            System.err.println("Exception while setting CrossPlatformLookAndFeel: " + e2);
                            throw new Error(e2);
                        }
                        MainFrame.this.guiLayout.initialize();
                    }
                    throw new Error(e);
                }
                MainFrame.this.bugPopupMenu = MainFrame.this.createBugPopupMenu();
                MainFrame.this.branchPopupMenu = MainFrame.this.createBranchPopUpMenu();
                MainFrame.this.comments.loadPrevCommentsList(GUISaveState.getInstance().getPreviousComments().toArray(new String[GUISaveState.getInstance().getPreviousComments().size()]));
                MainFrame.this.updateStatusBar();
                MainFrame.this.setBounds(GUISaveState.getInstance().getFrameBounds());
                Toolkit.getDefaultToolkit().setDynamicLayout(true);
                MainFrame.this.setDefaultCloseOperation(0);
                MainFrame.this.setJMenuBar(MainFrame.this.createMainMenuBar());
                MainFrame.this.setVisible(true);
                MainFrame.this.saveOpenFileChooser = new FBFileChooser();
                MainFrame.this.saveOpenFileChooser.setFileSelectionMode(2);
                MainFrame.this.saveOpenFileChooser.setAcceptAllFileFilterUsed(false);
                MainFrame.this.saveOpenFileChooser.addChoosableFileFilter(FindBugsProjectFileFilter.INSTANCE);
                MainFrame.this.saveOpenFileChooser.addChoosableFileFilter(FindBugsAnalysisFileFilter.INSTANCE);
                MainFrame.this.saveOpenFileChooser.addChoosableFileFilter(FindBugsFBPFileFilter.INSTANCE);
                MainFrame.this.saveOpenFileChooser.addChoosableFileFilter(FindBugsFBAFileFilter.INSTANCE);
                MainFrame.this.saveOpenFileChooser.setFileFilter(FindBugsAnalysisFileFilter.INSTANCE);
                MainFrame.this.filterOpenFileChooser = new FBFileChooser();
                MainFrame.this.filterOpenFileChooser.setFileSelectionMode(2);
                MainFrame.this.filterOpenFileChooser.setFileFilter(FindBugsFilterFileFilter.INSTANCE);
                JToolTip tempToolTip = MainFrame.this.tableheader.createToolTip();
                UIManager.put("ToolTip.font", new FontUIResource(tempToolTip.getFont().deriveFont(Driver.getFontSize())));
                if (MAC_OS_X) {
                    try {
                        MainFrame.this.osxAdapter = Class.forName("edu.umd.cs.findbugs.gui2.OSXAdapter");
                        Class[] defArgs = new Class[]{MainFrame.class};
                        Method registerMethod = MainFrame.this.osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                        if (registerMethod != null) {
                            registerMethod.invoke((Object)MainFrame.this.osxAdapter, MainFrame.this);
                        }
                        defArgs[0] = Boolean.TYPE;
                        MainFrame.this.osxPrefsEnableMethod = MainFrame.this.osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                        MainFrame.this.enablePreferences(true);
                    }
                    catch (NoClassDefFoundError e) {
                        System.err.println("This version of Mac OS X does not support the Apple EAWT. Application Menu handling has been disabled (" + e + ")");
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("This version of Mac OS X does not support the Apple EAWT. Application Menu handling has been disabled (" + e + ")");
                    }
                    catch (Exception e) {
                        System.err.println("Exception while loading the OSXAdapter: " + e);
                        e.printStackTrace();
                        if (!DEBUG) break block16;
                        e.printStackTrace();
                    }
                }
            }
            if ((loadFromURL = SystemProperties.getProperty("findbugs.loadBugsFromURL")) != null) {
                try {
                    URL url = new URL(loadFromURL);
                    InputStream in = url.openConnection().getInputStream();
                    if (loadFromURL.endsWith(".gz")) {
                        in = new GZIPInputStream(in);
                    }
                    BugTreeModel.pleaseWait(L10N.getLocalString("msg.loading_bugs_over_network_txt", "Loading bugs over network..."));
                    MainFrame.this.loadAnalysisFromInputStream(in, url);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(MainFrame.this, "Error loading " + e1.getMessage());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(MainFrame.this, "Error loading " + e1.getMessage());
                }
            }
            MainFrame.this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    MainFrame.this.comments.resized();
                }
            });
            MainFrame.this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    if (MainFrame.this.comments.hasFocus()) {
                        MainFrame.this.setProjectChanged(true);
                    }
                    MainFrame.this.callOnClose();
                }
            });
            Driver.removeSplashScreen();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SaveReturn {
        SAVE_SUCCESSFUL,
        SAVE_IO_EXCEPTION,
        SAVE_ERROR;

    }
}

