/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManager;
import edu.umd.cs.findbugs.gui2.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class TabbedLayout
implements FindBugsLayoutManager {
    final MainFrame frame;
    private JTabbedPane mainTabs = null;

    public TabbedLayout(MainFrame frame) {
        this.frame = frame;
    }

    public JMenu createWindowMenu() {
        return null;
    }

    public void initialize() {
        if (Driver.getFontSize() > 15.0f && System.getProperty("os.name").startsWith("Mac")) {
            UIManager.put("TabbedPaneUI", "javax.swing.plaf.basic.BasicTabbedPaneUI");
            UIManager.put("FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI");
        }
        this.mainTabs = this.bottomTabs();
        JSplitPane split = new JSplitPane(0, this.frame.bugListPanel(), this.mainTabs);
        split.setOneTouchExpandable(true);
        split.setDividerLocation(275);
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)split, "Center");
        this.frame.add((Component)this.frame.statusBar(), "South");
    }

    public void makeCommentsVisible() {
        this.mainTabs.setSelectedIndex(1);
    }

    public void makeSourceVisible() {
        this.mainTabs.setSelectedIndex(2);
    }

    public void saveState() {
    }

    public void setSourceTitle(String title) {
        this.mainTabs.setTitleAt(2, title);
    }

    JTabbedPane bottomTabs() {
        JTabbedPane bottomTabs = new JTabbedPane();
        bottomTabs.addTab("Bug Summary", this.frame.summaryTab());
        bottomTabs.addTab("Comments", null, this.frame.createCommentsInputPanel(), "User defined comments of current bug.");
        bottomTabs.addTab("Source", null, this.frame.createSourceCodePanel(), "Source code of current bug if available.");
        bottomTabs.setMnemonicAt(0, 66);
        bottomTabs.setMnemonicAt(1, 67);
        bottomTabs.setMnemonicAt(2, 83);
        return bottomTabs;
    }

    public JComponent getSourceTitleComponent() {
        return null;
    }
}

