/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.log;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.util.Comparator;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profiler
implements XMLWriteable {
    static final boolean REPORT = SystemProperties.getBoolean("profiler.report");
    private static Profiler instance = new Profiler();
    ThreadLocal<Stack<Clock>> startTimes = new ThreadLocal<Stack<Clock>>(){

        @Override
        public Stack<Clock> initialValue() {
            return new Stack<Clock>();
        }
    };
    ConcurrentHashMap<Class<?>, Profile> profile = new ConcurrentHashMap();

    private Profiler() {
        if (REPORT) {
            System.err.println("Profiling activated");
        }
    }

    public static Profiler getInstance() {
        return instance;
    }

    public void start(Class<?> c) {
        long currentNanoTime = System.nanoTime();
        Stack<Clock> stack = this.startTimes.get();
        if (!stack.isEmpty()) {
            stack.peek().accumulateTime(currentNanoTime);
        }
        stack.push(new Clock(c, currentNanoTime));
    }

    public void end(Class<?> c) {
        Profile counter2;
        long accumulatedTime;
        long currentNanoTime = System.nanoTime();
        Stack<Clock> stack = this.startTimes.get();
        Clock ending = stack.pop();
        if (ending.clazz != c) {
            throw new AssertionError((Object)("Asked to end timing for " + c + " but top of stack is " + ending.clazz + ", remaining stack is " + stack));
        }
        ending.accumulateTime(currentNanoTime);
        if (!stack.isEmpty()) {
            Clock restarting = stack.peek();
            restarting.restartClock(currentNanoTime);
        }
        if ((accumulatedTime = ending.accumulatedTime) == 0L) {
            return;
        }
        Profile counter = this.profile.get(c);
        if (counter == null && (counter2 = this.profile.putIfAbsent(c, counter = new Profile())) != null) {
            counter = counter2;
        }
        counter.handleCall(accumulatedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report() {
        if (!REPORT) {
            return;
        }
        System.err.println("PROFILE REPORT");
        try {
            TreeSet treeSet = new TreeSet(new TotalTimeComparator());
            treeSet.addAll(this.profile.keySet());
            System.err.printf("%8s  %8s %9s %s\n", "msecs", "#calls", "usecs/call", "Class");
            for (Class c : treeSet) {
                Profile p = this.getProfile(c);
                long time = p.totalTime.get();
                int callCount = p.totalCalls.get();
                if (time <= 10000000L) continue;
                System.err.printf("%8d  %8d  %8d %s\n", TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS), callCount, TimeUnit.MICROSECONDS.convert(time / (long)callCount, TimeUnit.NANOSECONDS), c.getSimpleName());
            }
            System.err.flush();
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        this.profile.clear();
        this.startTimes.get().clear();
    }

    Profile getProfile(Class<?> c) {
        Profile result = this.profile.get(c);
        if (result == null) {
            AnalysisContext.logError("Unexpected null profile for " + c.getName(), new NullPointerException());
            result = new Profile();
            this.profile.putIfAbsent(c, result);
        }
        return result;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        xmlOutput.startTag("FindBugsProfile");
        xmlOutput.stopTag(false);
        TreeSet treeSet = new TreeSet(new TotalTimeComparator());
        treeSet.addAll(this.profile.keySet());
        for (Class c : treeSet) {
            Profile p = this.getProfile(c);
            if (p == null) continue;
            long time = p.totalTime.get();
            int callCount = p.totalCalls.get();
            long maxTimeMicros = TimeUnit.MICROSECONDS.convert(p.maxTime.get(), TimeUnit.NANOSECONDS);
            long timeMillis = TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS);
            long timeMicros = TimeUnit.MICROSECONDS.convert(time, TimeUnit.NANOSECONDS);
            long averageTimeMicros = timeMicros / (long)callCount;
            long totalSquareMicros = p.totalSquareMicroseconds.get();
            long averageSquareMicros = totalSquareMicros / (long)callCount;
            long timeVariance = averageSquareMicros - averageTimeMicros * averageTimeMicros;
            long timeStandardDeviation = (long)Math.sqrt(timeVariance);
            if (timeMillis <= 10L) continue;
            xmlOutput.startTag("ClassProfile");
            xmlOutput.addAttribute("name", c.getName());
            xmlOutput.addAttribute("totalMilliseconds", String.valueOf(timeMillis));
            xmlOutput.addAttribute("invocations", String.valueOf(callCount));
            xmlOutput.addAttribute("avgMicrosecondsPerInvocation", String.valueOf(averageTimeMicros));
            xmlOutput.addAttribute("maxMicrosecondsPerInvocation", String.valueOf(maxTimeMicros));
            xmlOutput.addAttribute("standardDeviationMircosecondsPerInvocation", String.valueOf(timeStandardDeviation));
            xmlOutput.stopTag(true);
        }
        xmlOutput.closeTag("FindBugsProfile");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TotalTimeComparator
    implements Comparator<Class<?>> {
        TotalTimeComparator() {
        }

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            long v2;
            long v1 = Profiler.this.getProfile(c1).totalTime.get();
            if (v1 < (v2 = Profiler.this.getProfile(c2).totalTime.get())) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return c1.getName().compareTo(c2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<V1, V2> {
        final V1 first;
        final V2 second;

        Pair(V1 first, V2 second) {
            this.first = first;
            this.second = second;
        }

        public String toString() {
            return this.first + ":" + this.second;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Clock {
        final Class<?> clazz;
        long startTimeNanos;
        long accumulatedTime;

        Clock(Class<?> clazz, long currentNanoTime) {
            this.clazz = clazz;
            this.startTimeNanos = currentNanoTime;
        }

        void accumulateTime(long currentNanoTime) {
            this.accumulatedTime += currentNanoTime - this.startTimeNanos;
        }

        void restartClock(long currentNanoTime) {
            this.startTimeNanos = currentNanoTime;
        }
    }

    static class Profile {
        final AtomicLong totalTime = new AtomicLong();
        final AtomicInteger totalCalls = new AtomicInteger();
        final AtomicLong maxTime = new AtomicLong();
        final AtomicLong totalSquareMicroseconds = new AtomicLong();

        Profile() {
        }

        public void handleCall(long nanoTime) {
            this.totalCalls.incrementAndGet();
            this.totalTime.addAndGet(nanoTime);
            long oldMax = this.maxTime.get();
            if (nanoTime > oldMax) {
                this.maxTime.compareAndSet(oldMax, nanoTime);
            }
            long microseconds = TimeUnit.MICROSECONDS.convert(nanoTime, TimeUnit.NANOSECONDS);
            this.totalSquareMicroseconds.addAndGet(microseconds * microseconds);
        }
    }
}

