/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.userAnnotations.ri;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.userAnnotations.UserAnnotationPlugin;
import java.awt.GraphicsEnvironment;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;

public class JDBCUserAnnotationPlugin
implements UserAnnotationPlugin {
    String url;
    String dbUser;
    String dbPassword;
    String findbugsUser;

    public static JDBCUserAnnotationPlugin getPlugin() {
        JDBCUserAnnotationPlugin plugin = new JDBCUserAnnotationPlugin();
        if (!plugin.setProperties()) {
            return null;
        }
        return plugin;
    }

    private String getProperty(String propertyName) {
        return SystemProperties.getProperty("findbugs.jdbc." + propertyName);
    }

    private boolean setProperties() {
        String sqlDriver = this.getProperty("dbDriver");
        this.url = this.getProperty("dbUrl");
        String dbName = this.getProperty("dbName");
        this.dbUser = this.getProperty("dbUser");
        this.dbPassword = this.getProperty("dbPassword");
        this.findbugsUser = this.getProperty("findbugsUser");
        if (sqlDriver == null || this.dbUser == null || this.url == null || this.dbPassword == null) {
            return false;
        }
        if (this.findbugsUser == null) {
            this.findbugsUser = System.getProperty("user.name", "");
        }
        try {
            Class.forName(sqlDriver);
            Connection c = this.getConnection();
            Statement stmt = c.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) from  findbugsIssues");
            boolean result = false;
            if (rs.next()) {
                int count = rs.getInt(1);
                if (!GraphicsEnvironment.isHeadless() && MainFrame.isAvailable()) {
                    int choice = JOptionPane.showConfirmDialog(MainFrame.getInstance(), "Store comments in " + dbName + " as user " + this.findbugsUser + "?", "Connect to database?", 0);
                    return choice == 0;
                }
                result = true;
            }
            rs.close();
            stmt.close();
            c.close();
            return result;
        }
        catch (Exception e) {
            AnalysisContext.logError("Unable to connect to database", e);
            if (!GraphicsEnvironment.isHeadless() && MainFrame.isAvailable()) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Unable to connect to database: " + e.getMessage());
            }
            e.printStackTrace();
            return false;
        }
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.dbUser, this.dbPassword);
    }

    public void loadUserAnnotations(BugCollection bugs) {
        try {
            Connection c = this.getConnection();
            Date now = new Date(bugs.getTimestamp());
            PreparedStatement stmt = c.prepareStatement("SELECT id, status, updated, lastSeen, who, comment FROM findbugsIssues WHERE hash=?");
            PreparedStatement stmt2 = c.prepareStatement("INSERT INTO findbugsIssues (firstSeen, lastSeen, updated, who, hash, bugPattern, priority, primaryClass) VALUES (?,?,?,?,?,?,?,?)");
            PreparedStatement stmt3 = c.prepareStatement("UPDATE findbugsIssues SET lastSeen = ? WHERE id = ?");
            PreparedStatement stmt4 = c.prepareStatement("UPDATE findbugsIssues SET status=?, updated=?, who=?, comment=?, lastSeen=? WHERE id=?");
            long startTime = System.currentTimeMillis();
            int existingIssues = 0;
            int newIssues = 0;
            int storedStatuses = 0;
            for (BugInstance bug : bugs.getCollection()) {
                BugDesignation bd = bug.getUserDesignation();
                stmt.setString(1, bug.getInstanceHash());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    boolean updateDatabase;
                    int col = 1;
                    ++existingIssues;
                    int id = rs.getInt(col++);
                    String designationString = rs.getString(col++);
                    Date when = rs.getDate(col++);
                    Date lastSeen = rs.getDate(col++);
                    String who = rs.getString(col++);
                    String comment = rs.getString(col++);
                    boolean bl = updateDatabase = bd != null && when.getTime() < bd.getTimestamp() && !bd.getDesignationKey().equals("UNCLASSIFIED");
                    if (updateDatabase) {
                        c.prepareStatement("UPDATE findbugsIssues SET status=?, updated=?, who=?, comment=?, lastSeen=? WHERE id=?");
                        ++storedStatuses;
                        col = 1;
                        stmt4.setString(col++, bd.getDesignationKey());
                        stmt4.setDate(col++, new Date(bd.getTimestamp()));
                        stmt4.setString(col++, this.findbugsUser);
                        String annotationText = bd.getAnnotationText();
                        stmt4.setString(col++, annotationText);
                        stmt4.setDate(col++, new Date(Math.max(bd.getTimestamp(), when.getTime())));
                        stmt4.setInt(col++, id);
                        stmt4.execute();
                    } else {
                        if (designationString.length() != 0) {
                            bd = new BugDesignation(designationString, when.getTime(), comment, who);
                            bug.setUserDesignation(bd);
                        }
                        if (now.getTime() - lastSeen.getTime() > TimeUnit.MILLISECONDS.convert(604800L, TimeUnit.SECONDS)) {
                            stmt3.setInt(2, id);
                            stmt3.setDate(1, now);
                            stmt3.execute();
                        }
                    }
                } else {
                    ++newIssues;
                    this.addEntry(stmt2, now, bug);
                }
                rs.close();
            }
            stmt.close();
            stmt2.close();
            stmt3.close();
            c.close();
            long timeTaken = System.currentTimeMillis() - startTime;
            System.out.printf("%d issues are new, %d issues are preexisting, stored %d statuses, %d milliseconds, %d milliseconds/issue\n", newIssues, existingIssues, storedStatuses, timeTaken, timeTaken / (long)(newIssues + existingIssues));
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisContext.logError("Problems looking up user annotations", e);
        }
    }

    private void addEntry(PreparedStatement stmt2, Date now, BugInstance bug) throws SQLException {
        int col = 1;
        stmt2.setDate(col++, now);
        stmt2.setDate(col++, now);
        stmt2.setDate(col++, now);
        stmt2.setString(col++, this.findbugsUser);
        stmt2.setString(col++, bug.getInstanceHash());
        stmt2.setString(col++, bug.getBugPattern().getType());
        stmt2.setInt(col++, bug.getPriority());
        ClassAnnotation primaryClass = bug.getPrimaryClass();
        String className = primaryClass == null ? "UNKNOWN" : primaryClass.getClassName();
        stmt2.setString(col++, className);
        stmt2.execute();
    }

    private void updatedUserAnnotation(Connection c, BugInstance bug) throws SQLException {
        BugDesignation bd = bug.getUserDesignation();
        if (bd == null) {
            return;
        }
        PreparedStatement stmt0 = c.prepareStatement("SELECT id FROM findbugsIssues WHERE hash=?");
        stmt0.setString(1, bug.getInstanceHash());
        ResultSet rs = stmt0.executeQuery();
        if (!rs.next()) {
            PreparedStatement stmt2 = c.prepareStatement("INSERT INTO findbugsIssues (firstSeen, lastSeen, updated, who, hash, bugPattern, priority, primaryClass) VALUES (?,?,?,?,?,?,?,?)");
            this.addEntry(stmt2, new Date(System.currentTimeMillis()), bug);
            stmt2.close();
        }
        PreparedStatement stmt = c.prepareStatement("UPDATE findbugsIssues SET status=?, updated=?, who=?, comment=? WHERE hash=?");
        stmt.setString(1, bd.getDesignationKey());
        stmt.setDate(2, new Date(bd.getTimestamp()));
        stmt.setString(3, this.findbugsUser);
        String annotationText = bd.getAnnotationText();
        if (annotationText == null) {
            annotationText = "";
        }
        stmt.setString(4, annotationText);
        stmt.setString(5, bug.getInstanceHash());
        boolean result = stmt.execute();
        stmt.close();
    }

    public void storeUserAnnotation(BugInstance bug) {
        try {
            Connection c = this.getConnection();
            this.updatedUserAnnotation(c, bug);
            c.close();
        }
        catch (SQLException e) {
            AnalysisContext.logError("Problems looking up user annotations", e);
            e.printStackTrace();
        }
    }

    public void storeUserAnnotations(BugCollection bugs) {
        try {
            Connection c = this.getConnection();
            for (BugInstance bug : bugs.getCollection()) {
                this.updatedUserAnnotation(c, bug);
            }
            c.close();
        }
        catch (SQLException e) {
            AnalysisContext.logError("Problems looking up user annotations", e);
        }
    }
}

