/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class LaunchBrowser {
    @CheckForNull
    private static final Method jnlpShowMethod;
    private static final Object jnlpShowObject;
    private static Object desktopObject;
    private static Method desktopBrowseMethod;

    public static boolean showDocument(URL url) {
        if (desktopObject != null && desktopBrowseMethod != null) {
            try {
                desktopBrowseMethod.invoke(desktopObject, url.toURI());
                return true;
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (jnlpShowMethod != null) {
            try {
                Object result = jnlpShowMethod.invoke(jnlpShowObject, url);
                return Boolean.TRUE.equals(result);
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    static {
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            desktopObject = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopBrowseMethod = desktopClass.getMethod("browse", URI.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        Method showMethod = null;
        Object showObject = null;
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            showObject = lookupMethod.invoke(null, "javax.jnlp.BasicService");
            showMethod = showObject.getClass().getMethod("showDocument", URL.class);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        jnlpShowMethod = showMethod;
        jnlpShowObject = showObject;
    }
}

