/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.visitclass;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.LineNumberTable;

public abstract class DismantleBytecode
extends AnnotationVisitor {
    private int opcode;
    private boolean opcodeIsWide;
    private int PC;
    private int nextPC;
    private int branchOffset;
    private int branchTarget;
    private int branchFallThrough;
    private int[] switchOffsets;
    private int[] switchLabels;
    private int[] prevOpcode = new int[32];
    private int currentPosInPrevOpcodeBuffer;
    private int sizePrevOpcodeBuffer;
    private int defaultSwitchOffset;
    @SlashedClassName
    private String classConstantOperand;
    private ClassDescriptor referencedClass;
    private XClass referencedXClass;
    private MethodDescriptor referencedMethod;
    private XMethod referencedXMethod;
    private FieldDescriptor referencedField;
    private XField referencedXField;
    private String dottedClassConstantOperand;
    private String nameConstantOperand;
    private String sigConstantOperand;
    private String dottedSigConstantOperand;
    private String stringConstantOperand;
    private String refConstantOperand;
    private boolean refFieldIsStatic;
    private Constant constantRefOperand;
    private int intConstant;
    private long longConstant;
    private float floatConstant;
    private double doubleConstant;
    private int registerOperand;
    private boolean isRegisterLoad;
    private boolean isRegisterStore;
    private static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private static final String NOT_AVAILABLE = "./.";
    public static final byte M_INT = 1;
    public static final byte M_UINT = 2;
    public static final byte M_CP = 3;
    public static final byte M_R = 4;
    public static final byte M_BR = 5;
    public static final byte M_PAD = 6;
    static final byte[][] MEANING_OF_OPERANDS = new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], {1}, {1}, {3}, {3}, {3}, {4}, {4}, {4}, {4}, {4}, new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], {4}, {4}, {4}, {4}, {4}, new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], {4, 1}, new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], {5}, {5}, {5}, {5}, {5}, {5}, {5}, {5}, {5}, {5}, {5}, {5}, {5}, {5}, {5}, {5}, {4}, new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], {3}, {3}, {3}, {3}, {3}, {3}, {3}, {3, 6, 6}, new byte[0], {3}, {2}, {3}, new byte[0], new byte[0], {3}, {3}, new byte[0], new byte[0], {6}, {3, 2}, {5}, {5}, {5}, {5}, new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]};
    protected byte[] codeBytes;
    protected LineNumberTable lineNumberTable;
    private static NumberFormat formatter = NumberFormat.getIntegerInstance();

    static String replaceSlashesWithDots(String c) {
        return c.replace('/', '.');
    }

    public ClassDescriptor getClassDescriptorOperand() {
        if (this.referencedClass == null) {
            throw new IllegalStateException("getClassDescriptorOperand called but value not available");
        }
        return this.referencedClass;
    }

    @CheckForNull
    public XClass getXClassOperand() {
        return this.referencedXClass;
    }

    public MethodDescriptor getMethodDescriptorOperand() {
        if (this.nameConstantOperand == NOT_AVAILABLE) {
            throw new IllegalStateException("getMethodDescriptorOperand called but value not available");
        }
        if (this.referencedMethod == null) {
            this.referencedMethod = DescriptorFactory.instance().getMethodDescriptor(this.classConstantOperand, this.nameConstantOperand, this.sigConstantOperand, this.opcode == 184);
        }
        return this.referencedMethod;
    }

    @CheckForNull
    public XMethod getXMethodOperand() {
        if (this.referencedXClass != null && this.referencedXMethod == null) {
            this.referencedXMethod = this.referencedXClass.findMethod(this.nameConstantOperand, this.sigConstantOperand, this.opcode == 184);
        }
        return this.referencedXMethod;
    }

    public FieldDescriptor getFieldDescriptorOperand() {
        if (this.nameConstantOperand == NOT_AVAILABLE) {
            throw new IllegalStateException("getFieldDescriptorOperand called but value not available");
        }
        if (this.referencedField == null) {
            this.referencedField = DescriptorFactory.instance().getFieldDescriptor(this.classConstantOperand, this.nameConstantOperand, this.sigConstantOperand, this.opcode == 178 || this.opcode == 179);
        }
        return this.referencedField;
    }

    @CheckForNull
    public XField getXFieldOperand() {
        if (this.referencedXClass != null && this.referencedXField == null) {
            this.referencedXField = this.referencedXClass.findField(this.nameConstantOperand, this.sigConstantOperand, this.opcode == 178 || this.opcode == 179);
        }
        return this.referencedXField;
    }

    public String getDottedClassConstantOperand() {
        if (this.dottedClassConstantOperand != null) {
            assert (this.dottedClassConstantOperand != NOT_AVAILABLE);
            return this.dottedClassConstantOperand;
        }
        if (this.classConstantOperand == NOT_AVAILABLE) {
            throw new IllegalStateException("getDottedClassConstantOperand called but value not available");
        }
        this.dottedClassConstantOperand = ClassName.toDottedClassName(this.classConstantOperand);
        return this.dottedClassConstantOperand;
    }

    public String getRefConstantOperand() {
        if (this.refConstantOperand == NOT_AVAILABLE) {
            throw new IllegalStateException("getRefConstantOperand called but value not available");
        }
        if (this.refConstantOperand == null) {
            String dottedClassConstantOperand = this.getDottedClassConstantOperand();
            StringBuilder ref = new StringBuilder(dottedClassConstantOperand.length() + this.nameConstantOperand.length() + this.dottedSigConstantOperand.length() + 5);
            ref.append(dottedClassConstantOperand).append(".").append(this.nameConstantOperand).append(" : ").append(this.dottedSigConstantOperand);
            this.refConstantOperand = ref.toString();
        }
        return this.refConstantOperand;
    }

    public String getNameConstantOperand() {
        if (this.nameConstantOperand == NOT_AVAILABLE) {
            throw new IllegalStateException("getNameConstantOperand called but value not available");
        }
        return this.nameConstantOperand;
    }

    @Deprecated
    public String getDottedSigConstantOperand() {
        if (this.dottedSigConstantOperand == NOT_AVAILABLE) {
            throw new IllegalStateException("getDottedSigConstantOperand called but value not available");
        }
        return this.dottedSigConstantOperand;
    }

    public String getSigConstantOperand() {
        if (this.sigConstantOperand == NOT_AVAILABLE) {
            throw new IllegalStateException("getSigConstantOperand called but value not available");
        }
        return this.sigConstantOperand;
    }

    @SlashedClassName
    public String getClassConstantOperand() {
        if (this.classConstantOperand == NOT_AVAILABLE) {
            throw new IllegalStateException("getClassConstantOperand called but value not available");
        }
        return this.classConstantOperand;
    }

    public String getStringConstantOperand() {
        if (this.stringConstantOperand == NOT_AVAILABLE) {
            throw new IllegalStateException("getStringConstantOperand called but value not available");
        }
        return this.stringConstantOperand;
    }

    public Constant getConstantRefOperand() {
        if (this.constantRefOperand == null) {
            throw new IllegalStateException("getConstantRefOperand called but value not available");
        }
        return this.constantRefOperand;
    }

    public boolean isRegisterLoad() {
        return this.isRegisterLoad;
    }

    public boolean isRegisterStore() {
        return this.isRegisterStore;
    }

    public int getRegisterOperand() {
        if (this.registerOperand == -1) {
            throw new IllegalStateException("getRegisterOperand called but value not available");
        }
        return this.registerOperand;
    }

    public int getIntConstant() {
        return this.intConstant;
    }

    public int getBranchOffset() {
        if (this.branchOffset == Integer.MIN_VALUE) {
            throw new IllegalStateException("getBranchOffset called but value not available");
        }
        return this.branchOffset;
    }

    public int getBranchTarget() {
        if (this.branchTarget == Integer.MIN_VALUE) {
            throw new IllegalStateException("getBranchTarget called but value not available");
        }
        return this.branchTarget;
    }

    public int getBranchFallThrough() {
        if (this.branchFallThrough == Integer.MIN_VALUE) {
            throw new IllegalStateException("getBranchFallThrough called but value not available");
        }
        return this.branchFallThrough;
    }

    public int getDefaultSwitchOffset() {
        if (this.defaultSwitchOffset == Integer.MIN_VALUE) {
            throw new IllegalStateException("getDefaultSwitchOffset called but value not available");
        }
        return this.defaultSwitchOffset;
    }

    public boolean getRefFieldIsStatic() {
        return this.refFieldIsStatic;
    }

    public int getPC() {
        return this.PC;
    }

    public int getPrevOpcode(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + offset + ") must be nonnegative");
        }
        if (offset >= this.prevOpcode.length || offset > this.sizePrevOpcodeBuffer) {
            return 0;
        }
        int pos = this.currentPosInPrevOpcodeBuffer - offset;
        if (pos < 0) {
            pos += this.prevOpcode.length;
        }
        return this.prevOpcode[pos];
    }

    public boolean isWideOpcode() {
        return this.opcodeIsWide;
    }

    public static boolean isBranch(int opcode) {
        byte[] operands = MEANING_OF_OPERANDS[opcode];
        return operands.length > 0 && operands[0] == 5;
    }

    public static boolean isSwitch(int opcode) {
        return opcode == 171 || opcode == 170;
    }

    @SuppressWarnings(value={"EI"})
    public int[] getSwitchOffsets() {
        if (this.switchOffsets == null) {
            throw new IllegalStateException("getSwitchOffsets called but value not available");
        }
        return this.switchOffsets;
    }

    @SuppressWarnings(value={"EI"})
    public int[] getSwitchLabels() {
        if (this.switchLabels == null) {
            throw new IllegalStateException("getSwitchLabels called but value not available");
        }
        return this.switchLabels;
    }

    private void resetState() {
        this.refConstantOperand = NOT_AVAILABLE;
        this.stringConstantOperand = NOT_AVAILABLE;
        this.dottedSigConstantOperand = NOT_AVAILABLE;
        this.sigConstantOperand = NOT_AVAILABLE;
        this.nameConstantOperand = NOT_AVAILABLE;
        this.classConstantOperand = NOT_AVAILABLE;
        this.refFieldIsStatic = false;
        this.constantRefOperand = null;
        this.registerOperand = -1;
        this.isRegisterLoad = false;
        this.isRegisterStore = false;
        this.defaultSwitchOffset = Integer.MIN_VALUE;
        this.branchFallThrough = Integer.MIN_VALUE;
        this.branchTarget = Integer.MIN_VALUE;
        this.branchOffset = Integer.MIN_VALUE;
        this.switchLabels = null;
        this.switchOffsets = null;
        this.dottedClassConstantOperand = null;
        this.referencedClass = null;
        this.referencedXClass = null;
        this.referencedMethod = null;
        this.referencedXMethod = null;
        this.referencedField = null;
        this.referencedXField = null;
    }

    private static void sortByOffset(int[] switchOffsets, int[] switchLabels) {
        int npairs = switchOffsets.length;
        for (int j = 0; j < npairs; ++j) {
            int min = j;
            for (int k = j + 1; k < npairs; ++k) {
                if (switchOffsets[min] <= switchOffsets[k]) continue;
                min = k;
            }
            if (min <= j) continue;
            int tmp = switchOffsets[min];
            switchOffsets[min] = switchOffsets[j];
            switchOffsets[j] = tmp;
            tmp = switchLabels[min];
            switchLabels[min] = switchLabels[j];
            switchLabels[j] = tmp;
        }
    }

    public int getMaxPC() {
        return this.codeBytes.length - 1;
    }

    public int getCodeByte(int offset) {
        return 0xFF & this.codeBytes[offset];
    }

    public int getOpcode() {
        return this.opcode;
    }

    public boolean atCatchBlock() {
        for (CodeException e : this.getCode().getExceptionTable()) {
            if (e.getHandlerPC() != this.getPC()) continue;
            return true;
        }
        return false;
    }

    public void visit(Code obj) {
        block83: {
            DataInputStream byteStream;
            block82: {
                this.sizePrevOpcodeBuffer = 0;
                this.currentPosInPrevOpcodeBuffer = this.prevOpcode.length - 1;
                int switchLow = 1000000;
                int switchHigh = -1000000;
                this.codeBytes = obj.getCode();
                byteStream = new DataInputStream(new ByteArrayInputStream(this.codeBytes));
                this.lineNumberTable = obj.getLineNumberTable();
                try {
                    int i = 0;
                    while (i < this.codeBytes.length) {
                        int o;
                        int prevOffset;
                        int k;
                        block86: {
                            short byteStreamArgCount;
                            block84: {
                                block88: {
                                    block87: {
                                        int o2;
                                        int npairs;
                                        int count;
                                        int pad;
                                        block85: {
                                            this.resetState();
                                            this.PC = i;
                                            this.opcodeIsWide = false;
                                            this.opcode = byteStream.readUnsignedByte();
                                            ++this.sizePrevOpcodeBuffer;
                                            ++this.currentPosInPrevOpcodeBuffer;
                                            if (this.currentPosInPrevOpcodeBuffer >= this.prevOpcode.length) {
                                                this.currentPosInPrevOpcodeBuffer = 0;
                                            }
                                            this.prevOpcode[this.currentPosInPrevOpcodeBuffer] = this.opcode;
                                            ++i;
                                            byteStreamArgCount = NO_OF_OPERANDS[this.opcode];
                                            if (byteStreamArgCount != -2) break block84;
                                            if (this.opcode != 171) break block85;
                                            pad = 4 - (i & 3);
                                            if (pad == 4) {
                                                pad = 0;
                                            }
                                            for (count = pad; count > 0; count -= byteStream.skipBytes(count)) {
                                            }
                                            i += pad;
                                            this.branchOffset = this.defaultSwitchOffset = byteStream.readInt();
                                            this.branchTarget = this.branchOffset + this.PC;
                                            i += 4;
                                            npairs = byteStream.readInt();
                                            i += 4;
                                            this.switchOffsets = new int[npairs];
                                            this.switchLabels = new int[npairs];
                                            for (o2 = 0; o2 < npairs; ++o2) {
                                                this.switchLabels[o2] = byteStream.readInt();
                                                this.switchOffsets[o2] = byteStream.readInt();
                                                i += 8;
                                            }
                                            DismantleBytecode.sortByOffset(this.switchOffsets, this.switchLabels);
                                            break block86;
                                        }
                                        if (this.opcode != 170) break block87;
                                        pad = 4 - (i & 3);
                                        if (pad == 4) {
                                            pad = 0;
                                        }
                                        for (count = pad; count > 0; count -= byteStream.skipBytes(count)) {
                                        }
                                        i += pad;
                                        this.branchOffset = this.defaultSwitchOffset = byteStream.readInt();
                                        this.branchTarget = this.branchOffset + this.PC;
                                        i += 4;
                                        switchLow = byteStream.readInt();
                                        i += 4;
                                        switchHigh = byteStream.readInt();
                                        i += 4;
                                        npairs = switchHigh - switchLow + 1;
                                        this.switchOffsets = new int[npairs];
                                        this.switchLabels = new int[npairs];
                                        for (o2 = 0; o2 < npairs; ++o2) {
                                            this.switchLabels[o2] = o2 + switchLow;
                                            this.switchOffsets[o2] = byteStream.readInt();
                                            i += 4;
                                        }
                                        DismantleBytecode.sortByOffset(this.switchOffsets, this.switchLabels);
                                        break block86;
                                    }
                                    if (this.opcode != 196) break block88;
                                    this.opcodeIsWide = true;
                                    this.opcode = byteStream.readUnsignedByte();
                                    ++i;
                                    switch (this.opcode) {
                                        case 21: 
                                        case 22: 
                                        case 23: 
                                        case 24: 
                                        case 25: 
                                        case 54: 
                                        case 55: 
                                        case 56: 
                                        case 57: 
                                        case 58: 
                                        case 169: {
                                            this.registerOperand = byteStream.readUnsignedShort();
                                            i += 2;
                                            break block86;
                                        }
                                        case 132: {
                                            this.registerOperand = byteStream.readUnsignedShort();
                                            i += 2;
                                            this.intConstant = byteStream.readShort();
                                            i += 2;
                                            break block86;
                                        }
                                        default: {
                                            throw new IllegalStateException("bad wide bytecode: " + OPCODE_NAMES[this.opcode]);
                                        }
                                    }
                                }
                                throw new IllegalStateException("bad unpredicatable bytecode: " + OPCODE_NAMES[this.opcode]);
                            }
                            if (byteStreamArgCount < 0) {
                                throw new IllegalStateException("bad length for bytecode: " + OPCODE_NAMES[this.opcode]);
                            }
                            block56: for (k = 0; k < TYPE_OF_OPERANDS[this.opcode].length; ++k) {
                                int v;
                                short t = TYPE_OF_OPERANDS[this.opcode][k];
                                byte m = MEANING_OF_OPERANDS[this.opcode][k];
                                boolean unsigned = m == 3 || m == 4 || m == 2;
                                switch (t) {
                                    case 8: {
                                        v = unsigned ? byteStream.readUnsignedByte() : (int)byteStream.readByte();
                                        ++i;
                                        break;
                                    }
                                    case 9: {
                                        v = unsigned ? byteStream.readUnsignedShort() : (int)byteStream.readShort();
                                        i += 2;
                                        break;
                                    }
                                    case 10: {
                                        v = byteStream.readInt();
                                        i += 4;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException();
                                    }
                                }
                                switch (m) {
                                    case 5: {
                                        this.branchOffset = v;
                                        this.branchTarget = v + this.PC;
                                        this.branchFallThrough = i;
                                        continue block56;
                                    }
                                    case 3: {
                                        this.constantRefOperand = this.getConstantPool().getConstant(v);
                                        if (this.constantRefOperand instanceof ConstantClass) {
                                            ConstantClass clazz = (ConstantClass)this.constantRefOperand;
                                            this.classConstantOperand = this.getStringFromIndex(clazz.getNameIndex());
                                            this.referencedClass = DescriptorFactory.createClassDescriptor(this.classConstantOperand);
                                            try {
                                                this.referencedXClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, this.referencedClass);
                                            }
                                            catch (CheckedAnalysisException e) {
                                                this.referencedXClass = null;
                                            }
                                            continue block56;
                                        }
                                        if (this.constantRefOperand instanceof ConstantInteger) {
                                            this.intConstant = ((ConstantInteger)this.constantRefOperand).getBytes();
                                            continue block56;
                                        }
                                        if (this.constantRefOperand instanceof ConstantLong) {
                                            this.longConstant = ((ConstantLong)this.constantRefOperand).getBytes();
                                            continue block56;
                                        }
                                        if (this.constantRefOperand instanceof ConstantFloat) {
                                            this.floatConstant = ((ConstantFloat)this.constantRefOperand).getBytes();
                                            continue block56;
                                        }
                                        if (this.constantRefOperand instanceof ConstantDouble) {
                                            this.doubleConstant = ((ConstantDouble)this.constantRefOperand).getBytes();
                                            continue block56;
                                        }
                                        if (this.constantRefOperand instanceof ConstantString) {
                                            int s = ((ConstantString)this.constantRefOperand).getStringIndex();
                                            this.stringConstantOperand = this.getStringFromIndex(s);
                                            continue block56;
                                        }
                                        if (!(this.constantRefOperand instanceof ConstantCP)) continue block56;
                                        ConstantCP cp = (ConstantCP)this.constantRefOperand;
                                        ConstantClass clazz = (ConstantClass)this.getConstantPool().getConstant(cp.getClassIndex());
                                        this.classConstantOperand = this.getStringFromIndex(clazz.getNameIndex());
                                        this.referencedClass = DescriptorFactory.createClassDescriptor(this.classConstantOperand);
                                        try {
                                            this.referencedXClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, this.referencedClass);
                                        }
                                        catch (CheckedAnalysisException e) {
                                            this.referencedXClass = null;
                                        }
                                        ConstantNameAndType sig = (ConstantNameAndType)this.getConstantPool().getConstant(cp.getNameAndTypeIndex());
                                        this.nameConstantOperand = this.getStringFromIndex(sig.getNameIndex());
                                        this.sigConstantOperand = this.getStringFromIndex(sig.getSignatureIndex());
                                        this.dottedSigConstantOperand = DismantleBytecode.replaceSlashesWithDots(this.sigConstantOperand);
                                        this.refConstantOperand = null;
                                        continue block56;
                                    }
                                    case 4: {
                                        this.registerOperand = v;
                                        continue block56;
                                    }
                                    case 1: 
                                    case 2: {
                                        this.intConstant = v;
                                    }
                                }
                            }
                        }
                        switch (this.opcode) {
                            case 132: {
                                this.isRegisterLoad = true;
                                this.isRegisterStore = true;
                                break;
                            }
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: {
                                this.registerOperand = this.opcode - 26;
                                this.isRegisterLoad = true;
                                break;
                            }
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: {
                                this.registerOperand = this.opcode - 42;
                                this.isRegisterLoad = true;
                                break;
                            }
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: {
                                this.registerOperand = this.opcode - 34;
                                this.isRegisterLoad = true;
                                break;
                            }
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: {
                                this.registerOperand = this.opcode - 38;
                                this.isRegisterLoad = true;
                                break;
                            }
                            case 30: 
                            case 31: 
                            case 32: 
                            case 33: {
                                this.registerOperand = this.opcode - 30;
                                this.isRegisterLoad = true;
                                break;
                            }
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: {
                                this.isRegisterLoad = true;
                                break;
                            }
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: {
                                this.registerOperand = this.opcode - 59;
                                this.isRegisterStore = true;
                                break;
                            }
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: {
                                this.registerOperand = this.opcode - 75;
                                this.isRegisterStore = true;
                                break;
                            }
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                this.registerOperand = this.opcode - 67;
                                this.isRegisterStore = true;
                                break;
                            }
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: {
                                this.registerOperand = this.opcode - 71;
                                this.isRegisterStore = true;
                                break;
                            }
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: {
                                this.registerOperand = this.opcode - 63;
                                this.isRegisterStore = true;
                                break;
                            }
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: {
                                this.isRegisterStore = true;
                            }
                        }
                        switch (this.opcode) {
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: {
                                break;
                            }
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: {
                                break;
                            }
                            case 169: {
                                break;
                            }
                            case 178: 
                            case 179: {
                                this.refFieldIsStatic = true;
                                break;
                            }
                            case 180: 
                            case 181: {
                                this.refFieldIsStatic = false;
                            }
                        }
                        this.nextPC = i;
                        if (this.beforeOpcode(this.opcode)) {
                            this.sawOpcode(this.opcode);
                        }
                        this.afterOpcode(this.opcode);
                        if (this.opcode == 170) {
                            this.sawInt(switchLow);
                            this.sawInt(switchHigh);
                            prevOffset = i - this.PC;
                            for (o = 0; o <= switchHigh - switchLow; ++o) {
                                this.sawBranchTo(this.switchOffsets[o] + this.PC);
                                this.sawOffset(this.switchOffsets[o] - prevOffset);
                                prevOffset = this.switchOffsets[o];
                            }
                            this.sawOffset(this.defaultSwitchOffset - prevOffset);
                            this.sawBranchTo(this.defaultSwitchOffset + this.PC);
                            continue;
                        }
                        if (this.opcode == 171) {
                            this.sawInt(this.switchOffsets.length);
                            prevOffset = i - this.PC;
                            for (o = 0; o < this.switchOffsets.length; ++o) {
                                this.sawBranchTo(this.switchOffsets[o] + this.PC);
                                prevOffset = this.switchOffsets[o];
                                this.sawInt(this.switchLabels[o]);
                            }
                            this.sawOffset(this.defaultSwitchOffset - prevOffset);
                            this.sawBranchTo(this.defaultSwitchOffset + this.PC);
                            continue;
                        }
                        block59: for (k = 0; k < TYPE_OF_OPERANDS[this.opcode].length; ++k) {
                            byte m = MEANING_OF_OPERANDS[this.opcode][k];
                            switch (m) {
                                case 5: {
                                    this.sawBranchTo(this.branchOffset + this.PC);
                                    if (this.branchOffset > 0) {
                                        this.sawOffset(this.branchOffset - (i - this.PC));
                                        continue block59;
                                    }
                                    this.sawOffset(this.branchOffset);
                                    continue block59;
                                }
                                case 3: {
                                    if (this.constantRefOperand instanceof ConstantInteger) {
                                        this.sawInt(this.intConstant);
                                        continue block59;
                                    }
                                    if (this.constantRefOperand instanceof ConstantLong) {
                                        this.sawLong(this.longConstant);
                                        continue block59;
                                    }
                                    if (this.constantRefOperand instanceof ConstantFloat) {
                                        this.sawFloat(this.floatConstant);
                                        continue block59;
                                    }
                                    if (this.constantRefOperand instanceof ConstantDouble) {
                                        this.sawDouble(this.doubleConstant);
                                        continue block59;
                                    }
                                    if (this.constantRefOperand instanceof ConstantString) {
                                        this.sawString(this.stringConstantOperand);
                                        continue block59;
                                    }
                                    if (this.constantRefOperand instanceof ConstantFieldref) {
                                        this.sawField();
                                        continue block59;
                                    }
                                    if (this.constantRefOperand instanceof ConstantMethodref) {
                                        this.sawMethod();
                                        continue block59;
                                    }
                                    if (this.constantRefOperand instanceof ConstantInterfaceMethodref) {
                                        this.sawIMethod();
                                        continue block59;
                                    }
                                    if (!(this.constantRefOperand instanceof ConstantClass)) continue block59;
                                    this.sawClass();
                                    continue block59;
                                }
                                case 4: {
                                    this.sawRegister(this.registerOperand);
                                    continue block59;
                                }
                                case 1: {
                                    this.sawInt(this.intConstant);
                                }
                            }
                        }
                    }
                }
                catch (IOException e) {
                    AnalysisContext.logError("Error while dismantling bytecode", e);
                    if ($assertionsDisabled) break block82;
                    throw new AssertionError();
                }
            }
            try {
                byteStream.close();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block83;
                throw new AssertionError();
            }
        }
    }

    public void sawDouble(double seen) {
    }

    public void sawFloat(float seen) {
    }

    public void sawRegister(int r) {
    }

    public void sawInt(int seen) {
    }

    public void sawLong(long seen) {
    }

    public void sawBranchTo(int seen) {
    }

    public void sawOffset(int seen) {
    }

    public boolean beforeOpcode(int seen) {
        return true;
    }

    public void afterOpcode(int seen) {
    }

    public void sawOpcode(int seen) {
    }

    public void sawString(String seen) {
    }

    public void sawField() {
    }

    public void sawMethod() {
    }

    public void sawIMethod() {
    }

    public void sawClass() {
    }

    public void printOpCode(int seen) {
        System.out.print("  TestingGround: [" + formatter.format(this.getPC()) + "]  " + OPCODE_NAMES[seen]);
        if (seen == 182 || seen == 183 || seen == 185 || seen == 184) {
            System.out.print("   " + this.getClassConstantOperand() + "." + this.getNameConstantOperand() + " " + this.getSigConstantOperand());
        } else if (seen == 18 || seen == 19 || seen == 20) {
            Constant c = this.getConstantRefOperand();
            if (c instanceof ConstantString) {
                System.out.print("   \"" + this.getStringConstantOperand() + "\"");
            } else if (c instanceof ConstantClass) {
                System.out.print("   " + this.getClassConstantOperand());
            } else {
                System.out.print("   " + c);
            }
        } else if (seen == 25 || seen == 58) {
            System.out.print("   " + this.getRegisterOperand());
        } else if (seen == 167 || seen == 200 || seen == 165 || seen == 166 || seen == 159 || seen == 162 || seen == 163 || seen == 164 || seen == 161 || seen == 160 || seen == 153 || seen == 156 || seen == 157 || seen == 158 || seen == 155 || seen == 154 || seen == 199 || seen == 198) {
            System.out.print("   " + this.getBranchTarget());
        } else if (seen == 187 || seen == 193) {
            System.out.print("   " + this.getClassConstantOperand());
        } else if (seen == 170 || seen == 171) {
            int[] offsets;
            System.out.print("    [");
            int switchPC = this.getPC();
            for (int offset : offsets = this.getSwitchOffsets()) {
                System.out.print(switchPC + offset + ",");
            }
            System.out.print(switchPC + this.getDefaultSwitchOffset() + "]");
        }
        System.out.println();
    }

    public int getNextPC() {
        return this.nextPC;
    }

    public boolean isReturn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    public static boolean areOppositeBranches(int opcode1, int opcode2) {
        if (!DismantleBytecode.isBranch(opcode1)) {
            throw new IllegalArgumentException(OPCODE_NAMES[opcode1] + " isn't a branch");
        }
        if (!DismantleBytecode.isBranch(opcode2)) {
            throw new IllegalArgumentException(OPCODE_NAMES[opcode2] + " isn't a branch");
        }
        switch (opcode1) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return (opcode1 + 1 ^ 1) == opcode2 + 1;
            }
            case 199: {
                return opcode2 == 198;
            }
            case 198: {
                return opcode2 == 199;
            }
        }
        return false;
    }

    public boolean isRegisterStore(int opcode) {
        switch (opcode) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return true;
            }
        }
        return false;
    }

    static {
        formatter.setMinimumIntegerDigits(4);
        formatter.setGroupingUsed(false);
    }
}

