/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.visitclass;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;

public class Util {
    @CheckForNull
    public static JavaClass getOuterClass(JavaClass obj) throws ClassNotFoundException {
        for (Attribute a : obj.getAttributes()) {
            if (!(a instanceof InnerClasses)) continue;
            for (InnerClass ic : ((InnerClasses)a).getInnerClasses()) {
                if (obj.getClassNameIndex() != ic.getInnerClassIndex()) continue;
                ConstantClass oc = (ConstantClass)obj.getConstantPool().getConstant(ic.getOuterClassIndex());
                String ocName = oc.getBytes(obj.getConstantPool());
                return Repository.lookupClass((String)ocName);
            }
        }
        return null;
    }

    public static int getSizeOfSurroundingTryBlock(Method method, String vmNameOfExceptionClass, int pc) {
        return Util.getSizeOfSurroundingTryBlock(method.getConstantPool(), method.getCode(), vmNameOfExceptionClass, pc);
    }

    public static int getSizeOfSurroundingTryBlock(ConstantPool constantPool, Code code, @CheckForNull String vmNameOfExceptionClass, int pc) {
        int size = Integer.MAX_VALUE;
        int tightStartPC = 0;
        int tightEndPC = Integer.MAX_VALUE;
        if (code.getExceptionTable() == null) {
            return size;
        }
        for (CodeException catchBlock : code.getExceptionTable()) {
            int thisSize;
            Constant catchType;
            if (vmNameOfExceptionClass != null && ((catchType = constantPool.getConstant(catchBlock.getCatchType())) == null || catchType instanceof ConstantClass && !((ConstantClass)catchType).getBytes(constantPool).equals(vmNameOfExceptionClass))) continue;
            int startPC = catchBlock.getStartPC();
            int endPC = catchBlock.getEndPC();
            if (pc < startPC || pc > endPC || size <= (thisSize = endPC - startPC)) continue;
            size = thisSize;
            tightStartPC = startPC;
            tightEndPC = endPC;
        }
        if (size == Integer.MAX_VALUE) {
            return size;
        }
        size = (size + 7) / 8;
        LineNumberTable lineNumberTable = code.getLineNumberTable();
        if (lineNumberTable == null) {
            return size;
        }
        int count = 0;
        for (LineNumber line : lineNumberTable.getLineNumberTable()) {
            if (line.getStartPC() > tightEndPC) break;
            if (line.getStartPC() < tightStartPC) continue;
            ++count;
        }
        return count;
    }
}

