/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class Churn {
    BugCollection bugCollection;
    Map<String, Data> data = new HashMap<String, Data>();

    public Churn() {
    }

    public Churn(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public void setBugCollection(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    String getKey(BugInstance b) {
        return b.getPriorityAbbreviation() + "-" + b.getType();
    }

    public Churn execute() {
        Data all = new Data();
        this.data.put("all", all);
        for (BugInstance bugInstance : this.bugCollection) {
            String key = this.getKey(bugInstance);
            Data d = this.data.get(key);
            if (d == null) {
                d = new Data();
                this.data.put(key, d);
            }
            if (bugInstance.isDead()) {
                ++d.fixed;
                ++all.fixed;
            } else {
                ++d.persist;
                ++all.persist;
            }
            long first = bugInstance.getFirstVersion();
            long last = bugInstance.getLastVersion();
            if (first == 0L || last == -1L) continue;
            System.out.printf("%3d age\n", last - first);
        }
        return this;
    }

    public void dump(PrintStream out) {
        System.out.printf("%3s %5s %5s  %s\n", "%", "const", "fix", "new");
        for (Map.Entry<String, Data> e : this.data.entrySet()) {
            Data d = e.getValue();
            int total = d.persist + d.fixed;
            if (total < 2) continue;
            System.out.printf("%3d %5d %5d  %s\n", d.fixed * 100 / total, d.persist, d.fixed, e.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DetectorFactoryCollection.instance();
        Churn churn = new Churn();
        ChurnCommandLine commandLine = churn.new ChurnCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + Churn.class.getName() + " [options] [<xml results> [<history]] ");
        SortedBugCollection bugCollection = new SortedBugCollection();
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++], new Project());
        } else {
            bugCollection.readXML(System.in, new Project());
        }
        churn.setBugCollection(bugCollection);
        churn.execute();
        PrintStream out = System.out;
        try {
            if (argCount < args.length) {
                out = new PrintStream(new FileOutputStream(args[argCount++]), true);
            }
            churn.dump(out);
        }
        finally {
            out.close();
        }
    }

    class ChurnCommandLine
    extends CommandLine {
        ChurnCommandLine() {
        }

        public void handleOption(String option, String optionalExtraPart) {
            throw new IllegalArgumentException("unknown option: " + option);
        }

        public void handleOptionWithArgument(String option, String argument) {
            throw new IllegalArgumentException("unknown option: " + option);
        }
    }

    static class Data {
        int persist;
        int fixed;

        Data() {
        }
    }
}

