/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFinder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.DocumentException;

public class CopyBuggySource {
    private static final String USAGE = "Usage: <cmd>   <bugs.xml> <destinationSrcDir>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws IOException, DocumentException {
        DetectorFactoryCollection.instance();
        if (args.length != 2) {
            System.out.println(USAGE);
            return;
        }
        Project project = new Project();
        SortedBugCollection origCollection = new SortedBugCollection();
        origCollection.readXML(args[0], project);
        File src = new File(args[1]);
        byte[] buf = new byte[4096];
        if (!src.isDirectory()) {
            throw new IllegalArgumentException(args[1] + " is not a source directory");
        }
        SourceFinder sourceFinder = new SourceFinder();
        sourceFinder.setSourceBaseList(project.getSourceDirList());
        HashSet<String> copied = new HashSet<String>();
        for (BugInstance bug : origCollection.getCollection()) {
            Iterator<BugAnnotation> i = bug.annotationIterator();
            while (i.hasNext()) {
                SourceLineAnnotation sourceAnnotation;
                BugAnnotation ann = i.next();
                if (ann instanceof BugAnnotationWithSourceLines) {
                    sourceAnnotation = ((BugAnnotationWithSourceLines)ann).getSourceLines();
                } else {
                    if (!(ann instanceof SourceLineAnnotation)) continue;
                    sourceAnnotation = (SourceLineAnnotation)ann;
                }
                if (sourceAnnotation == null) continue;
                String packageName = sourceAnnotation.getPackageName();
                String sourceFile = sourceAnnotation.getSourceFile();
                String fullName = packageName == "" ? sourceFile : packageName.replace('.', File.separatorChar) + File.separatorChar + sourceFile;
                if (!copied.add(fullName)) continue;
                File file = new File(src, fullName);
                if (file.exists()) {
                    System.out.println(file + " already exists");
                    continue;
                }
                File parent = file.getParentFile();
                if (parent.isDirectory() || parent.mkdirs()) {
                    InputStream in = null;
                    FileOutputStream out = null;
                    try {
                        int sz;
                        in = sourceFinder.openSource(packageName, sourceFile);
                        out = new FileOutputStream(file);
                        while ((sz = in.read(buf)) >= 0) {
                            ((OutputStream)out).write(buf, 0, sz);
                        }
                        System.out.println("Copied " + file);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("Did not find " + file);
                        CopyBuggySource.close(in);
                        CopyBuggySource.close(out);
                        continue;
                    }
                    catch (IOException e2) {
                        System.out.println("Problem copying " + file);
                        e2.printStackTrace(System.out);
                        {
                            catch (Throwable throwable) {
                                CopyBuggySource.close(in);
                                CopyBuggySource.close(out);
                                throw throwable;
                            }
                        }
                        CopyBuggySource.close(in);
                        CopyBuggySource.close(out);
                        continue;
                    }
                    CopyBuggySource.close(in);
                    CopyBuggySource.close(out);
                    continue;
                }
                System.out.println("Unable to create directory for " + parent);
            }
        }
    }

    public static void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

