/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ExcludingHashesBugReporter;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.workflow.SourceSearcher;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;

public class Filter {
    static SourceSearcher sourceSearcher;

    public static int parsePriority(String argument) {
        int i = " HMLE".indexOf(argument);
        if (i == -1) {
            i = " 1234".indexOf(argument);
        }
        if (i == -1) {
            throw new IllegalArgumentException("Bad priority: " + argument);
        }
        return i;
    }

    public static void main(String[] args) throws Exception {
        DetectorFactoryCollection.instance();
        FilterCommandLine commandLine = new FilterCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + Filter.class.getName() + " [options] [<orig results> [<new results]] ");
        Project project = new Project();
        SortedBugCollection origCollection = new SortedBugCollection();
        if (argCount == args.length) {
            origCollection.readXML(System.in, project);
        } else {
            origCollection.readXML(args[argCount++], project);
        }
        boolean verbose = argCount < args.length;
        SortedBugCollection resultCollection = origCollection.createEmptyCollectionWithMetadata();
        int passed = 0;
        int dropped = 0;
        resultCollection.setWithMessages(commandLine.withMessages);
        if (commandLine.hashChangedSpecified) {
            origCollection.computeBugHashes();
        }
        commandLine.adjustFilter(project, resultCollection);
        resultCollection.getProjectStats().clearBugCounts();
        if (commandLine.className != null) {
            resultCollection.getProjectStats().purgeClassesThatDontMatch(commandLine.className);
        }
        sourceSearcher = new SourceSearcher(project);
        for (BugInstance bug : origCollection.getCollection()) {
            if (commandLine.accept(bug)) {
                resultCollection.add(bug, false);
                if (!bug.isDead()) {
                    resultCollection.getProjectStats().addBug(bug);
                }
                ++passed;
                continue;
            }
            ++dropped;
        }
        if (verbose) {
            System.out.println(passed + " warnings passed through, " + dropped + " warnings dropped");
        }
        if (commandLine.withSourceSpecified && commandLine.withSource && !commandLine.dontUpdateStats) {
            for (PackageStats stats : resultCollection.getProjectStats().getPackageStats()) {
                Iterator<PackageStats.ClassStats> i = stats.getClassStats().iterator();
                while (i.hasNext()) {
                    String className = i.next().getName();
                    if (!Filter.sourceSearcher.sourceNotFound.contains(className) && (Filter.sourceSearcher.sourceFound.contains(className) || sourceSearcher.findSource(SourceLineAnnotation.createReallyUnknown(className)))) continue;
                    i.remove();
                }
            }
            resultCollection.getProjectStats().recomputeFromClassStats();
        }
        if (argCount == args.length) {
            assert (!verbose);
            resultCollection.writeXML(System.out, project);
        } else {
            resultCollection.writeXML(args[argCount++], project);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilterCommandLine
    extends CommandLine {
        public static final long MILLISECONDS_PER_DAY = 86400000L;
        Pattern className;
        Pattern bugPattern;
        public boolean notSpecified = false;
        public boolean not = false;
        long first;
        String firstAsString;
        long after;
        String afterAsString;
        long before;
        String beforeAsString;
        long last;
        String lastAsString;
        String fixedAsString;
        long present;
        String presentAsString;
        long absent;
        String absentAsString;
        String annotation;
        public boolean activeSpecified = false;
        public boolean active = false;
        public boolean hasField = false;
        public boolean hasFieldSpecified = false;
        public boolean hasLocal = false;
        public boolean hasLocalSpecified = false;
        public boolean applySuppression = false;
        public boolean applySuppressionSpecified = false;
        public boolean withSource = false;
        public boolean withSourceSpecified = false;
        public boolean introducedByChange = false;
        public boolean introducedByChangeSpecified = false;
        public boolean removedByChange = false;
        public boolean removedByChangeSpecified = false;
        public boolean newCode = false;
        public boolean newCodeSpecified = false;
        public boolean hashChanged = false;
        public boolean hashChangedSpecified = false;
        public boolean removedCode = false;
        public boolean removedCodeSpecified = false;
        public boolean dontUpdateStats = false;
        public boolean dontUpdateStatsSpecified = false;
        public boolean withMessagesSpecified = false;
        public boolean withMessages = false;
        private List<Matcher> includeFilter = new LinkedList<Matcher>();
        private List<Matcher> excludeFilter = new LinkedList<Matcher>();
        HashSet<String> excludedInstanceHashes = new HashSet();
        Set<String> designationKey = new HashSet<String>();
        Set<String> categoryKey = new HashSet<String>();
        int priority = 3;
        edu.umd.cs.findbugs.filter.Filter suppressionFilter;

        FilterCommandLine() {
            this.addSwitch("-not", "reverse (all) switches for the filter");
            this.addSwitchWithOptionalExtraPart("-withSource", "truth", "only warnings for which source is available");
            this.addSwitchWithOptionalExtraPart("-hashChanged", "truth", "only warnings for which the stored hash is not the same as the calculated hash");
            this.addOption("-excludeBugs", "baseline bug collection", "exclude bugs already contained in the baseline bug collection");
            this.addOption("-exclude", "filter file", "exclude bugs matching given filter");
            this.addOption("-include", "filter file", "include only bugs matching given filter");
            this.addOption("-annotation", "text", "allow only warnings containing this text in a user annotation");
            this.addSwitchWithOptionalExtraPart("-withMessages", "truth", "generated XML should contain textual messages");
            this.addOption("-after", "when", "allow only warnings that first occurred after this version");
            this.addOption("-before", "when", "allow only warnings that first occurred before this version");
            this.addOption("-first", "when", "allow only warnings that first occurred in this version");
            this.addOption("-last", "when", "allow only warnings that last occurred in this version");
            this.addOption("-fixed", "when", "allow only warnings that last occurred in the previous version (clobbers last)");
            this.addOption("-present", "when", "allow only warnings present in this version");
            this.addOption("-absent", "when", "allow only warnings absent in this version");
            this.addSwitchWithOptionalExtraPart("-hasField", "truth", "allow only warnings that are annotated with a field");
            this.addSwitchWithOptionalExtraPart("-hasLocal", "truth", "allow only warnings that are annotated with a local variable");
            this.addSwitchWithOptionalExtraPart("-active", "truth", "allow only warnings alive in the last sequence number");
            this.addSwitch("-applySuppression", "exclude warnings that match the suppression filter");
            this.addSwitchWithOptionalExtraPart("-introducedByChange", "truth", "allow only warnings introduced by a change of an existing class");
            this.addSwitchWithOptionalExtraPart("-removedByChange", "truth", "allow only warnings removed by a change of a persisting class");
            this.addSwitchWithOptionalExtraPart("-newCode", "truth", "allow only warnings introduced by the addition of a new class");
            this.addSwitchWithOptionalExtraPart("-removedCode", "truth", "allow only warnings removed by removal of a class");
            this.addOption("-priority", "level", "allow only warnings with this priority or higher");
            this.addOption("-class", "pattern", "allow only bugs whose primary class name matches this pattern");
            this.addOption("-bugPattern", "pattern", "allow only bugs whose type matches this pattern");
            this.addOption("-category", "category", "allow only warnings with a category that starts with this string");
            this.addOption("-designation", "designation", "allow only warnings with this designation (e.g., -designation SHOULD_FIX,MUST_FIX)");
            this.addSwitch("-hashChanged", "recomputed instance hash is different than stored instance hash");
            this.addSwitch("-dontUpdateStats", "used when withSource is specified to only update bugs, not the class and package stats");
        }

        static long getVersionNum(Map<String, AppVersion> versions, SortedMap<Long, AppVersion> timeStamps, String val, boolean roundToLaterVersion, long currentSeqNum) {
            long numVersions = currentSeqNum + 1L;
            if (val == null) {
                return -1L;
            }
            if (val.equals("last") || val.equals("lastVersion")) {
                return numVersions - 1L;
            }
            AppVersion v = versions.get(val);
            if (v != null) {
                return v.getSequenceNumber();
            }
            try {
                long time = 0L;
                time = val.endsWith("daysAgo") ? System.currentTimeMillis() - 86400000L * (long)Integer.parseInt(val.substring(0, val.length() - 7)) : Date.parse(val);
                return FilterCommandLine.getAppropriateSeq(timeStamps, time, roundToLaterVersion);
            }
            catch (Exception e) {
                try {
                    long version = Long.parseLong(val);
                    if (version < 0L) {
                        version = numVersions + version;
                    }
                    return version;
                }
                catch (NumberFormatException e1) {
                    throw new IllegalArgumentException("Could not interpret version specification of '" + val + "'");
                }
            }
        }

        private static long getAppropriateSeq(SortedMap<Long, AppVersion> timeStamps, long when, boolean roundToLaterVersion) {
            if (roundToLaterVersion) {
                SortedMap<Long, AppVersion> geq = timeStamps.tailMap(when);
                if (geq.isEmpty()) {
                    return Long.MAX_VALUE;
                }
                return ((AppVersion)geq.get(geq.firstKey())).getSequenceNumber();
            }
            SortedMap<Long, AppVersion> leq = timeStamps.headMap(when);
            if (leq.isEmpty()) {
                return Long.MIN_VALUE;
            }
            return ((AppVersion)leq.get(leq.lastKey())).getSequenceNumber();
        }

        void adjustFilter(Project project, BugCollection collection) {
            this.suppressionFilter = project.getSuppressionFilter();
            HashMap<String, AppVersion> versions = new HashMap<String, AppVersion>();
            TreeMap<Long, AppVersion> timeStamps = new TreeMap<Long, AppVersion>();
            Iterator<AppVersion> i = collection.appVersionIterator();
            while (i.hasNext()) {
                AppVersion v = i.next();
                versions.put(v.getReleaseName(), v);
                timeStamps.put(v.getTimestamp(), v);
            }
            AppVersion v = collection.getCurrentAppVersion();
            versions.put(v.getReleaseName(), v);
            timeStamps.put(v.getTimestamp(), v);
            this.first = FilterCommandLine.getVersionNum(versions, timeStamps, this.firstAsString, true, v.getSequenceNumber());
            this.last = FilterCommandLine.getVersionNum(versions, timeStamps, this.lastAsString, true, v.getSequenceNumber());
            this.before = FilterCommandLine.getVersionNum(versions, timeStamps, this.beforeAsString, true, v.getSequenceNumber());
            this.after = FilterCommandLine.getVersionNum(versions, timeStamps, this.afterAsString, false, v.getSequenceNumber());
            this.present = FilterCommandLine.getVersionNum(versions, timeStamps, this.presentAsString, true, v.getSequenceNumber());
            this.absent = FilterCommandLine.getVersionNum(versions, timeStamps, this.absentAsString, true, v.getSequenceNumber());
            long fixed = FilterCommandLine.getVersionNum(versions, timeStamps, this.fixedAsString, true, v.getSequenceNumber());
            if (fixed >= 0L) {
                this.last = fixed - 1L;
            }
        }

        boolean accept(BugInstance bug) {
            boolean result = this.evaluate(bug);
            if (this.not) {
                return !result;
            }
            return result;
        }

        boolean evaluate(BugInstance bug) {
            for (Matcher m : this.includeFilter) {
                if (m.match(bug)) continue;
                return false;
            }
            for (Matcher m : this.excludeFilter) {
                if (!m.match(bug)) continue;
                return false;
            }
            if (this.excludedInstanceHashes.contains(bug.getInstanceHash())) {
                return false;
            }
            if (this.annotation != null && bug.getAnnotationText().indexOf(this.annotation) == -1) {
                return false;
            }
            if (bug.getPriority() > this.priority) {
                return false;
            }
            if (this.firstAsString != null && bug.getFirstVersion() != this.first) {
                return false;
            }
            if (this.afterAsString != null && bug.getFirstVersion() <= this.after) {
                return false;
            }
            if (this.beforeAsString != null && bug.getFirstVersion() >= this.before) {
                return false;
            }
            if (!(this.lastAsString == null && this.fixedAsString == null || this.last >= 0L && bug.getLastVersion() == this.last)) {
                return false;
            }
            if (this.presentAsString != null && !this.bugLiveAt(bug, this.present)) {
                return false;
            }
            if (this.absentAsString != null && this.bugLiveAt(bug, this.absent)) {
                return false;
            }
            if (this.hasFieldSpecified && this.hasField != (bug.getPrimaryField() != null)) {
                return false;
            }
            if (this.hasLocalSpecified && this.hasLocal != (bug.getPrimaryLocalVariableAnnotation() != null)) {
                return false;
            }
            if (this.activeSpecified && this.active == bug.isDead()) {
                return false;
            }
            if (this.removedByChangeSpecified && bug.isRemovedByChangeOfPersistingClass() != this.removedByChange) {
                return false;
            }
            if (this.introducedByChangeSpecified && bug.isIntroducedByChangeOfExistingClass() != this.introducedByChange) {
                return false;
            }
            if (this.newCodeSpecified && this.newCode != (!bug.isIntroducedByChangeOfExistingClass() && bug.getFirstVersion() != 0L)) {
                return false;
            }
            if (this.removedCodeSpecified && this.removedCode != (!bug.isRemovedByChangeOfPersistingClass() && bug.isDead())) {
                return false;
            }
            if (this.bugPattern != null && !this.bugPattern.matcher(bug.getType()).find()) {
                return false;
            }
            if (this.className != null && !this.className.matcher(bug.getPrimaryClass().getClassName()).find()) {
                return false;
            }
            BugPattern thisBugPattern = bug.getBugPattern();
            if (!this.categoryKey.isEmpty() && thisBugPattern != null && !this.categoryKey.contains(thisBugPattern.getCategory())) {
                return false;
            }
            if (!this.designationKey.isEmpty() && !this.designationKey.contains(bug.getUserDesignationKey())) {
                return false;
            }
            if (this.withSourceSpecified && sourceSearcher.findSource(bug.getPrimarySourceLineAnnotation()) != this.withSource) {
                return false;
            }
            if (this.hashChangedSpecified && bug.isInstanceHashConsistent() == this.hashChanged) {
                return false;
            }
            return !this.applySuppressionSpecified || !this.applySuppression || !this.suppressionFilter.match(bug);
        }

        private void addDesignationKey(String argument) {
            I18N i18n = I18N.instance();
            block0: for (String x : argument.split("[,|]")) {
                for (String designationKey : i18n.getUserDesignationKeys()) {
                    if (!designationKey.equals(x) && !i18n.getUserDesignation(designationKey).equals(x)) continue;
                    this.designationKey.add(designationKey);
                    continue block0;
                }
            }
        }

        private void addCategoryKey(String argument) {
            I18N i18n = I18N.instance();
            block0: for (String x : argument.split("[,|]")) {
                for (BugCategory category : i18n.getBugCategoryObjects()) {
                    if (!category.getAbbrev().equals(x) && !category.getCategory().equals(x)) continue;
                    this.categoryKey.add(category.getCategory());
                    continue block0;
                }
            }
        }

        private boolean bugLiveAt(BugInstance bug, long now) {
            if (now < bug.getFirstVersion()) {
                return false;
            }
            return !bug.isDead() || bug.getLastVersion() >= now;
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            option = option.substring(1);
            if (optionExtraPart.length() == 0) {
                this.setField(option, true);
            } else {
                this.setField(option, Boolean.parseBoolean(optionExtraPart));
            }
            this.setField(option + "Specified", true);
        }

        private void setField(String fieldName, boolean value) {
            try {
                Field f = FilterCommandLine.class.getField(fieldName);
                f.setBoolean(this, value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-priority")) {
                this.priority = Filter.parsePriority(argument);
            } else if (option.equals("-first")) {
                this.firstAsString = argument;
            } else if (option.equals("-last")) {
                this.lastAsString = argument;
            } else if (option.equals("-fixed")) {
                this.fixedAsString = argument;
            } else if (option.equals("-after")) {
                this.afterAsString = argument;
            } else if (option.equals("-before")) {
                this.beforeAsString = argument;
            } else if (option.equals("-present")) {
                this.presentAsString = argument;
            } else if (option.equals("-absent")) {
                this.absentAsString = argument;
            } else if (option.equals("-category")) {
                this.addCategoryKey(argument);
            } else if (option.equals("-designation")) {
                this.addDesignationKey(argument);
            } else if (option.equals("-class")) {
                this.className = Pattern.compile(argument);
            } else if (option.equals("-bugPattern")) {
                this.bugPattern = Pattern.compile(argument);
            } else if (option.equals("-annotation")) {
                this.annotation = argument;
            } else if (option.equals("-excludeBugs")) {
                try {
                    ExcludingHashesBugReporter.addToExcludedInstanceHashes(this.excludedInstanceHashes, argument);
                }
                catch (DocumentException e) {
                    throw new IllegalArgumentException("Error processing include file: " + argument, e);
                }
            } else if (option.equals("-include")) {
                try {
                    this.includeFilter.add(new edu.umd.cs.findbugs.filter.Filter(argument));
                }
                catch (FilterException e) {
                    throw new IllegalArgumentException("Error processing include file: " + argument, e);
                }
            } else if (option.equals("-exclude")) {
                try {
                    this.excludeFilter.add(new edu.umd.cs.findbugs.filter.Filter(argument));
                }
                catch (FilterException e) {
                    throw new IllegalArgumentException("Error processing include file: " + argument, e);
                }
            } else {
                throw new IllegalArgumentException("can't handle command line argument of " + option);
            }
        }
    }
}

