/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.constant;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import edu.umd.cs.findbugs.ba.constant.ConstantFrameModelingVisitor;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantAnalysis
extends FrameDataflowAnalysis<Constant, ConstantFrame> {
    private MethodGen methodGen;
    private ConstantFrameModelingVisitor visitor;

    public ConstantAnalysis(MethodGen methodGen, DepthFirstSearch dfs) {
        super(dfs);
        this.methodGen = methodGen;
        this.visitor = new ConstantFrameModelingVisitor(methodGen.getConstantPool());
    }

    @Override
    public ConstantFrame createFact() {
        return new ConstantFrame(this.methodGen.getMaxLocals());
    }

    @Override
    public void initEntryFact(ConstantFrame frame) {
        frame.setValid();
        frame.clearStack();
        int numSlots = frame.getNumSlots();
        for (int i = 0; i < numSlots; ++i) {
            frame.setValue(i, Constant.NOT_CONSTANT);
        }
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, ConstantFrame frame) throws DataflowAnalysisException {
        this.visitor.setFrameAndLocation(frame, new Location(handle, basicBlock));
        this.visitor.analyzeInstruction(handle.getInstruction());
    }

    @Override
    public void meetInto(ConstantFrame fact, Edge edge, ConstantFrame result) throws DataflowAnalysisException {
        if (fact.isValid()) {
            ConstantFrame tmpFact = null;
            if (edge.isExceptionEdge()) {
                tmpFact = this.modifyFrame(fact, tmpFact);
                tmpFact.clearStack();
                tmpFact.pushValue(Constant.NOT_CONSTANT);
            }
            if (tmpFact != null) {
                fact = tmpFact;
            }
        }
        this.mergeInto(fact, result);
    }

    @Override
    protected void mergeValues(ConstantFrame otherFrame, ConstantFrame resultFrame, int slot) throws DataflowAnalysisException {
        Constant value = Constant.merge((Constant)resultFrame.getValue(slot), (Constant)otherFrame.getValue(slot));
        resultFrame.setValue(slot, value);
    }
}

