/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.SaveType;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JMenu;

public class RecentMenu {
    LimitedArrayList<File> recentFiles = new LimitedArrayList();
    JMenu recentMenu;

    public RecentMenu(JMenu menu) {
        this.recentMenu = menu;
        for (File f : GUISaveState.getInstance().getRecentFiles()) {
            this.recentFiles.add(f);
        }
        this.makeRecentMenu();
    }

    public void makeRecentMenu() {
        this.recentMenu.removeAll();
        for (File f : this.recentFiles) {
            Debug.println(f);
            if (!f.exists()) {
                if (!MainFrame.DEBUG) continue;
                System.err.println("a recent project was not found, removing it from menu");
                continue;
            }
            this.recentMenu.add(MainFrame.getInstance().createRecentItem(f, SaveType.forFile(f)));
        }
    }

    public void addRecentFile(File f) {
        if (f != null) {
            this.recentFiles.add(f);
        }
        this.makeRecentMenu();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LimitedArrayList<T>
    extends ArrayList<T> {
        public static final int MAX_ENTRIES = 5;

        public LimitedArrayList() {
            super(5);
        }

        @Override
        public boolean add(T element) {
            if (!this.contains(element)) {
                super.add(0, element);
                if (this.size() > 5) {
                    this.remove(5);
                }
            } else {
                this.remove(element);
                super.add(0, element);
            }
            return true;
        }
    }
}

