/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.CheckBoxList;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class SorterDialog
extends FBDialog {
    private JTableHeader preview;
    private ArrayList<JCheckBox> checkBoxSortList = new ArrayList();
    private CheckBoxList chBList;
    JButton sortApply;
    private static SorterDialog instance = new SorterDialog();

    public static SorterDialog getInstance() {
        return instance;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ((SorterTableColumnModel)this.preview.getColumnModel()).createFrom(MainFrame.getInstance().getSorter());
            this.setSorterCheckBoxes();
        }
    }

    private SorterDialog() {
        this.setTitle("Sort By...");
        this.add(this.createSorterPane());
        this.pack();
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.preview.setColumnModel(new SorterTableColumnModel(MainFrame.getInstance().getSorter().getOrder()));
    }

    private JPanel createSorterPane() {
        JPanel sorter = new JPanel();
        JPanel insidePanel = new JPanel();
        insidePanel.setLayout(new BorderLayout());
        sorter.setLayout(new BorderLayout());
        this.preview = new JTableHeader();
        Sortables[] sortables = MainFrame.getInstance().sortables();
        this.preview.setColumnModel(new SorterTableColumnModel(sortables));
        for (Sortables s : sortables) {
            if (s == Sortables.DIVIDER) {
                this.checkBoxSortList.add(new JCheckBox(L10N.getLocalString("sort.divider", "[divider]")));
                continue;
            }
            this.checkBoxSortList.add(new JCheckBox(s.toString()));
        }
        this.setSorterCheckBoxes();
        for (int i = 0; i < sortables.length; ++i) {
            this.checkBoxSortList.get(i).addChangeListener(new CheckBoxChangedListener(i));
        }
        this.chBList = new CheckBoxList(this.checkBoxSortList.toArray(new JCheckBox[this.checkBoxSortList.size()]));
        insidePanel.add((Component)this.chBList, "North");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JTable t = new JTable(new DefaultTableModel(0, sortables.length));
        t.setTableHeader(this.preview);
        JScrollPane sp = new JScrollPane(t);
        int num = (int)((double)Driver.getFontSize() * 1.2);
        sp.setPreferredSize(new Dimension(670, 10 + num));
        bottomPanel.add((Component)sp, "Center");
        insidePanel.add((Component)bottomPanel, "South");
        this.sortApply = new JButton(L10N.getLocalString("dlg.apply_btn", "Apply"));
        this.sortApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().getSorter().createFrom((SorterTableColumnModel)SorterDialog.this.preview.getColumnModel());
                ((BugTreeModel)MainFrame.getInstance().getTree().getModel()).checkSorter();
                instance.setVisible(false);
            }
        });
        bottomPanel.add((Component)this.sortApply, "South");
        sorter.add((Component)new JScrollPane(insidePanel), "Center");
        return sorter;
    }

    private void setSorterCheckBoxes() {
        boolean[] chBoxSorterBooleans = MainFrame.getInstance().getSorter().getVisibleColumns();
        if (chBoxSorterBooleans.length != this.checkBoxSortList.size()) {
            return;
        }
        for (int i = 0; i < this.checkBoxSortList.size(); ++i) {
            this.checkBoxSortList.get(i).setSelected(chBoxSorterBooleans[i]);
        }
    }

    void freeze() {
        this.sortApply.setEnabled(false);
    }

    void thaw() {
        this.sortApply.setEnabled(true);
    }

    private class CheckBoxChangedListener
    implements ChangeListener {
        int indexOfCheckBox;

        public CheckBoxChangedListener(int index) {
            this.indexOfCheckBox = index;
        }

        public void stateChanged(ChangeEvent e) {
            ((SorterTableColumnModel)SorterDialog.this.preview.getColumnModel()).setIndexChanged(this.indexOfCheckBox);
        }
    }
}

