/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class LaunchBrowser {
    @CheckForNull
    private static final Method jnlpShowMethod;
    private static final Object jnlpShowObject;
    public static final boolean launchFirefox;
    private static Object desktopObject;
    private static Method desktopBrowseMethod;
    private static boolean launchViaExecFailed;

    public static boolean desktopFeasible() {
        return desktopObject != null && desktopBrowseMethod != null;
    }

    public static boolean webstartFeasible() {
        return jnlpShowMethod != null && jnlpShowObject != null;
    }

    public static boolean showDocumentViaDesktop(URL u) {
        if (desktopObject != null && desktopBrowseMethod != null) {
            try {
                LaunchBrowser.viaDesktop(u.toURI());
                return true;
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void viaDesktop(URI u) throws IllegalAccessException, InvocationTargetException, URISyntaxException {
        if (desktopBrowseMethod == null) {
            throw new UnsupportedOperationException("Launch via desktop not available");
        }
        desktopBrowseMethod.invoke(desktopObject, u);
    }

    public static Boolean viaWebStart(URL url) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (jnlpShowMethod == null) {
            throw new UnsupportedOperationException("Launch via web start not available");
        }
        return (Boolean)jnlpShowMethod.invoke(jnlpShowObject, url);
    }

    public static boolean showViaWebStart(URL url) {
        if (jnlpShowMethod != null) {
            try {
                Boolean b = LaunchBrowser.viaWebStart(url);
                return b != null && b != false;
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean showDocumentViaExec(URL url) {
        if (launchFirefox && !launchViaExecFailed) {
            try {
                Process p = LaunchBrowser.launchFirefox(url);
                Thread.sleep(20L);
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    launchViaExecFailed = true;
                    return false;
                }
                return true;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
            catch (Exception e) {
                launchViaExecFailed = true;
            }
        }
        return false;
    }

    public static Process launchFirefox(URL url) throws IOException {
        ProcessBuilder builder = new ProcessBuilder("firefox", url.toString());
        Process p = builder.start();
        return p;
    }

    public static boolean showDocument(URL url) {
        if (LaunchBrowser.showDocumentViaExec(url)) {
            return true;
        }
        if (LaunchBrowser.showDocumentViaDesktop(url)) {
            return true;
        }
        return LaunchBrowser.showViaWebStart(url);
    }

    static {
        launchFirefox = SystemProperties.getBoolean("findbugs.launchFirefox") && "Linux".equals(SystemProperties.getProperty("os.name"));
        launchViaExecFailed = false;
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            desktopObject = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopBrowseMethod = desktopClass.getMethod("browse", URI.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        Method showMethod = null;
        Object showObject = null;
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            showObject = lookupMethod.invoke(null, "javax.jnlp.BasicService");
            showMethod = showObject.getClass().getMethod("showDocument", URL.class);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        jnlpShowMethod = showMethod;
        jnlpShowObject = showObject;
    }
}

