/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.IOException;
import org.dom4j.DocumentException;

public class UnionResults {
    public static SortedBugCollection union(SortedBugCollection origCollection, SortedBugCollection newCollection) {
        SortedBugCollection result = origCollection.duplicate();
        for (BugInstance bugInstance : newCollection) {
            result.add(bugInstance);
        }
        ProjectStats stats = result.getProjectStats();
        ProjectStats stats2 = newCollection.getProjectStats();
        stats.addStats(stats2);
        return result;
    }

    public static void main(String[] argv) throws IOException, DocumentException {
        UnionResultsCommandLine commandLine = new UnionResultsCommandLine();
        int argCount = commandLine.parse(argv, 2, Integer.MAX_VALUE, "Usage: " + UnionResults.class.getName() + " [options] [<results1> <results2> ... <resultsn>] ");
        SortedBugCollection results = null;
        Project project = null;
        for (int i = argCount; i < argv.length; ++i) {
            try {
                SortedBugCollection more = new SortedBugCollection();
                more.readXML(argv[i]);
                if (project != null) {
                    project.add(more.getProject());
                    results = UnionResults.union(results, more);
                    continue;
                }
                project = more.getProject();
                results = more;
                continue;
            }
            catch (IOException e) {
                System.err.println("Trouble reading/parsing " + argv[i]);
                continue;
            }
            catch (DocumentException e) {
                System.err.println("Trouble reading/parsing " + argv[i]);
            }
        }
        if (results == null) {
            System.err.println("No files successfully read");
            System.exit(1);
        }
        results.setWithMessages(commandLine.withMessages);
        if (commandLine.outputFile == null) {
            results.writeXML(System.out);
        } else {
            results.writeXML(commandLine.outputFile);
        }
    }

    static {
        DetectorFactoryCollection.instance();
    }

    static class UnionResultsCommandLine
    extends CommandLine {
        public String outputFile;
        boolean withMessages;

        UnionResultsCommandLine() {
            this.addSwitch("-withMessages", "Generated XML should contain msgs for external processing");
            this.addOption("-output", "outputFile", "File in which to store combined results");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (!option.equals("-withMessages")) {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
            this.withMessages = true;
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (!option.equals("-output")) {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
            this.outputFile = argument;
        }
    }
}

