/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.RecomputableClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.classfile.impl.ZipInputStreamCodeBaseEntry;
import edu.umd.cs.findbugs.io.IO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDataAnalysisEngine
extends RecomputableClassAnalysisEngine<ClassData> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassData analyze(IAnalysisCache analysisCache, ClassDescriptor descriptor) throws CheckedAnalysisException {
        ByteArrayOutputStream byteSink;
        byte[] data;
        ICodeBaseEntry codeBaseEntry;
        block7: {
            String resourceName = descriptor.toResourceName();
            try {
                codeBaseEntry = analysisCache.getClassPath().lookupResource(resourceName);
            }
            catch (ResourceNotFoundException e) {
                throw new MissingClassException(descriptor, (Throwable)e);
            }
            if (codeBaseEntry instanceof ZipInputStreamCodeBaseEntry) {
                data = ((ZipInputStreamCodeBaseEntry)codeBaseEntry).getBytes();
                return new ClassData(descriptor, codeBaseEntry, data);
            }
            int length = codeBaseEntry.getNumBytes();
            byteSink = length >= 0 ? new ByteArrayOutputStream(length) : new ByteArrayOutputStream();
            InputStream in = null;
            try {
                try {
                    in = codeBaseEntry.openResource();
                    IO.copy(in, byteSink);
                }
                catch (IOException e) {
                    throw new MissingClassException(descriptor, (Throwable)e);
                }
                Object var11_10 = null;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (in == null) throw throwable;
                IO.close(in);
                throw throwable;
            }
            IO.close(in);
        }
        data = byteSink.toByteArray();
        return new ClassData(descriptor, codeBaseEntry, data);
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerClassAnalysisEngine(ClassData.class, this);
    }
}

