/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.FindBugs;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParametersAreNonnullByDefault
public class FindBugsMain
implements Comparable<FindBugsMain> {
    @Nonnull
    final Class<?> mainClass;
    final Method mainMethod;
    @Nonnull
    public final String cmd;
    public final String description;
    @Nonnull
    public final String kind;
    final boolean analysis;

    public FindBugsMain(Class<?> mainClass, String cmd, String description, String kind, boolean analysis) throws SecurityException, NoSuchMethodException {
        this.mainClass = mainClass;
        this.mainMethod = mainClass.getMethod("main", String[].class);
        this.cmd = cmd;
        this.description = description;
        this.kind = kind;
        this.analysis = analysis;
    }

    public void invoke(String[] args) throws Exception {
        if (!this.analysis) {
            FindBugs.setNoAnalysis();
        }
        this.mainMethod.invoke(null, new Object[]{args});
    }

    @Override
    public int compareTo(FindBugsMain that) {
        int result = this.kind.compareTo(that.kind);
        if (result != 0) {
            return result;
        }
        return this.cmd.compareTo(that.cmd);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FindBugsMain)) {
            return false;
        }
        FindBugsMain that = (FindBugsMain)o;
        return this.kind.equals(that.kind) && this.cmd.equals(that.cmd);
    }

    public int hashCode() {
        return this.kind.hashCode() + this.cmd.hashCode();
    }
}

