/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DFSEdgeTypes;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.DominatorsAnalysis;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePattern;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePatternMatch;
import edu.umd.cs.findbugs.ba.bcp.MatchResult;
import edu.umd.cs.findbugs.ba.bcp.PatternElement;
import edu.umd.cs.findbugs.ba.bcp.PatternElementMatch;
import edu.umd.cs.findbugs.ba.bcp.Wild;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternMatcher
implements DFSEdgeTypes {
    private static final boolean DEBUG = SystemProperties.getBoolean("bcp.debug");
    private static final boolean SHOW_WILD = SystemProperties.getBoolean("bcp.showWild");
    private ByteCodePattern pattern;
    private CFG cfg;
    private ConstantPoolGen cpg;
    private DepthFirstSearch dfs;
    private ValueNumberDataflow vnaDataflow;
    private DominatorsAnalysis domAnalysis;
    private LinkedList<BasicBlock> workList;
    private IdentityHashMap<BasicBlock, BasicBlock> visitedBlockMap;
    private LinkedList<ByteCodePatternMatch> resultList;
    private int nextPath = 0;
    int depth = 0;

    public PatternMatcher(ByteCodePattern pattern, ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        this.pattern = pattern;
        this.cfg = classContext.getCFG(method);
        this.cpg = classContext.getConstantPoolGen();
        this.dfs = classContext.getDepthFirstSearch(method);
        this.vnaDataflow = classContext.getValueNumberDataflow(method);
        this.domAnalysis = classContext.getNonExceptionDominatorsAnalysis(method);
        this.workList = new LinkedList();
        this.visitedBlockMap = new IdentityHashMap();
        this.resultList = new LinkedList();
    }

    public PatternMatcher execute() throws DataflowAnalysisException {
        this.workList.addLast(this.cfg.getEntry());
        while (!this.workList.isEmpty()) {
            BasicBlock basicBlock = this.workList.removeLast();
            this.visitedBlockMap.put(basicBlock, basicBlock);
            BasicBlock.InstructionIterator i = basicBlock.instructionIterator();
            while (i.hasNext()) {
                this.attemptMatch(basicBlock, i.duplicate());
                i.next();
            }
            Iterator<BasicBlock> succIterator = this.cfg.successorIterator(basicBlock);
            while (succIterator.hasNext()) {
                BasicBlock succ = succIterator.next();
                if (this.visitedBlockMap.get(succ) != null) continue;
                this.workList.addLast(succ);
            }
        }
        return this;
    }

    public Iterator<ByteCodePatternMatch> byteCodePatternMatchIterator() {
        return this.resultList.iterator();
    }

    private void attemptMatch(BasicBlock basicBlock, BasicBlock.InstructionIterator instructionIterator) throws DataflowAnalysisException {
        this.work(new State(basicBlock, instructionIterator, this.pattern.getFirst()));
    }

    private void debug(String s) {
        if (!DEBUG) {
            throw new IllegalStateException("Only call if DEBUG is true");
        }
        System.out.print("                                            ".substring(0, this.depth));
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void work(State state) throws DataflowAnalysisException {
        block17: {
            block16: {
                block15: {
                    block14: {
                        ++this.depth;
                        try {
                            State advance;
                            if (state.isComplete()) {
                                if (DEBUG) {
                                    this.debug("FINISHED A MATCH!");
                                }
                                this.resultList.add(state.getResult());
                                Object var11_2 = null;
                                --this.depth;
                                return;
                            }
                            if (DEBUG) {
                                this.debug("Matching " + state.getPatternElement() + " against " + state.currentMatch);
                            }
                            if ((advance = state.advanceToNextElement()) != null) {
                                this.work(advance);
                            }
                            if (!state.currentElementCanContinue()) {
                                break block14;
                            }
                            MatchResult matchResult = null;
                            if (state.lookForDominatedInstruction()) {
                                Iterable<State> dominatedInstructions = state.dominatedInstructionStateIterable();
                                for (State s : dominatedInstructions) {
                                    if (DEBUG) {
                                        this.debug("trying " + s);
                                    }
                                    this.work(s);
                                }
                                break block15;
                            }
                            if (state.moreInstructionsInBasicBlock() && (matchResult = state.matchNextInBasicBlock()) == null) {
                                break block16;
                            }
                            if (state.moreInstructionsInBasicBlock()) {
                                this.work(state);
                                break block17;
                            }
                            if (state.canAdvanceToNextBasicBlock()) {
                                Iterator i = this.cfg.outgoingEdgeIterator(state.getBasicBlock());
                                BitSet visitedSuccessorSet = new BitSet();
                                while (i.hasNext()) {
                                    BasicBlock destBlock;
                                    int destId;
                                    Edge edge = (Edge)i.next();
                                    if (this.dfs.getDFSEdgeType(edge) == 1 || visitedSuccessorSet.get(destId = (destBlock = (BasicBlock)edge.getTarget()).getLabel())) continue;
                                    visitedSuccessorSet.set(destId, true);
                                    State succState = state.advanceToSuccessor(edge, matchResult);
                                    if (succState == null) continue;
                                    this.work(succState);
                                }
                            }
                            break block17;
                        }
                        catch (Throwable throwable) {
                            Object var11_7 = null;
                            --this.depth;
                            throw throwable;
                        }
                    }
                    Object var11_3 = null;
                    --this.depth;
                    return;
                }
                Object var11_4 = null;
                --this.depth;
                return;
            }
            Object var11_5 = null;
            --this.depth;
            return;
        }
        Object var11_6 = null;
        --this.depth;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class State {
        private BasicBlock basicBlock;
        private BasicBlock.InstructionIterator instructionIterator;
        private PatternElement patternElement;
        private int matchCount;
        private PatternElementMatch currentMatch;
        private BindingSet bindingSet;
        private boolean canFork;
        private final int parentPath;
        private final int path;

        public String toString() {
            return this.patternElement + " : " + this.instructionIterator + " :: " + this.currentMatch;
        }

        public State(BasicBlock basicBlock, BasicBlock.InstructionIterator instructionIterator, PatternElement patternElement) {
            this(null, basicBlock, instructionIterator, patternElement, 0, null, null, true);
        }

        public State(State parent, BasicBlock basicBlock, BasicBlock.InstructionIterator instructionIterator, PatternElement patternElement, @Nullable int matchCount, @Nullable PatternElementMatch currentMatch, BindingSet bindingSet, boolean canFork) {
            this.basicBlock = basicBlock;
            this.instructionIterator = instructionIterator;
            this.patternElement = patternElement;
            this.matchCount = matchCount;
            this.currentMatch = currentMatch;
            this.bindingSet = bindingSet;
            this.canFork = canFork;
            this.parentPath = parent != null ? parent.path : -1;
            this.path = PatternMatcher.this.nextPath++;
        }

        public State duplicate() {
            return new State(this, this.basicBlock, this.instructionIterator, this.patternElement, this.matchCount, this.currentMatch, this.bindingSet, this.canFork);
        }

        public BasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public PatternElement getPatternElement() {
            return this.patternElement;
        }

        public PatternElementMatch getCurrentMatch() {
            return this.currentMatch;
        }

        public boolean isComplete() {
            return this.patternElement == null;
        }

        public ByteCodePatternMatch getResult() {
            if (!this.isComplete()) {
                throw new IllegalStateException("match not complete!");
            }
            return new ByteCodePatternMatch(this.bindingSet, this.currentMatch);
        }

        public State advanceToNextElement() {
            if (!this.canFork || this.matchCount < this.patternElement.minOccur()) {
                return null;
            }
            State advance = new State(this, this.basicBlock, this.instructionIterator.duplicate(), this.patternElement.getNext(), 0, this.currentMatch, this.bindingSet, true);
            this.canFork = false;
            return advance;
        }

        public boolean currentElementCanContinue() {
            return this.matchCount < this.patternElement.maxOccur();
        }

        public boolean moreInstructionsInBasicBlock() {
            return this.instructionIterator.hasNext();
        }

        public MatchResult matchNextInBasicBlock() throws DataflowAnalysisException {
            if (!this.moreInstructionsInBasicBlock()) {
                throw new IllegalStateException("At end of BB!");
            }
            Location location = new Location(this.instructionIterator.next(), this.basicBlock);
            return this.matchLocation(location);
        }

        public boolean canAdvanceToNextBasicBlock() {
            return this.currentMatch == null || this.currentMatch.allowTrailingEdges();
        }

        public InstructionHandle getLastMatchedInstruction() {
            if (this.currentMatch == null) {
                throw new IllegalStateException("no current match!");
            }
            return this.currentMatch.getMatchedInstructionInstructionHandle();
        }

        public State advanceToSuccessor(Edge edge, MatchResult matchResult) {
            if (matchResult != null && !matchResult.getPatternElement().acceptBranch(edge, this.getLastMatchedInstruction())) {
                return null;
            }
            return new State(this, (BasicBlock)edge.getTarget(), ((BasicBlock)edge.getTarget()).instructionIterator(), this.patternElement, this.matchCount, this.currentMatch, this.bindingSet, this.canFork);
        }

        public boolean lookForDominatedInstruction() {
            return this.patternElement.getDominatedBy() != null && this.matchCount == 0;
        }

        public Iterable<State> dominatedInstructionStateIterable() throws DataflowAnalysisException {
            if (!this.lookForDominatedInstruction()) {
                throw new IllegalStateException();
            }
            LinkedList<State> stateList = new LinkedList<State>();
            State dup = this.duplicate();
            if (this.currentMatch != null) {
                PatternElementMatch dominator = this.currentMatch.getFirstLabeledMatch(this.patternElement.getDominatedBy());
                BasicBlock domBlock = dominator.getBasicBlock();
                InstructionHandle domInstruction = dominator.getMatchedInstructionInstructionHandle();
                Iterator<BasicBlock> i = PatternMatcher.this.cfg.blockIterator();
                while (i.hasNext()) {
                    BasicBlock block = i.next();
                    boolean includeInstructions = block != domBlock;
                    BitSet dominators = (BitSet)PatternMatcher.this.domAnalysis.getResultFact(block);
                    if (block != domBlock && !dominators.get(domBlock.getLabel())) continue;
                    BasicBlock.InstructionIterator j = block.instructionIterator();
                    while (j.hasNext()) {
                        InstructionHandle next = (InstructionHandle)j.next();
                        if (includeInstructions) {
                            MatchResult matchResult = dup.matchLocation(new Location(next, block));
                            if (matchResult == null) continue;
                            stateList.add(dup);
                            dup = this.duplicate();
                            continue;
                        }
                        if (!next.equals(domInstruction)) continue;
                        includeInstructions = true;
                    }
                }
            }
            return stateList;
        }

        private MatchResult matchLocation(Location location) throws DataflowAnalysisException {
            boolean debug;
            ValueNumberFrame before = (ValueNumberFrame)PatternMatcher.this.vnaDataflow.getFactAtLocation(location);
            ValueNumberFrame after = (ValueNumberFrame)PatternMatcher.this.vnaDataflow.getFactAfterLocation(location);
            boolean bl = debug = DEBUG && (!(this.patternElement instanceof Wild) || SHOW_WILD);
            if (debug) {
                PatternMatcher.this.debug((this.parentPath >= 0 ? this.parentPath + "->" : "") + this.path + ": Match " + this.patternElement + " against " + location.getHandle() + " " + (this.bindingSet != null ? this.bindingSet.toString() : "[]") + "...");
            }
            MatchResult matchResult = this.patternElement.match(location.getHandle(), PatternMatcher.this.cpg, before, after, this.bindingSet);
            if (debug) {
                PatternMatcher.this.debug("\t" + (matchResult != null ? " ==> MATCH" : " ==> NOT A MATCH"));
            }
            if (matchResult != null) {
                ++this.matchCount;
                this.canFork = true;
                this.currentMatch = new PatternElementMatch(matchResult.getPatternElement(), location.getHandle(), location.getBasicBlock(), this.matchCount, this.currentMatch);
                this.bindingSet = matchResult.getBindingSet();
            }
            return matchResult;
        }
    }
}

