/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.jsr305.FlowValue;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkInfo;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeQualifierValueSet {
    private Map<ValueNumber, FlowValue> valueMap;
    private Map<ValueNumber, Set<SourceSinkInfo>> whereAlways;
    private Map<ValueNumber, Set<SourceSinkInfo>> whereNever;
    private State state = State.VALID;

    public TypeQualifierValueSet() {
        this.valueMap = new HashMap<ValueNumber, FlowValue>(3);
        this.whereAlways = new HashMap<ValueNumber, Set<SourceSinkInfo>>(3);
        this.whereNever = new HashMap<ValueNumber, Set<SourceSinkInfo>>(3);
        this.state = State.TOP;
    }

    public void modelSourceSink(SourceSinkInfo sourceSinkInfo) {
        assert (sourceSinkInfo != null);
        ValueNumber vn = sourceSinkInfo.getValueNumber();
        FlowValue flowValue = FlowValue.flowValueFromWhen(sourceSinkInfo.getWhen());
        this.setValue(vn, flowValue);
        switch (flowValue) {
            case ALWAYS: {
                TypeQualifierValueSet.addSourceSinkInfo(this.whereAlways, vn, sourceSinkInfo);
                break;
            }
            case NEVER: {
                TypeQualifierValueSet.addSourceSinkInfo(this.whereNever, vn, sourceSinkInfo);
            }
        }
    }

    private void setValue(ValueNumber vn, FlowValue flowValue) {
        if (flowValue == FlowValue.TOP) {
            this.pruneValue(vn);
        } else {
            this.valueMap.put(vn, flowValue);
        }
    }

    static <K, V> void copyMapValue(Map<K, V> map, K from, K to) {
        if (!map.containsKey(from)) {
            return;
        }
        map.put(to, map.get(from));
    }

    void copyInfo(ValueNumber from, ValueNumber to) {
        if (this.state == State.TOP) {
            return;
        }
        TypeQualifierValueSet.copyMapValue(this.valueMap, from, to);
        TypeQualifierValueSet.copyMapValue(this.whereAlways, from, to);
        TypeQualifierValueSet.copyMapValue(this.whereNever, from, to);
    }

    private static void addSourceSinkInfo(Map<ValueNumber, Set<SourceSinkInfo>> sourceSinkInfoSetMap, ValueNumber vn, SourceSinkInfo sourceSinkInfo) {
        Set<SourceSinkInfo> sourceSinkInfoSet = sourceSinkInfoSetMap.get(vn);
        if (sourceSinkInfoSet == null) {
            sourceSinkInfoSet = new HashSet<SourceSinkInfo>(3);
            sourceSinkInfoSetMap.put(vn, sourceSinkInfoSet);
        }
        sourceSinkInfoSet.add(sourceSinkInfo);
    }

    public void pruneValue(ValueNumber vn) {
        assert (this.isValid());
        this.valueMap.remove(vn);
        this.whereAlways.remove(vn);
        this.whereNever.remove(vn);
    }

    public Set<? extends SourceSinkInfo> getWhere(ValueNumber vn) {
        FlowValue f = this.getValue(vn);
        switch (f) {
            case ALWAYS: {
                return TypeQualifierValueSet.getSourceSinkInfoSet(this.whereAlways, vn);
            }
            case NEVER: {
                return TypeQualifierValueSet.getSourceSinkInfoSet(this.whereNever, vn);
            }
        }
        return Collections.emptySet();
    }

    public Set<? extends SourceSinkInfo> getWhereAlways(ValueNumber vn) {
        return TypeQualifierValueSet.getSourceSinkInfoSet(this.whereAlways, vn);
    }

    public Set<? extends SourceSinkInfo> getWhereNever(ValueNumber vn) {
        return TypeQualifierValueSet.getSourceSinkInfoSet(this.whereNever, vn);
    }

    private static Set<? extends SourceSinkInfo> getSourceSinkInfoSet(Map<ValueNumber, Set<SourceSinkInfo>> sourceSinkInfoSetMap, ValueNumber vn) {
        Set<SourceSinkInfo> sourceSinkInfoSet = sourceSinkInfoSetMap.get(vn);
        if (sourceSinkInfoSet == null || sourceSinkInfoSet.isEmpty()) {
            return Collections.emptySet();
        }
        return sourceSinkInfoSet;
    }

    private static Set<SourceSinkInfo> getOrCreateSourceSinkInfoSet(Map<ValueNumber, Set<SourceSinkInfo>> sourceSinkInfoSetMap, ValueNumber vn) {
        Set<SourceSinkInfo> sourceSinkInfoSet = sourceSinkInfoSetMap.get(vn);
        if (sourceSinkInfoSet == null) {
            sourceSinkInfoSet = new HashSet<SourceSinkInfo>(3);
            sourceSinkInfoSetMap.put(vn, sourceSinkInfoSet);
        }
        return sourceSinkInfoSet;
    }

    public FlowValue getValue(ValueNumber vn) {
        FlowValue result = this.valueMap.get(vn);
        return result != null ? result : FlowValue.TOP;
    }

    public Collection<? extends ValueNumber> getValueNumbers() {
        return this.valueMap.keySet();
    }

    public boolean isValid() {
        return this.state == State.VALID;
    }

    public void makeValid() {
        this.reset(State.VALID);
    }

    public void makeSameAs(TypeQualifierValueSet source) {
        this.reset(source.state);
        this.valueMap.putAll(source.valueMap);
        this.copySourceSinkInfoSetMap(this.whereAlways, source.whereAlways);
        this.copySourceSinkInfoSetMap(this.whereNever, source.whereNever);
    }

    private void copySourceSinkInfoSetMap(Map<ValueNumber, Set<SourceSinkInfo>> dest, Map<ValueNumber, Set<SourceSinkInfo>> source) {
        dest.clear();
        for (Map.Entry<ValueNumber, Set<SourceSinkInfo>> entry : source.entrySet()) {
            HashSet copy = new HashSet(entry.getValue());
            dest.put(entry.getKey(), copy);
        }
    }

    public boolean isTop() {
        return this.state == State.TOP;
    }

    public void setTop() {
        this.reset(State.TOP);
    }

    public boolean isBottom() {
        return this.state == State.BOTTOM;
    }

    public void setBottom() {
        this.reset(State.BOTTOM);
    }

    private void reset(State state) {
        this.valueMap.clear();
        this.whereAlways.clear();
        this.whereNever.clear();
        this.state = state;
    }

    public void propagateAcrossPhiNode(ValueNumber fromVN, ValueNumber toVN) {
        assert (this.isValid());
        this.setValue(toVN, this.getValue(fromVN));
        TypeQualifierValueSet.transferSourceSinkInfoSet(this.whereAlways, fromVN, toVN);
        TypeQualifierValueSet.transferSourceSinkInfoSet(this.whereNever, fromVN, toVN);
        this.valueMap.remove(fromVN);
        this.whereAlways.remove(fromVN);
        this.whereNever.remove(fromVN);
    }

    private static void transferSourceSinkInfoSet(Map<ValueNumber, Set<SourceSinkInfo>> sourceSinkInfoSetMap, ValueNumber fromVN, ValueNumber toVN) {
        Set<? extends SourceSinkInfo> locSet = TypeQualifierValueSet.getSourceSinkInfoSet(sourceSinkInfoSetMap, fromVN);
        for (SourceSinkInfo sourceSinkInfo : locSet) {
            TypeQualifierValueSet.addSourceSinkInfo(sourceSinkInfoSetMap, toVN, sourceSinkInfo);
        }
    }

    public void mergeWith(TypeQualifierValueSet fact) throws DataflowAnalysisException {
        if (!this.isValid() || !fact.isValid()) {
            throw new DataflowAnalysisException("merging an invalid TypeQualifierValueSet");
        }
        HashSet<ValueNumber> interesting = new HashSet<ValueNumber>();
        interesting.addAll(this.valueMap.keySet());
        interesting.addAll(fact.valueMap.keySet());
        for (ValueNumber vn : interesting) {
            this.setValue(vn, FlowValue.meet(this.getValue(vn), fact.getValue(vn)));
            this.mergeSourceSinkInfoSets(this.whereAlways, fact.whereAlways, vn);
            this.mergeSourceSinkInfoSets(this.whereNever, fact.whereNever, vn);
        }
    }

    private void mergeSourceSinkInfoSets(Map<ValueNumber, Set<SourceSinkInfo>> sourceSinkInfoSetMapToUpdate, Map<ValueNumber, Set<SourceSinkInfo>> otherSourceSinkInfoSetMap, ValueNumber vn) {
        if (!otherSourceSinkInfoSetMap.containsKey(vn)) {
            return;
        }
        Set<? extends SourceSinkInfo> otherInfo = TypeQualifierValueSet.getSourceSinkInfoSet(otherSourceSinkInfoSetMap, vn);
        if (!otherInfo.isEmpty()) {
            Set<SourceSinkInfo> sourceSinkInfoSetToUpdate = TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(sourceSinkInfoSetMapToUpdate, vn);
            sourceSinkInfoSetToUpdate.addAll(otherInfo);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TypeQualifierValueSet other = (TypeQualifierValueSet)obj;
        if (this.isValid() && other.isValid()) {
            return this.valueMap.equals(other.valueMap);
        }
        return this.state == other.state;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.state != State.VALID) {
            return this.state.toString();
        }
        TreeSet<ValueNumber> interesting = new TreeSet<ValueNumber>();
        interesting.addAll(this.valueMap.keySet());
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        boolean first = true;
        for (ValueNumber vn : interesting) {
            FlowValue value = this.getValue(vn);
            if (value == FlowValue.TOP || value == FlowValue.UNKNOWN) continue;
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append(this.valueNumberToString(vn, value));
        }
        buf.append("}");
        return buf.toString();
    }

    public String valueNumberToString(ValueNumber vn) {
        return this.valueNumberToString(vn, this.getValue(vn));
    }

    public String valueNumberToString(ValueNumber vn, FlowValue value) {
        StringBuilder buf = new StringBuilder();
        buf.append(vn.getNumber());
        buf.append("->");
        buf.append((Object)value);
        if (value != FlowValue.TOP) {
            Set<? extends SourceSinkInfo> always = TypeQualifierValueSet.getSourceSinkInfoSet(this.whereAlways, vn);
            Set<? extends SourceSinkInfo> never = TypeQualifierValueSet.getSourceSinkInfoSet(this.whereNever, vn);
            if (value != FlowValue.UNKNOWN || !always.equals(never)) {
                buf.append("[");
                if (!always.isEmpty()) {
                    TypeQualifierValueSet.appendSourceSinkInfos(buf, "YES=", always);
                }
                if (!always.isEmpty() && !never.isEmpty()) {
                    buf.append(",");
                }
                if (!never.isEmpty()) {
                    TypeQualifierValueSet.appendSourceSinkInfos(buf, "NO=", never);
                }
                buf.append("]");
            }
        }
        return buf.toString();
    }

    private static void appendSourceSinkInfos(StringBuilder buf, String key, Set<? extends SourceSinkInfo> sourceSinkInfoSet) {
        TreeSet<? extends SourceSinkInfo> sortedLocSet = new TreeSet<SourceSinkInfo>();
        sortedLocSet.addAll(sourceSinkInfoSet);
        boolean first = true;
        buf.append(key);
        buf.append("(");
        for (SourceSinkInfo sourceSinkInfo : sortedLocSet) {
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(sourceSinkInfo.getLocation().toCompactString());
        }
        buf.append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        VALID,
        TOP,
        BOTTOM;

    }
}

