/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysisFeatures;
import javax.annotation.Nonnull;

public class IsNullValue
implements IsNullValueAnalysisFeatures,
Debug {
    private static final boolean DEBUG_EXCEPTION = SystemProperties.getBoolean("inv.debugException");
    private static final boolean DEBUG_KABOOM = SystemProperties.getBoolean("inv.debugKaboom");
    private static final int NULL = 0;
    private static final int CHECKED_NULL = 1;
    private static final int NN = 2;
    private static final int CHECKED_NN = 3;
    private static final int NO_KABOOM_NN = 4;
    private static final int NSP = 5;
    private static final int NN_UNKNOWN = 6;
    private static final int NCP2 = 7;
    private static final int NCP3 = 8;
    private static final int FLAG_SHIFT = 8;
    private static final int EXCEPTION = 256;
    private static final int PARAM = 512;
    private static final int RETURN_VAL = 1024;
    private static final int FIELD_VAL = 2048;
    private static final int READLINE_VAL = 5120;
    private static final int FLAG_MASK = 7936;
    private static final int[][] mergeMatrix = new int[][]{{0}, {0, 1}, {5, 5, 2}, {5, 5, 2, 3}, {5, 5, 2, 2, 4}, {5, 5, 5, 5, 5, 5}, {5, 5, 6, 6, 6, 5, 6}, {5, 5, 7, 7, 7, 5, 7, 7}, {5, 5, 8, 8, 8, 5, 8, 8, 8}};
    private static final IsNullValue[][] instanceByFlagsList = IsNullValue.createInstanceByFlagList();
    private final int kind;
    private final Location locationOfKaBoom;

    private static IsNullValue[][] createInstanceByFlagList() {
        int max = 31;
        IsNullValue[][] result = new IsNullValue[32][];
        for (int i = 0; i <= 31; ++i) {
            int flags = i << 8;
            result[i] = new IsNullValue[]{new IsNullValue(0 | flags), new IsNullValue(1 | flags), new IsNullValue(2 | flags), new IsNullValue(3 | flags), null, new IsNullValue(5 | flags), new IsNullValue(6 | flags), new IsNullValue(7 | flags), new IsNullValue(8 | flags)};
        }
        return result;
    }

    private IsNullValue(int kind) {
        this.kind = kind;
        this.locationOfKaBoom = null;
        if (VERIFY_INTEGRITY) {
            this.checkNoKaboomNNLocation();
        }
    }

    private IsNullValue(int kind, Location ins) {
        this.kind = kind;
        this.locationOfKaBoom = ins;
        if (VERIFY_INTEGRITY) {
            this.checkNoKaboomNNLocation();
        }
    }

    private void checkNoKaboomNNLocation() {
        if (this.getBaseKind() == 4 && this.locationOfKaBoom == null) {
            throw new IllegalStateException("construction of no-KaBoom NN without Location");
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsNullValue other = (IsNullValue)o;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.locationOfKaBoom == other.locationOfKaBoom) {
            return true;
        }
        if (this.locationOfKaBoom == null || other.locationOfKaBoom == null) {
            return false;
        }
        return this.locationOfKaBoom.equals(other.locationOfKaBoom);
    }

    public int hashCode() {
        int hashCode = this.kind;
        if (this.locationOfKaBoom != null) {
            hashCode += this.locationOfKaBoom.hashCode();
        }
        return hashCode;
    }

    private int getBaseKind() {
        return this.kind & 0xFFFFE0FF;
    }

    private int getFlags() {
        return this.kind & 0x1F00;
    }

    private boolean hasFlag(int flag) {
        return (this.kind & flag) == flag;
    }

    public boolean isException() {
        return this.hasFlag(256);
    }

    public boolean isReturnValue() {
        return this.hasFlag(1024);
    }

    public boolean isReadlineValue() {
        return this.hasFlag(5120);
    }

    public boolean isFieldValue() {
        return this.hasFlag(2048);
    }

    public boolean isParamValue() {
        return (this.kind & 0x200) != 0;
    }

    public boolean isChecked() {
        return this.getBaseKind() == 1 || this.getBaseKind() == 3;
    }

    public boolean wouldHaveBeenAKaboom() {
        return this.getBaseKind() == 4;
    }

    private IsNullValue toBaseValue() {
        return instanceByFlagsList[0][this.getBaseKind()];
    }

    public IsNullValue toExceptionValue() {
        if (this.getBaseKind() == 4) {
            return new IsNullValue(this.kind | 0x100, this.locationOfKaBoom);
        }
        return instanceByFlagsList[(this.getFlags() | 0x100) >> 8][this.getBaseKind()];
    }

    public IsNullValue markInformationAsComingFromReturnValueOfMethod(XMethod methodInvoked) {
        int flag = 1024;
        if (methodInvoked.getName().equals("readLine") && methodInvoked.getSignature().equals("()Ljava/lang/String;")) {
            flag = 5120;
        }
        if (this.getBaseKind() == 4) {
            return new IsNullValue(this.kind | flag, this.locationOfKaBoom);
        }
        return instanceByFlagsList[(this.getFlags() | flag) >> 8][this.getBaseKind()];
    }

    public IsNullValue markInformationAsComingFromFieldValue(XField field) {
        if (this.getBaseKind() == 4) {
            return new IsNullValue(this.kind | 0x800, this.locationOfKaBoom);
        }
        return instanceByFlagsList[(this.getFlags() | 0x800) >> 8][this.getBaseKind()];
    }

    public static IsNullValue nullValue() {
        return instanceByFlagsList[0][0];
    }

    public static IsNullValue checkedNullValue() {
        return instanceByFlagsList[0][1];
    }

    public static IsNullValue nonNullValue() {
        return instanceByFlagsList[0][2];
    }

    public static IsNullValue checkedNonNullValue() {
        return instanceByFlagsList[0][3];
    }

    public static IsNullValue noKaboomNonNullValue(@Nonnull Location ins) {
        if (ins == null) {
            throw new NullPointerException("ins cannot be null");
        }
        return new IsNullValue(4, ins);
    }

    public static IsNullValue nullOnSimplePathValue() {
        return instanceByFlagsList[0][5];
    }

    public static IsNullValue parameterMarkedAsMightBeNull(XMethodParameter mp) {
        return instanceByFlagsList[2][5];
    }

    public static IsNullValue parameterMarkedAsNonnull(XMethodParameter mp) {
        return instanceByFlagsList[2][2];
    }

    public static IsNullValue nonReportingNotNullValue() {
        return instanceByFlagsList[0][6];
    }

    public static IsNullValue nullOnComplexPathValue() {
        return instanceByFlagsList[0][7];
    }

    public static IsNullValue nullOnComplexPathValue3() {
        return instanceByFlagsList[0][8];
    }

    public static IsNullValue pathSensitiveNullValue() {
        return instanceByFlagsList[0][1];
    }

    public static IsNullValue pathSensitiveNonNullValue() {
        return instanceByFlagsList[0][3];
    }

    public static IsNullValue merge(IsNullValue a, IsNullValue b) {
        if (a == b) {
            return a;
        }
        if (a.equals(b)) {
            return a;
        }
        int aKind = a.kind & 0xFF;
        int bKind = b.kind & 0xFF;
        int aFlags = a.getFlags();
        int bFlags = b.getFlags();
        int combinedFlags = aFlags & bFlags;
        if (!a.isNullOnSomePath() && !a.isDefinitelyNull() && b.isException()) {
            combinedFlags |= 0x100;
        } else if (!b.isNullOnSomePath() && !b.isDefinitelyNull() && a.isException()) {
            combinedFlags |= 0x100;
        }
        if (aKind < bKind) {
            int tmp = aKind;
            aKind = bKind;
            bKind = tmp;
        }
        assert (aKind >= bKind);
        int result = mergeMatrix[aKind][bKind];
        IsNullValue resultValue = result == 4 ? IsNullValue.noKaboomNonNullValue(a.locationOfKaBoom) : instanceByFlagsList[combinedFlags >> 8][result];
        return resultValue;
    }

    public boolean isDefinitelyNull() {
        int baseKind = this.getBaseKind();
        return baseKind == 0 || baseKind == 1;
    }

    public boolean isNullOnSomePath() {
        int baseKind = this.getBaseKind();
        if (NCP_EXTRA_BRANCH) {
            return baseKind == 5 || baseKind == 7;
        }
        return baseKind == 5;
    }

    public boolean isNullOnComplicatedPath() {
        int baseKind = this.getBaseKind();
        return baseKind == 6 || baseKind == 7 || baseKind == 8;
    }

    public boolean isNullOnComplicatedPath23() {
        int baseKind = this.getBaseKind();
        return baseKind == 7 || baseKind == 8;
    }

    public boolean isNullOnComplicatedPath2() {
        int baseKind = this.getBaseKind();
        return baseKind == 7;
    }

    public boolean mightBeNull() {
        return this.isDefinitelyNull() || this.isNullOnSomePath();
    }

    public boolean isDefinitelyNotNull() {
        int baseKind = this.getBaseKind();
        return baseKind == 2 || baseKind == 3 || baseKind == 4;
    }

    public String toString() {
        String pfx = "";
        if (DEBUG_EXCEPTION) {
            int flags = this.getFlags();
            if (flags == 0) {
                pfx = "_";
            } else {
                if ((flags & 0x100) != 0) {
                    pfx = pfx + "e";
                }
                if ((flags & 0x200) != 0) {
                    pfx = pfx + "p";
                }
                if ((flags & 0x400) != 0) {
                    pfx = pfx + "r";
                }
                if ((flags & 0x800) != 0) {
                    pfx = pfx + "f";
                }
            }
        }
        if (DEBUG_KABOOM && this.locationOfKaBoom == null) {
            pfx = pfx + "[?]";
        }
        switch (this.getBaseKind()) {
            case 0: {
                return pfx + "n" + ",";
            }
            case 1: {
                return pfx + "w" + ",";
            }
            case 2: {
                return pfx + "N" + ",";
            }
            case 3: {
                return pfx + "W" + ",";
            }
            case 4: {
                return pfx + "K" + ",";
            }
            case 5: {
                return pfx + "s" + ",";
            }
            case 6: {
                return pfx + "-" + ",";
            }
            case 7: {
                return pfx + "/" + ",";
            }
        }
        throw new IllegalStateException("unknown kind of IsNullValue: " + this.kind);
    }

    public Location getLocationOfKaBoom() {
        return this.locationOfKaBoom;
    }

    public IsNullValue downgradeOnControlSplit() {
        IsNullValue value = this;
        if (NCP_EXTRA_BRANCH) {
            if (value.isNullOnSomePath()) {
                value = IsNullValue.nullOnComplexPathValue();
            } else if (value.equals(IsNullValue.nullOnComplexPathValue())) {
                value = IsNullValue.nullOnComplexPathValue3();
            }
        } else if (value.isNullOnSomePath()) {
            value = IsNullValue.nullOnComplexPathValue();
        }
        return value;
    }
}

