/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DeepSubtypeAnalysis;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ProgramPoint;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.detect.UnreadFieldsData;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.Bag;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.Externalizable;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnreadFields
extends OpcodeStackDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("unreadfields.debug");
    boolean hasNativeMethods;
    boolean isSerializable;
    boolean sawSelfCallInConstructor;
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    boolean publicOrProtectedConstructor;
    static final int DO_NOT_CONSIDER = 5;
    final ClassDescriptor externalizable = DescriptorFactory.createClassDescriptor(Externalizable.class);
    final ClassDescriptor serializable = DescriptorFactory.createClassDescriptor(Serializable.class);
    final ClassDescriptor remote = DescriptorFactory.createClassDescriptor(Remote.class);
    int count_aload_1;
    private int previousOpcode;
    private int previousPreviousOpcode;
    boolean seenInvokeStatic;
    boolean seenMonitorEnter;
    XField pendingGetField;
    UnreadFieldsData data = new UnreadFieldsData();
    int saState;
    static Pattern dontComplainAbout = Pattern.compile("class[$]");
    static Pattern withinAnonymousClass = Pattern.compile("[$][0-9].*[$]");

    @Deprecated
    public boolean isContainerField(XField f) {
        return this.data.isContainerField(f);
    }

    @Deprecated
    public Set<? extends XField> getReadFields() {
        return this.data.getReadFields();
    }

    @Deprecated
    public Set<? extends XField> getWrittenFields() {
        return this.data.getWrittenFields();
    }

    @Deprecated
    public boolean isWrittenOutsideOfInitialization(XField f) {
        return this.data.isWrittenOutsideOfInitialization(f);
    }

    @Deprecated
    public boolean isWrittenDuringInitialization(XField f) {
        return this.data.isWrittenDuringInitialization(f);
    }

    @Deprecated
    public boolean isWrittenInConstructor(XField f) {
        return this.data.isWrittenInConstructor(f);
    }

    public UnreadFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        this.data.reflectiveFields.add(XFactory.createXField("java.lang.System", "in", "Ljava/io/InputStream;", true));
        this.data.reflectiveFields.add(XFactory.createXField("java.lang.System", "out", "Ljava/io/PrintStream;", true));
        this.data.reflectiveFields.add(XFactory.createXField("java.lang.System", "err", "Ljava/io/PrintStream;", true));
        this.data = context.getUnreadFieldsData();
        context.setUnreadFields(this);
    }

    @Deprecated
    public void strongEvidenceForIntendedSerialization(ClassDescriptor c) {
        this.data.strongEvidenceForIntendedSerialization(c);
    }

    @Deprecated
    public boolean existsStrongEvidenceForIntendedSerialization(ClassDescriptor c) {
        return this.data.existsStrongEvidenceForIntendedSerialization(c);
    }

    @Override
    public void visit(JavaClass obj) {
        String[] interface_names;
        this.data.calledFromConstructors.clear();
        this.hasNativeMethods = false;
        this.sawSelfCallInConstructor = false;
        this.publicOrProtectedConstructor = false;
        this.isSerializable = false;
        if (obj.isAbstract()) {
            this.data.abstractClasses.add(this.getDottedClassName());
        } else {
            String superClass = obj.getSuperclassName();
            if (superClass != null) {
                this.data.hasNonAbstractSubClass.add(superClass);
            }
        }
        this.data.classesScanned.add(this.getDottedClassName());
        boolean superClassIsObject = "java.lang.Object".equals(obj.getSuperclassName());
        if (this.getSuperclassName().indexOf("$") >= 0 || this.getSuperclassName().indexOf("+") >= 0 || withinAnonymousClass.matcher(this.getDottedClassName()).find()) {
            this.data.innerClassCannotBeStatic.add(this.getDottedClassName());
            this.data.innerClassCannotBeStatic.add(this.getDottedSuperclassName());
        }
        for (String interface_name : interface_names = obj.getInterfaceNames()) {
            if (interface_name.equals("java.io.Externalizable")) {
                this.isSerializable = true;
                continue;
            }
            if (!interface_name.equals("java.io.Serializable")) continue;
            this.isSerializable = true;
            break;
        }
        if (!(superClassIsObject && interface_names.length <= 0 || this.isSerializable)) {
            try {
                Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                ClassDescriptor desc = DescriptorFactory.createClassDescriptor(obj);
                if (subtypes2.getSubtypes(this.serializable).contains(desc) || subtypes2.getSubtypes(this.externalizable).contains(desc) || subtypes2.getSubtypes(this.remote).contains(desc)) {
                    this.isSerializable = true;
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        super.visit(obj);
    }

    public static boolean classHasParameter(JavaClass obj) {
        for (Attribute a : obj.getAttributes()) {
            if (!(a instanceof Signature)) continue;
            String sig = ((Signature)a).getSignature();
            return sig.charAt(0) == '<';
        }
        return false;
    }

    @Override
    public void visitAfter(JavaClass obj) {
        if (this.hasNativeMethods) {
            this.data.fieldsOfSerializableOrNativeClassed.addAll(this.data.myFields);
            this.data.fieldsOfNativeClasses.addAll(this.data.myFields);
        }
        if (this.isSerializable) {
            this.data.fieldsOfSerializableOrNativeClassed.addAll(this.data.myFields);
        }
        if (this.sawSelfCallInConstructor) {
            this.data.myFields.removeAll(this.data.writtenInConstructorFields);
            this.data.writtenInInitializationFields.addAll(this.data.myFields);
        }
        this.data.myFields.clear();
        this.data.allMyFields.clear();
        this.data.calledFromConstructors.clear();
    }

    @Override
    public void visit(Field obj) {
        super.visit(obj);
        XField f = XFactory.createXField(this);
        this.data.allMyFields.add(f);
        String signature = obj.getSignature();
        if (!this.getFieldName().equals("serialVersionUID")) {
            this.data.myFields.add(f);
            if (obj.getName().equals("_jspx_dependants")) {
                this.data.containerFields.add(f);
            }
        }
        if (UnreadFields.isSeleniumWebElement(signature)) {
            this.data.containerFields.add(f);
        }
    }

    public static boolean isSeleniumWebElement(String signature) {
        return signature.equals("Lorg/openqa/selenium/RenderedWebElement;") || signature.equals("Lorg/openqa/selenium/WebElement;");
    }

    @Override
    public void visitAnnotation(String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (!this.visitingField()) {
            return;
        }
        if (UnreadFields.isInjectionAttribute(annotationClass)) {
            this.data.containerFields.add(XFactory.createXField(this));
        }
        if (!annotationClass.startsWith("edu.umd.cs.findbugs") && !annotationClass.startsWith("javax.lang")) {
            this.data.unknownAnnotation.add(XFactory.createXField(this), annotationClass);
        }
    }

    public static boolean isInjectionAttribute(@DottedClassName String annotationClass) {
        if (annotationClass.startsWith("javax.annotation.") || annotationClass.startsWith("javax.ejb") || annotationClass.equals("org.apache.tapestry5.annotations.Persist") || annotationClass.equals("org.jboss.seam.annotations.In") || annotationClass.startsWith("javax.persistence") || annotationClass.endsWith("SpringBean") || annotationClass.equals("com.google.inject.Inject") || annotationClass.startsWith("com.google.") && annotationClass.endsWith(".Bind") && annotationClass.hashCode() == -243168318 || annotationClass.startsWith("org.nuxeo.common.xmap.annotation") || annotationClass.startsWith("com.google.gwt.uibinder.client") || annotationClass.startsWith("org.springframework.beans.factory.annotation") || annotationClass.equals("javax.ws.rs.core.Context")) {
            return true;
        }
        int lastDot = annotationClass.lastIndexOf(46);
        String lastPart = annotationClass.substring(lastDot + 1);
        return lastPart.startsWith("Inject");
    }

    @Override
    public void visit(ConstantValue obj) {
        XField f = XFactory.createXField(this);
        this.data.constantFields.add(f);
    }

    @Override
    public void visit(Code obj) {
        this.count_aload_1 = 0;
        this.previousOpcode = -1;
        this.previousPreviousOpcode = -1;
        this.data.nullTested.clear();
        this.seenInvokeStatic = false;
        this.seenMonitorEnter = this.getMethod().isSynchronized();
        this.data.staticFieldsReadInThisMethod.clear();
        super.visit(obj);
        if (this.getMethodName().equals("<init>") && this.count_aload_1 > 1 && (this.getClassName().indexOf(36) >= 0 || this.getClassName().indexOf(43) >= 0)) {
            this.data.needsOuterObjectInConstructor.add(this.getDottedClassName());
        }
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("Checking " + this.getClassName() + "." + obj.getName());
        }
        if (this.getMethodName().equals("<init>") && (obj.isPublic() || obj.isProtected())) {
            this.publicOrProtectedConstructor = true;
        }
        this.pendingGetField = null;
        this.saState = 0;
        super.visit(obj);
        int flags = obj.getAccessFlags();
        if ((flags & 0x100) != 0) {
            this.hasNativeMethods = true;
        }
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        boolean selfAssignment;
        block97: {
            OpcodeStack.Item item2;
            XField f;
            block95: {
                XField f2;
                XField f3;
                String fieldClass;
                String fieldName;
                if (DEBUG) {
                    System.out.println(this.getPC() + ": " + OPCODE_NAMES[seen] + " " + this.saState);
                }
                if (seen == 194) {
                    this.seenMonitorEnter = true;
                }
                switch (this.saState) {
                    case 0: {
                        if (seen != 42) break;
                        this.saState = 1;
                        break;
                    }
                    case 1: {
                        if (seen == 42) {
                            this.saState = 2;
                            break;
                        }
                        this.saState = 0;
                        break;
                    }
                    case 2: {
                        if (seen == 180) {
                            this.saState = 3;
                            break;
                        }
                        this.saState = 0;
                        break;
                    }
                    case 3: {
                        this.saState = seen == 181 ? 4 : 0;
                    }
                }
                selfAssignment = false;
                if (this.pendingGetField != null) {
                    if (seen != 181 && seen != 179) {
                        this.data.readFields.add(this.pendingGetField);
                    } else if (XFactory.createReferencedXField(this).equals(this.pendingGetField) && (this.saState == 4 || seen == 179)) {
                        selfAssignment = true;
                    } else {
                        this.data.readFields.add(this.pendingGetField);
                    }
                    this.pendingGetField = null;
                }
                if (this.saState == 4) {
                    this.saState = 0;
                }
                if (seen == 184 && this.getClassConstantOperand().equals("java/util/concurrent/atomic/AtomicReferenceFieldUpdater") && this.getNameConstantOperand().equals("newUpdater")) {
                    fieldName = (String)this.stack.getStackItem(0).getConstant();
                    String fieldSignature = (String)this.stack.getStackItem(1).getConstant();
                    String fieldClass2 = (String)this.stack.getStackItem(2).getConstant();
                    if (fieldName != null && fieldSignature != null && fieldClass2 != null) {
                        XField f4 = XFactory.createXField(fieldClass2.replace('/', '.'), fieldName, ClassName.toSignature(fieldSignature), false);
                        this.data.reflectiveFields.add(f4);
                    }
                }
                if (seen == 184 && this.getClassConstantOperand().equals("java/util/concurrent/atomic/AtomicIntegerFieldUpdater") && this.getNameConstantOperand().equals("newUpdater")) {
                    fieldName = (String)this.stack.getStackItem(0).getConstant();
                    fieldClass = (String)this.stack.getStackItem(1).getConstant();
                    if (fieldName != null && fieldClass != null) {
                        f3 = XFactory.createXField(fieldClass.replace('/', '.'), fieldName, "I", false);
                        this.data.reflectiveFields.add(f3);
                    }
                }
                if (seen == 184 && this.getClassConstantOperand().equals("java/util/concurrent/atomic/AtomicLongFieldUpdater") && this.getNameConstantOperand().equals("newUpdater")) {
                    fieldName = (String)this.stack.getStackItem(0).getConstant();
                    fieldClass = (String)this.stack.getStackItem(1).getConstant();
                    if (fieldName != null && fieldClass != null) {
                        f3 = XFactory.createXField(fieldClass.replace('/', '.'), fieldName, "J", false);
                        this.data.reflectiveFields.add(f3);
                    }
                }
                if (seen == 178) {
                    f2 = XFactory.createReferencedXField(this);
                    this.data.staticFieldsReadInThisMethod.add(f2);
                } else if (seen == 184) {
                    this.seenInvokeStatic = true;
                } else if (seen == 179 && !this.getMethod().isStatic()) {
                    f2 = XFactory.createReferencedXField(this);
                    OpcodeStack.Item valuePut = this.getStack().getStackItem(0);
                    if (f2.getName().indexOf("class$") != 0) {
                        int priority;
                        block94: {
                            priority = 3;
                            if (f2.isReferenceType()) {
                                try {
                                    ValueNumberDataflow vnaDataflow = this.getClassContext().getValueNumberDataflow(this.getMethod());
                                    IsNullValueDataflow invDataflow = this.getClassContext().getIsNullValueDataflow(this.getMethod());
                                    ValueNumberFrame vFrame = (ValueNumberFrame)((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getFactAtPC(vnaDataflow.getCFG(), this.getPC());
                                    IsNullValueFrame iFrame = (IsNullValueFrame)((IsNullValueAnalysis)invDataflow.getAnalysis()).getFactAtPC(invDataflow.getCFG(), this.getPC());
                                    AvailableLoad l = new AvailableLoad(f2);
                                    ValueNumber[] availableLoads = vFrame.getAvailableLoad(l);
                                    if (availableLoads == null || !iFrame.isTrackValueNumbers()) break block94;
                                    for (ValueNumber v : availableLoads) {
                                        IsNullValue knownValue = iFrame.getKnownValue(v);
                                        if (knownValue == null) continue;
                                        if (knownValue.isDefinitelyNotNull()) {
                                            priority = valuePut.isNull() ? ++priority : --priority;
                                            break;
                                        }
                                        if (!knownValue.isDefinitelyNull()) {
                                            continue;
                                        }
                                        break block95;
                                    }
                                }
                                catch (CheckedAnalysisException e) {
                                    AnalysisContext.logError("foo", e);
                                }
                            }
                        }
                        if (!this.publicOrProtectedConstructor) {
                            --priority;
                        }
                        if (this.seenMonitorEnter) {
                            ++priority;
                        }
                        if (!this.seenInvokeStatic && this.data.staticFieldsReadInThisMethod.isEmpty()) {
                            --priority;
                        }
                        if (this.getThisClass().isPublic() && this.getMethod().isPublic()) {
                            --priority;
                        }
                        if (this.getThisClass().isPrivate() || this.getMethod().isPrivate()) {
                            ++priority;
                        }
                        if (this.getClassName().indexOf(36) != -1 || this.getMethod().isSynthetic() || f2.isSynthetic() || f2.getName().indexOf(36) >= 0) {
                            ++priority;
                        }
                        if (f2.getName().indexOf("DEBUG") >= 0 || f2.getName().indexOf("VERBOSE") >= 0 && f2.getSignature().equals("Z")) {
                            ++priority;
                            ++priority;
                        }
                        if (this.getMethodName().equals("start") || this.getMethodName().equals("stop") && this.getMethodSig().equals("(Lorg/osgi/framework/BundleContext;)V")) {
                            try {
                                FieldDescriptor fieldInfo;
                                String dottedClass;
                                JavaClass fieldClass3;
                                JavaClass bundleClass = Repository.lookupClass((String)"org.osgi.framework.BundleActivator");
                                if (this.getThisClass().instanceOf(bundleClass)) {
                                    ++priority;
                                }
                                if (f2.isReferenceType() && (fieldClass3 = Repository.lookupClass((String)(dottedClass = DeepSubtypeAnalysis.getComponentClass((fieldInfo = f2.getFieldDescriptor()).getSignature())))) != null && fieldClass3.instanceOf(bundleClass)) {
                                    priority = 5;
                                }
                            }
                            catch (ClassNotFoundException e) {
                                this.bugReporter.reportMissingClass(e);
                            }
                        }
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", priority).addClassAndMethod(this).addField(f2), this);
                    }
                }
            }
            if (seen == 182 || seen == 185 || seen == 183 || seen == 184) {
                String sig = this.getSigConstantOperand();
                String invokedClassName = this.getClassConstantOperand();
                if (invokedClassName.equals(this.getClassName()) && (this.getMethodName().equals("<init>") || this.getMethodName().equals("<clinit>"))) {
                    this.data.calledFromConstructors.add(this.getNameConstantOperand() + ":" + sig);
                }
                int pos = PreorderVisitor.getNumberArguments(sig);
                if (this.stack.getStackDepth() > pos) {
                    boolean selfCall;
                    boolean superCall;
                    OpcodeStack.Item item3 = this.stack.getStackItem(pos);
                    boolean bl = superCall = seen == 183 && !invokedClassName.equals(this.getClassName());
                    if (DEBUG) {
                        System.out.println("In " + this.getFullyQualifiedMethodName() + " saw call on " + item3);
                    }
                    boolean bl2 = selfCall = item3.getRegisterNumber() == 0 && !superCall;
                    if (selfCall && this.getMethodName().equals("<init>")) {
                        this.sawSelfCallInConstructor = true;
                        if (DEBUG) {
                            System.out.println("Saw self call in " + this.getFullyQualifiedMethodName() + " to " + invokedClassName + "." + this.getNameConstantOperand());
                        }
                    }
                }
            }
            if ((seen == 198 || seen == 199) && this.stack.getStackDepth() > 0 && (f = (item2 = this.stack.getStackItem(0)).getXField()) != null) {
                this.data.nullTested.add(f);
                if (DEBUG) {
                    System.out.println(f + " null checked in " + this.getFullyQualifiedMethodName());
                }
            }
            if ((seen == 165 || seen == 166) && this.stack.getStackDepth() >= 2) {
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                XField field1 = item1.getXField();
                if (item0.isNull() && field1 != null) {
                    this.data.nullTested.add(field1);
                } else {
                    XField field0 = item0.getXField();
                    if (item1.isNull() && field0 != null) {
                        this.data.nullTested.add(field0);
                    }
                }
            }
            if (seen == 180 || seen == 182 || seen == 185 || seen == 183 || seen == 181 || seen == 46 || seen == 50 || seen == 51 || seen == 52 || seen == 53 || seen == 79 || seen == 83 || seen == 84 || seen == 85 || seen == 86 || seen == 190) {
                XField f5;
                int pos = 0;
                switch (seen) {
                    case 180: 
                    case 190: {
                        pos = 0;
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 185: {
                        String sig = this.getSigConstantOperand();
                        pos = PreorderVisitor.getNumberArguments(sig);
                        break;
                    }
                    case 46: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 181: {
                        pos = 1;
                        break;
                    }
                    case 79: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        pos = 2;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Impossible");
                    }
                }
                if (!(this.stack.getStackDepth() < pos || (f5 = (item = this.stack.getStackItem(pos)).getXField()) == null || f5.isStatic() || this.data.nullTested.contains(f5) || (this.data.writtenInConstructorFields.contains(f5) || this.data.writtenInInitializationFields.contains(f5)) && this.data.writtenNonNullFields.contains(f5))) {
                    block96: {
                        try {
                            IsNullValueDataflow invDataflow = this.getClassContext().getIsNullValueDataflow(this.getMethod());
                            IsNullValueFrame iFrame = (IsNullValueFrame)((IsNullValueAnalysis)invDataflow.getAnalysis()).getFactBeforeExceptionCheck(invDataflow.getCFG(), this.getPC());
                            if (iFrame.isValid() && !((IsNullValue)iFrame.getStackValue(pos)).isDefinitelyNotNull()) break block96;
                            break block97;
                        }
                        catch (CheckedAnalysisException e) {
                            AnalysisContext.logError("foo", e);
                        }
                    }
                    if (DEBUG) {
                        System.out.println("RRR: " + f5 + " " + this.data.nullTested.contains(f5) + " " + this.data.writtenInConstructorFields.contains(f5) + " " + this.data.writtenNonNullFields.contains(f5));
                    }
                    ProgramPoint p = new ProgramPoint(this);
                    Set<ProgramPoint> s = this.data.assumedNonNull.get(f5);
                    s = s == null ? Collections.singleton(p) : Util.addTo(s, p);
                    this.data.assumedNonNull.put(f5, s);
                    if (DEBUG) {
                        System.out.println(f5 + " assumed non-null in " + this.getFullyQualifiedMethodName());
                    }
                }
            }
        }
        if (seen == 43) {
            ++this.count_aload_1;
        } else if (seen == 180 || seen == 178) {
            XField f;
            this.pendingGetField = f = XFactory.createReferencedXField(this);
            if (this.getMethodName().equals("readResolve") && seen == 180) {
                this.data.writtenFields.add(f);
                this.data.writtenNonNullFields.add(f);
            }
            if (DEBUG) {
                System.out.println("get: " + f);
            }
            if (this.data.writtenFields.contains(f)) {
                this.data.fieldAccess.remove(f);
            } else if (!this.data.fieldAccess.containsKey(f)) {
                this.data.fieldAccess.put(f, SourceLineAnnotation.fromVisitedInstruction(this));
            }
        } else if (!(seen != 181 && seen != 179 || selfAssignment)) {
            boolean isConstructor;
            boolean writtingNonNull;
            XField f = XFactory.createReferencedXField(this);
            item = null;
            if (this.stack.getStackDepth() > 0 && !(item = this.stack.getStackItem(0)).isNull()) {
                this.data.nullTested.add(f);
            }
            this.data.writtenFields.add(f);
            boolean bl = writtingNonNull = this.previousOpcode != 1 || this.previousPreviousOpcode == 167;
            if (writtingNonNull) {
                this.data.writtenNonNullFields.add(f);
                if (DEBUG) {
                    System.out.println("put nn: " + f);
                }
            } else if (DEBUG) {
                System.out.println("put: " + f);
            }
            if (writtingNonNull && this.data.readFields.contains(f)) {
                this.data.fieldAccess.remove(f);
            } else if (!this.data.fieldAccess.containsKey(f)) {
                this.data.fieldAccess.put(f, SourceLineAnnotation.fromVisitedInstruction(this));
            }
            boolean bl3 = isConstructor = this.getMethodName().equals("<init>") || this.getMethodName().equals("<clinit>");
            if (this.getMethod().isStatic() == f.isStatic() && (isConstructor || this.data.calledFromConstructors.contains(this.getMethodName() + ":" + this.getMethodSig()) || this.getMethodName().equals("init") || this.getMethodName().equals("init") || this.getMethodName().equals("initialize") || this.getMethod().isPrivate())) {
                if (isConstructor) {
                    this.data.writtenInConstructorFields.add(f);
                    if (f.getSignature().equals("Ljava/lang/ThreadLocal;") && item != null && item.isNewlyAllocated()) {
                        this.data.threadLocalAssignedInConstructor.put(f, new ProgramPoint(this));
                    }
                } else {
                    this.data.writtenInInitializationFields.add(f);
                }
                if (writtingNonNull) {
                    this.data.assumedNonNull.remove(f);
                }
            } else {
                this.data.writtenOutsideOfInitializationFields.add(f);
            }
        }
        this.previousPreviousOpcode = this.previousOpcode;
        this.previousOpcode = seen;
    }

    @Deprecated
    public boolean isReflexive(XField f) {
        return this.data.isReflexive(f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void report() {
        String className;
        String fieldName;
        HashSet<String> fieldNamesSet = new HashSet<String>();
        for (XField f : this.data.writtenNonNullFields) {
            fieldNamesSet.add(f.getName());
        }
        if (DEBUG) {
            System.out.println("read fields:");
            for (XField f : this.data.readFields) {
                System.out.println("  " + f);
            }
            if (!this.data.containerFields.isEmpty()) {
                System.out.println("ejb3 fields:");
                for (XField f : this.data.containerFields) {
                    System.out.println("  " + f);
                }
            }
            if (!this.data.reflectiveFields.isEmpty()) {
                System.out.println("reflective fields:");
                for (XField f : this.data.reflectiveFields) {
                    System.out.println("  " + f);
                }
            }
            System.out.println("written fields:");
            for (XField f : this.data.writtenFields) {
                System.out.println("  " + f);
            }
            System.out.println("written nonnull fields:");
            for (XField f : this.data.writtenNonNullFields) {
                System.out.println("  " + f);
            }
            System.out.println("assumed nonnull fields:");
            for (XField f : this.data.assumedNonNull.keySet()) {
                System.out.println("  " + f);
            }
        }
        HashSet<XField> declaredFields = new HashSet<XField>();
        AnalysisContext currentAnalysisContext = AnalysisContext.currentAnalysisContext();
        XFactory xFactory = AnalysisContext.currentXFactory();
        for (XField f : AnalysisContext.currentXFactory().allFields()) {
            ClassDescriptor classDescriptor = f.getClassDescriptor();
            if (!currentAnalysisContext.isApplicationClass(classDescriptor) || currentAnalysisContext.isTooBig(classDescriptor) || xFactory.isReflectiveClass(classDescriptor)) continue;
            declaredFields.add(f);
        }
        HashSet<XField> unknownAnotationAndUnwritten = new HashSet<XField>(this.data.unknownAnnotation.keySet());
        unknownAnotationAndUnwritten.removeAll(this.data.writtenFields);
        declaredFields.removeAll(unknownAnotationAndUnwritten);
        declaredFields.removeAll(this.data.containerFields);
        declaredFields.removeAll(this.data.reflectiveFields);
        Iterator i = declaredFields.iterator();
        while (i.hasNext()) {
            XField f = (XField)i.next();
            if ((!f.isSynthetic() || f.getName().startsWith("this$")) && !f.getName().startsWith("_")) continue;
            i.remove();
        }
        TreeSet notInitializedInConstructors = new TreeSet(declaredFields);
        notInitializedInConstructors.retainAll(this.data.readFields);
        notInitializedInConstructors.retainAll(this.data.writtenNonNullFields);
        notInitializedInConstructors.retainAll(this.data.assumedNonNull.keySet());
        notInitializedInConstructors.removeAll(this.data.writtenInConstructorFields);
        notInitializedInConstructors.removeAll(this.data.writtenInInitializationFields);
        Iterator i2 = notInitializedInConstructors.iterator();
        while (i2.hasNext()) {
            if (!((XField)i2.next()).isStatic()) continue;
            i2.remove();
        }
        TreeSet readOnlyFields = new TreeSet(declaredFields);
        readOnlyFields.removeAll(this.data.writtenFields);
        readOnlyFields.retainAll(this.data.readFields);
        TreeSet nullOnlyFields = new TreeSet(declaredFields);
        nullOnlyFields.removeAll(this.data.writtenNonNullFields);
        nullOnlyFields.retainAll(this.data.readFields);
        HashSet<XField> writeOnlyFields = declaredFields;
        writeOnlyFields.removeAll(this.data.readFields);
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        Bag<String> nullOnlyFieldNames = new Bag<String>();
        Bag<ClassDescriptor> classContainingNullOnlyFields = new Bag<ClassDescriptor>();
        for (XField f : nullOnlyFields) {
            nullOnlyFieldNames.add(f.getName());
            classContainingNullOnlyFields.add(f.getClassDescriptor());
            int increment = 3;
            Collection assumedNonNullAt = this.data.assumedNonNull.get(f);
            if (assumedNonNullAt != null) {
                increment += assumedNonNullAt.size();
            }
            for (String s : this.data.unknownAnnotation.get(f)) {
                Integer value = (Integer)count.get(s);
                if (value == null) {
                    count.put(s, increment);
                    continue;
                }
                count.put(s, value + increment);
            }
        }
        HashMap<XField, Integer> maxCount = new HashMap<XField, Integer>();
        LinkedList<XField> assumeReflective = new LinkedList<XField>();
        for (XField f : nullOnlyFields) {
            int myMaxCount = 0;
            for (String s : this.data.unknownAnnotation.get(f)) {
                Integer value = (Integer)count.get(s);
                if (value == null || myMaxCount >= value) continue;
                myMaxCount = value;
            }
            if (myMaxCount > 0) {
                maxCount.put(f, myMaxCount);
            }
            if (myMaxCount > 15) {
                assumeReflective.add(f);
                continue;
            }
            if (nullOnlyFieldNames.getCount(f.getName()) > 8) {
                assumeReflective.add(f);
                continue;
            }
            if (classContainingNullOnlyFields.getCount(f.getClassDescriptor()) > 4) {
                assumeReflective.add(f);
                continue;
            }
            if (classContainingNullOnlyFields.getCount(f.getClassDescriptor()) <= 2 || f.getName().length() != 1) continue;
            assumeReflective.add(f);
        }
        readOnlyFields.removeAll(assumeReflective);
        nullOnlyFields.removeAll(assumeReflective);
        notInitializedInConstructors.removeAll(assumeReflective);
        Bag<String> notInitializedUses = new Bag<String>();
        for (XField f : notInitializedInConstructors) {
            String className2 = f.getClassName();
            Set<ProgramPoint> assumedNonnullAt = this.data.assumedNonNull.get(f);
            notInitializedUses.add(className2, assumedNonnullAt.size());
        }
        for (XField f : notInitializedInConstructors) {
            String className2 = f.getClassName();
            if (notInitializedUses.getCount(className2) >= 8) continue;
            String fieldSignature = f.getSignature();
            if (!f.isResolved() || this.data.fieldsOfNativeClasses.contains(f) || fieldSignature.charAt(0) != 'L' && fieldSignature.charAt(0) != '[') continue;
            int priority = 3;
            Set<ProgramPoint> assumedNonnullAt = this.data.assumedNonNull.get(f);
            if (assumedNonnullAt.size() >= 4) continue;
            for (ProgramPoint p : assumedNonnullAt) {
                BugInstance bug = new BugInstance(this, "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", priority).addClass(className2).addField(f).addMethod(p.getMethodAnnotation());
                this.bugAccumulator.accumulateBug(bug, p.getSourceLineAnnotation());
            }
        }
        for (XField f : readOnlyFields) {
            fieldName = f.getName();
            className = f.getClassName();
            String fieldSignature = f.getSignature();
            if (!f.isResolved() || this.data.fieldsOfNativeClasses.contains(f)) continue;
            int priority = 2;
            if (fieldSignature.charAt(0) != 'L' && fieldSignature.charAt(0) != '[') {
                ++priority;
            }
            if (maxCount.containsKey(f)) {
                ++priority;
            }
            String pattern = "UWF_UNWRITTEN_FIELD";
            if (f.isProtected() || f.isPublic()) {
                pattern = "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD";
            }
            this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance(this, pattern, priority), f));
        }
        for (XField f : nullOnlyFields) {
            fieldName = f.getName();
            className = f.getClassName();
            String fieldSignature = f.getSignature();
            if (DEBUG) {
                System.out.println("Null only: " + f);
                System.out.println("   : " + this.data.assumedNonNull.containsKey(f));
                System.out.println("   : " + this.data.fieldsOfSerializableOrNativeClassed.contains(f));
                System.out.println("   : " + fieldNamesSet.contains(f.getName()));
                System.out.println("   : " + this.data.abstractClasses.contains(f.getClassName()));
                System.out.println("   : " + this.data.hasNonAbstractSubClass.contains(f.getClassName()));
                System.out.println("   : " + f.isResolved());
            }
            if (!f.isResolved() || this.data.fieldsOfNativeClasses.contains(f)) continue;
            if (DEBUG) {
                System.out.println("Ready to report");
            }
            int priority = 2;
            if (maxCount.containsKey(f)) {
                ++priority;
            }
            if (this.data.abstractClasses.contains(f.getClassName())) {
                ++priority;
                if (!this.data.hasNonAbstractSubClass.contains(f.getClassName())) {
                    ++priority;
                }
            }
            if (this.data.assumedNonNull.containsKey(f)) {
                int npPriority = priority--;
                Set<ProgramPoint> assumedNonNullAt = this.data.assumedNonNull.get(f);
                if (assumedNonNullAt.size() > 14) {
                    npPriority += 2;
                } else if (assumedNonNullAt.size() > 6) {
                    ++npPriority;
                }
                String pattern = f.isPublic() || f.isProtected() ? "NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD" : "NP_UNWRITTEN_FIELD";
                for (ProgramPoint p : assumedNonNullAt) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, pattern, npPriority).addClassAndMethod(p.method).addField(f), p.getSourceLineAnnotation());
                }
            } else {
                if (f.isStatic()) {
                    ++priority;
                }
                if (f.isFinal()) {
                    ++priority;
                }
                if (this.data.fieldsOfSerializableOrNativeClassed.contains(f)) {
                    ++priority;
                }
            }
            if (readOnlyFields.contains(f)) continue;
            this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance(this, "UWF_NULL_FIELD", priority), f).lowerPriorityIfDeprecated());
        }
        block23: for (XField f : writeOnlyFields) {
            boolean isAnonymousInnerClass;
            fieldName = f.getName();
            className = f.getClassName();
            int lastDollar = Math.max(className.lastIndexOf(36), className.lastIndexOf(43));
            boolean bl = isAnonymousInnerClass = lastDollar > 0 && lastDollar < className.length() - 1 && Character.isDigit(className.charAt(lastDollar + 1));
            if (DEBUG) {
                System.out.println("Checking write only field " + className + "." + fieldName + "\t" + this.data.constantFields.contains(f) + "\t" + f.isStatic());
            }
            if (!f.isResolved() || dontComplainAbout.matcher(fieldName).find()) continue;
            if (lastDollar >= 0 && (fieldName.startsWith("this$") || fieldName.startsWith("this+"))) {
                void var25_56;
                boolean easyChange;
                String outerClassName = className.substring(0, lastDollar);
                try {
                    JavaClass outerClass;
                    XClass thisClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, f.getClassDescriptor());
                    if (isAnonymousInnerClass) {
                        for (XField xField : thisClass.getXFields()) {
                            if (xField == f || !xField.isPrivate() || !xField.isSynthetic() || xField.getName().startsWith("this$") || !xField.getName().contains("$")) continue;
                            continue block23;
                        }
                    }
                    if (UnreadFields.classHasParameter(outerClass = Repository.lookupClass((String)outerClassName))) continue;
                    ClassDescriptor classDescriptor = DescriptorFactory.createClassDescriptorFromDottedClassName(outerClassName);
                    XClass outerXClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDescriptor);
                    AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
                    Subtypes2 subtypes2 = analysisContext.getSubtypes2();
                    for (XField xField : outerXClass.getXFields()) {
                        Type ofType;
                        String sourceSignature;
                        if (xField.isStatic() || (sourceSignature = xField.getSourceSignature()) == null || !xField.getSignature().equals("Ljava/lang/ThreadLocal;") || !((ofType = GenericUtilities.getType(sourceSignature)) instanceof GenericObjectType)) continue;
                        GenericObjectType gType = (GenericObjectType)ofType;
                        for (ReferenceType referenceType : gType.getParameters()) {
                            if (!(referenceType instanceof ObjectType)) continue;
                            ClassDescriptor c = DescriptorFactory.getClassDescriptor((ObjectType)referenceType);
                            if (!subtypes2.isSubtype(f.getClassDescriptor(), c)) continue;
                            ProgramPoint p = this.data.threadLocalAssignedInConstructor.get(xField);
                            int priority = p == null ? 2 : 1;
                            BugInstance bug = new BugInstance(this, "SIC_THREADLOCAL_DEADLY_EMBRACE", priority).addClass(className).addField(xField);
                            if (p != null) {
                                bug.addMethod(p.method).add(p.getSourceLineAnnotation());
                            }
                            this.bugReporter.reportBug(bug);
                        }
                    }
                    boolean outerClassIsInnerClass = false;
                    for (Field field : outerClass.getFields()) {
                        if (!field.getName().equals("this$0")) continue;
                        outerClassIsInnerClass = true;
                    }
                    if (outerClassIsInnerClass) {
                        continue;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                }
                catch (CheckedAnalysisException e) {
                    this.bugReporter.logError("Error getting outer XClass for " + outerClassName, e);
                }
                if (this.data.innerClassCannotBeStatic.contains(className)) continue;
                boolean bl2 = easyChange = !this.data.needsOuterObjectInConstructor.contains(className);
                if (!easyChange && isAnonymousInnerClass) continue;
                int priority = 3;
                if (easyChange && !isAnonymousInnerClass) {
                    priority = 2;
                }
                String string = "SIC_INNER_SHOULD_BE_STATIC";
                if (isAnonymousInnerClass) {
                    String string2 = "SIC_INNER_SHOULD_BE_STATIC_ANON";
                } else if (!easyChange) {
                    String string3 = "SIC_INNER_SHOULD_BE_STATIC_NEEDS_THIS";
                }
                this.bugReporter.reportBug(new BugInstance(this, (String)var25_56, priority).addClass(className));
                continue;
            }
            if (!f.isResolved()) continue;
            if (this.data.constantFields.contains(f)) {
                if (f.isStatic()) continue;
                this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance(this, "SS_SHOULD_BE_STATIC", 2), f));
                continue;
            }
            if (this.data.fieldsOfSerializableOrNativeClassed.contains(f)) continue;
            if (!this.data.writtenFields.contains(f)) {
                this.bugReporter.reportBug(new BugInstance(this, f.isPublic() || f.isProtected() ? "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD" : "UUF_UNUSED_FIELD", 2).addClass(className).addField(f).lowerPriorityIfDeprecated());
                continue;
            }
            if (f.getName().toLowerCase().indexOf("guardian") >= 0) continue;
            int priority = 2;
            if (f.isStatic()) {
                ++priority;
            }
            if (f.isFinal()) {
                ++priority;
            }
            this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance(this, f.isPublic() || f.isProtected() ? "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD" : "URF_UNREAD_FIELD", priority), f));
        }
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private BugInstance addClassFieldAndAccess(BugInstance instance, XField f) {
        if (this.data.writtenNonNullFields.contains(f) && this.data.readFields.contains(f)) {
            throw new IllegalArgumentException("No information for fields that are both read and written nonnull");
        }
        instance.addClass(f.getClassName()).addField(f);
        if (this.data.fieldAccess.containsKey(f)) {
            instance.add(this.data.fieldAccess.get(f));
        }
        return instance;
    }
}

