/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.filter.Matcher;
import javax.annotation.Nonnull;

public class FilterBugReporter
extends DelegatingBugReporter {
    private static final boolean DEBUG = SystemProperties.getBoolean("filter.debug");
    private Matcher filter;
    private boolean include;

    public FilterBugReporter(BugReporter realBugReporter, Matcher filter, boolean include) {
        super(realBugReporter);
        this.filter = filter;
        this.include = include;
    }

    public void reportBug(@Nonnull BugInstance bugInstance) {
        if (DEBUG) {
            System.out.print("Match ==> ");
        }
        boolean match = this.filter.match(bugInstance);
        if (DEBUG) {
            System.out.println(match ? "YES" : "NO");
        }
        if (this.include == match) {
            this.getDelegate().reportBug(bugInstance);
        }
    }
}

