/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.IntAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.ba.ClassHash;
import edu.umd.cs.findbugs.filter.AndMatcher;
import edu.umd.cs.findbugs.filter.BugMatcher;
import edu.umd.cs.findbugs.filter.ClassMatcher;
import edu.umd.cs.findbugs.filter.CompoundMatcher;
import edu.umd.cs.findbugs.filter.DesignationMatcher;
import edu.umd.cs.findbugs.filter.FieldMatcher;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.FirstVersionMatcher;
import edu.umd.cs.findbugs.filter.LastVersionMatcher;
import edu.umd.cs.findbugs.filter.LocalMatcher;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.MethodMatcher;
import edu.umd.cs.findbugs.filter.NotMatcher;
import edu.umd.cs.findbugs.filter.OrMatcher;
import edu.umd.cs.findbugs.filter.PriorityMatcher;
import edu.umd.cs.findbugs.filter.RankMatcher;
import edu.umd.cs.findbugs.model.ClassFeatureSet;
import edu.umd.cs.findbugs.util.MapCache;
import edu.umd.cs.findbugs.util.Strings;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXBugCollectionHandler
extends DefaultHandler {
    private static final String FIND_BUGS_FILTER = "FindBugsFilter";
    private static final String PROJECT = "Project";
    private static final String BUG_COLLECTION = "BugCollection";
    private static final Logger LOGGER = Logger.getLogger(SAXBugCollectionHandler.class.getName());
    @CheckForNull
    private final BugCollection bugCollection;
    @CheckForNull
    private final Project project;
    private final Stack<CompoundMatcher> matcherStack = new Stack();
    private Filter filter;
    private final MapCache<String, String> cache = new MapCache(2000);
    private final ArrayList<String> elementStack;
    private final StringBuilder textBuffer;
    private BugInstance bugInstance;
    private BugAnnotationWithSourceLines bugAnnotationWithSourceLines;
    private AnalysisError analysisError;
    private ClassFeatureSet classFeatureSet;
    private final ArrayList<String> stackTrace;
    private int nestingOfIgnoredElements = 0;
    @CheckForNull
    private final File base;
    private final String topLevelName;
    private String cloudPropertyKey;
    Pattern ignoredElement = Pattern.compile("Message|ShortMessage|LongMessage");
    private static boolean DEBUG = false;
    boolean nextMatchedIsDisabled;
    private final Set<String> outerElementTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("And", "Match", "Or", "Not")));

    public String getOptionalAttribute(Attributes attributes, String qName) {
        return this.memoized(attributes.getValue(qName));
    }

    private SAXBugCollectionHandler(String topLevelName, @CheckForNull BugCollection bugCollection, @CheckForNull Project project, @CheckForNull File base) {
        this.topLevelName = topLevelName;
        this.bugCollection = bugCollection;
        this.project = project;
        this.elementStack = new ArrayList();
        this.textBuffer = new StringBuilder();
        this.stackTrace = new ArrayList();
        this.base = base;
    }

    public SAXBugCollectionHandler(BugCollection bugCollection, @CheckForNull File base) {
        this(BUG_COLLECTION, bugCollection, bugCollection.getProject(), base);
    }

    public SAXBugCollectionHandler(BugCollection bugCollection) {
        this(BUG_COLLECTION, bugCollection, bugCollection.getProject(), null);
    }

    public SAXBugCollectionHandler(Project project, File base) {
        this(PROJECT, null, project, base);
    }

    public SAXBugCollectionHandler(Filter filter, File base) {
        this(FIND_BUGS_FILTER, null, null, base);
        this.filter = filter;
        this.pushCompoundMatcher(filter);
    }

    public boolean discardedElement(String qName) {
        return this.ignoredElement.matcher(qName).matches();
    }

    public String getTextContents() {
        return this.memoized(Strings.unescapeXml(this.textBuffer.toString()));
    }

    private String memoized(String s) {
        if (s == null) {
            return s;
        }
        String result = (String)this.cache.get(s);
        if (result != null) {
            return result;
        }
        this.cache.put(s, s);
        return s;
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
        if (this.discardedElement(qName)) {
            ++this.nestingOfIgnoredElements;
        } else if (this.nestingOfIgnoredElements <= 0) {
            if (this.elementStack.isEmpty() && !qName.equals(this.topLevelName)) {
                throw new SAXException("Invalid top-level element (expected " + this.topLevelName + ", saw " + qName + ")");
            }
            if (qName.equals(BUG_COLLECTION)) {
                String releaseName;
                String analysisVersion;
                BugCollection bugCollection = this.bugCollection;
                assert (bugCollection != null);
                String version = this.getOptionalAttribute(attributes, "version");
                if (bugCollection instanceof SortedBugCollection) {
                    bugCollection.setAnalysisVersion(version);
                }
                String sequence = this.getOptionalAttribute(attributes, "sequence");
                long seqval = this.parseLong(sequence, 0L);
                bugCollection.setSequenceNumber(seqval);
                String timestamp = this.getOptionalAttribute(attributes, "timestamp");
                long tsval = this.parseLong(timestamp, -1L);
                bugCollection.setTimestamp(tsval);
                String analysisTimestamp = this.getOptionalAttribute(attributes, "analysisTimestamp");
                if (analysisTimestamp != null) {
                    bugCollection.setAnalysisTimestamp(this.parseLong(analysisTimestamp, -1L));
                }
                if ((analysisVersion = this.getOptionalAttribute(attributes, "version")) != null) {
                    bugCollection.setAnalysisVersion(analysisVersion);
                }
                bugCollection.setReleaseName((releaseName = this.getOptionalAttribute(attributes, "release")) != null ? releaseName : "");
            } else if (this.isTopLevelFilter(qName)) {
                if (this.project != null) {
                    this.filter = new Filter();
                    this.project.setSuppressionFilter(this.filter);
                }
                this.matcherStack.clear();
                this.pushCompoundMatcher(this.filter);
            } else if (qName.equals(PROJECT)) {
                Project project = this.project;
                assert (project != null);
                String projectName = this.getOptionalAttribute(attributes, "projectName");
                if (projectName != null) {
                    project.setProjectName(projectName);
                }
            } else {
                String outerElement = this.elementStack.get(this.elementStack.size() - 1);
                if (outerElement.equals(BUG_COLLECTION)) {
                    if (qName.equals("BugInstance")) {
                        String consensus;
                        String reviewCount;
                        String isInCloud;
                        String firstSeen;
                        String oldInstanceHash;
                        String removedByChange;
                        String lastVersion;
                        String type = this.getRequiredAttribute(attributes, "type", qName);
                        String priority = this.getRequiredAttribute(attributes, "priority", qName);
                        try {
                            int prio = Integer.parseInt(priority);
                            this.bugInstance = new BugInstance(type, prio);
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException("BugInstance with invalid priority value \"" + priority + "\"", e);
                        }
                        String firstVersion = this.getOptionalAttribute(attributes, "first");
                        if (firstVersion != null) {
                            this.bugInstance.setFirstVersion(Long.parseLong(firstVersion));
                        }
                        if ((lastVersion = this.getOptionalAttribute(attributes, "last")) != null) {
                            this.bugInstance.setLastVersion(Long.parseLong(lastVersion));
                        }
                        if (this.bugInstance.isDead() && this.bugInstance.getFirstVersion() > this.bugInstance.getLastVersion()) {
                            throw new IllegalStateException("huh");
                        }
                        String introducedByChange = this.getOptionalAttribute(attributes, "introducedByChange");
                        if (introducedByChange != null) {
                            this.bugInstance.setIntroducedByChangeOfExistingClass(Boolean.parseBoolean(introducedByChange));
                        }
                        if ((removedByChange = this.getOptionalAttribute(attributes, "removedByChange")) != null) {
                            this.bugInstance.setRemovedByChangeOfPersistingClass(Boolean.parseBoolean(removedByChange));
                        }
                        if ((oldInstanceHash = this.getOptionalAttribute(attributes, "instanceHash")) == null) {
                            oldInstanceHash = this.getOptionalAttribute(attributes, "oldInstanceHash");
                        }
                        if (oldInstanceHash != null) {
                            this.bugInstance.setOldInstanceHash(oldInstanceHash);
                        }
                        if ((firstSeen = this.getOptionalAttribute(attributes, "firstSeen")) != null) {
                            try {
                                this.bugInstance.getXmlProps().setFirstSeen(BugInstance.firstSeenXMLFormat().parse(firstSeen));
                            }
                            catch (ParseException e) {
                                LOGGER.warning("Could not parse first seen entry: " + firstSeen);
                            }
                        }
                        if ((isInCloud = this.getOptionalAttribute(attributes, "isInCloud")) != null) {
                            this.bugInstance.getXmlProps().setIsInCloud(Boolean.parseBoolean(isInCloud));
                        }
                        if ((reviewCount = this.getOptionalAttribute(attributes, "reviews")) != null) {
                            this.bugInstance.getXmlProps().setReviewCount(Integer.parseInt(reviewCount));
                        }
                        if ((consensus = this.getOptionalAttribute(attributes, "consensus")) != null) {
                            this.bugInstance.getXmlProps().setConsensus(consensus);
                        }
                    } else if (qName.equals("FindBugsSummary")) {
                        String referencedClasses;
                        String totalSize;
                        BugCollection bugCollection = this.bugCollection;
                        assert (bugCollection != null);
                        String timestamp = this.getRequiredAttribute(attributes, "timestamp", qName);
                        String vmVersion = this.getOptionalAttribute(attributes, "vm_version");
                        String totalClasses = this.getOptionalAttribute(attributes, "total_classes");
                        if (totalClasses != null && totalClasses.length() > 0) {
                            bugCollection.getProjectStats().setTotalClasses(Integer.parseInt(totalClasses));
                        }
                        if ((totalSize = this.getOptionalAttribute(attributes, "total_size")) != null && totalSize.length() > 0) {
                            bugCollection.getProjectStats().setTotalSize(Integer.parseInt(totalSize));
                        }
                        if ((referencedClasses = this.getOptionalAttribute(attributes, "referenced_classes")) != null && referencedClasses.length() > 0) {
                            bugCollection.getProjectStats().setReferencedClasses(Integer.parseInt(referencedClasses));
                        }
                        bugCollection.getProjectStats().setVMVersion(vmVersion);
                        try {
                            bugCollection.getProjectStats().setTimestamp(timestamp);
                        }
                        catch (ParseException e) {
                            throw new SAXException("Unparseable sequence number: '" + timestamp + "'", e);
                        }
                    }
                } else if (outerElement.equals("BugInstance")) {
                    this.parseBugInstanceContents(qName, attributes);
                } else if (outerElement.equals("Method") || outerElement.equals("Field") || outerElement.equals("Class") || outerElement.equals("Type")) {
                    if (qName.equals("SourceLine")) {
                        this.bugAnnotationWithSourceLines.setSourceLines(this.createSourceLineAnnotation(qName, attributes));
                    }
                } else if (outerElement.equals("Errors")) {
                    if (qName.equals("AnalysisError") || qName.equals("Error")) {
                        this.analysisError = new AnalysisError("Unknown error");
                        this.stackTrace.clear();
                    }
                } else if (outerElement.equals("FindBugsSummary") && qName.equals("PackageStats")) {
                    BugCollection bugCollection = this.bugCollection;
                    assert (bugCollection != null);
                    String packageName = this.getRequiredAttribute(attributes, "package", qName);
                    int numClasses = Integer.valueOf(this.getRequiredAttribute(attributes, "total_types", qName));
                    int size = Integer.valueOf(this.getRequiredAttribute(attributes, "total_size", qName));
                    bugCollection.getProjectStats().putPackageStats(packageName, numClasses, size);
                } else if (outerElement.equals("PackageStats")) {
                    BugCollection bugCollection = this.bugCollection;
                    assert (bugCollection != null);
                    if (qName.equals("ClassStats")) {
                        String className = this.getRequiredAttribute(attributes, "class", qName);
                        Boolean isInterface = Boolean.valueOf(this.getRequiredAttribute(attributes, "interface", qName));
                        int size = Integer.valueOf(this.getRequiredAttribute(attributes, "size", qName));
                        String sourceFile = this.getOptionalAttribute(attributes, "sourceFile");
                        bugCollection.getProjectStats().addClass(className, sourceFile, isInterface, size, false);
                    }
                } else if (this.isTopLevelFilter(outerElement) || this.isCompoundElementTag(outerElement)) {
                    this.parseMatcher(qName, attributes);
                } else if (outerElement.equals("ClassFeatures")) {
                    if (qName.equals("ClassFeatureSet")) {
                        String className = this.getRequiredAttribute(attributes, "class", qName);
                        this.classFeatureSet = new ClassFeatureSet();
                        this.classFeatureSet.setClassName(className);
                    }
                } else if (outerElement.equals("ClassFeatureSet")) {
                    if (qName.equals("Feature")) {
                        String value = this.getRequiredAttribute(attributes, "value", qName);
                        this.classFeatureSet.addFeature(value);
                    }
                } else if (outerElement.equals("History")) {
                    if (qName.equals("AppVersion")) {
                        BugCollection bugCollection = this.bugCollection;
                        assert (bugCollection != null);
                        try {
                            String sequence = this.getRequiredAttribute(attributes, "sequence", qName);
                            String timestamp = this.getOptionalAttribute(attributes, "timestamp");
                            String releaseName = this.getOptionalAttribute(attributes, "release");
                            String codeSize = this.getOptionalAttribute(attributes, "codeSize");
                            String numClasses = this.getOptionalAttribute(attributes, "numClasses");
                            AppVersion appVersion = new AppVersion(Long.valueOf(sequence));
                            if (timestamp != null) {
                                appVersion.setTimestamp(Long.valueOf(timestamp));
                            }
                            if (releaseName != null) {
                                appVersion.setReleaseName(releaseName);
                            }
                            if (codeSize != null) {
                                appVersion.setCodeSize(Integer.parseInt(codeSize));
                            }
                            if (numClasses != null) {
                                appVersion.setNumClasses(Integer.parseInt(numClasses));
                            }
                            bugCollection.addAppVersion(appVersion);
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException("Invalid AppVersion element", e);
                        }
                    }
                } else if (outerElement.equals(PROJECT)) {
                    Project project = this.project;
                    assert (project != null);
                    if (qName.equals("Cloud")) {
                        String cloudId = this.getRequiredAttribute(attributes, "id", qName);
                        project.setCloudId(cloudId);
                        if (this.bugCollection != null) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                map.put(attributes.getLocalName(i), attributes.getValue(i));
                            }
                            this.bugCollection.setXmlCloudDetails(Collections.unmodifiableMap(map));
                        }
                    } else if (qName.equals("Plugin")) {
                        String pluginId = this.getRequiredAttribute(attributes, "id", qName);
                        Boolean enabled = Boolean.valueOf(this.getRequiredAttribute(attributes, "enabled", qName));
                        project.setPluginStatusTrinary(pluginId, enabled);
                    }
                } else if (outerElement.equals("Cloud") && qName.equals("Property")) {
                    this.cloudPropertyKey = this.getRequiredAttribute(attributes, "key", qName);
                }
            }
        }
        this.textBuffer.delete(0, this.textBuffer.length());
        this.elementStack.add(qName);
    }

    private boolean isCompoundElementTag(String qName) {
        return this.outerElementTags.contains(qName);
    }

    private boolean isTopLevelFilter(String qName) {
        return qName.equals(FIND_BUGS_FILTER) || qName.equals("SuppressionFilter");
    }

    private void addMatcher(Matcher m) {
        if (m == null) {
            throw new IllegalArgumentException("matcher must not be null");
        }
        CompoundMatcher peek = this.matcherStack.peek();
        if (peek == null) {
            throw new NullPointerException("Top of stack is null");
        }
        peek.addChild(m);
        if (this.nextMatchedIsDisabled) {
            if (peek instanceof Filter) {
                ((Filter)peek).disable(m);
            } else assert (false);
            this.nextMatchedIsDisabled = false;
        }
    }

    private void pushCompoundMatcherAsChild(CompoundMatcher m) {
        this.addMatcher(m);
        this.pushCompoundMatcher(m);
    }

    private void pushCompoundMatcher(CompoundMatcher m) {
        if (m == null) {
            throw new IllegalArgumentException("matcher must not be null");
        }
        this.matcherStack.push(m);
    }

    private void parseMatcher(String qName, Attributes attributes) throws SAXException {
        if (DEBUG) {
            System.out.println(this.elementStack + " " + qName + " " + this.matcherStack);
        }
        String disabled = this.getOptionalAttribute(attributes, "disabled");
        this.nextMatchedIsDisabled = "true".equals(disabled);
        if (qName.equals("Bug")) {
            this.addMatcher(new BugMatcher(this.getOptionalAttribute(attributes, "code"), this.getOptionalAttribute(attributes, "pattern"), this.getOptionalAttribute(attributes, "category")));
        } else if (qName.equals("Class")) {
            this.addMatcher(new ClassMatcher(this.getRequiredAttribute(attributes, "name", qName)));
        } else if (qName.equals("FirstVersion")) {
            this.addMatcher(new FirstVersionMatcher(this.getRequiredAttribute(attributes, "value", qName), this.getRequiredAttribute(attributes, "relOp", qName)));
        } else if (qName.equals("LastVersion")) {
            this.addMatcher(new LastVersionMatcher(this.getRequiredAttribute(attributes, "value", qName), this.getRequiredAttribute(attributes, "relOp", qName)));
        } else if (qName.equals("Designation")) {
            this.addMatcher(new DesignationMatcher(this.getRequiredAttribute(attributes, "designation", qName)));
        } else if (qName.equals("BugCode")) {
            this.addMatcher(new BugMatcher(this.getRequiredAttribute(attributes, "name", qName), "", ""));
        } else if (qName.equals("Local")) {
            this.addMatcher(new LocalMatcher(this.getRequiredAttribute(attributes, "name", qName)));
        } else if (qName.equals("BugPattern")) {
            this.addMatcher(new BugMatcher("", this.getRequiredAttribute(attributes, "name", qName), ""));
        } else if (qName.equals("Priority") || qName.equals("Confidence")) {
            this.addMatcher(new PriorityMatcher(this.getRequiredAttribute(attributes, "value", qName)));
        } else if (qName.equals("Rank")) {
            this.addMatcher(new RankMatcher(this.getRequiredAttribute(attributes, "value", qName)));
        } else if (qName.equals("Package")) {
            String pName = this.getRequiredAttribute(attributes, "name", qName);
            pName = pName.startsWith("~") ? pName : "~" + pName.replace(".", "\\.");
            this.addMatcher(new ClassMatcher(pName + "\\.[^.]+"));
        } else if (qName.equals("Method")) {
            String name = this.getOptionalAttribute(attributes, "name");
            String params = this.getOptionalAttribute(attributes, "params");
            String returns = this.getOptionalAttribute(attributes, "returns");
            String role = this.getOptionalAttribute(attributes, "role");
            this.addMatcher(new MethodMatcher(name, params, returns, role));
        } else if (qName.equals("Field")) {
            String name = this.getOptionalAttribute(attributes, "name");
            String type = this.getOptionalAttribute(attributes, "type");
            this.addMatcher(new FieldMatcher(name, type));
        } else if (qName.equals("Or")) {
            OrMatcher matcher = new OrMatcher();
            this.pushCompoundMatcherAsChild(matcher);
        } else if (qName.equals("And") || qName.equals("Match")) {
            AndMatcher matcher = new AndMatcher();
            this.pushCompoundMatcherAsChild(matcher);
            if (qName.equals("Match")) {
                String classregex = this.getOptionalAttribute(attributes, "classregex");
                String classMatch = this.getOptionalAttribute(attributes, "class");
                if (classregex != null) {
                    this.addMatcher(new ClassMatcher("~" + classregex));
                } else if (classMatch != null) {
                    this.addMatcher(new ClassMatcher(classMatch));
                }
            }
        } else if (qName.equals("Not")) {
            NotMatcher matcher = new NotMatcher();
            this.pushCompoundMatcherAsChild(matcher);
        }
        this.nextMatchedIsDisabled = false;
    }

    private void parseBugInstanceContents(String qName, Attributes attributes) throws SAXException {
        BugAnnotation bugAnnotation = null;
        if (qName.equals("Class")) {
            String className = this.getRequiredAttribute(attributes, "classname", qName);
            this.bugAnnotationWithSourceLines = new ClassAnnotation(className);
            bugAnnotation = this.bugAnnotationWithSourceLines;
        } else if (qName.equals("Type")) {
            String typeDescriptor = this.getRequiredAttribute(attributes, "descriptor", qName);
            TypeAnnotation typeAnnotation = new TypeAnnotation(typeDescriptor);
            this.bugAnnotationWithSourceLines = typeAnnotation;
            bugAnnotation = typeAnnotation;
            String typeParameters = this.getOptionalAttribute(attributes, "typeParameters");
            if (typeParameters != null) {
                typeAnnotation.setTypeParameters(Strings.unescapeXml(typeParameters));
            }
        } else if (qName.equals("Method") || qName.equals("Field")) {
            String classname = this.getRequiredAttribute(attributes, "classname", qName);
            String fieldOrMethodName = this.getRequiredAttribute(attributes, "name", qName);
            String signature = this.getRequiredAttribute(attributes, "signature", qName);
            if (qName.equals("Method")) {
                String isStatic = this.getOptionalAttribute(attributes, "isStatic");
                if (isStatic == null) {
                    isStatic = "false";
                }
                this.bugAnnotationWithSourceLines = new MethodAnnotation(classname, fieldOrMethodName, signature, Boolean.valueOf(isStatic));
                bugAnnotation = this.bugAnnotationWithSourceLines;
            } else {
                String isStatic = this.getRequiredAttribute(attributes, "isStatic", qName);
                this.bugAnnotationWithSourceLines = new FieldAnnotation(classname, fieldOrMethodName, signature, Boolean.valueOf(isStatic));
                bugAnnotation = this.bugAnnotationWithSourceLines;
            }
        } else if (qName.equals("SourceLine")) {
            SourceLineAnnotation sourceAnnotation = this.createSourceLineAnnotation(qName, attributes);
            if (!sourceAnnotation.isSynthetic()) {
                bugAnnotation = sourceAnnotation;
            }
        } else {
            String value;
            if (qName.equals("Int")) {
                try {
                    value = this.getRequiredAttribute(attributes, "value", qName);
                    bugAnnotation = new IntAnnotation(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    throw new SAXException("Bad integer value in Int");
                }
            }
            if (qName.equals("String")) {
                value = this.getRequiredAttribute(attributes, "value", qName);
                bugAnnotation = StringAnnotation.fromXMLEscapedString(value);
            } else {
                if (qName.equals("LocalVariable")) {
                    try {
                        String varName = this.getRequiredAttribute(attributes, "name", qName);
                        int register = Integer.parseInt(this.getRequiredAttribute(attributes, "register", qName));
                        int pc = Integer.parseInt(this.getRequiredAttribute(attributes, "pc", qName));
                        bugAnnotation = new LocalVariableAnnotation(varName, register, pc);
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("Invalid integer value in attribute of LocalVariable element");
                    }
                }
                if (qName.equals("Property")) {
                    String propName = this.getRequiredAttribute(attributes, "name", qName);
                    String propValue = this.getRequiredAttribute(attributes, "value", qName);
                    this.bugInstance.setProperty(propName, propValue);
                } else if (qName.equals("UserAnnotation")) {
                    String s = this.getOptionalAttribute(attributes, "designation");
                    if (s != null) {
                        this.bugInstance.setUserDesignationKey(s, null);
                    }
                    if ((s = this.getOptionalAttribute(attributes, "user")) != null) {
                        this.bugInstance.setUser(s);
                    }
                    if ((s = this.getOptionalAttribute(attributes, "timestamp")) != null) {
                        try {
                            long timestamp = Long.valueOf(s);
                            this.bugInstance.setUserAnnotationTimestamp(timestamp);
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                    if ((s = this.getOptionalAttribute(attributes, "needsSync")) == null || s.equals("false")) {
                        this.bugInstance.setUserAnnotationDirty(false);
                    }
                } else {
                    throw new SAXException("Unknown bug annotation named " + qName);
                }
            }
        }
        if (bugAnnotation != null) {
            String role = this.getOptionalAttribute(attributes, "role");
            if (role != null) {
                bugAnnotation.setDescription(role);
            }
            this.setAnnotationRole(attributes, bugAnnotation);
            this.bugInstance.add(bugAnnotation);
        }
    }

    private long parseLong(String s, long defaultValue) {
        long value;
        try {
            value = s != null ? Long.parseLong(s) : defaultValue;
        }
        catch (NumberFormatException e) {
            value = defaultValue;
        }
        return value;
    }

    private byte[] extractHash(String qName, Attributes attributes) throws SAXException {
        byte[] hash;
        String encodedHash = this.getRequiredAttribute(attributes, "value", qName);
        try {
            hash = ClassHash.stringToHash(encodedHash);
        }
        catch (IllegalArgumentException e) {
            throw new SAXException("Invalid class hash", e);
        }
        return hash;
    }

    private void setAnnotationRole(Attributes attributes, BugAnnotation bugAnnotation) {
        String role = this.getOptionalAttribute(attributes, "role");
        if (role != null) {
            bugAnnotation.setDescription(role);
        }
    }

    private SourceLineAnnotation createSourceLineAnnotation(String qName, Attributes attributes) throws SAXException {
        String classname = this.getRequiredAttribute(attributes, "classname", qName);
        String sourceFile = this.getOptionalAttribute(attributes, "sourcefile");
        if (sourceFile == null) {
            sourceFile = "<Unknown>";
        }
        String startLine = this.getOptionalAttribute(attributes, "start");
        String endLine = this.getOptionalAttribute(attributes, "end");
        String startBytecode = this.getOptionalAttribute(attributes, "startBytecode");
        String endBytecode = this.getOptionalAttribute(attributes, "endBytecode");
        String synthetic = this.getOptionalAttribute(attributes, "synthetic");
        try {
            int sl = startLine != null ? Integer.parseInt(startLine) : -1;
            int el = endLine != null ? Integer.parseInt(endLine) : -1;
            int sb = startBytecode != null ? Integer.parseInt(startBytecode) : -1;
            int eb = endBytecode != null ? Integer.parseInt(endBytecode) : -1;
            SourceLineAnnotation s = new SourceLineAnnotation(classname, sourceFile, sl, el, sb, eb);
            if ("true".equals(synthetic)) {
                s.setSynthetic(true);
            }
            return s;
        }
        catch (NumberFormatException e) {
            throw new SAXException("Bad integer value in SourceLine element", e);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this.discardedElement(qName)) {
            --this.nestingOfIgnoredElements;
        } else if (this.nestingOfIgnoredElements <= 0 && !qName.equals(PROJECT) && this.elementStack.size() > 1) {
            String outerElement = this.elementStack.get(this.elementStack.size() - 2);
            if (this.isTopLevelFilter(qName) || this.isCompoundElementTag(qName)) {
                if (DEBUG) {
                    System.out.println("  ending " + this.elementStack + " " + qName + " " + this.matcherStack);
                }
                this.matcherStack.pop();
            } else if (outerElement.equals(BUG_COLLECTION)) {
                BugCollection bugCollection = this.bugCollection;
                assert (bugCollection != null);
                if (qName.equals("BugInstance")) {
                    bugCollection.add(this.bugInstance, false);
                }
            } else if (outerElement.equals(PROJECT)) {
                Project project = this.project;
                assert (project != null);
                if (qName.equals("Jar")) {
                    project.addFile(this.makeAbsolute(this.getTextContents()));
                } else if (qName.equals("SrcDir")) {
                    project.addSourceDir(this.makeAbsolute(this.getTextContents()));
                } else if (qName.equals("AuxClasspathEntry")) {
                    project.addAuxClasspathEntry(this.makeAbsolute(this.getTextContents()));
                }
            } else if (outerElement.equals("Cloud") && qName.equals("Property")) {
                Project project = this.project;
                assert (project != null);
                assert (this.cloudPropertyKey != null);
                project.getCloudProperties().setProperty(this.cloudPropertyKey, this.getTextContents());
                this.cloudPropertyKey = null;
            } else if (outerElement.equals("BugInstance")) {
                if (qName.equals("UserAnnotation")) {
                    this.bugInstance.setAnnotationText(this.getTextContents(), null);
                }
            } else if (outerElement.equals("Errors")) {
                BugCollection bugCollection = this.bugCollection;
                assert (bugCollection != null);
                if (qName.equals("AnalysisError")) {
                    this.analysisError.setMessage(this.getTextContents());
                    bugCollection.addError(this.analysisError);
                } else if (qName.equals("Error")) {
                    if (this.stackTrace.size() > 0) {
                        this.analysisError.setStackTrace(this.stackTrace.toArray(new String[this.stackTrace.size()]));
                    }
                    bugCollection.addError(this.analysisError);
                } else if (qName.equals("MissingClass")) {
                    bugCollection.addMissingClass(this.getTextContents());
                }
            } else if (outerElement.equals("Error")) {
                if (qName.equals("ErrorMessage")) {
                    this.analysisError.setMessage(this.getTextContents());
                } else if (qName.equals("Exception")) {
                    this.analysisError.setExceptionMessage(this.getTextContents());
                } else if (qName.equals("StackTrace")) {
                    this.stackTrace.add(this.getTextContents());
                }
            } else if (outerElement.equals("ClassFeatures") && qName.equals("ClassFeatureSet")) {
                BugCollection bugCollection = this.bugCollection;
                assert (bugCollection != null);
                bugCollection.setClassFeatureSet(this.classFeatureSet);
                this.classFeatureSet = null;
            }
        }
        this.elementStack.remove(this.elementStack.size() - 1);
    }

    private String makeAbsolute(String possiblyRelativePath) {
        if (possiblyRelativePath.contains("://") || possiblyRelativePath.startsWith("http:") || possiblyRelativePath.startsWith("https:") || possiblyRelativePath.startsWith("file:")) {
            return possiblyRelativePath;
        }
        if (this.base == null) {
            return possiblyRelativePath;
        }
        if (new File(possiblyRelativePath).isAbsolute()) {
            return possiblyRelativePath;
        }
        return new File(this.base.getParentFile(), possiblyRelativePath).getAbsolutePath();
    }

    public void characters(char[] ch, int start, int length) {
        this.textBuffer.append(ch, start, length);
    }

    private String getRequiredAttribute(Attributes attributes, String attrName, String elementName) throws SAXException {
        String value = attributes.getValue(attrName);
        if (value == null) {
            throw new SAXException(elementName + " element missing " + attrName + " attribute");
        }
        return this.memoized(Strings.unescapeXml(value));
    }
}

