/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.LastVersionMatcher;
import edu.umd.cs.findbugs.gui2.AnalysisCallback;
import edu.umd.cs.findbugs.gui2.AnalyzingDialog;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBFileChooser;
import edu.umd.cs.findbugs.gui2.FindBugsAnalysisFileFilter;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.workflow.Update;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class BugLoader {
    private static UserPreferences preferencesSingleton = UserPreferences.createDefaultUserPreferences();

    static UserPreferences getUserPreferences() {
        return preferencesSingleton;
    }

    public static BugCollection doAnalysis(@Nonnull Project p, FindBugsProgress progressCallback) throws IOException, InterruptedException {
        StringWriter stringWriter = new StringWriter();
        BugCollectionBugReporter pcb = new BugCollectionBugReporter(p, new PrintWriter((Writer)stringWriter, true));
        pcb.setPriorityThreshold(2);
        IFindBugsEngine fb = BugLoader.createEngine(p, pcb);
        fb.setUserPreferences(BugLoader.getUserPreferences());
        fb.setProgressCallback(progressCallback);
        fb.setProjectName(p.getProjectName());
        fb.execute();
        String warnings = stringWriter.toString();
        if (warnings.length() > 0) {
            JTextArea tp = new JTextArea(warnings);
            tp.setEditable(false);
            JScrollPane pane = new JScrollPane(tp);
            pane.setPreferredSize(new Dimension(600, 400));
            JOptionPane.showMessageDialog(MainFrame.getInstance(), pane, "Analysis errors", 2);
        }
        return pcb.getBugCollection();
    }

    private static IFindBugsEngine createEngine(@Nonnull Project p, BugReporter pcb) {
        FindBugs2 engine = new FindBugs2();
        engine.setBugReporter(pcb);
        engine.setProject(p);
        engine.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        engine.setAnalysisFeatureSettings(Driver.getAnalysisSettingList());
        return engine;
    }

    @CheckForNull
    public static SortedBugCollection loadBugs(MainFrame mainFrame, Project project, File source) {
        if (!source.isFile() || !source.canRead()) {
            JOptionPane.showMessageDialog(mainFrame, "Unable to read " + source);
            return null;
        }
        SortedBugCollection col = new SortedBugCollection(project);
        try {
            col.readXML(source);
            BugLoader.initiateCommunication(col);
            if (col.hasDeadBugs()) {
                BugLoader.addDeadBugMatcher(col);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(mainFrame, "Could not read " + source + "; " + e.getMessage());
        }
        MainFrame.getInstance().setProjectAndBugCollectionInSwingThread(project, col);
        return col;
    }

    private static void initiateCommunication(SortedBugCollection col) {
        Cloud cloud = col.getCloud();
        if (cloud != null) {
            cloud.initiateCommunication();
        }
    }

    @CheckForNull
    public static SortedBugCollection loadBugs(MainFrame mainFrame, Project project, URL url) {
        SortedBugCollection col;
        block4: {
            col = new SortedBugCollection(project);
            try {
                if (MainFrame.GUI2_DEBUG) {
                    System.out.println("loading from: " + url);
                    JOptionPane.showMessageDialog(mainFrame, "loading from: " + url);
                }
                col.readXML(url);
                if (MainFrame.GUI2_DEBUG) {
                    System.out.println("finished reading: " + url);
                    JOptionPane.showMessageDialog(mainFrame, "loaded: " + url);
                }
                BugLoader.initiateCommunication(col);
                BugLoader.addDeadBugMatcher(col);
            }
            catch (Exception e) {
                String msg = SystemProperties.getOSDependentProperty("findbugs.unableToLoadViaURL");
                msg = msg == null ? e.getMessage() : String.format(msg, new Object[0]);
                JOptionPane.showMessageDialog(mainFrame, "Could not read " + url + "\n" + msg);
                if (!SystemProperties.getBoolean("findbugs.failIfUnableToLoadViaURL")) break block4;
                System.exit(1);
            }
        }
        MainFrame.getInstance().setProjectAndBugCollectionInSwingThread(project, col);
        return col;
    }

    static void addDeadBugMatcher(BugCollection bugCollection) {
        if (bugCollection == null || !bugCollection.hasDeadBugs()) {
            return;
        }
        Filter suppressionMatcher = bugCollection.getProject().getSuppressionFilter();
        if (suppressionMatcher != null) {
            suppressionMatcher.softAdd(LastVersionMatcher.DEAD_BUG_MATCHER);
        }
    }

    @CheckForNull
    public static Project loadProject(MainFrame mainFrame, File f) {
        try {
            Project project = Project.readXML(f);
            project.setGuiCallback(mainFrame.getGuiCallback());
            return project;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(mainFrame, "Could not read " + f + "; " + e.getMessage());
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(mainFrame, "Could not read  project from " + f + "; " + e.getMessage());
        }
        return null;
    }

    private BugLoader() {
        throw new UnsupportedOperationException();
    }

    public static BugCollection combineBugHistories() {
        try {
            FBFileChooser chooser = new FBFileChooser();
            chooser.setFileFilter(new FindBugsAnalysisFileFilter());
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(L10N.getLocalString("dlg.choose_xmls_ttl", "Choose All XML's To Combine"));
            if (chooser.showOpenDialog(MainFrame.getInstance()) == 1) {
                return null;
            }
            SortedBugCollection conglomeration = new SortedBugCollection();
            conglomeration.readXML(chooser.getSelectedFiles()[0]);
            Update update = new Update();
            for (int x = 1; x < chooser.getSelectedFiles().length; ++x) {
                File f = chooser.getSelectedFiles()[x];
                SortedBugCollection col = new SortedBugCollection();
                col.readXML(f);
                conglomeration = (SortedBugCollection)update.mergeCollections(conglomeration, col, false, false);
            }
            return conglomeration;
        }
        catch (IOException e) {
            Debug.println(e);
            return null;
        }
        catch (DocumentException e) {
            Debug.println((Exception)((Object)e));
            return null;
        }
    }

    @CheckForNull
    public static BugCollection doAnalysis(@Nonnull Project p) {
        if (p == null) {
            throw new NullPointerException("null project");
        }
        RedoAnalysisCallback ac = new RedoAnalysisCallback();
        new AnalyzingDialog(p, ac, true);
        if (ac.finished) {
            return ac.getBugCollection();
        }
        return null;
    }

    @CheckForNull
    public static BugCollection redoAnalysisKeepComments(@Nonnull Project p) {
        if (p == null) {
            throw new NullPointerException("null project");
        }
        BugCollection current = MainFrame.getInstance().getBugCollection();
        Update update = new Update();
        RedoAnalysisCallback ac = new RedoAnalysisCallback();
        new AnalyzingDialog(p, ac, true);
        if (!ac.finished) {
            return null;
        }
        if (current == null) {
            current = ac.getBugCollection();
        } else if ((current = update.mergeCollections(current, ac.getBugCollection(), true, false)).hasDeadBugs()) {
            BugLoader.addDeadBugMatcher(current);
        }
        return current;
    }

    private static class RedoAnalysisCallback
    implements AnalysisCallback {
        BugCollection justAnalyzed;
        volatile boolean finished;

        private RedoAnalysisCallback() {
        }

        BugCollection getBugCollection() {
            return this.justAnalyzed;
        }

        public void analysisFinished(BugCollection b) {
            this.justAnalyzed = b;
            this.finished = true;
        }

        public void analysisInterrupted() {
            this.finished = false;
        }
    }
}

