/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassNotFoundExceptionParser;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBugReporter
implements BugReporter {
    private static final boolean DEBUG = SystemProperties.getBoolean("abreporter.debug");
    private static final boolean DEBUG_MISSING_CLASSES = SystemProperties.getBoolean("findbugs.debug.missingclasses");
    private int verbosityLevel = 1;
    private int priorityThreshold;
    private int rankThreshold = 20;
    private boolean relaxedSet;
    private boolean relaxed;
    private int errorCount;
    private final Set<String> missingClassMessageList = new LinkedHashSet<String>();
    private final Set<Error> errorSet = new HashSet<Error>();
    private final List<BugReporterObserver> observerList = new LinkedList<BugReporterObserver>();
    private final ProjectStats projectStats = new ProjectStats();

    @Override
    public void setErrorVerbosity(int level) {
        this.verbosityLevel = level;
    }

    @Override
    public void setPriorityThreshold(int threshold) {
        this.priorityThreshold = threshold;
    }

    public void setRankThreshold(int threshold) {
        this.rankThreshold = threshold;
    }

    public void setIsRelaxed(boolean relaxed) {
        this.relaxed = relaxed;
        this.relaxedSet = true;
    }

    protected boolean isRelaxed() {
        if (!this.relaxedSet) {
            if (FindBugsAnalysisFeatures.isRelaxedMode()) {
                this.relaxed = true;
            }
            this.relaxedSet = true;
        }
        return this.relaxed;
    }

    @Override
    public final void reportBug(@Nonnull BugInstance bugInstance) {
        if (this.isRelaxed()) {
            this.doReportBug(bugInstance);
            return;
        }
        if (this.priorityThreshold == 0) {
            throw new IllegalStateException("Priority threshold not set");
        }
        ClassAnnotation primaryClass = bugInstance.getPrimaryClass();
        if (primaryClass != null && !AnalysisContext.currentAnalysisContext().isApplicationClass(primaryClass.getClassName())) {
            if (DEBUG) {
                System.out.println("AbstractBugReporter: Filtering due to non-primary class");
            }
            return;
        }
        int priority = bugInstance.getPriority();
        int bugRank = bugInstance.getBugRank();
        if (priority <= this.priorityThreshold && bugRank <= this.rankThreshold) {
            this.doReportBug(bugInstance);
        } else if (DEBUG) {
            if (priority <= this.priorityThreshold) {
                System.out.println("AbstractBugReporter: Filtering due to priorityThreshold " + priority + " > " + this.priorityThreshold);
            } else {
                System.out.println("AbstractBugReporter: Filtering due to rankThreshold " + bugRank + " > " + this.rankThreshold);
            }
        }
    }

    public final void reportBugsFromXml(@WillClose InputStream in, Project theProject) throws IOException, DocumentException {
        SortedBugCollection theCollection = new SortedBugCollection(theProject);
        theCollection.readXML(in);
        for (BugInstance bug : theCollection.getCollection()) {
            this.doReportBug(bug);
        }
    }

    @CheckForNull
    @DottedClassName
    public static String getMissingClassName(ClassNotFoundException ex) {
        String className = ClassNotFoundExceptionParser.getMissingClassName(ex);
        if (className != null) {
            ClassName.assertIsDotted(className);
            return className;
        }
        return null;
    }

    @Override
    public void reportMissingClass(ClassNotFoundException ex) {
        if (DEBUG_MISSING_CLASSES) {
            System.out.println("Missing class: " + ex.toString());
            ex.printStackTrace(System.out);
        }
        if (this.verbosityLevel == 0) {
            return;
        }
        this.logMissingClass(AbstractBugReporter.getMissingClassName(ex));
    }

    protected static final boolean isValidMissingClassMessage(String message) {
        if (message == null) {
            return false;
        }
        if ((message = message.trim()).startsWith("[")) {
            return false;
        }
        if (message.equals("")) {
            return false;
        }
        if (message.endsWith(".package-info")) {
            return false;
        }
        return !message.equals("java.lang.Synthetic");
    }

    @Override
    public void reportMissingClass(ClassDescriptor classDescriptor) {
        if (DEBUG_MISSING_CLASSES) {
            System.out.println("Missing class: " + classDescriptor);
            new Throwable().printStackTrace(System.out);
        }
        if (this.verbosityLevel == 0) {
            return;
        }
        this.logMissingClass(classDescriptor.toDottedClassName());
    }

    private void logMissingClass(String message) {
        if (!AbstractBugReporter.isValidMissingClassMessage(message)) {
            return;
        }
        this.missingClassMessageList.add(message);
    }

    @Override
    public void reportSkippedAnalysis(MethodDescriptor method) {
    }

    @Override
    public void logError(String message) {
        Error error;
        if (this.verbosityLevel == 0) {
            return;
        }
        if (!this.errorSet.contains(error = new Error(this.errorCount++, message))) {
            this.errorSet.add(error);
        }
    }

    protected Set<Error> getQueuedErrors() {
        return this.errorSet;
    }

    protected Set<String> getMissingClasses() {
        return this.missingClassMessageList;
    }

    @Override
    public void logError(String message, Throwable e) {
        Error error;
        if (e instanceof MethodUnprofitableException) {
            return;
        }
        if (e instanceof edu.umd.cs.findbugs.classfile.MissingClassException) {
            edu.umd.cs.findbugs.classfile.MissingClassException e2 = (edu.umd.cs.findbugs.classfile.MissingClassException)e;
            this.reportMissingClass(e2.getClassDescriptor());
            return;
        }
        if (e instanceof MissingClassException) {
            MissingClassException missingClassEx = (MissingClassException)e;
            ClassNotFoundException cnfe = missingClassEx.getClassNotFoundException();
            this.reportMissingClass(cnfe);
            return;
        }
        if (this.verbosityLevel == 0) {
            return;
        }
        if (!this.errorSet.contains(error = new Error(this.errorCount++, message, e))) {
            this.errorSet.add(error);
        }
    }

    @Override
    public void reportQueuedErrors() {
        Error[] errorList = this.errorSet.toArray(new Error[this.errorSet.size()]);
        Arrays.sort(errorList, new Comparator<Error>(){

            @Override
            public int compare(Error o1, Error o2) {
                return o1.getSequence() - o2.getSequence();
            }
        });
        for (Error error : errorList) {
            this.reportAnalysisError(new AnalysisError(error.getMessage(), error.getCause()));
        }
        for (String aMissingClassMessageList : this.missingClassMessageList) {
            this.reportMissingClass(aMissingClassMessageList);
        }
    }

    @Override
    public void addObserver(BugReporterObserver observer) {
        this.observerList.add(observer);
    }

    @Override
    public ProjectStats getProjectStats() {
        return this.projectStats;
    }

    protected void notifyObservers(BugInstance bugInstance) {
        for (BugReporterObserver aObserverList : this.observerList) {
            aObserverList.reportBug(bugInstance);
        }
    }

    protected abstract void doReportBug(BugInstance var1);

    public abstract void reportAnalysisError(AnalysisError var1);

    public abstract void reportMissingClass(String var1);

    protected static class Error {
        private final int sequence;
        private final String message;
        private final Throwable cause;

        public Error(int sequence, String message) {
            this(sequence, message, null);
        }

        public Error(int sequence, String message, Throwable cause) {
            this.sequence = sequence;
            this.message = message;
            this.cause = cause;
        }

        public int getSequence() {
            return this.sequence;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public int hashCode() {
            int hashCode = this.message.hashCode();
            if (this.cause != null) {
                hashCode += 1009 * this.cause.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Error other = (Error)obj;
            if (!this.message.equals(other.message)) {
                return false;
            }
            if (this.cause == other.cause) {
                return true;
            }
            if (this.cause == null || other.cause == null) {
                return false;
            }
            return this.cause.equals(other.cause);
        }
    }
}

