/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BugRankCategory {
    SCARIEST(4),
    SCARY(9),
    TROUBLING(14),
    OF_CONCERN(20);

    public final int maxRank;

    @Nonnull
    public static BugRankCategory getRank(int rank) {
        for (BugRankCategory c : BugRankCategory.values()) {
            if (rank > c.maxRank) continue;
            return c;
        }
        throw new IllegalArgumentException("Rank of " + rank + " is outside legal rank");
    }

    private BugRankCategory(int maxRank) {
        this.maxRank = maxRank;
    }

    public String toString() {
        if (this == OF_CONCERN) {
            return "Of Concern";
        }
        return this.name().substring(0, 1) + this.name().toLowerCase().substring(1, this.name().length());
    }
}

