/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.RecursiveFileSearch;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.ClassNotFoundExceptionParser;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IClassFactory;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IClassPathBuilder;
import edu.umd.cs.findbugs.classfile.IClassPathBuilderProgress;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParserUsingASM;
import edu.umd.cs.findbugs.classfile.impl.ClassFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverSourceDirectories {
    private static boolean DEBUG = SystemProperties.getBoolean("findbugs.dsd.debug");
    private Project project;
    private String rootSourceDirectory;
    private boolean scanForNestedArchives;
    private IErrorLogger errorLogger = new NoOpErrorLogger();
    private Progress progress = new NoOpProgress();
    private final List<String> discoveredSourceDirectoryList = new LinkedList<String>();

    public void setProject(Project project) {
        this.project = project;
    }

    public void setRootSourceDirectory(String rootSourceDirectory) {
        this.rootSourceDirectory = rootSourceDirectory;
    }

    public void setScanForNestedArchives(boolean scanForNestedArchives) {
        this.scanForNestedArchives = scanForNestedArchives;
    }

    public void setErrorLogger(IErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public List<String> getDiscoveredSourceDirectoryList() {
        return Collections.unmodifiableList(this.discoveredSourceDirectoryList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws CheckedAnalysisException, IOException, InterruptedException {
        File dir = new File(this.rootSourceDirectory);
        if (!dir.isDirectory()) {
            throw new IOException("Path " + this.rootSourceDirectory + " is not a directory");
        }
        this.progress.startRecursiveDirectorySearch();
        RecursiveFileSearch rfs = new RecursiveFileSearch(this.rootSourceDirectory, new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        rfs.search();
        this.progress.doneRecursiveDirectorySearch();
        List<String> candidateSourceDirList = rfs.getDirectoriesScanned();
        IClassPath classPath = null;
        try {
            IClassFactory factory = ClassFactory.instance();
            IClassPathBuilder builder = factory.createClassPathBuilder(this.errorLogger);
            classPath = this.buildClassPath(builder, factory);
            List<String> fullyQualifiedSourceFileNameList = this.findFullyQualifiedSourceFileNames(builder, classPath);
            if (DEBUG) {
                System.out.println("looking for " + fullyQualifiedSourceFileNameList.size() + " files");
            }
            this.findSourceDirectoriesForAllSourceFiles(fullyQualifiedSourceFileNameList, candidateSourceDirList);
        }
        finally {
            if (classPath != null) {
                classPath.close();
            }
        }
    }

    private IClassPath buildClassPath(IClassPathBuilder builder, IClassFactory factory) throws InterruptedException, IOException, CheckedAnalysisException {
        this.progress.startScanningArchives(this.project.getFileCount());
        for (String path : this.project.getFileList()) {
            builder.addCodeBase(factory.createFilesystemCodeBaseLocator(path), true);
        }
        for (String path : this.project.getAuxClasspathEntryList()) {
            builder.addCodeBase(factory.createFilesystemCodeBaseLocator(path), false);
        }
        IClassPath classPath = factory.createClassPath();
        builder.build(classPath, this.progress);
        this.progress.doneScanningArchives();
        return classPath;
    }

    private String findFullyQualifiedSourceFileName(IClassPath classPath, ClassDescriptor classDesc) throws IOException, CheckedAnalysisException {
        try {
            String fullyQualifiedSourceFile;
            ICodeBaseEntry codeBaseEntry = classPath.lookupResource(classDesc.toResourceName());
            ClassParserUsingASM classParser = new ClassParserUsingASM(new ClassReader(codeBaseEntry.openResource()), classDesc, codeBaseEntry);
            ClassInfo.Builder classInfoBuilder = new ClassInfo.Builder();
            classParser.parse(classInfoBuilder);
            ClassInfo classInfo = classInfoBuilder.build();
            String packageName = classDesc.getPackageName();
            String sourceFile = classInfo.getSource();
            if (!packageName.equals("")) {
                packageName = packageName.replace('.', '/');
                packageName = packageName + "/";
            }
            String string = fullyQualifiedSourceFile = packageName + sourceFile;
            return string;
        }
        catch (CheckedAnalysisException e) {
            this.errorLogger.logError("Could scan class " + classDesc.toDottedClassName(), e);
            throw e;
        }
        finally {
            this.progress.finishClass();
        }
    }

    private List<String> findFullyQualifiedSourceFileNames(IClassPathBuilder builder, IClassPath classPath) {
        List<ClassDescriptor> appClassList = builder.getAppClassList();
        this.progress.startScanningClasses(appClassList.size());
        LinkedList<String> fullyQualifiedSourceFileNameList = new LinkedList<String>();
        for (ClassDescriptor classDesc : appClassList) {
            try {
                String fullyQualifiedSourceFileName = this.findFullyQualifiedSourceFileName(classPath, classDesc);
                fullyQualifiedSourceFileNameList.add(fullyQualifiedSourceFileName);
            }
            catch (IOException e) {
                this.errorLogger.logError("Couldn't scan class " + classDesc.toDottedClassName(), e);
            }
            catch (CheckedAnalysisException e) {
                this.errorLogger.logError("Couldn't scan class " + classDesc.toDottedClassName(), e);
            }
        }
        this.progress.doneScanningClasses();
        return fullyQualifiedSourceFileNameList;
    }

    private void findSourceDirectoriesForAllSourceFiles(List<String> fullyQualifiedSourceFileNameList, List<String> candidateSourceDirList) {
        HashSet<String> sourceDirsFound = new HashSet<String>();
        block0: for (String fullyQualifiedSourceFileName : fullyQualifiedSourceFileNameList) {
            for (String candidateSourceDir : candidateSourceDirList) {
                boolean found;
                String path = candidateSourceDir + File.separatorChar + fullyQualifiedSourceFileName;
                File f = new File(path);
                if (DEBUG) {
                    System.out.print("Checking " + f.getPath() + "...");
                }
                boolean bl = found = f.exists() && !f.isDirectory();
                if (DEBUG) {
                    System.out.println(found ? "FOUND" : "not found");
                }
                if (!found) continue;
                if (!sourceDirsFound.add(candidateSourceDir)) continue block0;
                this.discoveredSourceDirectoryList.add(candidateSourceDir);
                sourceDirsFound.add(candidateSourceDir);
                continue block0;
            }
        }
    }

    public static void main(String[] args) throws IOException, CheckedAnalysisException, InterruptedException {
        if (args.length != 2) {
            System.err.println("Usage: " + DiscoverSourceDirectories.class.getName() + " <project file> <root source dir>");
            System.exit(1);
        }
        Project project = Project.readProject(args[0]);
        IErrorLogger errorLogger = new IErrorLogger(){

            public void reportMissingClass(ClassNotFoundException ex) {
                String className = ClassNotFoundExceptionParser.getMissingClassName(ex);
                if (className != null) {
                    this.logError("Missing class: " + className);
                } else {
                    this.logError("Missing class: " + ex);
                }
            }

            public void reportMissingClass(ClassDescriptor classDescriptor) {
                this.logError("Missing class: " + classDescriptor.toDottedClassName());
            }

            public void logError(String message) {
                System.err.println("Error: " + message);
            }

            public void logError(String message, Throwable e) {
                this.logError(message + ": " + e.getMessage());
            }

            public void reportSkippedAnalysis(MethodDescriptor method) {
                this.logError("Skipped analysis of method " + method.toString());
            }
        };
        Progress progress = new Progress(){

            public void startRecursiveDirectorySearch() {
                System.out.print("Scanning directories...");
                System.out.flush();
            }

            public void doneRecursiveDirectorySearch() {
                System.out.println("done");
            }

            public void startScanningArchives(int numArchivesToScan) {
                System.out.print("Scanning " + numArchivesToScan + " archives..");
                System.out.flush();
            }

            public void doneScanningArchives() {
                System.out.println("done");
            }

            public void startScanningClasses(int numClassesToScan) {
                System.out.print("Scanning " + numClassesToScan + " classes...");
                System.out.flush();
            }

            public void finishClass() {
                System.out.print(".");
                System.out.flush();
            }

            public void doneScanningClasses() {
                System.out.println("done");
            }

            public void finishArchive() {
                System.out.print(".");
                System.out.flush();
            }

            public void startArchive(String name) {
            }
        };
        DiscoverSourceDirectories discoverSourceDirectories = new DiscoverSourceDirectories();
        discoverSourceDirectories.setProject(project);
        discoverSourceDirectories.setRootSourceDirectory(args[1]);
        discoverSourceDirectories.setErrorLogger(errorLogger);
        discoverSourceDirectories.setProgress(progress);
        discoverSourceDirectories.execute();
        System.out.println("Found source directories:");
        for (String srcDir : discoverSourceDirectories.getDiscoveredSourceDirectoryList()) {
            System.out.println("  " + srcDir);
        }
    }

    private static class NoOpProgress
    implements Progress {
        private NoOpProgress() {
        }

        public void startScanningArchives(int numArchivesToScan) {
        }

        public void doneScanningArchives() {
        }

        public void startScanningClasses(int numClassesToScan) {
        }

        public void finishClass() {
        }

        public void doneScanningClasses() {
        }

        public void finishArchive() {
        }

        public void startRecursiveDirectorySearch() {
        }

        public void doneRecursiveDirectorySearch() {
        }

        public void startArchive(String name) {
        }
    }

    private static class NoOpErrorLogger
    implements IErrorLogger {
        private NoOpErrorLogger() {
        }

        public void reportMissingClass(ClassNotFoundException ex) {
        }

        public void reportMissingClass(ClassDescriptor classDescriptor) {
        }

        public void logError(String message) {
        }

        public void logError(String message, Throwable e) {
        }

        public void reportSkippedAnalysis(MethodDescriptor method) {
        }
    }

    public static interface Progress
    extends IClassPathBuilderProgress {
        public void startRecursiveDirectorySearch();

        public void doneRecursiveDirectorySearch();

        public void startScanningArchives(int var1);

        public void doneScanningArchives();

        public void startScanningClasses(int var1);

        public void finishClass();

        public void doneScanningClasses();
    }
}

