/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisCacheToRepositoryAdapter;
import edu.umd.cs.findbugs.AnalysisLocal;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SuppressionMatcher;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisFeatures;
import edu.umd.cs.findbugs.ba.AnnotationRetentionDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnAnnotationDatabase;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassSummary;
import edu.umd.cs.findbugs.ba.EqualsKindSummary;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.InnerClassAccessMap;
import edu.umd.cs.findbugs.ba.JCIPAnnotationDatabase;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import edu.umd.cs.findbugs.ba.jsr305.DirectlyRelevantTypeQualifiersDatabase;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.ReturnValueNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.TypeQualifierNullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.detect.UnreadFields;
import edu.umd.cs.findbugs.detect.UnreadFieldsData;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import net.jcip.annotations.NotThreadSafe;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class AnalysisContext {
    public static final boolean DEBUG = SystemProperties.getBoolean("findbugs.analysiscontext.debug");
    public static final boolean IGNORE_BUILTIN_MODELS = SystemProperties.getBoolean("findbugs.ignoreBuiltinModels");
    public static final String DEFAULT_NONNULL_PARAM_DATABASE_FILENAME = "nonnullParam.db";
    public static final String DEFAULT_CHECK_FOR_NULL_PARAM_DATABASE_FILENAME = "checkForNullParam.db";
    public static final String DEFAULT_NULL_RETURN_VALUE_ANNOTATION_DATABASE = "nullReturn.db";
    public static final String UNCONDITIONAL_DEREF_DB_FILENAME = "unconditionalDeref.db";
    public static final String NONNULL_RETURN_DB_FILENAME = "nonnullReturn.db";
    public static final String UNCONDITIONAL_DEREF_DB_RESOURCE = "jdkBaseUnconditionalDeref.db";
    public static final String NONNULL_RETURN_DB_RESOURCE = "jdkBaseNonnullReturn.db";
    public static final String DEFAULT_NULL_RETURN_VALUE_DB_FILENAME = "mayReturnNull.db";
    private static InheritableThreadLocal<AnalysisContext> currentAnalysisContext = new InheritableThreadLocal<AnalysisContext>(){

        @Override
        public AnalysisContext initialValue() {
            return null;
        }
    };
    private static AnalysisLocal<XFactory> currentXFactory = new AnalysisLocal<XFactory>(){

        @Override
        public XFactory initialValue() {
            throw new IllegalStateException("currentXFactory should be set by AnalysisContext.setCurrentAnalysisContext");
        }
    };
    private static final org.apache.bcel.util.Repository originalRepository = Repository.getRepository();
    private static final int DEFAULT_CACHE_SIZE = 3;
    private BitSet boolPropertySet;
    private String databaseInputDir;
    private String databaseOutputDir;
    ClassSummary classSummary;
    ClassDescriptor classBeingAnalyzed;
    final EqualsKindSummary equalsKindSummary = new EqualsKindSummary();
    FieldSummary fieldSummary;
    final UnreadFieldsData unreadFieldsData = new UnreadFieldsData();
    UnreadFields unreadFields;
    boolean missingClassWarningsSuppressed = false;
    protected Project project;
    private final SuppressionMatcher suppressionMatcher = new SuppressionMatcher();
    private TypeQualifierNullnessAnnotationDatabase tqNullnessDatabase;
    protected final RepositoryLookupFailureCallback lookupFailureCallback;
    final Map<MethodInfo, MethodInfo> bridgeTo = new IdentityHashMap<MethodInfo, MethodInfo>();
    final Map<MethodInfo, MethodInfo> bridgeFrom = new IdentityHashMap<MethodInfo, MethodInfo>();

    public AnalysisContext() {
        this.boolPropertySet = new BitSet();
        this.lookupFailureCallback = new DelegatingRepositoryLookupFailureCallback();
    }

    private void clear() {
        this.boolPropertySet = null;
        this.databaseInputDir = null;
        this.databaseOutputDir = null;
    }

    public static AnalysisContext currentAnalysisContext() {
        return (AnalysisContext)currentAnalysisContext.get();
    }

    public static XFactory currentXFactory() {
        return currentXFactory.get();
    }

    public ClassDescriptor getClassBeingAnalyzed() {
        return this.classBeingAnalyzed;
    }

    public void setClassBeingAnalyzed(@Nonnull ClassDescriptor classBeingAnalyzed) {
        this.classBeingAnalyzed = classBeingAnalyzed;
    }

    public void clearClassBeingAnalyzed() {
        this.classBeingAnalyzed = null;
    }

    public ClassSummary getClassSummary() {
        if (this.classSummary == null) {
            throw new IllegalStateException("ClassSummary not set");
        }
        return this.classSummary;
    }

    public void setClassSummary(@Nonnull ClassSummary classSummary) {
        if (this.classSummary != null) {
            throw new IllegalStateException("ClassSummary already set");
        }
        this.classSummary = classSummary;
    }

    public EqualsKindSummary getEqualsKindSummary() {
        return this.equalsKindSummary;
    }

    public FieldSummary getFieldSummary() {
        if (this.fieldSummary == null) {
            AnalysisContext.logError("Field Summary not set", new IllegalStateException());
            this.fieldSummary = new FieldSummary();
        }
        return this.fieldSummary;
    }

    public void setFieldSummary(@Nonnull FieldSummary fieldSummary) {
        if (this.fieldSummary != null) {
            AnalysisContext.logError("Field Summary already set", new IllegalStateException());
        }
        this.fieldSummary = fieldSummary;
    }

    @Nonnull
    public UnreadFieldsData getUnreadFieldsData() {
        return this.unreadFieldsData;
    }

    @Nonnull
    public UnreadFields getUnreadFields() {
        if (this.unreadFieldsAvailable()) {
            throw new IllegalStateException();
        }
        return this.unreadFields;
    }

    public boolean unreadFieldsAvailable() {
        return this.unreadFields != null;
    }

    public void setUnreadFields(@Nonnull UnreadFields unreadFields) {
        if (this.unreadFields != null) {
            throw new IllegalStateException("UnreadFields detector already set");
        }
        this.unreadFields = unreadFields;
    }

    private static boolean skipReportingMissingClass(@CheckForNull @DottedClassName String missing) {
        return missing == null || missing.length() == 0 || missing.charAt(0) == '[' || missing.endsWith("package-info");
    }

    @CheckForNull
    private static RepositoryLookupFailureCallback getCurrentLookupFailureCallback() {
        AnalysisContext currentAnalysisContext2 = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext2 == null) {
            return null;
        }
        if (currentAnalysisContext2.missingClassWarningsSuppressed) {
            return null;
        }
        return currentAnalysisContext2.getLookupFailureCallback();
    }

    public static void reportMissingClass(ClassNotFoundException e) {
        if (e == null) {
            throw new NullPointerException("argument is null");
        }
        String missing = AbstractBugReporter.getMissingClassName(e);
        if (AnalysisContext.skipReportingMissingClass(missing)) {
            return;
        }
        if (!AnalysisContext.analyzingApplicationClass()) {
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = AnalysisContext.getCurrentLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.reportMissingClass(e);
        }
    }

    public static void reportMissingClass(MissingClassException e) {
        if (e == null) {
            throw new NullPointerException("argument is null");
        }
        AnalysisContext.reportMissingClass(e.getClassDescriptor());
    }

    public static boolean analyzingApplicationClass() {
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        if (context == null) {
            return false;
        }
        ClassDescriptor clazz = context.getClassBeingAnalyzed();
        if (clazz == null) {
            return false;
        }
        return context.isApplicationClass(clazz);
    }

    public static void reportMissingClass(edu.umd.cs.findbugs.classfile.MissingClassException e) {
        if (e == null) {
            throw new NullPointerException("argument is null");
        }
        AnalysisContext.reportMissingClass(e.getClassDescriptor());
    }

    public static void reportMissingClass(ClassDescriptor c) {
        if (c == null) {
            throw new NullPointerException("argument is null");
        }
        if (!AnalysisContext.analyzingApplicationClass()) {
            return;
        }
        String missing = c.getDottedClassName();
        if (missing.length() == 1) {
            System.out.println(c);
        }
        if (AnalysisContext.skipReportingMissingClass(missing)) {
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = AnalysisContext.getCurrentLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.reportMissingClass(c);
        }
    }

    public static void logError(String msg, Exception e) {
        AnalysisContext currentAnalysisContext2 = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext2 == null) {
            if (e instanceof BugInstance.NoSuchBugPattern) {
                return;
            }
            e.printStackTrace(System.err);
            return;
        }
        if (e instanceof MissingClassException) {
            AnalysisContext.reportMissingClass(((MissingClassException)e).getClassNotFoundException());
            return;
        }
        if (e instanceof edu.umd.cs.findbugs.classfile.MissingClassException) {
            AnalysisContext.reportMissingClass(((edu.umd.cs.findbugs.classfile.MissingClassException)e).toClassNotFoundException());
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = currentAnalysisContext2.getLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.logError(msg, e);
        }
    }

    public static void logError(String msg) {
        AnalysisContext currentAnalysisContext2 = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext2 == null) {
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = currentAnalysisContext2.getLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.logError(msg);
        }
    }

    public boolean setMissingClassWarningsSuppressed(boolean value) {
        boolean oldValue = this.missingClassWarningsSuppressed;
        this.missingClassWarningsSuppressed = value;
        return oldValue;
    }

    public final void setProject(Project project) {
        this.project = project;
    }

    public boolean isApplicationClass(JavaClass cls) {
        return this.getSubtypes2().isApplicationClass(DescriptorFactory.createClassDescriptor(cls));
    }

    public boolean isApplicationClass(@DottedClassName String className) {
        ClassDescriptor classDesc = DescriptorFactory.createClassDescriptorFromDottedClassName(className);
        return this.getSubtypes2().isApplicationClass(classDesc);
    }

    public boolean isApplicationClass(ClassDescriptor desc) {
        return this.getSubtypes2().isApplicationClass(desc);
    }

    public int getClassSize(ClassDescriptor desc) {
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        try {
            ClassContext classContext = analysisCache.getClassAnalysis(ClassContext.class, desc);
            ClassData classData = analysisCache.getClassAnalysis(ClassData.class, desc);
            return classData.getData().length;
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error getting class data for " + desc, e);
            return 10000;
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Could not get class context for " + desc, e);
            return 10000;
        }
    }

    public boolean isTooBig(ClassDescriptor desc) {
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        try {
            ClassContext classContext = analysisCache.getClassAnalysis(ClassContext.class, desc);
            ClassData classData = analysisCache.getClassAnalysis(ClassData.class, desc);
            if (classData.getData().length > 1000000) {
                return true;
            }
            try {
                JavaClass javaClass = classContext.getJavaClass();
                if (javaClass.getMethods().length > 1000) {
                    return true;
                }
            }
            catch (RuntimeException e) {
                AnalysisContext.logError("Error parsing class " + desc + " from " + classData.getCodeBaseEntry().getCodeBase(), e);
                return true;
            }
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error getting class data for " + desc, e);
            return true;
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Could not get class context for " + desc, e);
            return true;
        }
        return false;
    }

    public JavaClass lookupClass(@Nonnull ClassDescriptor classDescriptor) throws ClassNotFoundException {
        return this.lookupClass(classDescriptor.toDottedClassName());
    }

    public static JavaClass lookupSystemClass(@Nonnull String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (originalRepository == null) {
            throw new IllegalStateException("originalRepository is null");
        }
        JavaClass clazz = originalRepository.findClass(className);
        return clazz == null ? originalRepository.loadClass(className) : clazz;
    }

    public final String lookupSourceFile(@Nonnull @DottedClassName String dottedClassName) {
        if (dottedClassName == null) {
            throw new IllegalArgumentException("className is null");
        }
        try {
            XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, DescriptorFactory.createClassDescriptorFromDottedClassName(dottedClassName));
            String name = xClass.getSource();
            if (name == null) {
                return "<Unknown>";
            }
            return name;
        }
        catch (CheckedAnalysisException e) {
            return "<Unknown>";
        }
    }

    public final void loadInterproceduralDatabases() {
        this.loadPropertyDatabase(this.getFieldStoreTypeDatabase(), "fieldStoreTypes.db", "field store type database");
        this.loadPropertyDatabase(this.getUnconditionalDerefParamDatabase(), UNCONDITIONAL_DEREF_DB_FILENAME, "unconditional param deref database");
        this.loadPropertyDatabase(this.getReturnValueNullnessPropertyDatabase(), NONNULL_RETURN_DB_FILENAME, "nonnull return db database");
    }

    public final void loadDefaultInterproceduralDatabases() {
        if (IGNORE_BUILTIN_MODELS) {
            return;
        }
        this.loadPropertyDatabaseFromResource(this.getUnconditionalDerefParamDatabase(), UNCONDITIONAL_DEREF_DB_RESOURCE, "unconditional param deref database");
        this.loadPropertyDatabaseFromResource(this.getReturnValueNullnessPropertyDatabase(), NONNULL_RETURN_DB_RESOURCE, "nonnull return db database");
    }

    public final void setBoolProperty(@AnalysisFeatures.AnalysisFeature int prop, boolean value) {
        this.boolPropertySet.set(prop, value);
    }

    public final boolean getBoolProperty(@AnalysisFeatures.AnalysisFeature int prop) {
        return this.boolPropertySet.get(prop);
    }

    public final void setDatabaseInputDir(String databaseInputDir) {
        if (DEBUG) {
            System.out.println("Setting database input directory: " + databaseInputDir);
        }
        this.databaseInputDir = databaseInputDir;
    }

    public final String getDatabaseInputDir() {
        return this.databaseInputDir;
    }

    public final void setDatabaseOutputDir(String databaseOutputDir) {
        if (DEBUG) {
            System.out.println("Setting database output directory: " + databaseOutputDir);
        }
        this.databaseOutputDir = databaseOutputDir;
    }

    public final String getDatabaseOutputDir() {
        return this.databaseOutputDir;
    }

    public <DatabaseType extends PropertyDatabase<KeyType, Property>, KeyType extends FieldOrMethodDescriptor, Property> DatabaseType loadPropertyDatabase(DatabaseType database, String fileName, String description) {
        try {
            File dbFile = new File(this.getDatabaseInputDir(), fileName);
            if (DEBUG) {
                System.out.println("Loading " + description + " from " + dbFile.getPath() + "...");
            }
            database.readFromFile(dbFile.getPath());
            return database;
        }
        catch (IOException e) {
            this.getLookupFailureCallback().logError("Error loading " + description, e);
        }
        catch (PropertyDatabaseFormatException e) {
            this.getLookupFailureCallback().logError("Invalid " + description, e);
        }
        return null;
    }

    public <DatabaseType extends PropertyDatabase<KeyType, Property>, KeyType extends FieldOrMethodDescriptor, Property> DatabaseType loadPropertyDatabaseFromResource(DatabaseType database, String resourceName, String description) {
        try {
            InputStream in;
            if (DEBUG) {
                System.out.println("Loading default " + description + " from " + resourceName + " @ " + database.getClass().getResource(resourceName) + " ... ");
            }
            if ((in = database.getClass().getResourceAsStream(resourceName)) == null) {
                AnalysisContext.logError("Unable to load " + description + " from resource " + resourceName);
            } else {
                database.read(in);
                in.close();
            }
            return database;
        }
        catch (IOException e) {
            this.getLookupFailureCallback().logError("Error loading " + description, e);
        }
        catch (PropertyDatabaseFormatException e) {
            this.getLookupFailureCallback().logError("Invalid " + description, e);
        }
        return null;
    }

    public <DatabaseType extends PropertyDatabase<KeyType, Property>, KeyType extends FieldOrMethodDescriptor, Property> void storePropertyDatabase(DatabaseType database, String fileName, String description) {
        try {
            File dbFile = new File(this.getDatabaseOutputDir(), fileName);
            if (DEBUG) {
                System.out.println("Writing " + description + " to " + dbFile.getPath() + "...");
            }
            database.writeToFile(dbFile.getPath());
        }
        catch (IOException e) {
            this.getLookupFailureCallback().logError("Error writing " + description, e);
        }
    }

    public static void setCurrentAnalysisContext(AnalysisContext analysisContext) {
        currentAnalysisContext.set(analysisContext);
        if (Global.getAnalysisCache() != null) {
            currentXFactory.set(new XFactory());
        }
    }

    public static void removeCurrentAnalysisContext() {
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        if (context != null) {
            context.clear();
        }
        currentAnalysisContext.remove();
    }

    public Collection<XClass> getXClassCollection() {
        return this.getSubtypes2().getXClassCollection();
    }

    public SuppressionMatcher getSuppressionMatcher() {
        return this.suppressionMatcher;
    }

    public void addClasspathEntry(String url) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void clearClassContextCache() {
        throw new UnsupportedOperationException();
    }

    public void clearRepository() {
        Repository.setRepository((org.apache.bcel.util.Repository)new AnalysisCacheToRepositoryAdapter());
    }

    public AnnotationRetentionDatabase getAnnotationRetentionDatabase() {
        return this.getDatabase(AnnotationRetentionDatabase.class);
    }

    public CheckReturnAnnotationDatabase getCheckReturnAnnotationDatabase() {
        return this.getDatabase(CheckReturnAnnotationDatabase.class);
    }

    public ClassContext getClassContext(JavaClass javaClass) {
        ClassDescriptor classDescriptor = DescriptorFactory.instance().getClassDescriptor(ClassName.toSlashedClassName(javaClass.getClassName()));
        try {
            return Global.getAnalysisCache().getClassAnalysis(ClassContext.class, classDescriptor);
        }
        catch (CheckedAnalysisException e) {
            IllegalStateException ise = new IllegalStateException("Could not get ClassContext for JavaClass");
            ise.initCause(e);
            throw ise;
        }
    }

    public String getClassContextStats() {
        return "<unknown ClassContext stats>";
    }

    public FieldStoreTypeDatabase getFieldStoreTypeDatabase() {
        return this.getDatabase(FieldStoreTypeDatabase.class);
    }

    public JCIPAnnotationDatabase getJCIPAnnotationDatabase() {
        return this.getDatabase(JCIPAnnotationDatabase.class);
    }

    public RepositoryLookupFailureCallback getLookupFailureCallback() {
        return this.lookupFailureCallback;
    }

    public SourceFinder getSourceFinder() {
        return this.project.getSourceFinder();
    }

    public SourceInfoMap getSourceInfoMap() {
        return this.getDatabase(SourceInfoMap.class);
    }

    public ParameterNullnessPropertyDatabase getUnconditionalDerefParamDatabase() {
        return this.getDatabase(ParameterNullnessPropertyDatabase.class);
    }

    public void initDatabases() {
    }

    public JavaClass lookupClass(@Nonnull @DottedClassName String className) throws ClassNotFoundException {
        try {
            if (className.length() == 0) {
                throw new IllegalArgumentException("Class name is empty");
            }
            if (!ClassName.isValidClassName(className)) {
                throw new ClassNotFoundException("Invalid class name: " + className);
            }
            return Global.getAnalysisCache().getClassAnalysis(JavaClass.class, DescriptorFactory.instance().getClassDescriptor(ClassName.toSlashedClassName(className)));
        }
        catch (CheckedAnalysisException e) {
            throw new ClassNotFoundException("Class not found: " + className, e);
        }
    }

    public InnerClassAccessMap getInnerClassAccessMap() {
        return this.getDatabase(InnerClassAccessMap.class);
    }

    public void setAppClassList(List<ClassDescriptor> appClassCollection) {
        HashSet<ClassDescriptor> appSet = new HashSet<ClassDescriptor>(appClassCollection);
        ArrayList<ClassDescriptor> allClassDescriptors = new ArrayList<ClassDescriptor>(DescriptorFactory.instance().getAllClassDescriptors());
        for (ClassDescriptor appClass : allClassDescriptors) {
            try {
                XClass xclass = AnalysisContext.currentXFactory().getXClass(appClass);
                if (xclass == null) continue;
                if (appSet.contains(appClass)) {
                    this.getSubtypes2().addApplicationClass(xclass);
                    continue;
                }
                if (!(xclass instanceof ClassInfo)) continue;
                this.getSubtypes2().addClass(xclass);
            }
            catch (Exception e) {
                AnalysisContext.logError("Unable to get XClass for " + appClass, e);
            }
        }
        if (Subtypes2.DEBUG) {
            System.out.println(this.getSubtypes2().getGraph().getNumVertices() + " vertices in inheritance graph");
        }
    }

    public void updateDatabases(int pass) {
        if (pass == 0) {
            this.getCheckReturnAnnotationDatabase().loadAuxiliaryAnnotations();
            this.getNullnessAnnotationDatabase().loadAuxiliaryAnnotations();
        }
    }

    public ReturnValueNullnessPropertyDatabase getReturnValueNullnessPropertyDatabase() {
        return this.getDatabase(ReturnValueNullnessPropertyDatabase.class);
    }

    public Subtypes2 getSubtypes2() {
        return Global.getAnalysisCache().getDatabase(Subtypes2.class);
    }

    public DirectlyRelevantTypeQualifiersDatabase getDirectlyRelevantTypeQualifiersDatabase() {
        return Global.getAnalysisCache().getDatabase(DirectlyRelevantTypeQualifiersDatabase.class);
    }

    @CheckForNull
    public XMethod getBridgeTo(MethodInfo m) {
        return this.bridgeTo.get(m);
    }

    @CheckForNull
    public XMethod getBridgeFrom(MethodInfo m) {
        return this.bridgeFrom.get(m);
    }

    public void setBridgeMethod(MethodInfo from, MethodInfo to) {
        this.bridgeTo.put(from, to);
        this.bridgeFrom.put(to, from);
    }

    public TypeQualifierNullnessAnnotationDatabase getNullnessAnnotationDatabase() {
        if (this.tqNullnessDatabase == null) {
            this.tqNullnessDatabase = new TypeQualifierNullnessAnnotationDatabase();
        }
        return this.tqNullnessDatabase;
    }

    protected <E> E getDatabase(Class<E> cls) {
        return Global.getAnalysisCache().getDatabase(cls);
    }

    static class DelegatingRepositoryLookupFailureCallback
    implements RepositoryLookupFailureCallback {
        DelegatingRepositoryLookupFailureCallback() {
        }

        public void logError(String message) {
            Global.getAnalysisCache().getErrorLogger().logError(message);
        }

        public void logError(String message, Throwable e) {
            Global.getAnalysisCache().getErrorLogger().logError(message, e);
        }

        public void reportMissingClass(ClassNotFoundException ex) {
            Global.getAnalysisCache().getErrorLogger().reportMissingClass(ex);
        }

        public void reportMissingClass(ClassDescriptor classDescriptor) {
            Global.getAnalysisCache().getErrorLogger().reportMissingClass(classDescriptor);
        }

        public void reportSkippedAnalysis(MethodDescriptor method) {
            Global.getAnalysisCache().getErrorLogger().reportSkippedAnalysis(method);
        }
    }
}

