/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.type.TypeMerger;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerMap {
    private IdentityHashMap<InstructionHandle, List<CodeExceptionGen>> codeToHandlerMap = new IdentityHashMap();
    private IdentityHashMap<InstructionHandle, CodeExceptionGen> startInstructionToHandlerMap = new IdentityHashMap();
    private TypeMerger merger;

    public ExceptionHandlerMap(MethodGen methodGen, TypeMerger merger) {
        this.merger = merger;
        this.build(methodGen);
    }

    public List<CodeExceptionGen> getHandlerList(InstructionHandle handle) {
        return this.codeToHandlerMap.get(handle);
    }

    public CodeExceptionGen getHandlerForStartInstruction(InstructionHandle start) {
        return this.startInstructionToHandlerMap.get(start);
    }

    private void build(MethodGen methodGen) {
        CodeExceptionGen[] handlerList;
        for (CodeExceptionGen exceptionHandler : handlerList = methodGen.getExceptionHandlers()) {
            this.addExceptionHandler(exceptionHandler);
        }
        block1: for (InstructionHandle handle = methodGen.getInstructionList().getStart(); handle != null; handle = handle.getNext()) {
            int offset = handle.getPosition();
            for (CodeExceptionGen exceptionHandler : handlerList) {
                int startOfRange = exceptionHandler.getStartPC().getPosition();
                int endOfRange = exceptionHandler.getEndPC().getPosition();
                if (offset < startOfRange || offset > endOfRange) continue;
                this.addHandler(handle, exceptionHandler);
                if (Hierarchy.isUniversalExceptionHandler(exceptionHandler.getCatchType())) continue block1;
            }
        }
    }

    public static CodeExceptionGen merge(@CheckForNull TypeMerger m, CodeExceptionGen e1, CodeExceptionGen e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        if (m == null) {
            return e1;
        }
        if (!e1.getHandlerPC().equals(e2.getHandlerPC())) {
            return e1;
        }
        try {
            Type t = m.mergeTypes((Type)e1.getCatchType(), (Type)e2.getCatchType());
            return new CodeExceptionGen(e1.getStartPC(), e1.getEndPC(), e1.getHandlerPC(), (ObjectType)t);
        }
        catch (DataflowAnalysisException e) {
            e.printStackTrace();
            return e1;
        }
    }

    private void addExceptionHandler(CodeExceptionGen exceptionHandler) {
        InstructionHandle handlerPC = exceptionHandler.getHandlerPC();
        CodeExceptionGen existing = this.startInstructionToHandlerMap.get(handlerPC);
        if (existing != null) {
            exceptionHandler = ExceptionHandlerMap.merge(this.merger, existing, exceptionHandler);
        }
        this.startInstructionToHandlerMap.put(handlerPC, exceptionHandler);
    }

    private void addHandler(InstructionHandle handle, CodeExceptionGen exceptionHandler) {
        List<CodeExceptionGen> handlerList = this.codeToHandlerMap.get(handle);
        if (handlerList == null) {
            handlerList = new LinkedList<CodeExceptionGen>();
            this.codeToHandlerMap.put(handle, handlerList);
        }
        handlerList.add(exceptionHandler);
    }
}

