/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InvokeInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureParser {
    private int totalArgumentSize;
    @CheckForNull
    private int[] parameterOffset;
    private final String signature;

    public int getTotalArgumentSize() {
        if (this.parameterOffset == null) {
            this.getParameterOffset();
        }
        return this.totalArgumentSize;
    }

    @Nonnull
    int[] getParameterOffset() {
        if (this.parameterOffset != null) {
            return this.parameterOffset;
        }
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        Iterator<String> i = this.parameterSignatureIterator();
        int totalSize = 0;
        while (i.hasNext()) {
            String s = i.next();
            totalSize = s.equals("D") || s.equals("J") ? (totalSize += 2) : ++totalSize;
            offsets.add(totalSize);
        }
        this.totalArgumentSize = totalSize;
        int numParameters = offsets.size();
        this.parameterOffset = new int[numParameters];
        for (int j = 0; j < numParameters; ++j) {
            this.parameterOffset[j] = (Integer)offsets.get(j);
        }
        return this.parameterOffset;
    }

    public int getSlotsFromTopOfStackForParameter(int paramNum) {
        int offset = this.getParameterOffset()[paramNum];
        int result = this.totalArgumentSize - offset;
        return result;
    }

    public String toString() {
        return this.signature;
    }

    public SignatureParser(String signature) {
        if (!signature.startsWith("(")) {
            throw new IllegalArgumentException("Bad method signature: " + signature);
        }
        this.signature = signature;
    }

    public String[] getArguments() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> i = this.parameterSignatureIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result.toArray(new String[result.size()]);
    }

    public Iterator<String> parameterSignatureIterator() {
        return new ParameterSignatureIterator();
    }

    public Iterable<String> parameterSignatures() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new ParameterSignatureIterator();
            }
        };
    }

    public String getReturnTypeSignature() {
        int endOfParams = this.signature.lastIndexOf(41);
        if (endOfParams < 0) {
            throw new IllegalArgumentException("Bad method signature: " + this.signature);
        }
        return this.signature.substring(endOfParams + 1);
    }

    public int getNumParameters() {
        return this.getParameterOffset().length;
    }

    public boolean hasReferenceParameters() {
        Iterator<String> i = this.parameterSignatureIterator();
        while (i.hasNext()) {
            char c = i.next().charAt(0);
            if (c != 'L' && c != '[') continue;
            return true;
        }
        return false;
    }

    public String getParameter(int pos) {
        int count = 0;
        Iterator<String> i = this.parameterSignatureIterator();
        while (i.hasNext()) {
            String p = i.next();
            if (pos == count) {
                return p;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException("Asked for parameter " + pos + " of " + this.signature);
    }

    public static boolean isReferenceType(String signature) {
        return signature.startsWith("L") || signature.startsWith("[");
    }

    public static int getNumParametersForInvocation(InvokeInstruction inv, ConstantPoolGen cpg) {
        SignatureParser sigParser = new SignatureParser(inv.getSignature(cpg));
        return sigParser.getNumParameters();
    }

    public static int getNumSlotsForType(String sig) {
        if (sig.equals("J") || sig.equals("D")) {
            return 2;
        }
        return 1;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: " + SignatureParser.class.getName() + " '<method signature>'");
            System.exit(1);
        }
        SignatureParser parser = new SignatureParser(args[0]);
        Iterator<String> i = parser.parameterSignatureIterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
        System.out.println(parser.getNumParameters() + " parameter(s)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterSignatureIterator
    implements Iterator<String> {
        private int index = 1;

        private ParameterSignatureIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < SignatureParser.this.signature.length() && SignatureParser.this.signature.charAt(this.index) != ')';
        }

        @Override
        public String next() {
            boolean done;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StringBuilder result = new StringBuilder();
            do {
                done = true;
                char ch = SignatureParser.this.signature.charAt(this.index);
                switch (ch) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        result.append(SignatureParser.this.signature.charAt(this.index));
                        ++this.index;
                        break;
                    }
                    case 'L': {
                        int semi = SignatureParser.this.signature.indexOf(59, this.index + 1);
                        if (semi < 0) {
                            throw new IllegalStateException("Invalid method signature: " + SignatureParser.this.signature);
                        }
                        result.append(SignatureParser.this.signature.substring(this.index, semi + 1));
                        this.index = semi + 1;
                        break;
                    }
                    case '[': {
                        result.append('[');
                        ++this.index;
                        done = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid method signature: " + SignatureParser.this.signature);
                    }
                }
            } while (!done);
            return result.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

