/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.OverriddenMethodsVisitor;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.UncheckedAnalysisException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.meta.When;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analysis {
    private static final boolean DEBUG = SystemProperties.getBoolean("ctq.debug.analysis");
    public static final boolean FIND_EFFECTIVE_RELEVANT_QUALIFIERS = true;
    public static final boolean DEBUG_FIND_EFFECTIVE_RELEVANT_QUALIFIERS = SystemProperties.getBoolean("ctq.findeffective.debug");

    public static Collection<TypeQualifierValue<?>> getRelevantTypeQualifiers(MethodDescriptor methodDescriptor, CFG cfg) throws CheckedAnalysisException {
        final HashSet result = new HashSet();
        XMethod xmethod = XFactory.createXMethod(methodDescriptor);
        if (DEBUG_FIND_EFFECTIVE_RELEVANT_QUALIFIERS) {
            System.out.println("**** Finding effective type qualifiers for " + xmethod);
        }
        Analysis.getDirectlyRelevantTypeQualifiers(xmethod, result);
        Analysis.addEffectiveRelevantQualifiers(result, xmethod);
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        ConstantPoolGen cpg = analysisCache.getClassAnalysis(ConstantPoolGen.class, methodDescriptor.getClassDescriptor());
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (ins instanceof InvokeInstruction) {
                XMethod called = XFactory.createXMethod((InvokeInstruction)ins, cpg);
                Analysis.addEffectiveRelevantQualifiers(result, called);
            }
            if (!DEBUG_FIND_EFFECTIVE_RELEVANT_QUALIFIERS) continue;
            System.out.println("===> result: " + result);
        }
        if (!methodDescriptor.isStatic()) {
            OverriddenMethodsVisitor visitor = new OverriddenMethodsVisitor(xmethod){

                protected boolean visitOverriddenMethod(XMethod xmethod) {
                    Analysis.getDirectlyRelevantTypeQualifiers(xmethod, result);
                    return true;
                }
            };
            try {
                AnalysisContext.currentAnalysisContext().getSubtypes2().traverseSupertypes(xmethod.getClassDescriptor(), visitor);
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e);
                return Collections.emptySet();
            }
            catch (UncheckedAnalysisException e) {
                AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error getting relevant type qualifiers for " + xmethod.toString(), e);
                return Collections.emptySet();
            }
        }
        return result;
    }

    private static void addEffectiveRelevantQualifiers(HashSet<TypeQualifierValue<?>> result, XMethod xmethod) {
        if (DEBUG_FIND_EFFECTIVE_RELEVANT_QUALIFIERS) {
            System.out.println("  Finding effective qualifiers for " + xmethod);
        }
        for (TypeQualifierValue<?> tqv : TypeQualifierValue.getAllKnownTypeQualifiers()) {
            if (DEBUG_FIND_EFFECTIVE_RELEVANT_QUALIFIERS) {
                System.out.print("    " + tqv + "...");
            }
            boolean add = false;
            TypeQualifierAnnotation tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(xmethod, tqv);
            if (tqa != null) {
                add = true;
            }
            if (!add) {
                int numParams = xmethod.getNumParams();
                for (int i = 0; i < numParams; ++i) {
                    tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(xmethod, i, tqv);
                    if (tqa == null) continue;
                    add = true;
                    break;
                }
            }
            if (add) {
                result.add(tqv);
            }
            if (!DEBUG_FIND_EFFECTIVE_RELEVANT_QUALIFIERS) continue;
            System.out.println(add ? "YES" : "NO");
        }
    }

    private static void getDirectlyRelevantTypeQualifiers(XMethod xmethod, HashSet<TypeQualifierValue<?>> result) {
        result.addAll(AnalysisContext.currentAnalysisContext().getDirectlyRelevantTypeQualifiersDatabase().getDirectlyRelevantTypeQualifiers(xmethod.getMethodDescriptor()));
    }

    public static void addKnownTypeQualifiersForParameters(HashSet<? super TypeQualifierValue<?>> result, XMethod m) {
        int numParameters = new SignatureParser(m.getSignature()).getNumParameters();
        for (int p = 0; p < numParameters; ++p) {
            Analysis.addKnownTypeQualifiers(result, TypeQualifierApplications.getApplicableApplications(m, p));
        }
    }

    public static void addKnownTypeQualifiers(HashSet<? super TypeQualifierValue<?>> result, Collection<TypeQualifierAnnotation> applicableApplications) {
        for (TypeQualifierAnnotation t : applicableApplications) {
            if (t.when == When.UNKNOWN) continue;
            result.add(t.typeQualifier);
        }
    }
}

