/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.jsr305.ValidatorClassLoader;
import java.lang.annotation.Annotation;
import java.security.Permission;
import javax.annotation.CheckForNull;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValidationSecurityManager
extends SecurityManager {
    static final ValidationSecurityManager INSTANCE = new ValidationSecurityManager();
    private static final ThreadLocal<Boolean> performingValidation;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <A extends Annotation> When sandboxedValidation(A proxy, TypeQualifierValidator<A> v, @CheckForNull Object constantValue) {
        Throwable throwable2;
        When when;
        if (performingValidation.get().booleanValue()) {
            throw new IllegalStateException("recursive validation");
        }
        performingValidation.set(Boolean.TRUE);
        if (TypeQualifierValue.DEBUG_CLASSLOADING) {
            System.out.println("Performing validation in thread " + Thread.currentThread().getName());
        }
        try {
            When result = v.forConstantValue(proxy, constantValue);
            if (!performingValidation.get().booleanValue()) {
                throw new IllegalStateException("performingValidation not set when validation completes");
            }
            when = result;
        }
        catch (ClassCastException e) {
            try {
                Class<?> c = proxy.getClass();
                System.out.println(c.getName() + " extends " + c.getSuperclass().getName());
                for (Class<?> i : c.getInterfaces()) {
                    System.out.println("  " + i.getName());
                }
                throw e;
            }
            catch (Throwable throwable2) {
                Object var10_8 = null;
                performingValidation.set(Boolean.FALSE);
                if (!TypeQualifierValue.DEBUG_CLASSLOADING) throw throwable2;
                System.out.println("Validation finished in thread " + Thread.currentThread().getName());
            }
        }
        Object var10_7 = null;
        performingValidation.set(Boolean.FALSE);
        if (!TypeQualifierValue.DEBUG_CLASSLOADING) return when;
        System.out.println("Validation finished in thread " + Thread.currentThread().getName());
        return when;
        throw throwable2;
    }

    @Override
    public void checkPermission(Permission perm) {
        if (TypeQualifierValue.DEBUG_CLASSLOADING) {
            System.out.println("Checking for " + perm + " permission in thread " + Thread.currentThread().getName());
        }
        if (performingValidation.get().booleanValue() && this.inValidation()) {
            SecurityException e = new SecurityException("No permissions granted while performing JSR-305 validation");
            if (TypeQualifierValue.DEBUG_CLASSLOADING) {
                e.printStackTrace(System.out);
            }
            throw e;
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (TypeQualifierValue.DEBUG_CLASSLOADING) {
            System.out.println("Checking for " + perm + " permission with content in thread " + Thread.currentThread().getName());
        }
        if (performingValidation.get().booleanValue() && this.inValidation()) {
            SecurityException e = new SecurityException("No permissions granted while performing JSR-305 validation");
            if (TypeQualifierValue.DEBUG_CLASSLOADING) {
                e.printStackTrace(System.out);
            }
            throw e;
        }
    }

    private ValidationSecurityManager() {
    }

    private boolean inValidation() {
        for (Class<?> c : this.getClassContext()) {
            if (!TypeQualifierValidator.class.isAssignableFrom(c) && c.getClassLoader() != ValidatorClassLoader.INSTANCE) continue;
            return true;
        }
        return false;
    }

    static {
        if (TypeQualifierValue.DEBUG_CLASSLOADING) {
            new RuntimeException("Creating ValidationSecurityManager #").printStackTrace();
        }
        performingValidation = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }
}

