/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.IClassFactory;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IClassPathBuilder;
import edu.umd.cs.findbugs.classfile.IClassPathBuilderProgress;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import edu.umd.cs.findbugs.classfile.IScannableCodeBase;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParser;
import edu.umd.cs.findbugs.classfile.impl.DirectoryCodeBase;
import edu.umd.cs.findbugs.classfile.impl.FilesystemCodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.SingleFileCodeBaseEntry;
import edu.umd.cs.findbugs.io.IO;
import edu.umd.cs.findbugs.util.Archive;
import edu.umd.cs.findbugs.util.ClassPathUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathBuilder
implements IClassPathBuilder {
    private static final boolean VERBOSE = SystemProperties.getBoolean("findbugs2.builder.verbose");
    private static final boolean DEBUG = VERBOSE || SystemProperties.getBoolean("findbugs2.builder.debug");
    private static final boolean NO_PARSE_CLASS_NAMES = SystemProperties.getBoolean("findbugs2.builder.noparseclassnames");
    private final IClassFactory classFactory;
    private final IErrorLogger errorLogger;
    private final LinkedList<WorkListItem> projectWorkList;
    private final LinkedList<DiscoveredCodeBase> discoveredCodeBaseList;
    private final Map<String, DiscoveredCodeBase> discoveredCodeBaseMap;
    private final LinkedList<ClassDescriptor> appClassList;
    private boolean scanNestedArchives;

    ClassPathBuilder(IClassFactory classFactory, IErrorLogger errorLogger) {
        this.classFactory = classFactory;
        this.errorLogger = errorLogger;
        this.projectWorkList = new LinkedList();
        this.discoveredCodeBaseList = new LinkedList();
        this.discoveredCodeBaseMap = new HashMap<String, DiscoveredCodeBase>();
        this.appClassList = new LinkedList();
    }

    @Override
    public void addCodeBase(ICodeBaseLocator locator, boolean isApplication) {
        this.addToWorkList(this.projectWorkList, new WorkListItem(locator, isApplication, ICodeBase.Discovered.SPECIFIED));
    }

    @Override
    public void scanNestedArchives(boolean scanNestedArchives) {
        this.scanNestedArchives = scanNestedArchives;
    }

    @Override
    public void build(IClassPath classPath, IClassPathBuilderProgress progress) throws CheckedAnalysisException, IOException, InterruptedException {
        this.processWorkList(classPath, this.projectWorkList, progress);
        if (!this.discoveredCodeBaseList.isEmpty()) {
            this.locateCodebasesRequiredForAnalysis(classPath, progress);
        }
        for (DiscoveredCodeBase discoveredCodeBase : this.discoveredCodeBaseList) {
            classPath.addCodeBase(discoveredCodeBase.getCodeBase());
        }
        HashSet<ClassDescriptor> appClassSet = new HashSet<ClassDescriptor>();
        for (DiscoveredCodeBase discoveredCodeBase : this.discoveredCodeBaseList) {
            if (!discoveredCodeBase.getCodeBase().isApplicationCodeBase()) continue;
            ICodeBaseIterator i = discoveredCodeBase.iterator();
            while (i.hasNext()) {
                ICodeBaseEntry entry = i.next();
                if (!DescriptorFactory.isClassResource(entry.getResourceName())) continue;
                ClassDescriptor classDescriptor = entry.getClassDescriptor();
                if (classDescriptor == null) {
                    throw new IllegalStateException();
                }
                if (appClassSet.contains(classDescriptor)) continue;
                appClassSet.add(classDescriptor);
                this.appClassList.add(classDescriptor);
                classPath.mapResourceNameToCodeBaseEntry(entry.getResourceName(), entry);
            }
        }
        if (DEBUG) {
            System.out.println("Classpath:");
            this.dumpCodeBaseList(classPath.appCodeBaseIterator(), "Application codebases");
            this.dumpCodeBaseList(classPath.auxCodeBaseIterator(), "Auxiliary codebases");
        }
    }

    private void locateCodebasesRequiredForAnalysis(IClassPath classPath, IClassPathBuilderProgress progress) throws InterruptedException, IOException, ResourceNotFoundException {
        boolean foundJavaLangObject = false;
        boolean foundFindBugsAnnotations = false;
        boolean foundJSR305Annotations = false;
        for (DiscoveredCodeBase discoveredCodeBase : this.discoveredCodeBaseList) {
            if (!foundJavaLangObject) {
                foundJavaLangObject = this.probeCodeBaseForResource(discoveredCodeBase, "java/lang/Object.class");
            }
            if (!foundFindBugsAnnotations) {
                foundFindBugsAnnotations = this.probeCodeBaseForResource(discoveredCodeBase, "edu/umd/cs/findbugs/annotations/Nonnull.class");
            }
            if (foundJSR305Annotations) continue;
            foundJSR305Annotations = this.probeCodeBaseForResource(discoveredCodeBase, "javax/annotation/meta/TypeQualifier.class");
            if (!DEBUG) continue;
            System.out.println("foundJSR305Annotations: " + foundJSR305Annotations);
        }
        if (!foundJavaLangObject) {
            this.processWorkList(classPath, this.buildSystemCodebaseList(), progress);
        }
        if (this.runningFindBugsFullJar()) {
            this.processWorkList(classPath, this.buildFindBugsFullJarCodebaseList(), progress);
            return;
        }
        if (!foundFindBugsAnnotations) {
            this.processWorkList(classPath, this.buildFindBugsAnnotationCodebaseList(), progress);
        }
        if (!foundJSR305Annotations) {
            this.processWorkList(classPath, this.buildJSR305AnnotationsCodebaseList(), progress);
        }
    }

    private boolean runningFindBugsFullJar() {
        String findbugsFullJar = ClassPathUtil.findCodeBaseInClassPath("findbugs-full.jar", SystemProperties.getProperty("java.class.path"));
        return findbugsFullJar != null;
    }

    private LinkedList<WorkListItem> buildFindBugsFullJarCodebaseList() {
        String findbugsFullJar = ClassPathUtil.findCodeBaseInClassPath("findbugs-full.jar", SystemProperties.getProperty("java.class.path"));
        LinkedList<WorkListItem> workList = new LinkedList<WorkListItem>();
        if (findbugsFullJar != null) {
            FilesystemCodeBaseLocator loc = new FilesystemCodeBaseLocator(findbugsFullJar);
            workList.addLast(new WorkListItem(loc, false, ICodeBase.Discovered.IN_SYSTEM_CLASSPATH));
        }
        return workList;
    }

    private boolean probeCodeBaseForResource(DiscoveredCodeBase discoveredCodeBase, String resourceName) {
        ICodeBaseEntry resource = discoveredCodeBase.getCodeBase().lookupResource(resourceName);
        return resource != null;
    }

    private void dumpCodeBaseList(Iterator<? extends ICodeBase> i, String desc) throws InterruptedException {
        System.out.println("  " + desc + ":");
        while (i.hasNext()) {
            ICodeBase codeBase = i.next();
            System.out.println("    " + codeBase.getCodeBaseLocator().toString());
            if (!codeBase.containsSourceFiles()) continue;
            System.out.println("      * contains source files");
        }
    }

    private LinkedList<WorkListItem> buildSystemCodebaseList() {
        LinkedList<WorkListItem> workList = new LinkedList<WorkListItem>();
        String bootClassPath = SystemProperties.getProperty("sun.boot.class.path");
        this.addWorkListItemsForClasspath(workList, bootClassPath);
        String extPath = SystemProperties.getProperty("java.ext.dirs");
        if (extPath != null) {
            StringTokenizer st = new StringTokenizer(extPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String extDir = st.nextToken();
                this.addWorkListItemsForExtDir(workList, extDir);
            }
        }
        return workList;
    }

    private LinkedList<WorkListItem> buildFindBugsAnnotationCodebaseList() {
        return this.createFindBugsLibWorkList("annotations.jar");
    }

    private LinkedList<WorkListItem> buildJSR305AnnotationsCodebaseList() {
        return this.createFindBugsLibWorkList("jsr305.jar");
    }

    private LinkedList<WorkListItem> createFindBugsLibWorkList(String jarFileName) {
        LinkedList<WorkListItem> workList = new LinkedList<WorkListItem>();
        boolean found = false;
        String findbugsHome = FindBugs.getHome();
        if (findbugsHome != null) {
            File base = new File(findbugsHome);
            File loc1 = new File(new File(base, "lib"), jarFileName);
            File loc2 = new File(base, jarFileName);
            File loc = null;
            if (loc1.exists()) {
                loc = loc1;
            } else if (loc2.exists()) {
                loc = loc2;
            }
            if (loc != null) {
                found = true;
                ICodeBaseLocator codeBaseLocator = this.classFactory.createFilesystemCodeBaseLocator(loc.getPath());
                workList.add(new WorkListItem(codeBaseLocator, false, ICodeBase.Discovered.IN_SYSTEM_CLASSPATH));
            }
        }
        if (!found) {
            if (DEBUG) {
                System.out.println("Looking for " + jarFileName + " on classpath...");
            }
            String javaClassPath = SystemProperties.getProperty("java.class.path");
            StringTokenizer t = new StringTokenizer(javaClassPath, File.pathSeparator);
            while (t.hasMoreTokens()) {
                String entry = t.nextToken();
                if (DEBUG) {
                    System.out.print("  Checking " + entry + "...");
                }
                if (this.matchesJarFile(entry, jarFileName)) {
                    found = true;
                } else if (this.matchesJarFile(entry, "findbugs.jar")) {
                    File findbugsJar = new File(entry);
                    File loc = new File(findbugsJar.getParent() + File.separator + jarFileName);
                    if (DEBUG) {
                        System.out.print(" [findbugs.jar, checking " + loc.getPath() + "] ");
                    }
                    if (loc.exists()) {
                        entry = loc.getPath();
                        found = true;
                    }
                }
                if (DEBUG) {
                    System.out.println(found ? "FOUND" : "no");
                }
                if (!found) continue;
                ICodeBaseLocator codeBaseLocator = this.classFactory.createFilesystemCodeBaseLocator(entry);
                workList.add(new WorkListItem(codeBaseLocator, false, ICodeBase.Discovered.IN_SYSTEM_CLASSPATH));
                break;
            }
        }
        return workList;
    }

    private boolean matchesJarFile(String entry, String jarFileName) {
        return entry.equals(jarFileName) || entry.endsWith(File.separator + jarFileName) || entry.endsWith("/" + jarFileName);
    }

    private void addWorkListItemsForClasspath(LinkedList<WorkListItem> workList, String path) {
        if (path == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (DEBUG) {
                System.out.println("System classpath entry: " + entry);
            }
            this.addToWorkList(workList, new WorkListItem(this.classFactory.createFilesystemCodeBaseLocator(entry), false, ICodeBase.Discovered.IN_SYSTEM_CLASSPATH));
        }
    }

    private void addWorkListItemsForExtDir(LinkedList<WorkListItem> workList, String extDir) {
        File dir = new File(extDir);
        File[] fileList = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String path = pathname.getPath();
                boolean isArchive = Archive.isArchiveFileName(path);
                return isArchive;
            }
        });
        if (fileList == null) {
            return;
        }
        for (File archive : fileList) {
            this.addToWorkList(workList, new WorkListItem(this.classFactory.createFilesystemCodeBaseLocator(archive.getPath()), false, ICodeBase.Discovered.IN_SYSTEM_CLASSPATH));
        }
    }

    private void processWorkList(IClassPath classPath, LinkedList<WorkListItem> workList, IClassPathBuilderProgress progress) throws InterruptedException, IOException, ResourceNotFoundException {
        while (!workList.isEmpty()) {
            WorkListItem item;
            block12: {
                FilesystemCodeBaseLocator l;
                DiscoveredCodeBase discoveredCodeBase;
                item = workList.removeFirst();
                if (item.getHowDiscovered() == ICodeBase.Discovered.SPECIFIED) {
                    progress.startArchive(item.toString());
                }
                if (DEBUG) {
                    System.out.println("Working: " + item.getCodeBaseLocator());
                }
                if ((discoveredCodeBase = this.discoveredCodeBaseMap.get(item.getCodeBaseLocator().toString())) != null) {
                    if (discoveredCodeBase.getCodeBase().isApplicationCodeBase() || !item.isAppCodeBase()) continue;
                    discoveredCodeBase.getCodeBase().setApplicationCodeBase(true);
                    continue;
                }
                if (item.getCodeBaseLocator() instanceof FilesystemCodeBaseLocator && (l = (FilesystemCodeBaseLocator)item.getCodeBaseLocator()).getPathName().endsWith(".java")) {
                    if (!DEBUG) continue;
                    System.err.println("Ignoring .java file \"" + l.getPathName() + "\" specified in classpath or auxclasspath");
                    continue;
                }
                try {
                    discoveredCodeBase = new DiscoveredCodeBase(item.getCodeBaseLocator().openCodeBase());
                    discoveredCodeBase.getCodeBase().setApplicationCodeBase(item.isAppCodeBase());
                    discoveredCodeBase.getCodeBase().setHowDiscovered(item.getHowDiscovered());
                    this.discoveredCodeBaseMap.put(item.getCodeBaseLocator().toString(), discoveredCodeBase);
                    this.discoveredCodeBaseList.addLast(discoveredCodeBase);
                    if (discoveredCodeBase.getCodeBase() instanceof IScannableCodeBase && (discoveredCodeBase.codeBase.isApplicationCodeBase() || item.getHowDiscovered() == ICodeBase.Discovered.SPECIFIED)) {
                        this.scanCodebase(classPath, workList, discoveredCodeBase);
                    }
                    this.scanJarManifestForClassPathEntries(workList, discoveredCodeBase.getCodeBase());
                }
                catch (IOException e) {
                    if (item.isAppCodeBase() || item.getHowDiscovered() == ICodeBase.Discovered.SPECIFIED) {
                        if (e instanceof FileNotFoundException) {
                            this.errorLogger.logError("File not found: " + item.getCodeBaseLocator());
                        } else {
                            this.errorLogger.logError("Cannot open codebase " + item.getCodeBaseLocator(), e);
                        }
                    }
                }
                catch (ResourceNotFoundException e) {
                    if (item.getHowDiscovered() != ICodeBase.Discovered.SPECIFIED) break block12;
                    this.errorLogger.logError("Cannot open codebase " + item.getCodeBaseLocator(), e);
                }
            }
            if (item.getHowDiscovered() != ICodeBase.Discovered.SPECIFIED) continue;
            progress.finishArchive();
        }
    }

    private void scanCodebase(IClassPath classPath, LinkedList<WorkListItem> workList, DiscoveredCodeBase discoveredCodeBase) throws InterruptedException {
        if (DEBUG) {
            System.out.println("Scanning " + discoveredCodeBase.getCodeBase().getCodeBaseLocator());
        }
        IScannableCodeBase codeBase = (IScannableCodeBase)discoveredCodeBase.getCodeBase();
        ICodeBaseIterator i = codeBase.iterator();
        while (i.hasNext()) {
            ICodeBaseEntry entry = i.next();
            if (VERBOSE) {
                System.out.println("Entry: " + entry.getResourceName());
            }
            if (!NO_PARSE_CLASS_NAMES && codeBase.isApplicationCodeBase() && DescriptorFactory.isClassResource(entry.getResourceName()) && !(entry instanceof SingleFileCodeBaseEntry)) {
                this.parseClassName(entry);
            }
            discoveredCodeBase.addCodeBaseEntry(entry);
            if (!this.scanNestedArchives || !codeBase.isApplicationCodeBase() && !(codeBase instanceof DirectoryCodeBase) || !Archive.isLibraryFileName(entry.getResourceName())) continue;
            if (VERBOSE) {
                System.out.println("Entry is an library!");
            }
            ICodeBaseLocator nestedArchiveLocator = this.classFactory.createNestedArchiveCodeBaseLocator(codeBase, entry.getResourceName());
            this.addToWorkList(workList, new WorkListItem(nestedArchiveLocator, codeBase.isApplicationCodeBase(), ICodeBase.Discovered.NESTED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseClassName(ICodeBaseEntry entry) {
        DataInputStream in = null;
        try {
            block6: {
                try {
                    InputStream resourceIn = entry.openResource();
                    if (resourceIn == null) {
                        throw new NullPointerException("Got null resource");
                    }
                    in = new DataInputStream(resourceIn);
                    ClassParser parser = new ClassParser(in, null, entry);
                    ClassNameAndSuperclassInfo.Builder builder = new ClassNameAndSuperclassInfo.Builder();
                    parser.parse(builder);
                    String trueResourceName = builder.build().getClassDescriptor().toResourceName();
                    if (trueResourceName.equals(entry.getResourceName())) break block6;
                    entry.overrideResourceName(trueResourceName);
                }
                catch (IOException e) {
                    this.errorLogger.logError("Invalid class resource " + entry.getResourceName() + " in " + entry, e);
                    Object var8_10 = null;
                    IO.close(in);
                    return;
                }
                catch (InvalidClassFileFormatException e) {
                    this.errorLogger.logError("Invalid class resource " + entry.getResourceName() + " in " + entry, e);
                    Object var8_11 = null;
                    IO.close(in);
                    return;
                }
            }
            Object var8_9 = null;
            IO.close(in);
            return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            IO.close(in);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanJarManifestForClassPathEntries(LinkedList<WorkListItem> workList, ICodeBase codeBase) throws IOException {
        ICodeBaseEntry manifestEntry = codeBase.lookupResource("META-INF/MANIFEST.MF");
        if (manifestEntry == null) {
            return;
        }
        InputStream in = null;
        try {
            in = manifestEntry.openResource();
            Manifest manifest = new Manifest(in);
            Attributes mainAttrs = manifest.getMainAttributes();
            String classPath = mainAttrs.getValue("Class-Path");
            if (classPath != null) {
                String[] pathList;
                for (String path : pathList = classPath.split("\\s+")) {
                    ICodeBaseLocator relativeCodeBaseLocator = codeBase.getCodeBaseLocator().createRelativeCodeBaseLocator(path);
                    this.addToWorkList(workList, new WorkListItem(relativeCodeBaseLocator, false, ICodeBase.Discovered.IN_JAR_MANIFEST));
                }
            }
            Object var15_14 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (in == null) throw throwable;
            IO.close(in);
            throw throwable;
        }
        IO.close(in);
    }

    private void addToWorkList(LinkedList<WorkListItem> workList, WorkListItem itemToAdd) {
        if (DEBUG) {
            new RuntimeException("Adding work list item " + itemToAdd).printStackTrace(System.out);
        }
        if (!itemToAdd.isAppCodeBase()) {
            workList.addLast(itemToAdd);
            return;
        }
        ListIterator<WorkListItem> i = workList.listIterator();
        while (i.hasNext()) {
            WorkListItem listItem = (WorkListItem)i.next();
            if (listItem.isAppCodeBase()) continue;
            i.previous();
            break;
        }
        i.add(itemToAdd);
    }

    @Override
    public List<ClassDescriptor> getAppClassList() {
        return this.appClassList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoveredCodeBase {
        ICodeBase codeBase;
        LinkedList<ICodeBaseEntry> resourceList;

        public DiscoveredCodeBase(ICodeBase codeBase) {
            this.codeBase = codeBase;
            this.resourceList = new LinkedList();
        }

        public ICodeBase getCodeBase() {
            return this.codeBase;
        }

        public LinkedList<ICodeBaseEntry> getResourceList() {
            return this.resourceList;
        }

        public void addCodeBaseEntry(ICodeBaseEntry entry) {
            this.resourceList.add(entry);
        }

        public ICodeBaseIterator iterator() throws InterruptedException {
            if (this.codeBase instanceof IScannableCodeBase) {
                return ((IScannableCodeBase)this.codeBase).iterator();
            }
            return new ICodeBaseIterator(){

                public boolean hasNext() throws InterruptedException {
                    return false;
                }

                public ICodeBaseEntry next() throws InterruptedException {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class WorkListItem {
        private final ICodeBaseLocator codeBaseLocator;
        private final boolean isAppCodeBase;
        private final ICodeBase.Discovered howDiscovered;

        public String toString() {
            return "WorkListItem(" + this.codeBaseLocator + ", " + this.isAppCodeBase + ", " + (Object)((Object)this.howDiscovered) + ")";
        }

        public WorkListItem(ICodeBaseLocator codeBaseLocator, boolean isApplication, ICodeBase.Discovered howDiscovered) {
            this.codeBaseLocator = codeBaseLocator;
            this.isAppCodeBase = isApplication;
            this.howDiscovered = howDiscovered;
        }

        public ICodeBaseLocator getCodeBaseLocator() {
            return this.codeBaseLocator;
        }

        public boolean isAppCodeBase() {
            return this.isAppCodeBase;
        }

        public ICodeBase.Discovered getHowDiscovered() {
            return this.howDiscovered;
        }
    }
}

