/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.PropertyBundle;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public class BugFilingCommentHelper {
    private final Cloud cloud;
    private final String BUG_NOTE;
    private final String POSTMORTEM_NOTE;
    private final int POSTMORTEM_RANK;

    public BugFilingCommentHelper(Cloud cloud) {
        this.cloud = cloud;
        PropertyBundle properties = cloud.getPlugin().getProperties();
        this.BUG_NOTE = properties.getProperty("findbugs.bugnote");
        this.POSTMORTEM_NOTE = properties.getProperty("findbugs.postmortem.note");
        this.POSTMORTEM_RANK = properties.getInt("findbugs.postmortem.maxRank", 4);
    }

    public String getBugReportSummary(BugInstance b) {
        return b.getMessageWithoutPrefix() + " in " + b.getPrimaryClass().getSourceFileName();
    }

    public String getBugReportText(BugInstance b) {
        return this.getBugReportHead(b) + this.getBugReportSourceCode(b) + this.getLineTerminatedUserEvaluation(b) + this.getBugPatternExplanation(b) + this.getBugReportTail(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBugReportSourceCode(BugInstance b) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        ClassAnnotation primaryClass = b.getPrimaryClass();
        int firstLine = Integer.MAX_VALUE;
        int lastLine = Integer.MIN_VALUE;
        for (BugAnnotation bugAnnotation : b.getAnnotations()) {
            SourceLineAnnotation s;
            if (!(bugAnnotation instanceof SourceLineAnnotation) || !(s = (SourceLineAnnotation)bugAnnotation).getClassName().equals(primaryClass.getClassName()) || s.getStartLine() <= 0) continue;
            firstLine = Math.min(firstLine, s.getStartLine());
            lastLine = Math.max(lastLine, s.getEndLine());
        }
        SourceLineAnnotation primarySource = primaryClass.getSourceLines();
        if (primarySource.isSourceFileKnown() && firstLine >= 1 && firstLine <= lastLine && lastLine - firstLine < 50) {
            block11: {
                BufferedReader bufferedReader;
                Reader reader = null;
                try {
                    try {
                        String txt;
                        Project project = this.cloud.getBugCollection().getProject();
                        SourceFile sourceFile = project.getSourceFinder().findSourceFile(primarySource);
                        bufferedReader = UTF8.bufferedReader(sourceFile.getInputStream());
                        String commonWhiteSpace = null;
                        ArrayList<SourceLine> source = new ArrayList<SourceLine>();
                        for (int lineNumber = 1; lineNumber <= lastLine + 4 && (txt = bufferedReader.readLine()) != null; ++lineNumber) {
                            if (lineNumber < firstLine - 4) continue;
                            String trimmed = txt.trim();
                            if (trimmed.length() == 0) {
                                if (lineNumber > lastLine) break;
                                txt = trimmed;
                            }
                            source.add(new SourceLine(lineNumber, txt));
                            commonWhiteSpace = this.commonLeadingWhitespace(commonWhiteSpace, txt);
                        }
                        if (commonWhiteSpace == null) {
                            commonWhiteSpace = "";
                        }
                        out.println("\nRelevant source code:");
                        for (SourceLine s : source) {
                            if (s.text.length() == 0) {
                                out.printf("%5d: %n", s.line);
                                continue;
                            }
                            out.printf("%5d:   %s%n", s.line, s.text.substring(commonWhiteSpace.length()));
                        }
                        out.println();
                    }
                    catch (IOException e) {
                        Object var17_20 = null;
                        Util.closeSilently(reader);
                        break block11;
                    }
                    Object var17_19 = null;
                }
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    Util.closeSilently(reader);
                    throw throwable;
                }
                Util.closeSilently(bufferedReader);
            }
            out.close();
            return stringWriter.toString();
        }
        return "";
    }

    public String getBugReportHead(BugInstance b) {
        Collection<String> projects;
        URL link;
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        out.println("Bug report generated from FindBugs");
        out.println(b.getMessageWithoutPrefix());
        out.println();
        ClassAnnotation primaryClass = b.getPrimaryClass();
        for (BugAnnotation bugAnnotation : b.getAnnotations()) {
            if (bugAnnotation == primaryClass) {
                out.println(bugAnnotation);
                continue;
            }
            out.println("  " + bugAnnotation.toString(primaryClass));
        }
        if (this.cloud.supportsSourceLinks() && (link = this.cloud.getSourceLink(b)) != null) {
            out.println();
            out.println(this.cloud.getSourceLinkToolTip(b) + ": " + link);
            out.println();
        }
        if (this.BUG_NOTE != null) {
            out.println(this.BUG_NOTE);
            if (this.POSTMORTEM_NOTE != null && BugRanker.findRank(b) <= this.POSTMORTEM_RANK && this.cloud.getConsensusDesignation(b).score() >= 0) {
                out.println(this.POSTMORTEM_NOTE);
            }
            out.println();
        }
        if ((projects = this.cloud.getProjects(primaryClass.getClassName())) != null && !projects.isEmpty()) {
            String string2 = projects.toString();
            string2 = string2.substring(1, string2.length() - 1);
            out.println("Possibly part of: " + string2);
            out.println();
        }
        out.close();
        return stringWriter.toString();
    }

    public String getBugPatternExplanation(BugInstance b) {
        String detailPlainText = b.getBugPattern().getDetailPlainText();
        return "Bug pattern explanation:\n" + detailPlainText + "\n\n";
    }

    public String getLineTerminatedUserEvaluation(BugInstance b) {
        Cloud.UserDesignation designation = this.cloud.getUserDesignation(b);
        String result = designation != Cloud.UserDesignation.UNCLASSIFIED ? "Classified as: " + designation.toString() + "\n" : "";
        String eval = this.cloud.getUserEvaluation(b).trim();
        if (eval.length() > 0) {
            result = result + eval + "\n";
        }
        return result;
    }

    public String getBugReportTail(BugInstance b) {
        return "\nFindBugs issue identifier (do not modify or remove): " + b.getInstanceHash();
    }

    private String commonLeadingWhitespace(String soFar, String txt) {
        if (txt.length() == 0) {
            return soFar;
        }
        if (soFar == null) {
            return txt;
        }
        soFar = Util.commonPrefix(soFar, txt);
        for (int i = 0; i < soFar.length(); ++i) {
            if (Character.isWhitespace(soFar.charAt(i))) continue;
            return soFar.substring(0, i);
        }
        return soFar;
    }

    public static class SourceLine {
        public final int line;
        public final String text;

        public SourceLine(int line, String text) {
            this.line = line;
            this.text = text;
        }
    }
}

