/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.EqualsKindSummary;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;

public class FindHEmismatch
extends OpcodeStackDetector
implements StatelessDetector {
    boolean hasFields = false;
    boolean visibleOutsidePackage = false;
    boolean hasHashCode = false;
    boolean hasEqualsObject = false;
    boolean hashCodeIsAbstract = false;
    boolean equalsObjectIsAbstract = false;
    boolean equalsMethodIsInstanceOfEquals = false;
    boolean equalsReimplementesObjectEquals = false;
    boolean hasCompareToObject = false;
    boolean hasCompareToBridgeMethod = false;
    boolean hasEqualsSelf = false;
    boolean hasEqualsOther = false;
    boolean hasCompareToSelf = false;
    boolean extendsObject = false;
    MethodAnnotation equalsMethod = null;
    MethodAnnotation equalsOtherMethod = null;
    ClassDescriptor equalsOtherClass = null;
    MethodAnnotation compareToMethod = null;
    MethodAnnotation compareToObjectMethod = null;
    MethodAnnotation compareToSelfMethod = null;
    MethodAnnotation hashCodeMethod = null;
    HashSet<String> nonHashableClasses = new HashSet();
    Map<String, BugInstance> potentialBugs = new HashMap<String, BugInstance>();
    private BugReporter bugReporter;
    boolean isApplicationClass;
    static final Pattern predicateOverAnInstance = Pattern.compile("\\(L([^;]+);\\)Z");
    static final Pattern mapPattern = Pattern.compile("[^y]HashMap<L([^;<]*);");
    static final Pattern hashTablePattern = Pattern.compile("Hashtable<L([^;<]*);");
    static final Pattern setPattern = Pattern.compile("[^y]HashSet<L([^;<]*);");

    public boolean isHashableClassName(String dottedClassName) {
        return !this.nonHashableClasses.contains(dottedClassName);
    }

    public FindHEmismatch(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitAfter(JavaClass obj) {
        BugInstance bug;
        if (!obj.isClass()) {
            return;
        }
        if (this.getDottedClassName().equals("java.lang.Object")) {
            return;
        }
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 0x200) != 0) {
            return;
        }
        this.visibleOutsidePackage = obj.isPublic() || obj.isProtected();
        String whereEqual = this.getDottedClassName();
        boolean inheritedHashCodeIsFinal = false;
        boolean inheritedEqualsIsFinal = false;
        boolean inheritedEqualsIsAbstract = false;
        boolean inheritedEqualsFromAbstractClass = false;
        XMethod inheritedEquals = null;
        if (!this.hasEqualsObject) {
            XClass we = Lookup.findImplementor(this.getXClass(), "equals", "(Ljava/lang/Object;)Z", false, this.bugReporter);
            if (we == null || we.equals(this.getXClass())) {
                whereEqual = "java.lang.Object";
            } else {
                inheritedEqualsFromAbstractClass = we.isAbstract();
                whereEqual = we.getClassDescriptor().getDottedClassName();
                inheritedEquals = we.findMethod("equals", "(Ljava/lang/Object;)Z", false);
                if (inheritedEquals != null) {
                    inheritedEqualsIsFinal = inheritedEquals.isFinal();
                    inheritedEqualsIsAbstract = inheritedEquals.isAbstract();
                }
            }
        }
        boolean usesDefaultEquals = whereEqual.equals("java.lang.Object");
        String whereHashCode = this.getDottedClassName();
        if (!this.hasHashCode) {
            XClass wh = Lookup.findSuperImplementor(this.getXClass(), "hashCode", "()I", false, this.bugReporter);
            if (wh == null) {
                whereHashCode = "java.lang.Object";
            } else {
                whereHashCode = wh.getClassDescriptor().getDottedClassName();
                XMethod m = wh.findMethod("hashCode", "()I", false);
                if (m != null && m.isFinal()) {
                    inheritedHashCodeIsFinal = true;
                }
            }
        }
        boolean usesDefaultHashCode = whereHashCode.equals("java.lang.Object");
        if (!this.hasEqualsObject && !this.hasEqualsSelf && this.hasEqualsOther) {
            BugInstance bug2 = new BugInstance(this, usesDefaultEquals ? "EQ_OTHER_USE_OBJECT" : "EQ_OTHER_NO_OBJECT", 2).addClass(this).addMethod(this.equalsOtherMethod).addClass(this.equalsOtherClass);
            this.bugReporter.reportBug(bug2);
        }
        if (!this.hasEqualsObject && this.hasEqualsSelf) {
            String bugPattern;
            if (usesDefaultEquals) {
                int priority = 1;
                if (usesDefaultHashCode || obj.isAbstract()) {
                    ++priority;
                }
                if (!this.visibleOutsidePackage) {
                    ++priority;
                }
                bugPattern = "EQ_SELF_USE_OBJECT";
                bug = new BugInstance(this, bugPattern, priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            } else {
                int priority = 2;
                if (this.hasFields) {
                    --priority;
                }
                if (obj.isAbstract()) {
                    ++priority;
                }
                bugPattern = "EQ_SELF_NO_OBJECT";
                String superclassName = obj.getSuperclassName();
                if (superclassName.equals("java.lang.Enum")) {
                    bugPattern = "EQ_DONT_DEFINE_EQUALS_FOR_ENUM";
                    priority = 1;
                }
                BugInstance bug3 = new BugInstance(this, bugPattern, priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug3.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug3);
            }
        }
        if ((this.hasCompareToObject || this.hasCompareToSelf) && usesDefaultEquals) {
            BugInstance bug4 = new BugInstance(this, "EQ_COMPARETO_USE_OBJECT_EQUALS", obj.isAbstract() ? 3 : 2).addClass(this);
            if (this.compareToSelfMethod != null) {
                bug4.addMethod(this.compareToSelfMethod);
            } else {
                bug4.addMethod(this.compareToObjectMethod);
            }
            this.bugReporter.reportBug(bug4);
        }
        if (!this.hasCompareToObject && !this.hasCompareToBridgeMethod && this.hasCompareToSelf && !this.extendsObject) {
            this.bugReporter.reportBug(new BugInstance(this, "CO_SELF_NO_OBJECT", 2).addClass(this.getDottedClassName()).addMethod(this.compareToMethod));
        }
        if (!(!this.hasHashCode || this.hashCodeIsAbstract || this.hasEqualsObject && !this.equalsReimplementesObjectEquals || this.hasEqualsSelf)) {
            int priority = 3;
            if (usesDefaultEquals) {
                this.bugReporter.reportBug(new BugInstance(this, "HE_HASHCODE_USE_OBJECT_EQUALS", priority).addClass(this.getDottedClassName()).addMethod(this.hashCodeMethod));
            } else if (!inheritedEqualsIsFinal) {
                this.bugReporter.reportBug(new BugInstance(this, "HE_HASHCODE_NO_EQUALS", priority).addClass(this.getDottedClassName()).addMethod(this.hashCodeMethod));
            }
        }
        if (!this.equalsObjectIsAbstract && !this.hasHashCode && (this.hasEqualsObject || this.hasEqualsSelf)) {
            EqualsKindSummary.KindOfEquals equalsKind = AnalysisContext.currentAnalysisContext().getEqualsKindSummary().get(new ClassAnnotation(obj.getClassName()));
            if (equalsKind == EqualsKindSummary.KindOfEquals.ALWAYS_FALSE) {
                return;
            }
            if (usesDefaultHashCode) {
                int priority = 1;
                if (this.equalsMethodIsInstanceOfEquals) {
                    priority += 2;
                } else if (obj.isAbstract() || !this.hasEqualsObject) {
                    ++priority;
                }
                if (priority == 1) {
                    this.nonHashableClasses.add(this.getDottedClassName());
                }
                if (!this.visibleOutsidePackage) {
                    ++priority;
                }
                bug = new BugInstance(this, "HE_EQUALS_USE_HASHCODE", priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            } else if (!inheritedHashCodeIsFinal && !whereHashCode.startsWith("java.util.Abstract")) {
                int priority = 3;
                if (this.hasEqualsObject && inheritedEqualsIsAbstract) {
                    ++priority;
                }
                if (this.hasFields) {
                    --priority;
                }
                if (this.equalsMethodIsInstanceOfEquals || !this.hasEqualsObject) {
                    priority += 2;
                } else if (obj.isAbstract()) {
                    ++priority;
                }
                bug = new BugInstance(this, "HE_EQUALS_NO_HASHCODE", priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            }
        }
        if (!(this.hasHashCode || this.hasEqualsObject || this.hasEqualsSelf || usesDefaultEquals || !usesDefaultHashCode || obj.isAbstract() || !inheritedEqualsFromAbstractClass)) {
            BugInstance bug5 = new BugInstance(this, "HE_INHERITS_EQUALS_USE_HASHCODE", 2).addClass(this.getDottedClassName());
            if (this.equalsMethod != null) {
                bug5.addMethod(this.equalsMethod);
            }
            this.bugReporter.reportBug(bug5);
        }
        if (!(this.hasEqualsObject || this.hasEqualsSelf || usesDefaultEquals || obj.isAbstract() || !this.hasFields || inheritedEquals == null || inheritedEqualsIsFinal || inheritedEqualsFromAbstractClass || inheritedEquals.getClassDescriptor().getSimpleName().contains("Abstract") || inheritedEquals.getClassDescriptor().getClassName().equals("java/lang/Enum"))) {
            BugInstance bug6 = new BugInstance(this, "EQ_DOESNT_OVERRIDE_EQUALS", 2).addClass(this).addMethod(inheritedEquals).describe("METHOD_DID_YOU_MEAN_TO_OVERRIDE");
            this.bugReporter.reportBug(bug6);
        }
    }

    public void visit(JavaClass obj) {
        this.extendsObject = this.getDottedSuperclassName().equals("java.lang.Object");
        this.hasFields = false;
        this.hasHashCode = false;
        this.hasCompareToObject = false;
        this.hasCompareToBridgeMethod = false;
        this.hasCompareToSelf = false;
        this.hasEqualsObject = false;
        this.hasEqualsSelf = false;
        this.hasEqualsOther = false;
        this.hashCodeIsAbstract = false;
        this.equalsObjectIsAbstract = false;
        this.equalsMethodIsInstanceOfEquals = false;
        this.equalsMethod = null;
        this.equalsOtherMethod = null;
        this.compareToMethod = null;
        this.compareToSelfMethod = null;
        this.compareToObjectMethod = null;
        this.hashCodeMethod = null;
        this.equalsOtherClass = null;
        this.isApplicationClass = AnalysisContext.currentAnalysisContext().isApplicationClass(obj);
    }

    public boolean shouldVisitCode(Code obj) {
        if (this.isApplicationClass) {
            return true;
        }
        String name = this.getMethod().getName();
        return name.equals("hashCode") || name.equals("equals");
    }

    public static int opcode(byte[] code, int offset) {
        return code[offset] & 0xFF;
    }

    public void visit(Field obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        if (!(obj.getName().startsWith("this$") || BCELUtil.isSynthetic((FieldOrMethod)obj) || obj.isTransient())) {
            this.hasFields = true;
        }
    }

    public void visit(Method obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        String name = obj.getName();
        String sig = obj.getSignature();
        if ((accessFlags & 0x400) != 0) {
            if (name.equals("equals") && sig.equals("(L" + this.getClassName() + ";)Z")) {
                this.bugReporter.reportBug(new BugInstance(this, "EQ_ABSTRACT_SELF", 3).addClass(this.getDottedClassName()));
                return;
            }
            if (name.equals("compareTo") && sig.equals("(L" + this.getClassName() + ";)I")) {
                this.bugReporter.reportBug(new BugInstance(this, "CO_ABSTRACT_SELF", 3).addClass(this.getDottedClassName()));
                return;
            }
        }
        boolean sigIsObject = sig.equals("(Ljava/lang/Object;)Z");
        if (name.equals("hashCode") && sig.equals("()I")) {
            this.hasHashCode = true;
            if (obj.isAbstract()) {
                this.hashCodeIsAbstract = true;
            }
            this.hashCodeMethod = MethodAnnotation.fromVisitedMethod(this);
        } else if (obj.isPublic() && name.equals("equals")) {
            Matcher m = predicateOverAnInstance.matcher(sig);
            if (m.matches()) {
                if (sigIsObject) {
                    this.equalsMethod = MethodAnnotation.fromVisitedMethod(this);
                    this.hasEqualsObject = true;
                    if (obj.isAbstract()) {
                        this.equalsObjectIsAbstract = true;
                    } else if (!obj.isNative()) {
                        Code code = obj.getCode();
                        byte[] codeBytes = code.getCode();
                        if (codeBytes.length == 9) {
                            int op0 = FindHEmismatch.opcode(codeBytes, 0);
                            int op1 = FindHEmismatch.opcode(codeBytes, 1);
                            int op2 = FindHEmismatch.opcode(codeBytes, 2);
                            int op5 = FindHEmismatch.opcode(codeBytes, 5);
                            int op6 = FindHEmismatch.opcode(codeBytes, 6);
                            int op7 = FindHEmismatch.opcode(codeBytes, 7);
                            int op8 = FindHEmismatch.opcode(codeBytes, 8);
                            if (!((op0 != 42 || op1 != 43) && (op0 != 43 || op1 != 42) || op2 != 165 && op2 != 166 || op5 != 3 && op5 != 4 || op6 != 172 || op7 != 3 && op7 != 4 || op8 != 172)) {
                                this.equalsMethodIsInstanceOfEquals = true;
                            }
                        } else if (codeBytes.length == 11) {
                            int op0 = FindHEmismatch.opcode(codeBytes, 0);
                            int op1 = FindHEmismatch.opcode(codeBytes, 1);
                            int op2 = FindHEmismatch.opcode(codeBytes, 2);
                            int op5 = FindHEmismatch.opcode(codeBytes, 5);
                            int op6 = FindHEmismatch.opcode(codeBytes, 6);
                            int op9 = FindHEmismatch.opcode(codeBytes, 9);
                            int op10 = FindHEmismatch.opcode(codeBytes, 10);
                            if (!((op0 != 42 || op1 != 43) && (op0 != 43 || op1 != 42) || op2 != 165 && op2 != 166 || op5 != 3 && op5 != 4 || op6 != 167 || op9 != 3 && op9 != 4 || op10 != 172)) {
                                this.equalsMethodIsInstanceOfEquals = true;
                            }
                        } else if (codeBytes.length == 5 && (codeBytes[1] & 0xFF) == 193 || codeBytes.length == 15 && (codeBytes[1] & 0xFF) == 193 && (codeBytes[11] & 0xFF) == 183) {
                            this.equalsMethodIsInstanceOfEquals = true;
                        }
                    }
                } else if (sig.equals("(L" + this.getClassName() + ";)Z")) {
                    this.hasEqualsSelf = true;
                    if (this.equalsMethod == null) {
                        this.equalsMethod = MethodAnnotation.fromVisitedMethod(this);
                    }
                } else {
                    JavaClass findSuperImplementor;
                    String arg = m.group(1);
                    if (this.getSuperclassName().equals(arg) && (findSuperImplementor = Lookup.findSuperDefiner(this.getThisClass(), name, sig, this.bugReporter)) == null) {
                        this.hasEqualsOther = true;
                        this.equalsOtherMethod = MethodAnnotation.fromVisitedMethod(this);
                        this.equalsOtherClass = DescriptorFactory.createClassDescriptor(arg);
                    }
                }
            }
        } else if (name.equals("compareTo") && sig.endsWith(")I") && !obj.isStatic()) {
            MethodAnnotation tmp = MethodAnnotation.fromVisitedMethod(this);
            if (BCELUtil.isSynthetic((FieldOrMethod)obj)) {
                this.hasCompareToBridgeMethod = true;
            }
            if (sig.equals("(Ljava/lang/Object;)I")) {
                this.hasCompareToObject = true;
                this.compareToObjectMethod = this.compareToMethod = tmp;
            } else if (sig.equals("(L" + this.getClassName() + ";)I")) {
                this.hasCompareToSelf = true;
                this.compareToSelfMethod = this.compareToMethod = tmp;
            }
        }
    }

    Method findMethod(JavaClass clazz, String name, String sig) {
        Method[] m;
        for (Method aM : m = clazz.getMethods()) {
            if (!aM.getName().equals(name) || !aM.getSignature().equals(sig)) continue;
            return aM;
        }
        return null;
    }

    public void sawOpcode(int seen) {
        if (seen == 182 || seen == 185) {
            String className = this.getClassConstantOperand();
            if (className.equals("java/util/Map") || className.equals("java/util/HashMap") || className.equals("java/util/LinkedHashMap") || className.equals("java/util/concurrent/ConcurrentHashMap") || className.contains("Hash") && Subtypes2.instanceOf(ClassName.toDottedClassName(className), "java.util.Map")) {
                if (this.getNameConstantOperand().equals("put") && this.getSigConstantOperand().equals("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;") && this.stack.getStackDepth() >= 3) {
                    this.check(1);
                } else if ((this.getNameConstantOperand().equals("get") || this.getNameConstantOperand().equals("remove")) && this.getSigConstantOperand().startsWith("(Ljava/lang/Object;)") && this.stack.getStackDepth() >= 2) {
                    this.check(0);
                }
            } else if ((className.equals("java/util/Set") || className.equals("java/util/HashSet") || className.contains("Hash") && Subtypes2.instanceOf(ClassName.toDottedClassName(className), "java.util.Set")) && (this.getNameConstantOperand().equals("add") || this.getNameConstantOperand().equals("contains") || this.getNameConstantOperand().equals("remove") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z") && this.stack.getStackDepth() >= 2)) {
                this.check(0);
            }
        }
    }

    private void check(int pos) {
        OpcodeStack.Item item = this.stack.getStackItem(pos);
        JavaClass type = null;
        try {
            type = item.getJavaClass();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        if (type == null) {
            return;
        }
        String typeName = type.getClassName();
        if (typeName.startsWith("java.lang")) {
            return;
        }
        int priority = 2;
        OpcodeStack.Item collection = this.stack.getStackItem(PreorderVisitor.getNumberArguments(this.getSigConstantOperand()));
        String collectionSignature = collection.getSignature();
        if (collectionSignature.indexOf("Tree") >= 0 || collectionSignature.indexOf("Sorted") >= 0 || collectionSignature.indexOf("SkipList") >= 0) {
            return;
        }
        if (collectionSignature.indexOf("Hash") >= 0) {
            --priority;
        }
        if (!AnalysisContext.currentAnalysisContext().isApplicationClass(type)) {
            ++priority;
        }
        if (type.isAbstract() || type.isInterface()) {
            ++priority;
        }
        this.potentialBugs.put(type.getClassName(), new BugInstance(this, "HE_USE_OF_UNHASHABLE_CLASS", priority).addClassAndMethod(this).addTypeOfNamedClass(type.getClassName()).describe("TYPE_UNHASHABLE").addCalledMethod(this).addSourceLine(this));
    }

    @CheckForNull
    @DottedClassName
    String findHashedClassInSignature(String sig) {
        Matcher m = mapPattern.matcher(sig);
        if (m.find()) {
            return m.group(1).replace('/', '.');
        }
        m = hashTablePattern.matcher(sig);
        if (m.find()) {
            return m.group(1).replace('/', '.');
        }
        m = setPattern.matcher(sig);
        if (m.find()) {
            return m.group(1).replace('/', '.');
        }
        return null;
    }

    public void visit(Signature obj) {
        if (!this.isApplicationClass) {
            return;
        }
        String sig = obj.getSignature();
        String className = this.findHashedClassInSignature(sig);
        if (className == null) {
            return;
        }
        if (className.startsWith("java.lang")) {
            return;
        }
        JavaClass type = null;
        try {
            type = Repository.lookupClass((String)className);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        if (type == null) {
            return;
        }
        int priority = 2;
        if (sig.indexOf("Hash") >= 0) {
            --priority;
        }
        if (type.isAbstract() || type.isInterface()) {
            ++priority;
        }
        if (!AnalysisContext.currentAnalysisContext().isApplicationClass(type)) {
            ++priority;
        }
        BugInstance bug = null;
        bug = this.visitingField() ? new BugInstance(this, "HE_SIGNATURE_DECLARES_HASHING_OF_UNHASHABLE_CLASS", priority).addClass(this).addVisitedField(this).addTypeOfNamedClass(className).describe("TYPE_UNHASHABLE") : (this.visitingMethod() ? new BugInstance(this, "HE_SIGNATURE_DECLARES_HASHING_OF_UNHASHABLE_CLASS", priority).addClassAndMethod(this).addTypeOfNamedClass(className).describe("TYPE_UNHASHABLE") : new BugInstance(this, "HE_SIGNATURE_DECLARES_HASHING_OF_UNHASHABLE_CLASS", priority).addClass(this).addClass(this).addTypeOfNamedClass(className).describe("TYPE_UNHASHABLE"));
        this.potentialBugs.put(className, bug);
    }

    public void report() {
        for (Map.Entry<String, BugInstance> e : this.potentialBugs.entrySet()) {
            if (this.isHashableClassName(e.getKey())) continue;
            BugInstance bug = e.getValue();
            this.bugReporter.reportBug(bug);
        }
    }
}

