/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.CloudCommentsPaneSwing;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CommentsArea {
    private static final Logger LOGGER = Logger.getLogger(CommentsArea.class.getName());
    private JButton fileBug;
    private final MainFrame frame;
    private Cloud.BugFilingStatus currentBugStatus;
    private CloudCommentsPaneSwing commentsPane;

    CommentsArea(MainFrame frame) {
        this.frame = frame;
    }

    JPanel createCommentsInputPanel() {
        JPanel mainPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        mainPanel.setLayout(layout);
        this.fileBug = new JButton(Cloud.BugFilingStatus.FILE_BUG.toString());
        this.fileBug.setEnabled(false);
        this.fileBug.setToolTipText("Click to file bug for this issue");
        this.fileBug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CommentsArea.this.frame.getCurrentSelectedBugLeaf() == null) {
                    return;
                }
                if (!CommentsArea.this.canNavigateAway()) {
                    return;
                }
                BugInstance bug = CommentsArea.this.frame.getCurrentSelectedBugLeaf().getBug();
                Cloud cloud1 = MainFrame.getInstance().getBugCollection().getCloud();
                if (!cloud1.supportsBugLinks()) {
                    return;
                }
                try {
                    URL u = cloud1.getBugLink(bug);
                    if (u != null && LaunchBrowser.showDocument(u)) {
                        cloud1.bugFiled(bug, null);
                        MainFrame.getInstance().syncBugInformation();
                    }
                }
                catch (Exception e1) {
                    LOGGER.log(Level.SEVERE, "Could not view/file bug", e1);
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Could not view/file bug:\n" + e1.getClass().getSimpleName() + ": " + e1.getMessage());
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.commentsPane = new CloudCommentsPaneSwing();
        mainPanel.add((Component)new JScrollPane(this.commentsPane), c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        mainPanel.add((Component)this.fileBug, c);
        return mainPanel;
    }

    void updateCommentsFromLeafInformation(final BugLeafNode node) {
        if (node == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BugInstance bug = node.getBug();
                Cloud plugin = CommentsArea.this.getCloud();
                if (plugin.supportsBugLinks()) {
                    CommentsArea.this.currentBugStatus = plugin.getBugLinkStatus(bug);
                    CommentsArea.this.fileBug.setText(CommentsArea.this.currentBugStatus.toString());
                    CommentsArea.this.fileBug.setToolTipText(CommentsArea.this.currentBugStatus == Cloud.BugFilingStatus.FILE_BUG ? "Click to file bug for this issue" : "");
                    CommentsArea.this.fileBug.setEnabled(CommentsArea.this.currentBugStatus.linkEnabled());
                    CommentsArea.this.fileBug.setVisible(true);
                } else {
                    CommentsArea.this.fileBug.setVisible(false);
                }
                CommentsArea.this.commentsPane.setBugInstance(node.getBug());
            }
        });
    }

    private SortedBugCollection getBugCollection() {
        return (SortedBugCollection)MainFrame.getInstance().getBugCollection();
    }

    void updateCommentsFromNonLeafInformation(final BugAspects theAspects) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CommentsArea.this.updateCommentsFromNonLeafInformationFromSwingThread(theAspects);
            }
        });
    }

    public boolean canNavigateAway() {
        return this.commentsPane.canNavigateAway();
    }

    protected void updateCommentsFromNonLeafInformationFromSwingThread(BugAspects theAspects) {
        this.commentsPane.setBugAspects(theAspects);
        this.fileBug.setEnabled(false);
    }

    public boolean hasFocus() {
        return this.commentsPane.hasFocus();
    }

    @CheckForNull
    private Cloud getCloud() {
        MainFrame instance = MainFrame.getInstance();
        BugCollection bugCollection = instance.getBugCollection();
        if (bugCollection == null) {
            return null;
        }
        return bugCollection.getCloud();
    }

    public void updateBugCollection() {
        this.commentsPane.setBugCollection(this.getBugCollection());
    }

    public void refresh() {
        this.commentsPane.refresh();
    }

    public boolean canSetDesignations() {
        return this.commentsPane.canSetDesignations();
    }

    public void setDesignation(String designationKey) {
        this.commentsPane.setDesignation(designationKey);
    }

    public void updateCloud() {
        this.commentsPane.updateCloud();
    }
}

