/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.FilterFactory;
import edu.umd.cs.findbugs.gui2.Sortables;
import java.awt.Insets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FilterFromBugPicker {
    private final HashMap<JCheckBox, Sortables> map = new HashMap();
    private final BugInstance bug;
    private final List<Sortables> availableSortables;
    private final JPanel pickerPanel;
    private final JCheckBox notFilterCheck = new JCheckBox("Invert (i.e. filter bugs which do not match selected criteria).");

    public FilterFromBugPicker(BugInstance bug, List<Sortables> availableSortables) {
        this.bug = bug;
        this.availableSortables = availableSortables;
        this.pickerPanel = this.buildPanel();
    }

    private JPanel buildPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.addFilterLikeCheckboxes(panel);
        this.addNotFilterOption(panel);
        return panel;
    }

    private void addFilterLikeCheckboxes(JPanel center) {
        for (Sortables sortable : this.availableSortables) {
            if (!FilterFactory.canFilter(sortable)) continue;
            JCheckBox checkBox = new JCheckBox(sortable.toString() + " is " + sortable.formatValue(sortable.getFrom(this.bug)));
            this.map.put(checkBox, sortable);
            center.add(checkBox);
        }
    }

    private void addNotFilterOption(JPanel center) {
        center.add(new JSeparator(0));
        center.add(this.notFilterCheck);
    }

    public JPanel pickerPanel() {
        return this.pickerPanel;
    }

    public Matcher makeMatcherFromSelection() {
        HashSet<Sortables> set = new HashSet<Sortables>();
        for (Map.Entry<JCheckBox, Sortables> e : this.map.entrySet()) {
            if (!e.getKey().isSelected()) continue;
            set.add(e.getValue());
        }
        Matcher matcher = null;
        if (!set.isEmpty()) {
            matcher = FilterFactory.makeMatcher(set, this.bug);
            if (this.notFilterCheck.isSelected()) {
                matcher = FilterFactory.invertMatcher(matcher);
            }
        }
        return matcher;
    }
}

