/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.SortableStringComparator;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class FilterMatcher
implements Matcher,
Serializable,
Comparable<FilterMatcher> {
    private static final long serialVersionUID = -4859486064351510016L;
    private final Sortables filterBy;
    private final String value;
    private final FilterWhere mode;
    protected boolean active;

    public FilterMatcher(BugAspects.SortableValue sp) {
        this(sp.key, sp.value);
    }

    Sortables getFilterBy() {
        return this.filterBy;
    }

    String getValue() {
        return this.value;
    }

    public FilterMatcher(Sortables filterBy, String value, FilterWhere mode) {
        this.filterBy = filterBy;
        this.value = value;
        this.mode = mode;
        this.active = true;
    }

    public FilterMatcher(Sortables filterBy, String value) {
        this.filterBy = filterBy;
        this.value = value;
        this.mode = FilterWhere.FILTER_EXACTLY;
        this.active = true;
    }

    public void setActive(boolean active) {
        if (active != this.active) {
            this.active = active;
            if (active) {
                FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
            } else {
                FilterActivity.notifyListeners(FilterListener.Action.UNFILTERING, null);
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        if (!this.active) {
            return true;
        }
        SortableStringComparator ssc = this.filterBy.getComparator();
        int compare = ssc.compare(this.filterBy.getFrom(bugInstance), this.value);
        switch (this.mode) {
            case FILTER_EXACTLY: {
                return compare != 0;
            }
            case FILTER_AT_OR_AFTER: {
                return compare < 0;
            }
            case FILTER_AT_OR_BEFORE: {
                return compare > 0;
            }
            case FILTER_ALL_BUT: {
                return compare == 0;
            }
        }
        return true;
    }

    public String toString() {
        switch (this.mode) {
            case FILTER_EXACTLY: {
                return this.filterBy.toString() + " " + L10N.getLocalString("dlg.is", "is") + " " + L10N.getLocalString("mode.equal_to", "equal to") + " " + this.filterBy.formatValue(this.value);
            }
            case FILTER_AT_OR_AFTER: {
                return this.filterBy.toString() + " " + L10N.getLocalString("dlg.is", "is") + " " + L10N.getLocalString("mode.at_or_after", "at or after") + " " + this.filterBy.formatValue(this.value);
            }
            case FILTER_AT_OR_BEFORE: {
                return this.filterBy.toString() + " " + L10N.getLocalString("dlg.is", "is") + " " + L10N.getLocalString("mode.at_or_before", "at or before") + " " + this.filterBy.formatValue(this.value);
            }
            case FILTER_ALL_BUT: {
                return this.filterBy.toString() + " " + L10N.getLocalString("dlg.is", "is") + " " + L10N.getLocalString("mode.not_equal_to", "not equal to") + " " + this.filterBy.formatValue(this.value);
            }
        }
        throw new RuntimeException();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.filterBy.equals(((FilterMatcher)o).filterBy) && this.value.equals(((FilterMatcher)o).value);
    }

    public int hashCode() {
        return this.value.hashCode() + this.filterBy.hashCode();
    }

    @Override
    public int compareTo(FilterMatcher that) {
        if (this.filterBy != that.filterBy) {
            return this.filterBy.ordinal() < that.filterBy.ordinal() ? -1 : 1;
        }
        return this.value.compareTo(that.value);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FilterWhere {
        FILTER_EXACTLY,
        FILTER_AT_OR_AFTER,
        FILTER_AT_OR_BEFORE,
        FILTER_ALL_BUT;

    }
}

