/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.xml;

import edu.umd.cs.findbugs.util.Strings;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLAttributeList {
    private List<NameValuePair> nameValuePairList = new LinkedList<NameValuePair>();

    public XMLAttributeList addAttribute(@Nonnull String name, @Nonnull String value) {
        if (name == null) {
            throw new NullPointerException("name must be nonnull");
        }
        if (value == null) {
            throw new NullPointerException("value must be nonnull");
        }
        this.nameValuePairList.add(new NameValuePair(name, value));
        return this;
    }

    public XMLAttributeList addOptionalAttribute(@Nonnull String name, @CheckForNull String value) {
        if (value == null) {
            return this;
        }
        return this.addAttribute(name, value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (NameValuePair pair : this.nameValuePairList) {
            buf.append(' ');
            buf.append(pair.getName());
            buf.append('=');
            buf.append('\"');
            buf.append(XMLAttributeList.getQuotedAttributeValue(pair.getValue()));
            buf.append('\"');
        }
        return buf.toString();
    }

    public Iterator<NameValuePair> iterator() {
        return this.nameValuePairList.iterator();
    }

    public static String getQuotedAttributeValue(@Nonnull String rawValue) {
        return Strings.escapeXml(rawValue);
    }

    public static class NameValuePair {
        private String name;
        private String value;

        public NameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

