/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.StackMapTable;
import org.apache.bcel.classfile.StackMapTableEntry;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.generic.Type;

public class StackMapAnalyzer {
    static final boolean DEBUG = false;
    @CheckForNull
    static final Field frame_type_field;

    @CheckForNull
    static StackMapTable getStackMapTable(Code code) {
        for (Attribute a : code.getAttributes()) {
            if (!(a instanceof StackMapTable)) continue;
            return (StackMapTable)a;
        }
        return null;
    }

    static List<OpcodeStack.Item> getInitialLocals(MethodDescriptor descriptor) {
        ArrayList<OpcodeStack.Item> locals = new ArrayList<OpcodeStack.Item>();
        Type[] argTypes = Type.getArgumentTypes((String)descriptor.getSignature());
        int reg = 0;
        if (!descriptor.isStatic()) {
            OpcodeStack.Item it = OpcodeStack.Item.typeOnly("L" + descriptor.getSlashedClassName() + ";");
            locals.add(it);
            reg += it.getSize();
        }
        for (Type argType : argTypes) {
            OpcodeStack.Item it = OpcodeStack.Item.typeOnly(argType.getSignature());
            locals.add(it);
            reg += it.getSize();
            if (!it.usesTwoSlots()) continue;
            locals.add(null);
        }
        return locals;
    }

    static int getFrameType(StackMapTableEntry e) {
        if (frame_type_field == null) {
            return -1;
        }
        try {
            return (Integer)frame_type_field.get(e);
        }
        catch (IllegalArgumentException e1) {
            return -1;
        }
        catch (IllegalAccessException e1) {
            return -1;
        }
    }

    @CheckForNull
    private static JumpInfoFromStackMap getFromStackMap(IAnalysisCache analysisCache, MethodDescriptor descriptor) {
        Method method;
        if (frame_type_field == null) {
            return null;
        }
        try {
            method = analysisCache.getMethodAnalysis(Method.class, descriptor);
        }
        catch (CheckedAnalysisException e1) {
            analysisCache.getErrorLogger().logError("Unable to get method for " + descriptor, e1);
            return null;
        }
        Code code = method.getCode();
        if (code == null) {
            return null;
        }
        StackMapTable stackMapTable = StackMapAnalyzer.getStackMapTable(code);
        if (stackMapTable == null) {
            return null;
        }
        HashMap<Integer, List<OpcodeStack.Item>> jumpEntries = new HashMap<Integer, List<OpcodeStack.Item>>();
        HashMap<Integer, List<OpcodeStack.Item>> jumpStackEntries = new HashMap<Integer, List<OpcodeStack.Item>>();
        List<OpcodeStack.Item> locals = StackMapAnalyzer.getInitialLocals(descriptor);
        ArrayList<OpcodeStack.Item> stack = new ArrayList<OpcodeStack.Item>();
        BitSet jumpEntryLocations = new BitSet();
        int pc = 0;
        for (StackMapTableEntry e : stackMapTable.getStackMapTable()) {
            pc += e.getByteCodeOffsetDelta();
            StackFrameType stackFrameType = StackFrameType.get(StackMapAnalyzer.getFrameType(e));
            switch (stackFrameType) {
                case SAME_FRAME: {
                    stack.clear();
                    break;
                }
                case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                    stack.clear();
                    StackMapAnalyzer.addStack(stack, e.getTypesOfStackItems());
                    break;
                }
                case CHOP_FRAME: {
                    stack.clear();
                    for (int i = 0; i < e.getNumberOfLocals(); ++i) {
                        OpcodeStack.Item it = locals.remove(locals.size() - 1);
                        if (it != null) continue;
                        it = locals.remove(locals.size() - 1);
                        assert (it.usesTwoSlots());
                    }
                    break;
                }
                case APPEND_FRAME: {
                    stack.clear();
                    StackMapAnalyzer.addLocals(locals, e.getTypesOfLocals());
                    break;
                }
                case FULL_FRAME: {
                    stack.clear();
                    locals.clear();
                    StackMapAnalyzer.addLocals(locals, e.getTypesOfLocals());
                    StackMapAnalyzer.addStack(stack, e.getTypesOfStackItems());
                }
            }
            if (pc > 0) {
                jumpEntries.put(pc, new ArrayList<OpcodeStack.Item>(locals));
                if (!stack.isEmpty()) {
                    jumpStackEntries.put(pc, new ArrayList<OpcodeStack.Item>(stack));
                }
                jumpEntryLocations.set(pc);
            }
            ++pc;
        }
        return new JumpInfoFromStackMap(jumpEntries, jumpStackEntries, jumpEntryLocations);
    }

    private static OpcodeStack.Item getItem(StackMapType t) {
        switch (t.getType()) {
            case 3: {
                return OpcodeStack.Item.typeOnly("D");
            }
            case 2: {
                return OpcodeStack.Item.typeOnly("F");
            }
            case 1: {
                return OpcodeStack.Item.typeOnly("I");
            }
            case 4: {
                return OpcodeStack.Item.typeOnly("J");
            }
            case 0: 
            case 8: {
                return OpcodeStack.Item.typeOnly("Ljava/lang/Object;");
            }
            case 5: {
                OpcodeStack.Item it = new OpcodeStack.Item();
                it.setSpecialKind(24);
                return it;
            }
            case 6: {
                return OpcodeStack.Item.typeOnly("Ljava/lang/Object;");
            }
            case 7: {
                int index = t.getIndex();
                ConstantClass c = (ConstantClass)t.getConstantPool().getConstant(index);
                String name = c.getBytes(t.getConstantPool());
                if (name.charAt(0) != '[') {
                    name = "L" + name + ";";
                }
                return OpcodeStack.Item.typeOnly(name);
            }
        }
        throw new IllegalArgumentException("Bad item type: " + t.getType());
    }

    private static void addLocals(List<OpcodeStack.Item> lst, StackMapType[] typesOfStackItems) {
        for (StackMapType t : typesOfStackItems) {
            OpcodeStack.Item item = StackMapAnalyzer.getItem(t);
            lst.add(item);
            if (!item.usesTwoSlots()) continue;
            lst.add(null);
        }
    }

    private static void addStack(List<OpcodeStack.Item> lst, StackMapType[] typesOfStackItems) {
        for (StackMapType t : typesOfStackItems) {
            OpcodeStack.Item item = StackMapAnalyzer.getItem(t);
            lst.add(item);
        }
    }

    static {
        Field f;
        try {
            f = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    Class<StackMapTableEntry> c = StackMapTableEntry.class;
                    try {
                        Field result = c.getDeclaredField("frame_type");
                        result.setAccessible(true);
                        return result;
                    }
                    catch (NoSuchFieldException e) {
                        throw new AssertionError((Object)"frame_type field doesn't exist");
                    }
                    catch (SecurityException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            AnalysisContext.logError("Unable to create frame_type accessor", e);
            f = null;
        }
        frame_type_field = f;
    }

    static enum StackFrameType {
        SAME_FRAME,
        SAME_LOCALS_1_STACK_ITEM_FRAME,
        CHOP_FRAME,
        APPEND_FRAME,
        FULL_FRAME;


        static StackFrameType get(int frame_type) {
            if (frame_type >= 0 && frame_type <= 63) {
                return SAME_FRAME;
            }
            if (frame_type >= 64 && frame_type <= 127) {
                return SAME_LOCALS_1_STACK_ITEM_FRAME;
            }
            if (frame_type == 247) {
                return SAME_LOCALS_1_STACK_ITEM_FRAME;
            }
            if (frame_type >= 248 && frame_type <= 250) {
                return CHOP_FRAME;
            }
            if (frame_type == 251) {
                return SAME_FRAME;
            }
            if (frame_type >= 252 && frame_type <= 254) {
                return APPEND_FRAME;
            }
            if (frame_type == 255) {
                return FULL_FRAME;
            }
            throw new ClassFormatException("Invalid frame type : " + frame_type);
        }
    }

    static class JumpInfoFromStackMap
    extends OpcodeStack.JumpInfo {
        JumpInfoFromStackMap(Map<Integer, List<OpcodeStack.Item>> jumpEntries, Map<Integer, List<OpcodeStack.Item>> jumpStackEntries, BitSet jumpEntryLocations) {
            super(jumpEntries, jumpStackEntries, jumpEntryLocations);
        }
    }

    public static class StackMapAnalysisFactory
    extends AnalysisFactory<JumpInfoFromStackMap> {
        public StackMapAnalysisFactory() {
            super("Jump info for opcode stack from stack map analysis", JumpInfoFromStackMap.class);
        }

        @Override
        public JumpInfoFromStackMap analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) {
            return StackMapAnalyzer.getFromStackMap(analysisCache, descriptor);
        }
    }
}

