/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DeepSubtypeAnalysis;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindNonSerializableStoreIntoSession
implements Detector {
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private static final boolean DEBUG = false;

    public FindNonSerializableStoreIntoSession(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", e);
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        if (bytecodeSet == null) {
            return;
        }
        if (bytecodeSet.get(193) || bytecodeSet.get(192)) {
            return;
        }
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            ReferenceType refType;
            Type operandType;
            TypeFrame frame;
            String cName;
            INVOKEINTERFACE invoke;
            String mName;
            Location location = i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof INVOKEINTERFACE) || !(mName = (invoke = (INVOKEINTERFACE)ins).getMethodName(cpg)).equals("setAttribute") || !(cName = invoke.getClassName(cpg)).equals("javax.servlet.http.HttpSession") || !(frame = (TypeFrame)typeDataflow.getFactAtLocation(location)).isValid() || (operandType = (Type)frame.getTopValue()).equals((Object)TopType.instance()) || !(operandType instanceof ReferenceType) || (refType = (ReferenceType)operandType).equals((Object)NullType.instance())) continue;
            try {
                double isSerializable = DeepSubtypeAnalysis.isDeepSerializable(refType);
                if (!(isSerializable < 0.9)) continue;
                SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
                ReferenceType problem = DeepSubtypeAnalysis.getLeastSerializableTypeComponent(refType);
                this.bugAccumulator.accumulateBug(new BugInstance(this, "J2EE_STORE_OF_NON_SERIALIZABLE_OBJECT_INTO_SESSION", isSerializable < 0.15 ? 1 : (isSerializable > 0.5 ? 3 : 2)).addClassAndMethod(methodGen, sourceFile).addType((Type)problem).describe("TYPE_FOUND"), sourceLineAnnotation);
            }
            catch (ClassNotFoundException e) {}
        }
    }

    @Override
    public void report() {
    }
}

