/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FirstPassDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.HashSet;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

public class FunctionsThatMightBeMistakenForProcedures
extends OpcodeStackDetector
implements FirstPassDetector {
    final BugReporter bugReporter;
    private final boolean testingEnabled;
    static final boolean REPORT_INFERRED_METHODS = SystemProperties.getBoolean("mrc.inferred.report");
    boolean isInnerClass;
    boolean hasNonFinalFields;
    HashSet<XMethod> okToIgnore = new HashSet();
    HashSet<XMethod> methodsSeen = new HashSet();
    HashSet<XMethod> doNotIgnore = new HashSet();
    HashSet<XMethod> doNotIgnoreHigh = new HashSet();
    int returnSelf;
    int returnOther;
    int returnNew;
    int returnUnknown;
    int updates;
    @CheckForNull
    BugInstance inferredMethod;

    public FunctionsThatMightBeMistakenForProcedures(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.setVisitMethodsInCallOrder(true);
        this.testingEnabled = SystemProperties.getBoolean("report_TESTING_pattern_in_standard_detectors");
    }

    @Override
    public void visit(JavaClass obj) {
        this.isInnerClass = false;
        this.hasNonFinalFields = false;
    }

    @Override
    public void visit(Field obj) {
        if (obj.getName().equals("this$0")) {
            this.isInnerClass = true;
        }
        if (!(obj.isFinal() || obj.isStatic() || BCELUtil.isSynthetic((FieldOrMethod)obj))) {
            this.hasNonFinalFields = true;
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.okToIgnore.clear();
        this.doNotIgnore.clear();
        this.doNotIgnoreHigh.clear();
        this.methodsSeen.clear();
    }

    @Override
    public void visit(Code code) {
        GenericSignatureParser sig;
        String genericReturnValue;
        Type t;
        this.methodsSeen.add(this.getXMethod());
        String signature = this.getMethodSig();
        SignatureParser parser = new SignatureParser(signature);
        String returnType = parser.getReturnTypeSignature();
        String r = ClassName.fromFieldSignature(returnType);
        if (r == null || !r.equals(this.getClassName())) {
            return;
        }
        boolean funky = false;
        for (int i = 0; i < parser.getNumParameters(); ++i) {
            String p = ClassName.fromFieldSignature(parser.getParameter(i));
            if (!this.getClassName().equals(p)) continue;
            funky = true;
        }
        XMethod m = this.getXMethod();
        String sourceSig = m.getSourceSignature();
        if (sourceSig != null && (t = GenericUtilities.getType(genericReturnValue = (sig = new GenericSignatureParser(sourceSig)).getReturnTypeSignature())) instanceof GenericObjectType) {
            funky = true;
        }
        this.returnUnknown = 0;
        this.returnNew = 0;
        this.updates = 0;
        this.returnOther = 0;
        this.returnSelf = 0;
        this.inferredMethod = this.testingEnabled && REPORT_INFERRED_METHODS && AnalysisContext.currentAnalysisContext().isApplicationClass(this.getThisClass()) ? new BugInstance("TESTING", 2).addClassAndMethod(this) : null;
        super.visit(code);
        if (this.returnSelf > 0 && this.returnOther == 0) {
            this.okToIgnore.add(m);
        } else if (funky) {
            this.okToIgnore.add(m);
        } else if (this.returnOther > 0 && this.returnOther >= this.returnSelf && this.returnNew > 0 && this.returnNew >= this.returnOther - 1) {
            int priority = 1;
            if (this.returnSelf > 0 || this.updates > 0) {
                ++priority;
            }
            if (this.returnUnknown > 0) {
                ++priority;
            }
            if (this.returnNew > 0 && priority > 2) {
                priority = 2;
            }
            if (this.updates > 0) {
                priority = 3;
            }
            if (priority <= 1) {
                this.doNotIgnoreHigh.add(m);
            }
            if (priority <= 2) {
                this.doNotIgnore.add(m);
                if (!m.isStatic()) {
                    XFactory xFactory = AnalysisContext.currentXFactory();
                    xFactory.addFunctionThatMightBeMistakenForProcedures(this.getMethodDescriptor());
                    if (this.inferredMethod != null) {
                        this.inferredMethod.setPriority(priority);
                        this.inferredMethod.addString(String.format("%3d %3d %5d %3d", this.returnOther, this.returnSelf, this.returnNew, this.updates));
                        this.bugReporter.reportBug(this.inferredMethod);
                    }
                }
            }
            this.inferredMethod = null;
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: {
                if (this.getMethod().isStatic() || !this.hasNonFinalFields) break;
                String name = this.getNameConstantOperand();
                String sig = this.getSigConstantOperand();
                if (!name.startsWith("set") && !name.startsWith("update") && !sig.endsWith(")V")) break;
                OpcodeStack.Item invokedOn = this.stack.getItemMethodInvokedOn(this);
                if (invokedOn.isInitialParameter() && invokedOn.getRegisterNumber() == 0) {
                    ++this.updates;
                }
                if (this.inferredMethod == null) break;
                this.inferredMethod.addCalledMethod(this);
                break;
            }
            case 176: {
                OpcodeStack.Item rv = this.stack.getStackItem(0);
                if (rv.isNull()) break;
                if (rv.isInitialParameter()) {
                    ++this.returnSelf;
                    break;
                }
                XMethod xMethod = rv.getReturnValueOf();
                if (xMethod == null) {
                    ++this.returnSelf;
                    break;
                }
                if (this.inferredMethod != null) {
                    this.inferredMethod.addCalledMethod(xMethod);
                }
                if (this.okToIgnore.contains(xMethod)) {
                    ++this.returnSelf;
                    break;
                }
                if (xMethod.getName().equals("<init>")) {
                    boolean voidConstructor;
                    String sig = xMethod.getSignature();
                    if (!this.isInnerClass) {
                        voidConstructor = sig.equals("()V");
                    } else {
                        SignatureParser parser = new SignatureParser(sig);
                        boolean bl = voidConstructor = parser.getNumParameters() <= 1;
                    }
                    if (voidConstructor) {
                        ++this.returnSelf;
                        break;
                    }
                    ++this.returnOther;
                    ++this.returnNew;
                    break;
                }
                if (xMethod.isAbstract() && !xMethod.getClassDescriptor().equals(this.getClassDescriptor())) {
                    ++this.returnUnknown;
                    break;
                }
                if (xMethod.getName().equals("<init>") || this.doNotIgnoreHigh.contains(xMethod)) {
                    ++this.returnOther;
                    if (!xMethod.getName().equals("<init>") && !this.doNotIgnore.contains(xMethod)) break;
                    ++this.returnNew;
                    break;
                }
                if (this.doNotIgnore.contains(xMethod)) {
                    ++this.returnOther;
                    break;
                }
                ++this.returnUnknown;
                break;
            }
            case 181: {
                OpcodeStack.Item rv = this.stack.getStackItem(1);
                if (rv.getRegisterNumber() != 0 || !rv.isInitialParameter()) break;
                if (this.inferredMethod != null) {
                    this.inferredMethod.addReferencedField(this);
                }
                ++this.updates;
                break;
            }
        }
    }
}

