/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public final class FindMismatchedWaitOrNotify
implements Detector,
StatelessDetector {
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;

    public FindMismatchedWaitOrNotify(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass jclass = classContext.getJavaClass();
        for (Method method : methodList = jclass.getMethods()) {
            BitSet bytecodeSet;
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || (bytecodeSet = classContext.getBytecodeSet(method)) == null || !bytecodeSet.get(194) || !bytecodeSet.get(182)) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("FindMismatchedWaitOrNotify: caught exception", e);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("FindMismatchedWaitOrNotify: caught exception", e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        ConstantPoolGen cpg = methodGen.getConstantPool();
        CFG cfg = classContext.getCFG(method);
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        LockDataflow dataflow = classContext.getLockDataflow(method);
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            String methodSig;
            INVOKEVIRTUAL inv;
            String methodName;
            Location location = i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof INVOKEVIRTUAL) || !Hierarchy.isMonitorWait(methodName = (inv = (INVOKEVIRTUAL)ins).getName(cpg), methodSig = inv.getSignature(cpg)) && !Hierarchy.isMonitorNotify(methodName, methodSig)) continue;
            int numConsumed = inv.consumeStack(cpg);
            if (numConsumed == -2) {
                throw new DataflowAnalysisException("Unpredictable stack consumption", methodGen, handle);
            }
            ValueNumberFrame frame = (ValueNumberFrame)vnaDataflow.getFactAtLocation(location);
            if (!frame.isValid()) continue;
            if (frame.getStackDepth() - numConsumed < 0) {
                throw new DataflowAnalysisException("Stack underflow", methodGen, handle);
            }
            ValueNumber ref = (ValueNumber)frame.getValue(frame.getNumSlots() - numConsumed);
            LockSet lockSet = (LockSet)dataflow.getFactAtLocation(location);
            int lockCount = lockSet.getLockCount(ref.getNumber());
            if (lockCount != 0) continue;
            Collection<ValueNumber> lockedValueNumbers = lockSet.getLockedValueNumbers(frame);
            boolean foundMatch = false;
            for (ValueNumber v : lockedValueNumbers) {
                if (!frame.veryFuzzyMatch(ref, v)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            String type = "wait".equals(methodName) ? "MWN_MISMATCHED_WAIT" : "MWN_MISMATCHED_NOTIFY";
            String sourceFile = classContext.getJavaClass().getSourceFileName();
            int priority = method.isPublic() ? 2 : 3;
            this.bugAccumulator.accumulateBug(new BugInstance(this, type, priority).addClassAndMethod(methodGen, sourceFile), SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle));
        }
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void report() {
    }
}

