/*
 * Decompiled with CFR 0.152.
 */
package org.jscep;

import javax.security.auth.callback.Callback;
import org.jscep.util.HexUtil;

public class FingerprintVerificationCallback
implements Callback {
    private final byte[] fingerprint;
    private final String algorithm;
    private boolean verified;

    public FingerprintVerificationCallback(byte[] fingerprint, String algorithm) {
        this.fingerprint = fingerprint;
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getFingerprint() {
        return this.fingerprint;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.algorithm);
        builder.append(' ');
        builder.append(HexUtil.toHexString(this.fingerprint));
        builder.append(' ');
        if (this.verified) {
            builder.append("(Verified)");
        } else {
            builder.append("(Unverified)");
        }
        return builder.toString();
    }
}

